/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.data;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ErrorMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationNumberMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.ObligationStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.StepStatusMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.WarningMessage;
import tla2sany.st.Location;
import util.UniqueString;

public abstract class TLAPMMessage {
    public static final String TYPE_FIELD = "type";
    public static final String LOC_FIELD = "loc";
    public static final String STATUS_FIELD = "status";
    public static final String FIELD_PAIR_SPLIT = ":";
    public static final String OB_STATUS_TYPE = "obligation";
    public static final String STEP_STATUS_TYPE = "proof-step";
    public static final String THEOREM_STATUS_TYPE = "theorem";
    public static final String OB_NUMBER_TYPE = "obligationsnumber";
    public static final String WARNING_TYPE = "warning";
    public static final String ERROR_TYPE = "error";

    public static TLAPMMessage parseMessage(String proverMessage, String moduleName) {
        String[] fieldStrings = proverMessage.split("@!!");
        String type = null;
        HashMap<String, String> fieldPairs = new HashMap<String, String>();
        int i = 0;
        while (i < fieldStrings.length) {
            if (fieldStrings[i].trim().length() != 0) {
                String[] nameValPair = fieldStrings[i].trim().split(FIELD_PAIR_SPLIT, 2);
                Assert.isTrue((nameValPair.length == 2 ? 1 : 0) != 0, (String)("Encountered a flawed field name-value string : " + fieldStrings[i] + "\n in message :" + proverMessage));
                String fieldName = nameValPair[0];
                String fieldValue = nameValPair[1];
                if (fieldName != null && fieldValue != null) {
                    if (fieldName.equals(TYPE_FIELD)) {
                        type = fieldValue;
                    } else {
                        fieldPairs.put(fieldName, fieldValue);
                    }
                } else {
                    ProverUIActivator.getDefault().logDebug("Null field name or value when parsing message. This is a bug. Message:");
                    ProverUIActivator.getDefault().logDebug(proverMessage);
                }
            }
            ++i;
        }
        if (type != null) {
            if (type.equals(OB_STATUS_TYPE)) {
                ObligationStatusMessage message = ObligationStatusMessage.getObMessage(fieldPairs.entrySet(), moduleName);
                return message;
            }
            if (type.equals(STEP_STATUS_TYPE) || type.equals(THEOREM_STATUS_TYPE)) {
                StepStatusMessage message = StepStatusMessage.getStepMessage(fieldPairs.entrySet(), moduleName);
                return message;
            }
            if (type.equals(OB_NUMBER_TYPE)) {
                ObligationNumberMessage message = ObligationNumberMessage.getObNumMessage(fieldPairs.entrySet(), moduleName);
                return message;
            }
            if (type.equals(WARNING_TYPE)) {
                WarningMessage message = WarningMessage.getWarningMessage(fieldPairs.entrySet(), moduleName);
                return message;
            }
            if (type.equals(ERROR_TYPE)) {
                ErrorMessage message = ErrorMessage.getErrorMessage(fieldPairs.entrySet(), moduleName);
                return message;
            }
            ProverUIActivator.getDefault().logDebug("Unsuppported message type " + type);
        } else {
            ProverUIActivator.getDefault().logDebug("Type field not found in TLAPM message. The message follows.");
            ProverUIActivator.getDefault().logDebug(proverMessage);
        }
        return null;
    }

    protected static Location parseLocation(String locString, String moduleName) {
        try {
            String[] coordinates = locString.split(FIELD_PAIR_SPLIT);
            Assert.isTrue((coordinates.length >= 4 ? 1 : 0) != 0, (String)("Not enough coordinates found in location string : " + locString));
            return new Location(UniqueString.uniqueStringOf((String)moduleName), Integer.parseInt(coordinates[0]), Integer.parseInt(coordinates[1]), Integer.parseInt(coordinates[2]), Integer.parseInt(coordinates[3]) - 1);
        }
        catch (NumberFormatException e) {
            ProverUIActivator.getDefault().logError("Error parsing location from TLAPM message. Location string : " + locString, e);
            return null;
        }
    }
}

