/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.pcal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.pcal.ValidationProgressMonitorDialog;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.TLAMarkerHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;
import pcal.Translator;
import pcal.ValidationCallBack;

public class PCalTranslator {
    public void translate(TLAEditor tlaEditor, Shell shell) throws InvocationTargetException, InterruptedException {
        this.translate(tlaEditor, shell, true);
    }

    public void translate(final TLAEditor tlaEditor, Shell shell, final boolean saveEditor) throws InvocationTargetException, InterruptedException {
        final ValidationProgressMonitorDialog context = new ValidationProgressMonitorDialog(tlaEditor.getEditorSite().getShell());
        context.run(true, true, new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                IEditorInput editorInput = tlaEditor.getEditorInput();
                final IDocument doc = tlaEditor.getDocumentProvider().getDocument((Object)editorInput);
                IFile file = ((FileEditorInput)editorInput).getFile();
                Spec spec = ToolboxHandle.getCurrentSpec();
                TLAMarkerHelper.removeProblemMarkers((IResource)file, (IProgressMonitor)progressMonitor, (String)"toolbox.markers.PCalTranslatorProblemMarker");
                ArrayList<String> asList = new ArrayList<String>(Arrays.asList(PreferenceStoreHelper.getStringArray((Spec)spec, (String)"pCalCallParams", (String[])new String[]{"-nocfg"})));
                asList.add(file.getLocation().toOSString());
                final Translator translator = new Translator(doc.get(), asList);
                if (translator.translate((ValidationCallBack)context)) {
                    spec.setTpMapping(translator.getMapping(), file.getName(), progressMonitor);
                    if (translator.hasChanged()) {
                        UIHelper.runUISync((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ISelection selection = tlaEditor.getViewer().getSelection();
                                doc.set(translator.getOutput());
                                tlaEditor.getViewer().setSelection(selection);
                                if (selection instanceof ITextSelection) {
                                    ITextSelection its = (ITextSelection)selection;
                                    tlaEditor.selectAndReveal(its.getOffset(), its.getLength());
                                }
                                if (tlaEditor.isDirty() && saveEditor) {
                                    tlaEditor.doSave(progressMonitor);
                                }
                            }
                        });
                    }
                } else {
                    for (Translator.Error anError : translator.getErrors()) {
                        TLAMarkerHelper.installProblemMarker((IResource)file, (String)file.getName(), (int)2, (int[])anError.getLocation(), (String)anError.toString(), (IProgressMonitor)progressMonitor, (String)"toolbox.markers.PCalTranslatorProblemMarker");
                    }
                }
            }
        });
    }
}

