/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.parser.ModuleParserLauncher;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.util.HelpButton;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.StringSet;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.AssumeProveNode;
import tla2sany.semantic.DefStepNode;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LeafProofNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NewSymbNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.st.Location;
import util.StringHelper;
import util.UniqueString;

public class DecomposeProofHandler
extends AbstractHandler
implements IHandler {
    private IDocument doc;
    private Hashtable<String, IDocument> moduleNameToDoc;
    private ISelectionProvider selectionProvider;
    private TextSelection selection;
    private int offset;
    private ModuleNode moduleNode;
    private TheoremNode theorem;
    private TheoremNode step;
    private NodeRepresentation stepRep;
    private ProofNode proof;
    private int proofLevel;
    private String proofLevelString;
    private String stepNumber;
    private int stepColumn;
    private static final boolean SHOW_CONTEXT_DEFAULT = true;
    private static final boolean USE_SUFFICES_DEFAULT = true;
    private static final boolean USE_CASE_DEFAULT = true;
    private static final boolean SUBEXPRESSION_DEFAULT = false;
    private static final int PROOF_INDENT = 2;
    private static final boolean BLANK_LINE_BETWEEN_STEPS = false;
    private static final boolean OBVIOUS_HAS_PROOF = false;
    private static final boolean NUMBER_QED_STEP = true;
    private static final String STEP_NUMBER_PUNCTUATION = ".";
    private static final String RENAMING_SUFFIX = "_";
    private Shell windowShell;
    private Point location = null;
    private TLAEditor editor;
    private IFile editorIFile;
    private DecompositionState state = null;
    boolean hasAssumes;
    private StringSet declaredIdentifiers;
    private static String lastModuleWithImplicitRenamingWarning = "";
    private boolean showContextValue = true;
    private Button showContextButton;
    private boolean useSufficesValue = true;
    private Button useSufficesButton;
    private boolean useCaseValue = true;
    private Button useCaseButton;
    private boolean subexpressionValue = false;
    private Button subexpressionButton;
    public static final int MENU = 1;
    public static final int ACTION = 2;
    public static final int CHECK = 3;
    public static final int SHOW_CONTEXT_BUTTON = 3;
    public static final int PROVE_BUTTON = 2;
    public static final int BACK_BUTTON = 1;
    public static final int TEST_BUTTON = 99;

    private String getCurrentName(FormalParamNode node, Renaming rename) {
        String newName = null;
        int i = 0;
        while (i < rename.identifiers.size() && newName == null) {
            if (rename.identifiers.elementAt(i) == node) {
                newName = rename.newNames.elementAt(i);
            }
            ++i;
        }
        if (newName == null) {
            while (i < this.state.renaming.identifiers.size() && newName == null) {
                if (this.state.renaming.identifiers.elementAt(i) == node) {
                    newName = this.state.renaming.newNames.elementAt(i);
                }
                ++i;
            }
        }
        if (newName == null) {
            return node.getName().toString();
        }
        return newName;
    }

    private void addCurrentName(FormalParamNode node, String name, Renaming rename) {
        int i = 0;
        while (i < rename.identifiers.size() && rename.identifiers.elementAt(i) != node) {
            ++i;
        }
        if (i < rename.identifiers.size()) {
            rename.newNames.remove(i);
            rename.newNames.insertElementAt(name, i);
        } else if (!name.equals(node.getName().toString())) {
            rename.identifiers.add(node);
            rename.newNames.add(name);
        }
    }

    private String getNewName(FormalParamNode node, StringSet currentlyDeclared, Renaming rename) {
        String curName = this.getCurrentName(node, rename);
        if (!currentlyDeclared.contains(curName)) {
            return curName;
        }
        String oldName = this.getNewNamePrefix(node.getName().toString());
        int i = 1;
        while (currentlyDeclared.contains(oldName + i)) {
            ++i;
        }
        return oldName + i;
    }

    private String getNewNamePrefix(String oldname) {
        if (oldname.length() < 2 || !Character.isDigit(oldname.charAt(oldname.length() - 1))) {
            return oldname + RENAMING_SUFFIX;
        }
        String newname = oldname.substring(0, oldname.length() - 1);
        while (newname.length() > RENAMING_SUFFIX.length() && Character.isDigit(newname.charAt(newname.length() - 1)) && !newname.endsWith(RENAMING_SUFFIX)) {
            newname = newname.substring(0, newname.length() - 1);
        }
        if (newname.endsWith(RENAMING_SUFFIX)) {
            return newname;
        }
        return oldname + RENAMING_SUFFIX;
    }

    private int newAssumeRepsIndex(int oldIndex, int initPos) {
        if (oldIndex >= this.state.firstAddedAssumption) {
            return oldIndex;
        }
        if (oldIndex != -1) {
            --this.state.firstAddedAssumption;
        }
        int i = this.state.firstAddedAssumption;
        while (i < this.state.assumeReps.size() && initPos >= this.state.assumeReps.elementAt((int)i).initialPosition) {
            ++i;
        }
        return i;
    }

    private void readButtons() {
        this.showContextValue = this.showContextButton.getSelection();
        this.useSufficesValue = this.useSufficesButton.getSelection();
        this.useCaseValue = this.useCaseButton.getSelection();
        this.subexpressionValue = this.subexpressionButton.getSelection();
    }

    public Object realExecute() throws ExecutionException {
        int i;
        Vector<String> contextSources;
        Vector<Object> contextSteps;
        Vector<Object> contextAssumptions;
        String nullReason;
        TheoremNode goalStep;
        LevelNode goal;
        Vector<Object> assumes;
        block101: {
            block99: {
                block102: {
                    UniqueString goalOpName;
                    OpApplNode newGoal;
                    block105: {
                        block104: {
                            block103: {
                                block100: {
                                    assumes = new Vector<Object>();
                                    goal = null;
                                    goalStep = null;
                                    nullReason = "[This string should never be displayed]";
                                    contextAssumptions = new Vector<Object>();
                                    contextSteps = new Vector<Object>();
                                    contextSources = new Vector<String>();
                                    if (this.windowShell != null && !this.windowShell.isDisposed()) {
                                        System.out.println("Command called when being executed.");
                                        return null;
                                    }
                                    if (this.existDirtyModules()) {
                                        MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"There is an unsaved module.");
                                        return null;
                                    }
                                    Spec spec = Activator.getSpecManager().getSpecLoaded();
                                    if (spec == null || spec.getStatus() != 0) {
                                        MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The spec status must be \"parsed\" to execute this command.");
                                        return null;
                                    }
                                    if (this.editor == null) {
                                        Activator.getDefault().logDebug("2nd call of getTLAEditorWithFocus returned null");
                                        return null;
                                    }
                                    this.editorIFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
                                    if (this.editor.isDirty()) {
                                        MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The module is dirty; this should not happen.");
                                        return null;
                                    }
                                    this.state = new DecompositionState();
                                    this.state.hasChanged = false;
                                    this.state.goalDefinitions = new StringSet();
                                    this.state.assumpDefinitions = new HashSet();
                                    Location selectedLocation = EditorUtil.getLocationAt(this.doc, this.offset, this.selection.getLength());
                                    TheoremNode[] allTheorems = this.moduleNode.getTheorems();
                                    this.theorem = null;
                                    i = 0;
                                    String moduleFile = this.moduleNode.stn.getFilename();
                                    while (this.theorem == null & i < allTheorems.length) {
                                        if (allTheorems[i].stn.getFilename().equals(moduleFile) && EditorUtil.lineLocationContainment(selectedLocation, allTheorems[i].stn.getLocation())) {
                                            this.theorem = allTheorems[i];
                                        }
                                        ++i;
                                    }
                                    if (this.theorem == null) {
                                        MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The cursor is not in a theorem.");
                                        return null;
                                    }
                                    goal = this.theorem.getTheorem();
                                    if (goal instanceof AssumeProveNode) {
                                        goal = ((AssumeProveNode)goal).getProve();
                                    }
                                    goalStep = this.theorem;
                                    this.declaredIdentifiers = ResourceHelper.declaredSymbolsInScopeSet((ModuleNode)this.moduleNode, (Location)this.theorem.stn.getLocation());
                                    this.step = this.theorem;
                                    boolean notDone = true;
                                    this.proofLevel = -1;
                                    this.proof = this.step.getProof();
                                    while (notDone && this.proof != null && this.proof instanceof NonLeafProofNode) {
                                        LevelNode[] pfsteps = ((NonLeafProofNode)this.proof).getSteps();
                                        LevelNode foundLevelNode = null;
                                        i = 0;
                                        this.proofLevel = -1;
                                        while (foundLevelNode == null && i < pfsteps.length) {
                                            if (this.proofLevel == -1 && !(pfsteps[i] instanceof DefStepNode) && !(pfsteps[i] instanceof InstanceNode)) {
                                                this.proofLevel = DecomposeProofHandler.stepLevel((SemanticNode)pfsteps[i]);
                                            }
                                            String currStepName = null;
                                            if (pfsteps[i] instanceof TheoremNode) {
                                                currStepName = DecomposeProofHandler.getStepName((TheoremNode)pfsteps[i]);
                                            }
                                            if (EditorUtil.lineLocationContainment(selectedLocation, pfsteps[i].stn.getLocation())) {
                                                foundLevelNode = pfsteps[i];
                                                if (pfsteps[i] instanceof TheoremNode) {
                                                    boolean isChosenStep;
                                                    TheoremNode thmNode = (TheoremNode)pfsteps[i];
                                                    ProofNode pfNode = thmNode.getProof();
                                                    boolean bl = isChosenStep = pfNode == null || pfNode instanceof LeafProofNode;
                                                    if (!thmNode.isSuffices()) {
                                                        if (thmNode.getTheorem() instanceof AssumeProveNode) {
                                                            SemanticNode[] assumptions = ((AssumeProveNode)thmNode.getTheorem()).getAssumes();
                                                            int j = 0;
                                                            while (j < assumptions.length) {
                                                                if (assumptions[j] instanceof NewSymbNode) {
                                                                    this.declaredIdentifiers.add(((NewSymbNode)assumptions[j]).getOpDeclNode().getName().toString());
                                                                } else if (!(assumptions[j] instanceof AssumeProveNode)) {
                                                                    if (isChosenStep) {
                                                                        assumes.addElement(assumptions[j]);
                                                                    } else {
                                                                        contextAssumptions.addElement(assumptions[j]);
                                                                        contextSteps.addElement(thmNode);
                                                                        contextSources.addElement(currStepName);
                                                                    }
                                                                }
                                                                ++j;
                                                            }
                                                            goal = ((AssumeProveNode)thmNode.getTheorem()).getProve();
                                                            goalStep = thmNode;
                                                        } else {
                                                            LevelNode newGoalSemNode = thmNode.getTheorem();
                                                            if (newGoalSemNode instanceof OpApplNode) {
                                                                OpApplNode newGoal2 = (OpApplNode)newGoalSemNode;
                                                                UniqueString goalOpName2 = newGoal2.getOperator().getName();
                                                                if (goalOpName2 == ASTConstants.OP_pfcase) {
                                                                    if (isChosenStep) {
                                                                        assumes.addElement(newGoal2.getArgs()[0]);
                                                                    } else {
                                                                        contextAssumptions.addElement(newGoal2.getArgs()[0]);
                                                                        contextSteps.addElement(thmNode);
                                                                        contextSources.addElement(currStepName);
                                                                    }
                                                                } else if (goalOpName2 == ASTConstants.OP_pick) {
                                                                    goal = null;
                                                                    nullReason = "PICK";
                                                                } else if (goalOpName2 == ASTConstants.OP_have) {
                                                                    goal = null;
                                                                    nullReason = "HAVE";
                                                                } else if (goalOpName2 == ASTConstants.OP_take) {
                                                                    goal = null;
                                                                    nullReason = "TAKE";
                                                                } else if (goalOpName2 == null) {
                                                                    goal = null;
                                                                    nullReason = "weird";
                                                                } else if (goalOpName2 != ASTConstants.OP_qed) {
                                                                    goal = newGoal2;
                                                                    goalStep = thmNode;
                                                                }
                                                            } else {
                                                                goal = null;
                                                                nullReason = "weird";
                                                            }
                                                        }
                                                    } else {
                                                        goal = null;
                                                        nullReason = "SUFFICES";
                                                    }
                                                } else {
                                                    goal = null;
                                                    nullReason = "weird";
                                                }
                                            } else {
                                                if (pfsteps[i] instanceof TheoremNode) {
                                                    TheoremNode node = (TheoremNode)pfsteps[i];
                                                    if (node.isSuffices()) {
                                                        if (node.getTheorem() instanceof AssumeProveNode) {
                                                            goal = ((AssumeProveNode)node.getTheorem()).getProve();
                                                            goalStep = node;
                                                            SemanticNode[] assumptions = ((AssumeProveNode)node.getTheorem()).getAssumes();
                                                            int j = 0;
                                                            while (j < assumptions.length) {
                                                                if (assumptions[j] instanceof NewSymbNode) {
                                                                    this.declaredIdentifiers.add(((NewSymbNode)assumptions[j]).getOpDeclNode().getName().toString());
                                                                } else if (!(assumptions[j] instanceof AssumeProveNode)) {
                                                                    contextAssumptions.addElement(assumptions[j]);
                                                                    contextSteps.addElement(node);
                                                                    contextSources.addElement(currStepName);
                                                                }
                                                                ++j;
                                                            }
                                                        } else {
                                                            goal = node.getTheorem();
                                                            goalStep = node;
                                                            if (!(goal instanceof OpApplNode)) {
                                                                goal = null;
                                                                nullReason = "weird";
                                                            }
                                                        }
                                                    } else if (node.getTheorem() instanceof OpApplNode) {
                                                        OpApplNode oanode = (OpApplNode)node.getTheorem();
                                                        String operatorName = oanode.getOperator().getName().toString();
                                                        if (operatorName.equals("$Pick") || operatorName.equals("$Witness") || operatorName.equals("$Take")) {
                                                            FormalParamNode[] fp = oanode.getUnbdedQuantSymbols();
                                                            if (operatorName.equals("$Pick")) {
                                                                contextAssumptions.addElement(oanode.getArgs()[0]);
                                                                contextSteps.addElement(node);
                                                                contextSources.addElement(currStepName);
                                                            }
                                                            if (!operatorName.equals("$Witness")) {
                                                                if (fp != null) {
                                                                    int j = 0;
                                                                    while (j < fp.length) {
                                                                        this.declaredIdentifiers.add(fp[j].getName().toString());
                                                                        ++j;
                                                                    }
                                                                } else {
                                                                    FormalParamNode[][] fpn = oanode.getBdedQuantSymbolLists();
                                                                    int j = 0;
                                                                    while (j < fpn.length) {
                                                                        int k = 0;
                                                                        while (k < fpn[j].length) {
                                                                            this.declaredIdentifiers.add(fpn[j][k].getName().toString());
                                                                            ++k;
                                                                        }
                                                                        ++j;
                                                                    }
                                                                }
                                                                if (operatorName.equals("$Take")) {
                                                                    goal = null;
                                                                    nullReason = "TAKE";
                                                                }
                                                            } else {
                                                                goal = null;
                                                                nullReason = "WITNESS";
                                                            }
                                                        } else if (operatorName.equals("$Have")) {
                                                            goal = null;
                                                            nullReason = "HAVE";
                                                            contextAssumptions.addElement(oanode.getArgs()[0]);
                                                            contextSteps.addElement(node);
                                                            contextSources.addElement(currStepName);
                                                        } else if (!operatorName.equals("$Pfcase")) {
                                                            contextAssumptions.addElement(oanode);
                                                            contextSteps.addElement(node);
                                                            contextSources.addElement(currStepName);
                                                        }
                                                    }
                                                }
                                                if (pfsteps[i] instanceof DefStepNode) {
                                                    OpDefNode[] defs = ((DefStepNode)pfsteps[i]).getDefs();
                                                    int j = 0;
                                                    while (j < defs.length) {
                                                        this.declaredIdentifiers.add(defs[j].getName().toString());
                                                        ++j;
                                                    }
                                                }
                                                if (pfsteps[i] instanceof InstanceNode) {
                                                    ResourceHelper.addDeclaredSymbolsInScopeSet((StringSet)this.declaredIdentifiers, (ModuleNode)((InstanceNode)pfsteps[i]).getModule(), (Location)ResourceHelper.infiniteLoc);
                                                }
                                            }
                                            ++i;
                                        }
                                        if (foundLevelNode == null) {
                                            notDone = false;
                                            continue;
                                        }
                                        if (!(foundLevelNode instanceof TheoremNode)) {
                                            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The cursor is in a non-provable step.");
                                            return null;
                                        }
                                        this.step = (TheoremNode)foundLevelNode;
                                        this.proof = this.step.getProof();
                                    }
                                    if (this.proof != null && !(this.proof instanceof LeafProofNode)) {
                                        MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"You have selected a step that already has a non-leaf proof.");
                                        return null;
                                    }
                                    if (this.step != this.theorem) break block99;
                                    if (!(this.step.getTheorem() instanceof AssumeProveNode)) break block100;
                                    SemanticNode[] assumptions = ((AssumeProveNode)this.step.getTheorem()).getAssumes();
                                    int j = 0;
                                    while (j < assumptions.length) {
                                        if (assumptions[j] instanceof NewSymbNode) {
                                            this.declaredIdentifiers.add(((NewSymbNode)assumptions[j]).getOpDeclNode().getName().toString());
                                            assumes.addElement(assumptions[j]);
                                        } else if (!(assumptions[j] instanceof AssumeProveNode)) {
                                            assumes.addElement(assumptions[j]);
                                        }
                                        ++j;
                                    }
                                    goal = ((AssumeProveNode)this.step.getTheorem()).getProve();
                                    goalStep = this.step;
                                    break block101;
                                }
                                LevelNode newGoalSemNode = this.step.getTheorem();
                                if (!(newGoalSemNode instanceof OpApplNode)) break block102;
                                newGoal = (OpApplNode)newGoalSemNode;
                                goalOpName = newGoal.getOperator().getName();
                                if (goalOpName != ASTConstants.OP_pfcase) break block103;
                                goal = newGoal.getArgs()[0];
                                break block101;
                            }
                            if (goalOpName != ASTConstants.OP_pick) break block104;
                            goal = null;
                            nullReason = "PICK";
                            break block101;
                        }
                        if (goalOpName != null) break block105;
                        goal = null;
                        nullReason = "weird";
                        break block101;
                    }
                    if (goalOpName == ASTConstants.OP_qed) break block101;
                    goal = newGoal;
                    goalStep = this.step;
                    break block101;
                }
                goal = null;
                nullReason = "weird";
                break block101;
            }
            if (this.theorem.getTheorem() instanceof AssumeProveNode) {
                SemanticNode[] thmAssumps = ((AssumeProveNode)this.theorem.getTheorem()).getAssumes();
                int k = 0;
                int j = 0;
                while (j < thmAssumps.length) {
                    if (thmAssumps[j] instanceof NewSymbNode) {
                        this.declaredIdentifiers.add(((NewSymbNode)thmAssumps[j]).getOpDeclNode().getName().toString());
                    } else {
                        contextAssumptions.insertElementAt(thmAssumps[j], k);
                        contextSteps.insertElementAt(this.theorem.getTheorem(), k);
                        contextSources.insertElementAt(null, k);
                        ++k;
                    }
                    ++j;
                }
            }
        }
        if (goal == null) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)("Cannot decompose because goal is from a " + nullReason + " step."));
            return null;
        }
        int level = this.proofLevel;
        if (level < 0) {
            level = 0;
        }
        this.proofLevelString = "<" + (level + 1) + ">";
        SyntaxTreeNode nd = (SyntaxTreeNode)this.step.stn;
        if (this.step == this.theorem) {
            this.stepNumber = null;
        } else {
            this.stepNumber = nd.getHeirs()[0].image.toString();
            if (this.stepNumber.indexOf(62) == this.stepNumber.length() - 1) {
                this.stepNumber = null;
            } else {
                i = this.stepNumber.indexOf(62) + 1;
                while (i < this.stepNumber.length() && (Character.isLetterOrDigit(this.stepNumber.charAt(i)) || this.stepNumber.charAt(i) == '_')) {
                    ++i;
                }
                if (i < this.stepNumber.length()) {
                    this.stepNumber = this.stepNumber.substring(0, i);
                }
            }
        }
        this.stepColumn = nd.getLocation().beginColumn();
        try {
            this.stepRep = new NodeRepresentation(this.doc, (SemanticNode)this.step);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 1678 of DecomposeProofHandler.");
            return null;
        }
        this.state.assumeReps = new Vector();
        i = 0;
        while (i < contextAssumptions.size()) {
            NodeRepresentation contextStepRep = null;
            try {
                contextStepRep = new NodeRepresentation(this.doc, (SemanticNode)contextSteps.elementAt(i));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 1698 of DecomposeProofHandler.");
                return null;
            }
            NodeRepresentation nodeRep = contextStepRep.subNodeRep((SemanticNode)contextAssumptions.elementAt(i), this.state.assumeReps, null, null, null, true);
            nodeRep.contextStepName = (String)contextSources.elementAt(i);
            if (nodeRep.decomposition != null && nodeRep.nodeSubtype != 2 && nodeRep.nodeSubtype != 3) {
                nodeRep.initialPosition = this.state.assumeReps.size();
                this.state.assumeReps.addElement(nodeRep);
                ++this.state.numberOfContextAssumptions;
            }
            ++i;
        }
        this.hasAssumes = false;
        if (assumes.size() > 0) {
            this.hasAssumes = true;
        }
        i = 0;
        while (i < assumes.size()) {
            NodeRepresentation nodeRep = this.stepRep.subNodeRep((SemanticNode)assumes.elementAt(i), this.state.assumeReps, null, null, null, true);
            nodeRep.contextStepName = this.stepNumber;
            nodeRep.initialPosition = this.state.assumeReps.size();
            this.state.assumeReps.addElement(nodeRep);
            ++i;
        }
        this.state.firstAddedAssumption = this.state.assumeReps.size();
        NodeRepresentation goalStepRep = null;
        try {
            goalStepRep = new NodeRepresentation(this.doc, (SemanticNode)goalStep);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 1749 of DecomposeProofHandler.");
            return null;
        }
        this.state.goalRep = goalStepRep.subNodeRep((SemanticNode)goal, null, null, null, null, false);
        this.state.goalRep.initialPosition = 2147483605;
        this.state.goalRep.fromGoal = true;
        this.editorIFile.setReadOnly(true);
        this.raiseWindow();
        return null;
    }

    static String getStepName(TheoremNode step) {
        SyntaxTreeNode nd = (SyntaxTreeNode)step.stn;
        String result = nd.getHeirs()[0].image.toString();
        if (result.indexOf(62) == result.length() - 1) {
            result = null;
        } else {
            int i = result.indexOf(62) + 1;
            while (i < result.length() && (Character.isLetterOrDigit(result.charAt(i)) || result.charAt(i) == '_')) {
                ++i;
            }
            if (i < result.length()) {
                result = result.substring(0, i);
            }
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.editor = EditorUtil.getTLAEditorWithFocus();
        this.doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        this.selectionProvider = this.editor.getSelectionProvider();
        this.selection = (TextSelection)this.selectionProvider.getSelection();
        this.offset = this.selection.getOffset();
        String moduleName = this.editor.getModuleName();
        this.moduleNode = ResourceHelper.getModuleNode((String)moduleName);
        this.moduleNameToDoc = new Hashtable();
        this.moduleNameToDoc.put(this.moduleNode.getName().toString(), this.doc);
        boolean proceed = UIHelper.promptUserForDirtyModules();
        if (!proceed) {
            return null;
        }
        if (this.editor == null) {
            Activator.getDefault().logDebug("getTLAEditorWithFocus returned null");
            return null;
        }
        this.editorIFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        ParseResult parseResult = ResourceHelper.getValidParseResult((IFile)this.editorIFile);
        if (parseResult == null) {
            parseResult = new ModuleParserLauncher().parseModule((IResource)this.editorIFile, (IProgressMonitor)new NullProgressMonitor());
        }
        DecomposeProofRunnable runnable = new DecomposeProofRunnable(this);
        UIHelper.runUISync((Runnable)runnable);
        return null;
    }

    public void setEnabled(Object context) {
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        this.setBaseEnabled(spec.getStatus() == 0);
    }

    private void raiseWindow() {
        if (this.windowShell != null && !this.windowShell.isDisposed()) {
            this.location = this.windowShell.getLocation();
            this.windowShell.close();
            this.windowShell.dispose();
        }
        Shell topshell = UIHelper.getShellProvider().getShell();
        this.windowShell = new Shell(topshell, 112);
        this.windowShell.setText("Decompose Proof");
        this.windowShell.addDisposeListener((DisposeListener)new WindowDisposeListener(this));
        Composite shell = new Composite((Composite)this.windowShell, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        shell.setLayout((Layout)gridLayout);
        Composite topMenu = new Composite(shell, 0);
        gridLayout = new GridLayout(7, false);
        gridLayout.marginBottom = 0;
        topMenu.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        topMenu.setLayoutData((Object)gridData);
        Button backButton = new Button(topMenu, 8);
        this.setupMenuButton(backButton, 1, "\u2190");
        backButton.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        backButton.setEnabled(this.state.previousState != null);
        Button replaceButton = new Button(topMenu, 8);
        this.setupMenuButton(replaceButton, 2, "P");
        replaceButton.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        replaceButton.setEnabled(this.state.hasChanged && !this.state.splitChosen());
        this.showContextButton = new Button(topMenu, 32);
        this.setupCheckButton(this.showContextButton, "Show Context");
        this.showContextButton.setSelection(this.showContextValue);
        this.showContextButton.addSelectionListener((SelectionListener)new DecomposeProofButtonListener(this, new Integer(3), 1));
        this.useSufficesButton = new Button(topMenu, 32);
        this.setupCheckButton(this.useSufficesButton, "Use SUFFICES");
        this.useSufficesButton.setSelection(this.useSufficesValue);
        this.useCaseButton = new Button(topMenu, 32);
        this.setupCheckButton(this.useCaseButton, "Use CASE");
        this.useCaseButton.setSelection(this.useCaseValue);
        this.subexpressionButton = new Button(topMenu, 32);
        this.setupCheckButton(this.subexpressionButton, "Use subexpression names");
        this.subexpressionButton.setSelection(this.subexpressionValue);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.subexpressionButton.setLayoutData((Object)gridData);
        this.subexpressionButton.setVisible(false);
        Button helpButton = HelpButton.helpButton((Composite)topMenu, (String)"prover/decompose.html");
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        helpButton.setLayoutData((Object)gridData);
        if (this.state.assumeReps != null) {
            this.addAssumptionsToComposite(this.state.assumeReps, shell);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Label assumeLabel = new Label(shell, 0);
        assumeLabel.setLayoutData((Object)gridData);
        assumeLabel.setText("PROVE");
        assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        String labelText = null;
        boolean isProver = false;
        boolean disable = false;
        switch (this.state.goalRep.nodeSubtype) {
            case 0: {
                labelText = "/\\";
                isProver = true;
                disable = this.state.splitChosen();
                break;
            }
            case 3: {
                labelText = "\\A";
                disable = this.state.splitChosen();
                break;
            }
            case 2: {
                labelText = "=>";
                break;
            }
            default: {
                labelText = null;
            }
        }
        if (labelText != null) {
            Button goalButton = new Button(shell, 8);
            this.setupActionButton(goalButton, this.state.goalRep, labelText);
            goalButton.setEnabled(!disable);
        } else {
            assumeLabel = new Label(shell, 0);
            assumeLabel.setText("  ");
        }
        Composite comp = new Composite(shell, 0);
        gridLayout = new GridLayout(1, false);
        comp.setLayout((Layout)gridLayout);
        if (isProver && !disable) {
            assumeLabel = new Label(comp, 0);
            assumeLabel.setText("P");
            assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
        }
        comp.setSize(0, 5);
        assumeLabel = new Label(shell, 0);
        assumeLabel.setText(DecomposeProofHandler.stringArrayToString(this.state.goalRep.primedNodeText()));
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        assumeLabel.setLayoutData((Object)gridData);
        assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        shell.pack();
        this.windowShell.pack();
        this.windowShell.update();
        if (this.location != null) {
            this.windowShell.setLocation(this.location);
        }
        this.windowShell.open();
        this.editorIFile.setReadOnly(true);
    }

    void addAssumptionsToComposite(Vector<NodeRepresentation> nodeRepVector, Composite composite) {
        Label assumeLabel;
        GridData gridData;
        int assumeWidth = 0;
        int i = 0;
        while (i < nodeRepVector.size()) {
            int j = 0;
            while (j < nodeRepVector.elementAt((int)i).nodeText.length) {
                assumeWidth = Math.max(assumeWidth, nodeRepVector.elementAt((int)i).nodeText[j].length());
                ++j;
            }
            ++i;
        }
        boolean haveContextAssumpsToDisplay = false;
        int i2 = 0;
        while (i2 < this.state.numberOfContextAssumptions) {
            if (this.displayContextAssump(nodeRepVector.elementAt(i2), i2)) {
                haveContextAssumpsToDisplay = true;
            }
            ++i2;
        }
        if (haveContextAssumpsToDisplay) {
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            assumeLabel = new Label(composite, 0);
            assumeLabel.setText("CONTEXT ASSUMPTIONS");
            assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
            assumeLabel.setLayoutData((Object)gridData);
        }
        i2 = 0;
        while (i2 < nodeRepVector.size()) {
            if (i2 == this.state.numberOfContextAssumptions) {
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                assumeLabel = new Label(composite, 0);
                assumeLabel.setText("ASSUME");
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
                assumeLabel.setLayoutData((Object)gridData);
            }
            if (i2 == this.state.firstAddedAssumption) {
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                assumeLabel = new Label(composite, 0);
                assumeLabel.setText("    - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
                assumeLabel.setLayoutData((Object)gridData);
            }
            NodeRepresentation aRep = nodeRepVector.elementAt(i2);
            if (i2 >= this.state.numberOfContextAssumptions && this.displayNonContextAssump(aRep, i2) || i2 < this.state.numberOfContextAssumptions && this.displayContextAssump(aRep, i2)) {
                GridLayout gridLayout;
                Composite comp;
                if (aRep.nodeType != 2) {
                    String labelText = null;
                    boolean enable = true;
                    if (aRep.semanticNode != null && aRep.semanticNode.getKind() == 9) {
                        switch (aRep.nodeSubtype) {
                            case 0: {
                                labelText = "/\\";
                                enable = !this.state.splitChosen();
                                break;
                            }
                            case 1: 
                            case 5: {
                                labelText = "\\/";
                                enable = !this.state.splitChosen();
                                break;
                            }
                            case 4: {
                                labelText = "\\E";
                                break;
                            }
                            default: {
                                labelText = null;
                            }
                        }
                    }
                    if (labelText != null) {
                        Button button = new Button(composite, 8);
                        this.setupActionButton(button, nodeRepVector.elementAt(i2), labelText);
                        if (!enable) {
                            button.setEnabled(false);
                        }
                    } else {
                        comp = new Composite(composite, 0);
                        gridLayout = new GridLayout(1, false);
                        comp.setLayout((Layout)gridLayout);
                        assumeLabel = new Label(comp, 0);
                        assumeLabel.setText("  ");
                        gridData = new GridData();
                        gridData.horizontalIndent = 25;
                        comp.setLayoutData((Object)gridData);
                    }
                    comp = new Composite(composite, 0);
                    gridLayout = new GridLayout(1, false);
                    comp.setLayout((Layout)gridLayout);
                    comp.setSize(0, 5);
                    comp = new Composite(composite, 0);
                    gridLayout = new GridLayout(3, false);
                    comp.setLayout((Layout)gridLayout);
                    assumeLabel = new Label(comp, 2048);
                    Object text = DecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(i2).primedNodeText());
                    while (nodeRepVector.elementAt((int)i2).onSameLineAsNext) {
                        text = (String)text + ", " + DecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt((int)(++i2)).nodeText);
                    }
                    assumeLabel.setText((String)text);
                    assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                    gridData = new GridData();
                    gridData.horizontalIndent = 0;
                    gridData.verticalAlignment = 128;
                    gridData.horizontalAlignment = 16384;
                    assumeLabel.setLayoutData((Object)gridData);
                } else {
                    Button goalButton = new Button(composite, 8);
                    this.setupActionButton(goalButton, aRep, "P");
                    gridData = new GridData();
                    gridData.horizontalIndent = 15;
                    goalButton.setLayoutData((Object)gridData);
                    goalButton.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont"));
                    comp = new Composite(composite, 0);
                    gridLayout = new GridLayout(1, false);
                    comp.setLayout((Layout)gridLayout);
                    Composite inner = new Composite(composite, 0);
                    gridLayout = new GridLayout(2, false);
                    inner.setLayout((Layout)gridLayout);
                    int j = 0;
                    while (j < aRep.children.size()) {
                        assumeLabel = new Label(inner, 0);
                        assumeLabel.setText("CASE");
                        assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                        Composite caseComp = new Composite(inner, 2048);
                        gridLayout = new GridLayout(3, false);
                        caseComp.setLayout((Layout)gridLayout);
                        this.addCaseToComposite(aRep.children.elementAt(j), caseComp);
                        gridData = new GridData();
                        gridData.verticalAlignment = 128;
                        caseComp.setLayoutData((Object)gridData);
                        ++j;
                    }
                }
            }
            ++i2;
        }
    }

    boolean displayContextAssump(NodeRepresentation rep, int i) {
        return rep.isCreated || !this.state.splitChosen() && this.showContextValue;
    }

    boolean displayNonContextAssump(NodeRepresentation rep, int i) {
        return rep.isCreated || rep.nodeType == 2 || rep.nodeType == 4 || rep.nodeType == 0 && rep.nodeSubtype != 99;
    }

    void addCaseToComposite(Vector<NodeRepresentation> nodeRepVector, Composite composite) {
        int i = 0;
        while (i < nodeRepVector.size()) {
            GridLayout gridLayout;
            Composite comp;
            GridData gridData;
            Label assumeLabel;
            NodeRepresentation aRep = nodeRepVector.elementAt(i);
            if (aRep.nodeType == 1 || aRep.nodeType == 5 || aRep.nodeType == 0 && aRep.nodeSubtype != 1 && aRep.nodeSubtype != 4 && aRep.nodeSubtype != 5) {
                Object text = DecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(i).primedNodeText());
                while (nodeRepVector.elementAt((int)i).onSameLineAsNext) {
                    text = (String)text + ", " + DecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(++i).primedNodeText());
                }
                assumeLabel = new Label(composite, 0);
                assumeLabel.setText((String)text);
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                gridData = new GridData();
                gridData.horizontalSpan = 3;
                assumeLabel.setLayoutData((Object)gridData);
            } else if (aRep.nodeType != 2) {
                String labelText = null;
                if (aRep.semanticNode != null && aRep.semanticNode.getKind() == 9) {
                    switch (aRep.nodeSubtype) {
                        case 0: {
                            labelText = null;
                            break;
                        }
                        case 1: 
                        case 5: {
                            labelText = "\\/";
                            break;
                        }
                        case 4: {
                            labelText = "\\E";
                            break;
                        }
                        default: {
                            labelText = null;
                        }
                    }
                }
                if (labelText != null) {
                    Button button = new Button(composite, 8);
                    this.setupActionButton(button, nodeRepVector.elementAt(i), labelText);
                    if (aRep.nodeSubtype == 0 || aRep.nodeSubtype == 3) {
                        button.setEnabled(false);
                    }
                } else {
                    comp = new Composite(composite, 0);
                    gridLayout = new GridLayout(1, false);
                    comp.setLayout((Layout)gridLayout);
                    assumeLabel = new Label(comp, 0);
                    assumeLabel.setText("  ");
                    gridData = new GridData();
                    gridData.horizontalIndent = 25;
                    comp.setLayoutData((Object)gridData);
                }
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                comp.setSize(0, 5);
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(3, false);
                comp.setLayout((Layout)gridLayout);
                assumeLabel = new Label(comp, 0);
                String text = DecomposeProofHandler.stringArrayToString(nodeRepVector.elementAt(i).primedNodeText());
                assumeLabel.setText(text);
                assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                gridData = new GridData();
                gridData.horizontalIndent = 0;
                gridData.verticalAlignment = 128;
                gridData.horizontalAlignment = 16384;
                assumeLabel.setLayoutData((Object)gridData);
            } else {
                assumeLabel = new Label(composite, 0);
                assumeLabel.setText("  ");
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                comp = new Composite(composite, 0);
                gridLayout = new GridLayout(1, false);
                comp.setLayout((Layout)gridLayout);
                Composite inner = new Composite(composite, 0);
                gridLayout = new GridLayout(2, false);
                inner.setLayout((Layout)gridLayout);
                int j = 0;
                while (j < aRep.children.size()) {
                    assumeLabel = new Label(inner, 0);
                    assumeLabel.setText("CASE");
                    assumeLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
                    Composite caseComp = new Composite(inner, 2048);
                    gridLayout = new GridLayout(3, false);
                    caseComp.setLayout((Layout)gridLayout);
                    this.addCaseToComposite(aRep.children.elementAt(j), caseComp);
                    gridData = new GridData();
                    gridData.verticalAlignment = 128;
                    caseComp.setLayoutData((Object)gridData);
                    ++j;
                }
            }
            ++i;
        }
    }

    void andAction(NodeRepresentation nodeRep) {
        if (nodeRep.getParentVector() != null) {
            int idx = nodeRep.getParentIndex();
            Decomposition decomp = nodeRep.decomposition;
            this.state.hasChanged = false;
            if (decomp.definedOp != null) {
                this.state.assumpDefinitions.add(decomp.definedOp);
            }
            Vector<SemanticNode> addedAssumps = decomp.children;
            Vector<NodeRepresentation> addedToAssumeReps = new Vector<NodeRepresentation>();
            int i = 0;
            while (i < addedAssumps.size()) {
                NodeRepresentation rep = this.decompositionChildToNodeRep(nodeRep, i, this.state.assumeReps, null);
                rep.initialPosition = nodeRep.initialPosition;
                rep.isCreated = false;
                addedToAssumeReps.add(rep);
                ++i;
            }
            this.state.assumeReps.remove(idx);
            i = 0;
            while (i < addedToAssumeReps.size()) {
                this.state.assumeReps.add(idx + i, (NodeRepresentation)addedToAssumeReps.elementAt(i));
                ++i;
            }
            if (idx < this.state.numberOfContextAssumptions) {
                this.state.numberOfContextAssumptions += addedAssumps.size() - 1;
            }
            if (idx < this.state.firstAddedAssumption) {
                this.state.firstAddedAssumption += addedAssumps.size() - 1;
            }
            this.raiseWindow();
            return;
        }
        this.makeProof(nodeRep, true, false);
    }

    void forAllAction(NodeRepresentation nodeRep) {
        QuantifierDecomposition qdc = this.decomposeQuantifier(nodeRep, true);
        if (qdc != null) {
            Decomposition decomp = nodeRep.decomposition;
            this.state.hasChanged = true;
            if (decomp.definedOp != null) {
                this.state.assumpDefinitions.add(decomp.definedOp);
            }
            this.state.goalRep = qdc.body;
            int newIdx = this.newAssumeRepsIndex(-1, nodeRep.initialPosition);
            int i = 0;
            while (i < qdc.news.size()) {
                this.state.assumeReps.add(newIdx + i, qdc.news.elementAt(i));
                ++i;
            }
        }
        this.raiseWindow();
    }

    void existsAction(NodeRepresentation nodeRep) {
        QuantifierDecomposition qdc;
        int idx = nodeRep.getParentIndex();
        Vector<NodeRepresentation> parentVec = nodeRep.getParentVector();
        Decomposition decomp = nodeRep.decomposition;
        this.state.hasChanged = true;
        if (decomp.definedOp != null) {
            if (parentVec == this.state.assumeReps) {
                this.state.assumpDefinitions.add(nodeRep.instantiationSubstitutions.prefix + decomp.definedOp);
            } else {
                this.state.goalDefinitions.add(nodeRep.instantiationSubstitutions.prefix + decomp.definedOp);
            }
        }
        if ((qdc = this.decomposeQuantifier(nodeRep, false)) != null) {
            qdc.body.isCreated = true;
            qdc.body.fromExists = true;
            parentVec.remove(idx);
            if (parentVec == this.state.assumeReps) {
                int newIdx = idx;
                if (idx < this.state.firstAddedAssumption) {
                    --this.state.firstAddedAssumption;
                    newIdx = this.state.firstAddedAssumption;
                }
                if (idx < this.state.numberOfContextAssumptions) {
                    --this.state.numberOfContextAssumptions;
                }
                idx = newIdx;
            }
            int i = 0;
            while (i < qdc.news.size()) {
                parentVec.add(idx + i, qdc.news.elementAt(i));
                ++i;
            }
            parentVec.add(idx + qdc.news.size(), qdc.body);
        }
        this.raiseWindow();
    }

    void impliesAction(NodeRepresentation nodeRep) {
        Decomposition decomp = nodeRep.decomposition;
        this.state.hasChanged = true;
        if (decomp.definedOp != null) {
            this.state.assumpDefinitions.add(decomp.definedOp);
        }
        NodeTextRep newNodeText = null;
        if (decomp.definedOp != null && this.subexpressionButton.getSelection()) {
            newNodeText = decomp.definedOpRep;
        } else if (nodeRep.isSubexpressionName) {
            newNodeText = new NodeTextRep(nodeRep.nodeText, nodeRep.mapping);
        }
        NodeRepresentation nrep = this.decompositionChildToNodeRep(nodeRep, 0, this.state.assumeReps, nodeRep.parentNode);
        nrep.isCreated = true;
        nrep.isPrimed = nrep.isPrimed || decomp.primed;
        int newIdx = this.newAssumeRepsIndex(-1, nodeRep.initialPosition);
        this.state.assumeReps.add(newIdx, nrep);
        nrep = this.decompositionChildToNodeRep(nodeRep, 1, nodeRep.getParentVector(), nodeRep.parentNode);
        nrep.isCreated = true;
        this.state.goalRep = nrep;
        this.raiseWindow();
    }

    void orAction(NodeRepresentation nodeRep) {
        int idx = nodeRep.getParentIndex();
        Vector<NodeRepresentation> parentVec = nodeRep.getParentVector();
        if (parentVec == this.state.assumeReps) {
            int oldIdx = nodeRep.getParentIndex();
            if (oldIdx < this.state.numberOfContextAssumptions) {
                --this.state.numberOfContextAssumptions;
            }
            if (oldIdx < this.state.firstAddedAssumption) {
                --this.state.firstAddedAssumption;
            }
            this.state.assumeReps.remove(oldIdx);
            this.state.assumeReps.add(nodeRep);
        }
        Decomposition decomp = nodeRep.decomposition;
        this.state.hasChanged = true;
        if (decomp.definedOp != null) {
            this.state.goalDefinitions.add(nodeRep.instantiationSubstitutions.prefix + decomp.definedOp);
        }
        nodeRep.nodeType = 2;
        nodeRep.nodeSubtype = 99;
        nodeRep.children = new Vector();
        nodeRep.initialPosition = Integer.MAX_VALUE;
        int i = 0;
        while (i < decomp.children.size()) {
            Vector<NodeRepresentation> repVec = new Vector<NodeRepresentation>();
            nodeRep.children.add(repVec);
            NodeRepresentation rep = this.decompositionChildToNodeRep(nodeRep, i, repVec, nodeRep);
            repVec.add(rep);
            ++i;
        }
        this.raiseWindow();
    }

    void sqsubAction(NodeRepresentation nodeRep) {
        int idx = nodeRep.getParentIndex();
        Vector<NodeRepresentation> parentVec = nodeRep.getParentVector();
        if (parentVec == this.state.assumeReps) {
            nodeRep.initialPosition = Integer.MAX_VALUE;
            int oldIdx = nodeRep.getParentIndex();
            if (oldIdx < this.state.numberOfContextAssumptions) {
                --this.state.numberOfContextAssumptions;
            }
            if (oldIdx < this.state.firstAddedAssumption) {
                --this.state.firstAddedAssumption;
            }
            this.state.assumeReps.remove(oldIdx);
            this.state.assumeReps.add(nodeRep);
        }
        Decomposition decomp = nodeRep.decomposition;
        this.state.hasChanged = true;
        if (decomp.definedOp != null) {
            this.state.goalDefinitions.add(nodeRep.instantiationSubstitutions.prefix + decomp.definedOp);
        }
        nodeRep.nodeType = 2;
        nodeRep.nodeSubtype = 99;
        nodeRep.children = new Vector();
        int i = 0;
        while (i < decomp.children.size()) {
            Vector<NodeRepresentation> repVec = new Vector<NodeRepresentation>();
            nodeRep.children.add(repVec);
            NodeRepresentation rep = this.decompositionChildToNodeRep(nodeRep, i, repVec, nodeRep);
            if (i == 1) {
                rep.nodeType = 5;
                rep.nodeSubtype = 99;
                rep.nodeText = DecomposeProofHandler.prependToStringArray(rep.nodeText, "UNCHANGED ");
            }
            repVec.add(rep);
            ++i;
        }
        this.raiseWindow();
    }

    void caseAction(NodeRepresentation nodeRep) {
        this.makeProof(nodeRep, false, false);
    }

    void makeProof(NodeRepresentation nodeRep, boolean isAndProof, boolean sufficesOnly) {
        boolean hasSufficesStep;
        Vector<NodeRepresentation> createdAssumps = new Vector<NodeRepresentation>();
        StringSet createdAssumpsDefs = new StringSet();
        StringSet createdAssumpStepNames = new StringSet();
        int i = this.state.firstAddedAssumption;
        while (i < this.state.assumeReps.size()) {
            NodeRepresentation rep = this.state.assumeReps.elementAt(i);
            if (rep.nodeType != 2) {
                createdAssumps.add(rep);
                if (rep.contextStepName != null && !rep.fromGoal) {
                    createdAssumpStepNames.add(rep.contextStepName);
                }
                createdAssumpsDefs.addAll(rep.fromDefs);
            } else if (rep != nodeRep) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 3285 of DecomposeProofHandler.");
            }
            ++i;
        }
        Vector<String[]> createdAssumpsNodeTexts = new Vector<String[]>();
        int i2 = 0;
        while (i2 < createdAssumps.size()) {
            createdAssumpsNodeTexts.add(((NodeRepresentation)createdAssumps.elementAt((int)i2)).nodeText);
            ++i2;
        }
        if (sufficesOnly && createdAssumps.size() == 0) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Sanity check failed at line 3301 of DecomposeProofHandler.");
        }
        int proofIndent = 2;
        String proofIndentString = StringHelper.copyString((String)" ", (int)proofIndent);
        String[] assumptionsText = this.createdAssumptions();
        String[] assumptionsAsConjText = new String[createdAssumps.size()];
        int k = 0;
        while (assumptionsAsConjText != null && k < createdAssumps.size()) {
            NodeRepresentation rep = (NodeRepresentation)createdAssumps.elementAt(k);
            if (rep.nodeType == 1) {
                assumptionsAsConjText = null;
            } else {
                assumptionsAsConjText[k] = createdAssumps.size() > 1 ? DecomposeProofHandler.stringArrayToString(DecomposeProofHandler.prependToStringArray(rep.nodeText, "/\\ ")) : DecomposeProofHandler.stringArrayToString(rep.nodeText);
            }
            ++k;
        }
        String[] proofText = null;
        StringSet proofBY = null;
        StringSet proofDEF = null;
        if (this.proof != null) {
            proofText = this.stepRep.subNodeText((SemanticNode)this.proof).nodeText;
            proofText = DecomposeProofHandler.prependToStringArray(proofText, proofIndentString);
            try {
                IRegion proofRegion = EditorUtil.getRegionOf(this.doc, ((SyntaxTreeNode)this.proof.stn).getLocation());
                this.doc.replace(proofRegion.getOffset(), proofRegion.getLength(), "");
            }
            catch (BadLocationException e) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 3358 of DecomposeProofHandler.");
                e.printStackTrace();
            }
            proofBY = new StringSet();
            proofDEF = new StringSet();
            String line = "";
            int lineNum = 0;
            int idx = 0;
            boolean notfound = true;
            while (notfound && lineNum < proofText.length) {
                line = proofText[lineNum].trim();
                if (line.startsWith("BY")) {
                    idx = proofText[lineNum].indexOf("BY") + 2;
                    notfound = false;
                    continue;
                }
                if (line.equals("")) {
                    ++lineNum;
                    continue;
                }
                lineNum = Integer.MAX_VALUE;
            }
            if (!notfound) {
                Object stringBY = "";
                boolean defNotfound = true;
                while (defNotfound && lineNum < proofText.length) {
                    line = proofText[lineNum].substring(idx, proofText[lineNum].length());
                    int defIdx = 0;
                    while (defIdx < line.length() && defNotfound) {
                        if ((defIdx = line.indexOf("DEF", defIdx)) == -1) {
                            defIdx = line.length();
                            continue;
                        }
                        if ((defIdx == 0 || Character.isWhitespace(line.charAt(defIdx - 1))) && (defIdx + 3 == line.length() || Character.isWhitespace(line.charAt(defIdx + 3)))) {
                            defNotfound = false;
                            continue;
                        }
                        defIdx += 3;
                    }
                    stringBY = (String)stringBY + line.substring(0, defIdx);
                    if (defNotfound) {
                        ++lineNum;
                        idx = 0;
                        continue;
                    }
                    idx = idx + defIdx + 3;
                }
                proofBY.addAll(StringSet.CommaSeparatedListToStringSet((String)stringBY));
                if (!defNotfound) {
                    Object stringDEF = "";
                    while (lineNum < proofText.length) {
                        line = proofText[lineNum].substring(idx, proofText[lineNum].length());
                        stringDEF = (String)stringDEF + line;
                        ++lineNum;
                        idx = 0;
                    }
                    proofDEF.addAll(StringSet.CommaSeparatedListToStringSet((String)stringDEF));
                }
            }
        }
        String[] sufficesStep = null;
        boolean bl = hasSufficesStep = this.useSufficesButton.getSelection() && createdAssumps.size() != 0 || sufficesOnly;
        if (hasSufficesStep) {
            Object sufficesProof = null;
            StringSet sufficesDEF = createdAssumpsDefs.clone();
            if (nodeRep != null && nodeRep.nodeType == 2 && (nodeRep.fromGoal || nodeRep.fromExists)) {
                if (createdAssumps.size() != 0) {
                    assumptionsText = DecomposeProofHandler.appendToStringArray(assumptionsText, ",");
                }
                assumptionsText = DecomposeProofHandler.concatStringArrays(assumptionsText, nodeRep.nodeText);
                sufficesDEF.addAll(nodeRep.fromDefs);
            }
            String[] suffices = DecomposeProofHandler.prependToStringArray(DecomposeProofHandler.concatStringArrays(DecomposeProofHandler.prependToStringArray(assumptionsText, "ASSUME "), DecomposeProofHandler.prependToStringArray(this.state.goalRep.primedNodeText(), "PROVE  ")), this.proofLevelString + " SUFFICES ");
            if (this.state.assumpDefinitions.isEmpty() && createdAssumpStepNames.isEmpty()) {
                sufficesProof = "OBVIOUS";
            } else {
                sufficesProof = "BY ";
                if (!createdAssumpStepNames.isEmpty()) {
                    sufficesProof = (String)sufficesProof + createdAssumpStepNames.toCommaSeparatedString() + " ";
                }
                if (!sufficesDEF.isEmpty()) {
                    sufficesProof = (String)sufficesProof + "DEF " + sufficesDEF.toCommaSeparatedString();
                }
            }
            sufficesStep = DecomposeProofHandler.concatStringArrays(suffices, new String[]{proofIndentString + (String)sufficesProof});
        }
        String[][] mainProofSteps = null;
        int numberOfSteps = 0;
        String proofDef = null;
        if (!sufficesOnly) {
            if (isAndProof) {
                Decomposition decomp = nodeRep.decomposition;
                numberOfSteps = decomp.children.size();
                mainProofSteps = new String[numberOfSteps][];
                proofDef = decomp.definedOp;
                int i3 = 0;
                while (i3 < numberOfSteps) {
                    String[] step;
                    NodeRepresentation stepGoalRep = this.decompositionChildToNodeRep(nodeRep, i3, null, null);
                    String[] goalArray = stepGoalRep.primedNodeText();
                    boolean isAssumeProve = false;
                    if (sufficesStep == null && createdAssumps.size() != 0) {
                        step = DecomposeProofHandler.concatStringArrays(DecomposeProofHandler.prependToStringArray(assumptionsText, "ASSUME "), DecomposeProofHandler.prependToStringArray(goalArray, "PROVE  "));
                        isAssumeProve = true;
                    } else {
                        step = goalArray;
                    }
                    String stepNum = this.proofLevelString + (i3 + 1);
                    step = DecomposeProofHandler.prependToStringArray(step, stepNum + ". ");
                    if (proofText != null) {
                        String[] newProofText = (String[])proofText.clone();
                        if (isAssumeProve) {
                            this.addStepNumToProof(stepNum, newProofText);
                        }
                        step = DecomposeProofHandler.concatStringArrays(step, newProofText);
                    }
                    mainProofSteps[i3] = step;
                    ++i3;
                }
            } else {
                Vector<String[]> pfStepVec = new Vector<String[]>();
                int i4 = 0;
                while (i4 < nodeRep.children.size()) {
                    String[] assumpArray;
                    Vector<NodeRepresentation> childVec = nodeRep.children.elementAt(i4);
                    if (!hasSufficesStep) {
                        assumpArray = new String[assumptionsText.length];
                        int j = 0;
                        while (j < assumptionsText.length) {
                            assumpArray[j] = assumptionsText[j];
                            ++j;
                        }
                    } else {
                        assumpArray = new String[]{};
                        assumptionsAsConjText = new String[]{};
                    }
                    boolean assumpArrayOnlyFormulas = true;
                    int j = 0;
                    while (j < createdAssumps.size()) {
                        assumpArrayOnlyFormulas = assumpArrayOnlyFormulas && ((NodeRepresentation)createdAssumps.elementAt((int)j)).nodeType != 1;
                        ++j;
                    }
                    this.addCaseProofs(pfStepVec, childVec, assumpArray, proofText, assumptionsAsConjText);
                    ++i4;
                }
                mainProofSteps = new String[pfStepVec.size()][];
                i4 = 0;
                while (i4 < mainProofSteps.length) {
                    mainProofSteps[i4] = (String[])pfStepVec.elementAt(i4);
                    ++i4;
                }
                numberOfSteps = mainProofSteps.length;
            }
        }
        String[] qedStep = new String[2];
        qedStep[0] = this.proofLevelString;
        if (numberOfSteps != 0) {
            qedStep[0] = qedStep[0] + (numberOfSteps + 1) + STEP_NUMBER_PUNCTUATION;
        }
        qedStep[0] = qedStep[0] + " QED";
        if (sufficesOnly) {
            if (proofText != null) {
                qedStep[1] = DecomposeProofHandler.stringArrayToString(proofText);
            } else {
                qedStep = new String[]{qedStep[0]};
            }
        } else {
            StringSet qedBY = new StringSet();
            StringSet qedDEF = new StringSet();
            int i5 = 1;
            while (i5 <= numberOfSteps) {
                qedBY.add(this.proofLevelString + i5);
                ++i5;
            }
            if (isAndProof) {
                qedBY.addAll(createdAssumpStepNames);
                if (proofDef != null) {
                    qedDEF.add(proofDef);
                }
                if (!hasSufficesStep) {
                    qedDEF.addAll(nodeRep.fromDefs);
                    qedDEF.addAll(createdAssumpsDefs);
                }
            } else if (this.useSufficesButton.getSelection()) {
                if (nodeRep.contextStepName != null) {
                    qedBY.add(nodeRep.contextStepName);
                }
                qedDEF.addAll(this.state.goalDefinitions);
                if (!hasSufficesStep && nodeRep.fromGoal) {
                    qedDEF.addAll(nodeRep.fromDefs);
                }
            } else {
                qedBY.addAll(createdAssumpStepNames);
                if (nodeRep.contextStepName != null) {
                    qedBY.add(nodeRep.contextStepName);
                }
                qedDEF.addAll(createdAssumpsDefs);
                qedDEF.addAll(nodeRep.fromDefs);
                qedDEF.addAll(this.state.goalDefinitions);
            }
            qedStep[1] = proofIndentString + "BY " + qedBY.toCommaSeparatedString();
            if (!qedDEF.isEmpty()) {
                qedStep[1] = qedStep[1] + " DEF " + qedDEF.toCommaSeparatedString();
            }
        }
        String[] blankLine = new String[]{""};
        String[] completeProof = new String[]{};
        if (sufficesStep != null) {
            completeProof = sufficesStep;
        }
        if (mainProofSteps != null) {
            completeProof = DecomposeProofHandler.concatStringArrays(completeProof, mainProofSteps[0]);
            int i6 = 1;
            while (i6 < mainProofSteps.length) {
                completeProof = DecomposeProofHandler.concatStringArrays(completeProof, mainProofSteps[i6]);
                ++i6;
            }
        }
        completeProof = DecomposeProofHandler.concatStringArrays(completeProof, qedStep);
        completeProof = DecomposeProofHandler.prependToStringArray(completeProof, StringHelper.copyString((String)" ", (int)(this.step.getLocation().beginColumn() - 1 + proofIndent)));
        try {
            int nextLineOffset = this.doc.getLineInformation(this.step.getTheorem().getLocation().endLine()).getOffset();
            this.doc.replace(nextLineOffset, 0, DecomposeProofHandler.stringArrayToString(completeProof) + "\n");
        }
        catch (BadLocationException e) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 3845 of DecomposeProofHandler.");
            e.printStackTrace();
        }
        this.windowShell.dispose();
    }

    void addCaseProofs(Vector<String[]> pfStepVec, Vector<NodeRepresentation> childVec, String[] assumpArray, String[] proofText, String[] assumpArrayAsFormula) {
        int newAssumpCount = assumpArray.length;
        Object newAssumpArrayAsFormula = assumpArrayAsFormula;
        newAssumpArrayAsFormula = childVec.elementAt((int)0).nodeType == 1 ? null : new String[]{};
        NodeRepresentation lastChildNode = childVec.elementAt(childVec.size() - 1);
        int lenOfChildAssumps = childVec.size();
        if (lastChildNode.nodeType == 2) {
            --lenOfChildAssumps;
        }
        int i = 0;
        while (i < lenOfChildAssumps) {
            newAssumpCount += childVec.elementAt(i).primedNodeText().length;
            ++i;
        }
        String[] newAssumpArray = new String[newAssumpCount];
        int i2 = 0;
        while (i2 < assumpArray.length) {
            newAssumpArray[i2] = assumpArray[i2];
            ++i2;
        }
        if (lenOfChildAssumps > 0) {
            if (assumpArray.length > 0) {
                newAssumpArray[assumpArray.length - 1] = newAssumpArray[assumpArray.length - 1] + ",";
            }
            int idx = assumpArray.length;
            int i3 = 0;
            while (i3 < lenOfChildAssumps) {
                String[] assump = childVec.elementAt(i3).primedNodeText();
                int j = 0;
                while (j < assump.length) {
                    newAssumpArray[idx] = assump[j];
                    ++idx;
                    ++j;
                }
                if (i3 != lenOfChildAssumps - 1) {
                    newAssumpArray[idx - 1] = newAssumpArray[idx - 1] + ",";
                }
                ++i3;
            }
        }
        if (lastChildNode.nodeType == 2) {
            i2 = 0;
            while (i2 < lastChildNode.children.size()) {
                this.addCaseProofs(pfStepVec, lastChildNode.children.elementAt(i2), newAssumpArray, proofText, (String[])newAssumpArrayAsFormula);
                ++i2;
            }
        } else {
            String[] step;
            if (assumpArrayAsFormula != null && this.useCaseButton.getSelection() && childVec.size() == 1) {
                if (assumpArrayAsFormula.length == 0) {
                    step = DecomposeProofHandler.prependToStringArray(lastChildNode.primedNodeText(), "CASE ");
                } else {
                    String[] aarrayAsForm = (String[])assumpArrayAsFormula.clone();
                    if (assumpArrayAsFormula.length == 1) {
                        aarrayAsForm[0] = "/\\ " + aarrayAsForm[0];
                    }
                    step = DecomposeProofHandler.prependToStringArray(DecomposeProofHandler.concatStringArrays(aarrayAsForm, DecomposeProofHandler.prependToStringArray(lastChildNode.primedNodeText(), "/\\ ")), "CASE ");
                }
            } else {
                step = DecomposeProofHandler.concatStringArrays(DecomposeProofHandler.prependToStringArray(newAssumpArray, "ASSUME "), DecomposeProofHandler.prependToStringArray(this.state.goalRep.primedNodeText(), "PROVE  "));
            }
            String stepNum = this.proofLevelString + (pfStepVec.size() + 1);
            step = DecomposeProofHandler.prependToStringArray(step, stepNum + ". ");
            if (proofText != null) {
                String[] newProofText = (String[])proofText.clone();
                this.addStepNumToProof(stepNum, newProofText);
                step = DecomposeProofHandler.concatStringArrays(step, newProofText);
            }
            pfStepVec.add(step);
        }
    }

    private void addStepNumToProof(String stepNum, String[] proofText) {
        LeafProofNode pfNode = (LeafProofNode)this.proof;
        if (pfNode.getOmitted()) {
            return;
        }
        if (!(pfNode.getFacts() != null && pfNode.getFacts().length != 0 || pfNode.getDefs() != null && pfNode.getDefs().length != 0)) {
            int i = 0;
            boolean notDone = true;
            while (notDone && i < proofText.length) {
                int idx = proofText[i].indexOf("OBVIOUS");
                if (idx != -1) {
                    proofText[i] = proofText[i].replaceFirst("OBVIOUS", "BY " + stepNum);
                    notDone = false;
                }
                ++i;
            }
        } else {
            String comesAfter = "BY";
            if (pfNode.getOnlyFlag()) {
                comesAfter = "ONLY";
            }
            Object stepNumAdded = stepNum;
            if (pfNode.getFacts() != null && pfNode.getFacts().length > 0) {
                stepNumAdded = stepNum + ",";
            }
            int i = 0;
            boolean notDone = true;
            while (notDone && i < proofText.length) {
                int idx = proofText[i].indexOf(comesAfter);
                if (idx != -1) {
                    proofText[i] = proofText[i].replaceFirst(comesAfter, comesAfter + " " + (String)stepNumAdded);
                    notDone = false;
                }
                ++i;
            }
        }
    }

    NodeRepresentation decompositionChildToNodeRep(NodeRepresentation nodeRep, int i, Vector<NodeRepresentation> vec, NodeRepresentation father) {
        NodeRepresentation result;
        Decomposition decomp = nodeRep.decomposition;
        NodeTextRep newNodeText = null;
        if (decomp.definedOp != null && this.subexpressionButton.getSelection()) {
            newNodeText = DecomposeProofHandler.appendToNodeText(decomp.definedOpRep, decomp.namePath.elementAt(i));
        } else if (nodeRep.isSubexpressionName) {
            newNodeText = DecomposeProofHandler.appendToNodeText(new NodeTextRep(nodeRep.nodeText, nodeRep.mapping), decomp.namePath.elementAt(i));
        }
        IDocument childDoc = this.doc;
        String moduleName = this.moduleNode.getName().toString();
        if (decomp.moduleName != null) {
            childDoc = this.moduleNameToIDocument(decomp.moduleName);
        }
        if (decomp.definedOp != null && newNodeText == null) {
            try {
                NodeRepresentation res = new NodeRepresentation(childDoc, decomp.children.elementAt(i));
                NodeTextRep ntext = this.decompSubstituteInNodeText(nodeRep, (ExprNode)decomp.children.elementAt(i), new NodeTextRep(res.nodeText, res.mapping), nodeRep);
                res.nodeText = ntext.nodeText;
                res.mapping = ntext.mapping;
                if (res.decomposition != null) {
                    res.decomposition.renaming = ntext.renaming;
                }
                res.instantiationSubstitutions = decomp.instantiationSubstitutions.clone();
                result = res.subNodeRep(decomp.children.elementAt(i), vec, father, null, decomp, vec != null);
                result.isPrimed = nodeRep.isPrimed;
                if (result.decomposition != null) {
                    result.decomposition.renaming = result.decomposition.renaming.addAll(ntext.renaming);
                }
                if (!(decomp.children.elementAt(i) instanceof ExprNode)) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 4152 of DecomposeProofHandler.");
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 4160 of DecomposeProofHandler.");
                return null;
            }
            if (result.semanticNode instanceof OpApplNode) {
                NodeTextRep ntr = result.toNodeTextRep();
                ntr = this.instantiateInNodeText(DecomposeProofHandler.OpDeclNodeVectorToArray(decomp.instantiationSubstitutions.params), DecomposeProofHandler.StringVectorToArray(decomp.instantiationSubstitutions.substs), (ExprOrOpArgNode)((OpApplNode)result.semanticNode), ntr);
                if ((ntr = this.renameInNodeText((ExprOrOpArgNode)((OpApplNode)result.semanticNode), ntr, decomp.instantiationSubstitutions.prefix, "")) == null) {
                    return null;
                }
                result.nodeText = ntr.nodeText;
                result.mapping = ntr.mapping;
            }
        } else {
            result = nodeRep.subNodeRep(decomp.children.elementAt(i), vec, father, newNodeText, decomp, vec != null);
            NodeTextRep ntext = this.decompSubstituteInNodeText(nodeRep, (ExprNode)decomp.children.elementAt(i), new NodeTextRep(result.nodeText, result.mapping), nodeRep);
            result.nodeText = ntext.nodeText;
            result.mapping = ntext.mapping;
            if (result.decomposition != null) {
                result.decomposition.renaming = ntext.renaming;
            }
        }
        result.isPrimed = result.isPrimed || decomp.primed;
        result.isSubexpressionName = nodeRep.isSubexpressionName || newNodeText != null;
        result.initialPosition = nodeRep.initialPosition;
        result.contextStepName = nodeRep.contextStepName;
        result.fromGoal = nodeRep.fromGoal;
        result.fromExists = nodeRep.fromExists;
        result.fromDefs = nodeRep.fromDefs.clone();
        result.instantiationSubstitutions = decomp.instantiationSubstitutions;
        if (decomp.definedOp != null) {
            result.fromDefs.add(nodeRep.instantiationSubstitutions.prefix + decomp.definedOp);
        }
        return result;
    }

    IDocument moduleNameToIDocument(String moduleName) {
        IDocument result = this.moduleNameToDoc.get(moduleName);
        if (result == null) {
            IFile moduleIFile = (IFile)ResourceHelper.getResourceByModuleName((String)moduleName);
            FileEditorInput fileEditorInput = new FileEditorInput(moduleIFile);
            FileDocumentProvider moduleFileDocProvider = new FileDocumentProvider();
            try {
                moduleFileDocProvider.connect((Object)fileEditorInput);
            }
            catch (CoreException e1) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 4239 of DecomposeProofHandler.");
            }
            result = moduleFileDocProvider.getDocument((Object)fileEditorInput);
        }
        return result;
    }

    QuantifierDecomposition decomposeQuantifier(NodeRepresentation nodeRepArg, boolean isForAll) {
        QuantifierDecomposition result = new QuantifierDecomposition();
        result.news = new Vector();
        NodeRepresentation nodeRep = nodeRepArg;
        Decomposition decomp = nodeRep.decomposition;
        NodeTextRep newNodeText = null;
        if (decomp.definedOp != null && this.subexpressionButton.getSelection()) {
            newNodeText = decomp.definedOpRep;
        } else if (nodeRep.isSubexpressionName) {
            newNodeText = new NodeTextRep(nodeRep.nodeText, nodeRep.mapping);
        } else if (decomp.definedOp != null) {
            NodeTextRep ntr;
            ExprNode sn;
            block34: {
                block33: {
                    if (nodeRepArg.semanticNode instanceof OpApplNode) break block33;
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 4313 of DecomposeProofHandler.");
                    return null;
                }
                try {
                    OpApplNode oan = (OpApplNode)nodeRepArg.semanticNode;
                    if (oan.getOperator().getName() == ASTConstants.OP_prime) {
                        oan = (OpApplNode)oan.getArgs()[0];
                    }
                    InstanceSubstitution instSubs = decomp.instantiationSubstitutions.clone();
                    sn = ((OpDefNode)oan.getOperator()).getBody();
                    while (sn instanceof SubstInNode) {
                        sn = ((SubstInNode)sn).getBody();
                    }
                    String moduleName = sn.getLocation().source();
                    IDocument idoc = this.moduleNameToIDocument(moduleName);
                    NodeRepresentation res = new NodeRepresentation(idoc, (SemanticNode)sn);
                    nodeRep = res.subNodeRep((SemanticNode)sn, nodeRepArg.getParentVector(), nodeRepArg.parentNode, null, decomp, !isForAll);
                    nodeRep.isPrimed = nodeRepArg.isPrimed;
                    nodeRep.fromGoal = nodeRepArg.fromGoal;
                    nodeRep.fromExists = nodeRepArg.fromExists;
                    nodeRep.fromDefs = nodeRepArg.fromDefs.clone();
                    nodeRep.instantiationSubstitutions = instSubs;
                    if (decomp.definedOp != null) {
                        nodeRep.fromDefs.add(nodeRepArg.instantiationSubstitutions.prefix + decomp.definedOp);
                    }
                    ntr = nodeRep.toNodeTextRep();
                    ntr = this.instantiateInNodeText(DecomposeProofHandler.OpDeclNodeVectorToArray(nodeRep.instantiationSubstitutions.params), DecomposeProofHandler.StringVectorToArray(nodeRep.instantiationSubstitutions.substs), (ExprOrOpArgNode)((OpApplNode)nodeRep.semanticNode), ntr);
                    if ((ntr = this.renameInNodeText((ExprOrOpArgNode)((OpApplNode)nodeRep.semanticNode), ntr, nodeRep.instantiationSubstitutions.prefix, "")) != null) break block34;
                    return null;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 4390 of DecomposeProofHandler.");
                    return null;
                }
            }
            nodeRep.nodeText = ntr.nodeText;
            nodeRep.mapping = ntr.mapping;
            nodeRep.decomposition.formalParams = nodeRepArg.decomposition.formalParams;
            nodeRep.decomposition.arguments = nodeRepArg.decomposition.arguments;
            nodeRep.decomposition.argNodes = nodeRepArg.decomposition.argNodes;
            NodeTextRep ntext = this.decompSubstituteInNodeText(nodeRep, sn, new NodeTextRep(nodeRep.nodeText, nodeRep.mapping), nodeRepArg);
            nodeRep.nodeText = ntext.nodeText;
            nodeRep.mapping = ntext.mapping;
            if (nodeRep.decomposition != null) {
                nodeRep.decomposition.renaming = ntext.renaming;
            }
        }
        Vector<FormalParamNode> idsToRename = new Vector<FormalParamNode>();
        Vector<String> idNewNames = new Vector<String>();
        if (!isForAll) {
            StringSet prevDeclared = this.declaredIdentifiers.clone();
            this.addDeclaredSymbols(prevDeclared, nodeRepArg);
            this.addSymbolsDeclaredLater(prevDeclared, nodeRepArg, true);
            int i = 0;
            while (i < decomp.quantIds.size()) {
                FormalParamNode id = decomp.quantIds.elementAt(i);
                if (prevDeclared.contains(this.getCurrentName(id, decomp.renaming))) {
                    idsToRename.add(id);
                    idNewNames.add(this.getNewName(id, prevDeclared, decomp.renaming));
                }
                ++i;
            }
            FormalParamNode[] formalParams = new FormalParamNode[idsToRename.size()];
            String[] arguments = new String[idsToRename.size()];
            boolean[] isBoundedIdRenaming = new boolean[idsToRename.size()];
            SemanticNode[] argNodes = new SemanticNode[idsToRename.size()];
            int i2 = 0;
            while (i2 < idsToRename.size()) {
                formalParams[i2] = (FormalParamNode)idsToRename.elementAt(i2);
                arguments[i2] = (String)idNewNames.elementAt(i2);
                isBoundedIdRenaming[i2] = true;
                argNodes[i2] = null;
                ++i2;
            }
            NodeTextRep nText = this.substituteInNodeText(formalParams, arguments, isBoundedIdRenaming, argNodes, (ExprNode)nodeRep.semanticNode, new NodeTextRep(nodeRep.nodeText, nodeRep.mapping), nodeRep.decomposition);
            nodeRep.nodeText = nText.nodeText;
            nodeRep.mapping = nText.mapping;
            int i3 = 0;
            while (i3 < idsToRename.size()) {
                this.addCurrentName((FormalParamNode)idsToRename.elementAt(i3), (String)idNewNames.elementAt(i3), nodeRep.decomposition.renaming);
                this.addCurrentName((FormalParamNode)idsToRename.elementAt(i3), (String)idNewNames.elementAt(i3), this.state.renaming);
                ++i3;
            }
        }
        int lastLine = -1;
        int i = 0;
        while (i < decomp.quantIds.size()) {
            NodeRepresentation rep = new NodeRepresentation();
            rep.initialPosition = nodeRepArg.initialPosition;
            rep.semanticNode = null;
            rep.nodeType = 1;
            rep.newId = this.getCurrentName(decomp.quantIds.elementAt(i), nodeRep.decomposition.renaming);
            rep.isCreated = true;
            rep.parentNode = nodeRep.parentNode;
            if (nodeRep.getParentVector() != null) {
                rep.setParentVector(nodeRep.getParentVector());
            } else {
                rep.setParentVector(this.state.assumeReps);
            }
            NodeTextRep ntrep = new NodeTextRep();
            String id = "NEW " + rep.newId;
            int beginLine = ((SyntaxTreeNode)decomp.quantIds.elementAt((int)i).stn).getLocation().beginLine();
            if (decomp.quantBounds == null) {
                ntrep.nodeText = new String[1];
                ntrep.nodeText[0] = id;
                ntrep.mapping = new Vector[1];
                ntrep.mapping[0] = new Vector();
                ntrep.mapping[0].addElement(new MappingPair(1, -1));
            } else {
                if (newNodeText == null) {
                    ntrep = nodeRep.subNodeText((SemanticNode)decomp.quantBounds.elementAt(i));
                    if (decomp.primed || nodeRep.isPrimed) {
                        ntrep = DecomposeProofHandler.primingNeedsParens((SemanticNode)decomp.quantBounds.elementAt(i)) ? DecomposeProofHandler.prependToNodeText(DecomposeProofHandler.appendToNodeText(ntrep, ")'"), "(") : DecomposeProofHandler.appendToNodeText(ntrep, "'");
                    }
                } else {
                    Object str = decomp.quantBoundsubexpNames.elementAt(i);
                    if (decomp.primed) {
                        str = (String)str + "'";
                    }
                    ntrep = DecomposeProofHandler.appendToNodeText(newNodeText, (String)str);
                }
                ntrep = DecomposeProofHandler.prependToNodeText(ntrep, " \\in ");
                if (ntrep.nodeText.length > 1) {
                    beginLine = -1;
                }
            }
            if (decomp.quantBounds != null) {
                ntrep = DecomposeProofHandler.prependToNodeText(ntrep, id);
                rep.semanticNode = (SemanticNode)decomp.quantBounds.elementAt(i);
            }
            rep.nodeText = ntrep.nodeText;
            rep.mapping = ntrep.mapping;
            rep.contextStepName = nodeRepArg.contextStepName;
            rep.fromGoal = nodeRepArg.fromGoal;
            rep.fromDefs = nodeRep.fromDefs;
            result.news.add(rep);
            if (beginLine != -1 && beginLine == lastLine) {
                result.news.elementAt((int)(i - 1)).onSameLineAsNext = true;
            }
            lastLine = beginLine;
            ++i;
        }
        if (newNodeText != null) {
            Object str = "!(";
            int i4 = 0;
            while (i4 < decomp.quantIds.size()) {
                if (i4 != 0) {
                    str = (String)str + ", ";
                }
                str = (String)str + decomp.quantIds.elementAt(i4).getName().toString();
                ++i4;
            }
            str = (String)str + ")";
            newNodeText = DecomposeProofHandler.appendToNodeText(newNodeText, (String)str);
        }
        result.body = nodeRep.subNodeRep(decomp.children.elementAt(0), nodeRep.getParentVector(), nodeRep.parentNode, newNodeText, nodeRep.decomposition, !isForAll);
        result.body.isCreated = true;
        result.body.isPrimed = result.body.isPrimed || decomp.primed;
        result.body.isSubexpressionName = nodeRep.isSubexpressionName || newNodeText != null;
        result.body.initialPosition = nodeRepArg.initialPosition;
        result.body.contextStepName = nodeRepArg.contextStepName;
        result.body.fromGoal = nodeRep.fromGoal;
        result.body.fromExists = nodeRep.fromExists;
        result.body.fromDefs = nodeRep.fromDefs.clone();
        return result;
    }

    String[] createdAssumptions() {
        Boolean sufficesSelected = this.useSufficesButton.getSelection();
        Vector<String[]> vec = new Vector<String[]>();
        int lastAddedAssump = this.state.assumeReps.size();
        if (this.state.splitChosen()) {
            --lastAddedAssump;
        }
        int i = this.state.firstAddedAssumption;
        while (i < lastAddedAssump) {
            NodeRepresentation rep = this.state.assumeReps.elementAt(i);
            Object newDecls = null;
            while (rep.onSameLineAsNext) {
                newDecls = newDecls != null ? newDecls + ", " : "";
                newDecls = (String)newDecls + rep.nodeText[0];
                rep = this.state.assumeReps.elementAt(++i);
            }
            if (newDecls == null) {
                vec.add(rep.primedNodeText());
            } else {
                vec.add(new String[]{(String)newDecls + ", " + rep.nodeText[0]});
            }
            ++i;
        }
        Vector<String> resVec = new Vector<String>();
        int i2 = 0;
        while (i2 < vec.size()) {
            String[] strArray = (String[])vec.elementAt(i2);
            int j = 0;
            while (j < strArray.length) {
                Object str = strArray[j];
                if (j == strArray.length - 1 && i2 != vec.size() - 1) {
                    str = (String)str + ",";
                }
                resVec.add((String)str);
                ++j;
            }
            ++i2;
        }
        String[] result = new String[resVec.size()];
        int i3 = 0;
        while (i3 < result.length) {
            result[i3] = (String)resVec.elementAt(i3);
            ++i3;
        }
        return result;
    }

    NodeTextRep substituteInNodeText(FormalParamNode[] formalParams, String[] arguments, boolean[] isBoundedIdRenaming, SemanticNode[] argNodes, ExprNode sn, NodeTextRep nodeTextRep, Decomposition decomp) {
        NodeTextRep result = nodeTextRep.clone();
        int numOfLines = result.nodeText.length;
        Vector[] inserts = new Vector[numOfLines];
        int i = 0;
        while (i < numOfLines) {
            inserts[i] = new Vector();
            ++i;
        }
        int beginLine = sn.stn.getLocation().beginLine();
        int i2 = 0;
        while (i2 < arguments.length) {
            Location useLocation;
            SemanticNode[] uses = ResourceHelper.getUsesOfSymbol((SymbolNode)formalParams[i2], (SemanticNode)sn);
            String replacementText = arguments[i2];
            int sourceTextLength = this.getCurrentName(formalParams[i2], decomp.renaming).length();
            boolean mayNeedParens = false;
            if (DecomposeProofHandler.primingNeedsParens(argNodes[i2]) && (replacementText.charAt(replacementText.length() - 1) != '\'' || replacementText.startsWith("\\/") || replacementText.startsWith("/\\"))) {
                mayNeedParens = true;
            }
            int j = 0;
            while (j < uses.length) {
                if (!(uses[j] instanceof OpApplNode)) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 4750 of DecomposeProofHandler.");
                    return result;
                }
                Location useLocation2 = uses[j].stn.getLocation();
                int useIdx = useLocation2.beginLine() - beginLine;
                int offset = DecomposeProofHandler.colToLoc(useLocation2.beginColumn(), result.mapping[useIdx]);
                Object thisReplaceText = replacementText;
                if (mayNeedParens) {
                    String[] precedingSafe = new String[]{"(", "[", "{", ",", "<<", "->", ":"};
                    String[] followingSafe = new String[]{")", "]", "}", ",", ">>", "->", "~>"};
                    String testString = result.nodeText[useIdx].substring(0, offset).trim();
                    int line = useIdx;
                    while (testString.equals("") && line > 0) {
                        testString = result.nodeText[--line];
                    }
                    boolean terminated = testString.equals("");
                    int k = 0;
                    while (!terminated && k < precedingSafe.length) {
                        terminated = testString.endsWith(precedingSafe[k]);
                        ++k;
                    }
                    if (terminated) {
                        testString = result.nodeText[useIdx].substring(offset + sourceTextLength).trim();
                        line = useIdx;
                        while (testString.equals("") && line < result.nodeText.length - 1) {
                            testString = result.nodeText[++line];
                        }
                        terminated = testString.equals("");
                        k = 0;
                        while (!terminated && k < precedingSafe.length) {
                            terminated = testString.startsWith(followingSafe[k]);
                            ++k;
                        }
                    }
                    if (!terminated) {
                        thisReplaceText = "(" + replacementText + ")";
                    }
                }
                result.nodeText[useIdx] = result.nodeText[useIdx].substring(0, offset) + (String)thisReplaceText + result.nodeText[useIdx].substring(offset + sourceTextLength);
                DecomposeProofHandler.adjustMappingPairVector(useLocation2.beginColumn() + 1, ((String)thisReplaceText).length() - sourceTextLength, result.mapping[useIdx]);
                inserts[useIdx].add(new Insertion(offset, sourceTextLength, ((String)thisReplaceText).length()));
                ++j;
            }
            if (isBoundedIdRenaming[i2] && EditorUtil.locationContainment(useLocation = formalParams[i2].stn.getLocation(), sn.stn.getLocation())) {
                int useIdx = useLocation.beginLine() - beginLine;
                int offset = DecomposeProofHandler.colToLoc(useLocation.beginColumn(), result.mapping[useIdx]);
                result.nodeText[useIdx] = result.nodeText[useIdx].substring(0, offset) + replacementText + result.nodeText[useIdx].substring(offset + sourceTextLength);
                DecomposeProofHandler.adjustMappingPairVector(useLocation.beginColumn() + 1, replacementText.length() - sourceTextLength, result.mapping[useIdx]);
                inserts[useIdx].add(new Insertion(offset, sourceTextLength, replacementText.length()));
            }
            ++i2;
        }
        DecomposeProofHandler.adjustIndentation(nodeTextRep, result, inserts);
        return result;
    }

    NodeTextRep instantiateInNodeText(OpDeclNode[] formalParams, String[] arguments, ExprOrOpArgNode sn, NodeTextRep nodeTextRep) {
        NodeTextRep result = nodeTextRep.clone();
        int numOfLines = result.nodeText.length;
        Vector[] inserts = new Vector[numOfLines];
        int i = 0;
        while (i < numOfLines) {
            inserts[i] = new Vector();
            ++i;
        }
        int beginLine = sn.stn.getLocation().beginLine();
        int i2 = 0;
        while (i2 < arguments.length) {
            SemanticNode[] uses = ResourceHelper.getUsesOfSymbol((SymbolNode)formalParams[i2], (SemanticNode)sn);
            String replacementText = arguments[i2];
            int sourceTextLength = formalParams[i2].getName().toString().length();
            boolean mayNeedParens = false;
            if (DecomposeProofHandler.primingNeedsParens((SemanticNode)formalParams[i2]) && (replacementText.charAt(replacementText.length() - 1) != '\'' || replacementText.startsWith("\\/") || replacementText.startsWith("/\\"))) {
                mayNeedParens = true;
            }
            int j = 0;
            while (j < uses.length) {
                if (!(uses[j] instanceof OpApplNode) && !(uses[j] instanceof OpArgNode)) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 4941 of DecomposeProofHandler.");
                    return result;
                }
                Location useLocation = uses[j].stn.getLocation();
                int useIdx = useLocation.beginLine() - beginLine;
                int offset = DecomposeProofHandler.colToLoc(useLocation.beginColumn(), result.mapping[useIdx]);
                Object thisReplaceText = replacementText;
                if (mayNeedParens) {
                    String[] precedingSafe = new String[]{"(", "[", "{", ",", "<<", "->", ":"};
                    String[] followingSafe = new String[]{")", "]", "}", ",", ">>", "->", "~>"};
                    String testString = result.nodeText[useIdx].substring(0, offset).trim();
                    int line = useIdx;
                    while (testString.equals("") && line > 0) {
                        testString = result.nodeText[--line];
                    }
                    boolean terminated = testString.equals("");
                    int k = 0;
                    while (!terminated && k < precedingSafe.length) {
                        terminated = testString.endsWith(precedingSafe[k]);
                        ++k;
                    }
                    if (terminated) {
                        testString = result.nodeText[useIdx].substring(offset + sourceTextLength).trim();
                        line = useIdx;
                        while (testString.equals("") && line < result.nodeText.length - 1) {
                            testString = result.nodeText[++line];
                        }
                        terminated = testString.equals("");
                        k = 0;
                        while (!terminated && k < precedingSafe.length) {
                            terminated = testString.startsWith(followingSafe[k]);
                            ++k;
                        }
                    }
                    if (!terminated) {
                        thisReplaceText = "(" + replacementText + ")";
                    }
                }
                result.nodeText[useIdx] = result.nodeText[useIdx].substring(0, offset) + (String)thisReplaceText + result.nodeText[useIdx].substring(offset + sourceTextLength);
                DecomposeProofHandler.adjustMappingPairVector(useLocation.beginColumn() + 1, ((String)thisReplaceText).length() - sourceTextLength, result.mapping[useIdx]);
                inserts[useIdx].add(new Insertion(offset, sourceTextLength, ((String)thisReplaceText).length()));
                ++j;
            }
            ++i2;
        }
        DecomposeProofHandler.adjustIndentation(nodeTextRep, result, inserts);
        return result;
    }

    NodeTextRep renameInNodeText(ExprOrOpArgNode sn, NodeTextRep nodeTextRep, String prefix, String postPrefix) {
        NodeTextRep result = nodeTextRep;
        if (prefix.equals("") && postPrefix.equals("")) {
            return result;
        }
        boolean errorFound = false;
        String[] trialPrefixes = DecomposeProofHandler.DefPrefixes(postPrefix);
        int i = 0;
        while (i < trialPrefixes.length) {
            trialPrefixes[i] = prefix + trialPrefixes[i];
            ++i;
        }
        ExprOrOpArgNode[] opUses = ResourceHelper.getUsesOfUserDefinedOps((SemanticNode)sn);
        int i2 = 0;
        while (i2 < opUses.length) {
            if (opUses[i2] instanceof OpApplNode) {
                OpDefNode opDef = (OpDefNode)((OpApplNode)opUses[i2]).getOperator();
                String opDefName = opDef.getName().toString();
                ExprNode opDefBody = opDef.getBody();
                boolean notFound = true;
                int j = 0;
                while (notFound && j < trialPrefixes.length) {
                    OpDefNode symNode = this.stringToOpDef(trialPrefixes[j] + opDefName);
                    if (symNode != null) {
                        ExprNode foundOpDefBody = symNode.getBody();
                        ExprNode body = opDefBody;
                        while (notFound && foundOpDefBody instanceof SubstInNode) {
                            notFound = body != foundOpDefBody;
                            foundOpDefBody = ((SubstInNode)foundOpDefBody).getBody();
                        }
                        if (notFound) {
                            boolean bl = notFound = body != foundOpDefBody;
                        }
                    }
                    if (!notFound) continue;
                    ++j;
                }
                if (notFound) {
                    if (!errorFound) {
                        MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something that should not happen has occurred in line 5099 of DecomposeProofHandler.");
                        errorFound = true;
                    }
                } else {
                    result = DecomposeProofHandler.prependToOpName(result, (SemanticNode)sn, (OpApplNode)opUses[i2], trialPrefixes[j]);
                }
            } else if (opUses[i2] instanceof OpArgNode && trialPrefixes.length > 1) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)("A use of " + String.valueOf(((OpArgNode)opUses[i2]).getName()) + " as an operator name may require manual renaming."));
            } else if (!errorFound) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something that should not happen has occurred in line 5122 of DecomposeProofHandler.");
                errorFound = true;
            }
            ++i2;
        }
        return result;
    }

    OpDefNode stringToOpDef(String str) {
        OpDefNode result = null;
        OpDefNode[] allDefs = this.moduleNode.getOpDefs();
        int i = 0;
        while (result == null && i < allDefs.length) {
            if (str.equals(allDefs[i].getName().toString())) {
                result = allDefs[i];
            }
            ++i;
        }
        return result;
    }

    static String[] DefPrefixes(String prefix) {
        if (prefix.equals("")) {
            return new String[]{""};
        }
        String[] split = prefix.split("!");
        String[] result = new String[split.length + 1];
        int i = 0;
        while (i < result.length) {
            result[i] = i == 0 ? "" : result[i - 1] + split[i - 1];
            if (i != 0) {
                result[i] = result[i] + "!";
            }
            ++i;
        }
        return result;
    }

    NodeTextRep decompSubstituteInNodeText(NodeRepresentation nodeRep, ExprNode sn, NodeTextRep nodeTextRep, NodeRepresentation originalNodeRep) {
        Decomposition decomp = nodeRep.decomposition;
        StringSet prevDeclared = this.declaredIdentifiers.clone();
        this.addDeclaredSymbols(prevDeclared, originalNodeRep);
        this.addSymbolsDeclaredLater(prevDeclared, originalNodeRep, false);
        Renaming rename = decomp.renaming.clone();
        this.addToRenaming(rename, prevDeclared, sn);
        int decompParamsLen = 0;
        if (decomp.formalParams != null) {
            decompParamsLen = decomp.formalParams.length;
        }
        FormalParamNode[] formalParams = new FormalParamNode[decompParamsLen + rename.identifiers.size()];
        String[] arguments = new String[formalParams.length];
        boolean[] isBoundedIdRenaming = new boolean[formalParams.length];
        SemanticNode[] argNodes = new SemanticNode[formalParams.length];
        int i = 0;
        while (i < decompParamsLen) {
            formalParams[i] = decomp.formalParams[i];
            arguments[i] = decomp.arguments[i];
            isBoundedIdRenaming[i] = false;
            argNodes[i] = decomp.argNodes[i];
            ++i;
        }
        i = 0;
        while (i < rename.identifiers.size()) {
            formalParams[i + decompParamsLen] = rename.identifiers.elementAt(i);
            arguments[i + decompParamsLen] = rename.newNames.elementAt(i);
            isBoundedIdRenaming[i + decompParamsLen] = true;
            argNodes[i + decompParamsLen] = null;
            ++i;
        }
        NodeTextRep result = this.substituteInNodeText(formalParams, arguments, isBoundedIdRenaming, argNodes, sn, nodeTextRep, decomp);
        result.renaming = rename;
        this.addToRenaming(this.state.renaming, prevDeclared, sn);
        return result;
    }

    InstanceSubstitution substInNodeToInstanceSub(InstanceSubstitution isub, String opName, SubstInNode subIn) {
        InstanceSubstitution result = isub.clone();
        int lastBang = opName.lastIndexOf(33);
        String postPrefix = "";
        if (lastBang != -1) {
            postPrefix = opName.substring(0, lastBang + 1);
        }
        IDocument doc = this.moduleNameToIDocument(subIn.getLocation().source());
        Subst[] substitutes = subIn.getSubsts();
        OpDeclNode[] paramsArray = DecomposeProofHandler.OpDeclNodeVectorToArray(isub.params);
        String[] subsArray = DecomposeProofHandler.StringVectorToArray(isub.substs);
        int i = 0;
        while (i < substitutes.length) {
            Subst subst = substitutes[i];
            if (!subst.isImplicit()) {
                NodeRepresentation nodeRep;
                result.params.add(subst.getOp());
                try {
                    nodeRep = new NodeRepresentation(doc, (SemanticNode)subst.getExpr());
                }
                catch (BadLocationException e) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 5356 of DecomposeProofHandler.");
                    return null;
                }
                if (nodeRep.nodeText.length != 1) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Cannot handle instantiation of module parameter\n with multi-line formula.");
                    return null;
                }
                NodeTextRep ntRep = nodeRep.toNodeTextRep();
                ntRep = this.instantiateInNodeText(paramsArray, subsArray, subst.getExpr(), ntRep);
                ntRep = this.renameInNodeText(subst.getExpr(), ntRep, isub.prefix, postPrefix);
                if (ntRep == null) {
                    return null;
                }
                result.substs.add(ntRep.nodeText[0]);
            } else if (!this.moduleNode.getName().toString().equals(lastModuleWithImplicitRenamingWarning) && !this.moduleNode.getName().toString().equals(subst.getExpr().getTreeNode().getFilename())) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"The implicit instantiation of one or more module parameters in an INSTANCE\nstatement in an instantiated module may cause the incorrect expansion of\ndefinitions imported by instantiation.  This can be avoided by using\nWITH clauses to make instantiations explicit.\n\nThis warning will probably not be repeated for this module.");
                lastModuleWithImplicitRenamingWarning = this.moduleNode.getName().toString();
            }
            ++i;
        }
        return result;
    }

    NodeTextRep instanceSubstitute(InstanceSubstitution isub, String newPrefix, NodeRepresentation nodeRep) {
        NodeTextRep result = new NodeTextRep(nodeRep.nodeText, nodeRep.mapping).clone();
        return result;
    }

    private void addToRenaming(Renaming renaming, StringSet prevDeclared, ExprNode expr) {
        int i;
        if (!(expr instanceof OpApplNode)) {
            return;
        }
        StringSet newDeclared = prevDeclared.clone();
        OpApplNode node = (OpApplNode)expr;
        if (node.getUnbdedQuantSymbols() != null) {
            i = 0;
            while (i < node.getUnbdedQuantSymbols().length) {
                FormalParamNode id = node.getUnbdedQuantSymbols()[i];
                if (newDeclared.contains(this.getCurrentName(id, renaming))) {
                    String newname = this.getNewName(id, newDeclared, renaming);
                    newDeclared.add(newname);
                    this.addCurrentName(id, newname, renaming);
                }
                ++i;
            }
        }
        if (node.getBdedQuantSymbolLists() != null) {
            i = 0;
            while (i < node.getBdedQuantSymbolLists().length) {
                this.addToRenaming(renaming, prevDeclared, node.getBdedQuantBounds()[i]);
                FormalParamNode[] nodeList = node.getBdedQuantSymbolLists()[i];
                int j = 0;
                while (j < nodeList.length) {
                    FormalParamNode id = nodeList[j];
                    if (newDeclared.contains(this.getCurrentName(id, renaming))) {
                        String newname = this.getNewName(id, newDeclared, renaming);
                        newDeclared.add(newname);
                        this.addCurrentName(id, newname, renaming);
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < node.getArgs().length) {
            if (node.getArgs()[i] instanceof ExprNode) {
                this.addToRenaming(renaming, newDeclared, (ExprNode)node.getArgs()[i]);
            }
            ++i;
        }
    }

    NodeRepresentation pathToNodeRep(Vector<Integer> vec) {
        NodeRepresentation result = null;
        int i = vec.size() - 1;
        int idx = vec.elementAt(i);
        if (idx == -1) {
            return this.state.goalRep;
        }
        result = this.state.assumeReps.elementAt(idx);
        --i;
        while (i >= 0) {
            int idx1 = vec.elementAt(i);
            int idx2 = vec.elementAt(--i);
            result = result.children.elementAt(idx1).elementAt(idx2);
            --i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    static NodeTextRep prependToOpName(NodeTextRep ntRep, SemanticNode ntRepNode, OpApplNode oaNode, String prefix) {
        result = ntRep.clone();
        opSym = oaNode.getOperator();
        if (!(opSym instanceof OpDefNode)) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 6617 of NDecomposeProofHandler.");
            return null;
        }
        opDef = (OpDefNode)opSym;
        if (opDef.getKind() != 5) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 6626 of DecomposeProofHandler.");
            return null;
        }
        split = opDef.getName().toString().split("!");
        ntLoc = ntRepNode.getLocation();
        opApplLoc = oaNode.getLocation();
        isAlphaNum = true;
        ppart = split[split.length - 1];
        i = 0;
        while (i < ppart.length() && isAlphaNum) {
            ch = Character.valueOf(ppart.charAt(i));
            if (!Character.isLetterOrDigit(ch.charValue()) && ch.charValue() != '_') {
                isAlphaNum = false;
            }
            ++i;
        }
        oaBeginLine = opApplLoc.beginLine() - ntLoc.beginLine();
        bCol = opApplLoc.beginColumn();
        oaBeginLoc = DecomposeProofHandler.colToLoc(bCol, result.mapping[oaBeginLine]);
        oaEndLine = opApplLoc.endLine() - ntLoc.beginLine();
        oaEndLoc = DecomposeProofHandler.colToLoc(opApplLoc.endColumn(), result.mapping[oaEndLine]);
        bLine = oaBeginLine;
        bPos = oaBeginLoc;
        if (!isAlphaNum) {
            oaArgs = oaNode.getArgs();
            if (oaArgs.length == 0) {
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 6673 of DecomposeProofHandler.");
                return null;
            }
            firstArgLoc = oaArgs[0].getLocation();
            bLine = firstArgLoc.endLine() - ntLoc.beginLine();
            bCol = firstArgLoc.endColumn() + 1;
            bPos = DecomposeProofHandler.colToLoc(firstArgLoc.endColumn() + 1, result.mapping[bLine]);
        }
        notDone = true;
        ** GOTO lbl52
        {
            if (!Character.isWhitespace(result.nodeText[bLine].charAt(bPos))) {
                notDone = false;
            } else {
                ++bCol;
                ++bPos;
            }
            do {
                if (notDone && bPos < result.nodeText[bLine].length()) continue block1;
                if (!notDone) continue;
                bPos = 0;
                if (++bLine < result.nodeText[bLine].length()) continue;
                MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Something unexpected is going on at line 6701 of DecomposeProofHandler.");
                return null;
lbl52:
                // 3 sources

            } while (notDone);
        }
        ePos = result.nodeText[bLine].length();
        if (oaEndLine == bLine) {
            ePos = oaEndLoc + 1;
        }
        aSplit = result.nodeText[bLine].substring(bPos, ePos).split("!");
        i = 0;
        while (i < aSplit.length) {
            aSplit[i] = aSplit[i].trim();
            ++i;
        }
        OK = aSplit.length >= split.length;
        i = 0;
        while (OK && i < split.length) {
            OK = split[i].equals(aSplit[i]) != false || i == split.length - 1 && aSplit[i].startsWith(split[i]) != false && (isAlphaNum == false || Character.isLetterOrDigit(aSplit[i].charAt(split[i].length())) == false && aSplit[i].charAt(split[i].length()) != '_');
            ++i;
        }
        if (!OK) {
            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)("Cannot rename use of " + String.valueOf(opDef.getName())));
            return null;
        }
        result.nodeText[bLine] = result.nodeText[bLine].substring(0, bPos) + prefix + result.nodeText[bLine].substring(bPos);
        DecomposeProofHandler.adjustMappingPairVector(bCol + 1, prefix.length(), result.mapping[bLine]);
        insVecArray = new Vector[result.nodeText.length];
        i = 0;
        while (i < result.nodeText.length) {
            insVecArray[i] = new Vector<E>();
            if (i == bLine) {
                insVecArray[i].add(new Insertion(bPos, 0, prefix.length()));
            }
            ++i;
        }
        DecomposeProofHandler.adjustIndentation(ntRep, result, insVecArray);
        return result;
    }

    static NodeTextRep appendToNodeText(NodeTextRep nodeRep, String str) {
        NodeTextRep result = nodeRep.clone();
        result.nodeText[result.nodeText.length - 1] = result.nodeText[result.nodeText.length - 1] + str;
        return result;
    }

    static NodeTextRep prependToNodeText(NodeTextRep nodeRep, String str) {
        NodeTextRep result = nodeRep.clone();
        int i = 0;
        while (i < nodeRep.nodeText.length) {
            if (i == 0) {
                result.nodeText[0] = str + result.nodeText[0];
            } else {
                result.nodeText[i] = StringHelper.copyString((String)" ", (int)str.length()) + result.nodeText[i];
            }
            DecomposeProofHandler.adjustMappingPairVector(1, str.length(), result.mapping[i]);
            ++i;
        }
        return result;
    }

    static String[] appendToStringArray(String[] array, String str) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = array[i];
            ++i;
        }
        result[result.length - 1] = array[result.length - 1] + str;
        return result;
    }

    static String[] prependToStringArray(String[] array, String str) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < result.length) {
            if (i == 0) {
                result[0] = str + array[0];
            } else {
                result[i] = StringHelper.copyString((String)" ", (int)str.length()) + array[i];
            }
            ++i;
        }
        return result;
    }

    static String[] concatStringArrays(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        int i = 0;
        while (i < array1.length) {
            result[i] = array1[i];
            ++i;
        }
        i = 0;
        while (i < array2.length) {
            result[i + array1.length] = array2[i];
            ++i;
        }
        return result;
    }

    static String concatCommaSeparatedLists(String str1, String str2) {
        if (str1 == null || str1.trim().equals("")) {
            return str2;
        }
        String result = str1.trim();
        if (str2 == null || str2.trim().equals("")) {
            return result;
        }
        return result + ", " + str2.trim();
    }

    static String setOfStringsToList(Set<String> set) {
        Object result = "";
        Iterator<String> iter = set.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                result = (String)result + ", ";
            }
            result = (String)result + iter.next();
        }
        return result;
    }

    private void addDeclaredSymbols(StringSet result, NodeRepresentation node) {
        Vector<NodeRepresentation> parentVec = node.getParentVector();
        if (parentVec == null) {
            parentVec = this.state.assumeReps;
        }
        int i = 0;
        while (i < parentVec.size() && parentVec.elementAt(i) != node) {
            NodeRepresentation parent = parentVec.elementAt(i);
            if (parent.nodeType == 1) {
                result.add(parent.newId);
            }
            ++i;
        }
        if (parentVec != this.state.assumeReps) {
            if (node.parentNode != null) {
                this.addDeclaredSymbols(result, node.parentNode);
            } else {
                System.out.println("Bug found in DecomposeProofHandler.addDeclaredSymbols.");
            }
        }
    }

    private void addSymbolsDeclaredLater(StringSet prevDeclared, NodeRepresentation nodeRepArg, boolean includeGoal) {
        NodeRepresentation assumpRepNode = nodeRepArg;
        while (assumpRepNode.parentNode != null) {
            assumpRepNode = assumpRepNode.parentNode;
        }
        int idx = 0;
        while (idx < this.state.assumeReps.size() && this.state.assumeReps.elementAt(idx) != assumpRepNode) {
            ++idx;
        }
        if (idx == this.state.assumeReps.size()) {
            return;
        }
        int i = idx + 1;
        while (i < this.state.assumeReps.size()) {
            NodeRepresentation anode = this.state.assumeReps.elementAt(i);
            if (anode.nodeType == 1) {
                prevDeclared.add(anode.newId);
            }
            if (includeGoal && anode.isCreated) {
                ExprNode snode = null;
                if (anode.semanticNode != null && anode.semanticNode instanceof ExprNode) {
                    snode = (ExprNode)anode.semanticNode;
                }
                if (snode != null) {
                    FormalParamNode[] goalIdents = ResourceHelper.getBoundIdentifiers(snode);
                    int j = 0;
                    while (j < goalIdents.length) {
                        prevDeclared.add(this.getCurrentName(goalIdents[j], this.state.renaming));
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (includeGoal) {
            FormalParamNode[] goalIdents = ResourceHelper.getBoundIdentifiers((ExprNode)((ExprNode)this.state.goalRep.semanticNode));
            int i2 = 0;
            while (i2 < goalIdents.length) {
                prevDeclared.add(this.getCurrentName(goalIdents[i2], this.state.renaming));
                ++i2;
            }
        }
    }

    public static String nodeSubTypeToString(int subType) {
        String val = "?";
        switch (subType) {
            case 0: {
                val = "AND_TYPE";
                break;
            }
            case 1: {
                val = "OR_TYPE";
                break;
            }
            case 2: {
                val = "IMPLIES_TYPE";
                break;
            }
            case 3: {
                val = "FORALL_TYPE";
                break;
            }
            case 4: {
                val = "EXISTS_TYPE";
                break;
            }
            case 5: {
                val = "SQSUB_TYPE";
                break;
            }
            case 99: {
                val = "OTHER_TYPE";
            }
        }
        return val;
    }

    private Decomposition decompose(NodeRepresentation nodeRep, Decomposition decomp, boolean isAssumption) {
        int i;
        OpApplNode node;
        SemanticNode sn = nodeRep.semanticNode;
        if (!(sn instanceof OpApplNode)) {
            return null;
        }
        OpApplNode unprimedNode = node = (OpApplNode)sn;
        Decomposition result = new Decomposition();
        if (decomp != null) {
            result.renaming.identifiers = (Vector)decomp.renaming.identifiers.clone();
            result.renaming.newNames = (Vector)decomp.renaming.newNames.clone();
        }
        result.instantiationSubstitutions = nodeRep.instantiationSubstitutions;
        if (node.getOperator().getName() == ASTConstants.OP_prime) {
            if (!(node.getArgs()[0] instanceof OpApplNode)) {
                return null;
            }
            unprimedNode = node = (OpApplNode)node.getArgs()[0];
            result.primed = true;
        }
        if (!nodeRep.isSubexpressionName && node.getOperator().getKind() == 5) {
            OpDefNode definition = (OpDefNode)node.getOperator();
            String operatorName = definition.getName().toString();
            ExprNode opDef = definition.getBody();
            InstanceSubstitution instSubs = nodeRep.instantiationSubstitutions.clone();
            while (opDef instanceof SubstInNode) {
                if ((instSubs = this.substInNodeToInstanceSub(instSubs, operatorName, (SubstInNode)opDef)) == null) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"Decomposing an instantiated definition whose\ninstantiation cannot be handled.");
                    return null;
                }
                opDef = ((SubstInNode)opDef).getBody();
            }
            Object instNamePrefix = nodeRep.instantiationSubstitutions.prefix;
            String restOfName = operatorName;
            while (restOfName.indexOf("!") != -1) {
                instNamePrefix = (String)instNamePrefix + restOfName.substring(0, restOfName.indexOf("!") + 1);
                restOfName = restOfName.substring(restOfName.indexOf("!") + 1);
            }
            instSubs.prefix = instNamePrefix;
            if (opDef instanceof OpApplNode) {
                ExprOrOpArgNode[] args = node.getArgs();
                i = 0;
                while (i < args.length) {
                    SyntaxTreeNode stn = (SyntaxTreeNode)args[i].stn;
                    Location stnLoc = stn.getLocation();
                    if (stnLoc.beginLine() != stnLoc.endLine()) {
                        return null;
                    }
                    ++i;
                }
                node = (OpApplNode)opDef;
                result.moduleName = ((SyntaxTreeNode)node.stn).getLocation().source();
                result.instantiationSubstitutions = instSubs;
                result.definedOp = operatorName;
                result.definedOpRep = nodeRep.subNodeText((SemanticNode)unprimedNode);
                result.formalParams = definition.getParams();
                result.arguments = new String[result.formalParams.length];
                result.argNodes = unprimedNode.getArgs();
                i = 0;
                while (i < result.arguments.length) {
                    result.arguments[i] = DecomposeProofHandler.stringArrayToString(nodeRep.subNodeText((SemanticNode)unprimedNode.getArgs()[i]).nodeText);
                    ++i;
                }
            } else {
                return null;
            }
        }
        boolean isAndOrOr = false;
        boolean isJunction = false;
        boolean isQuantifier = false;
        boolean isBoundedQuantifier = false;
        if (!(node.getOperator() instanceof OpDefNode)) {
            return null;
        }
        UniqueString opId = ((OpDefNode)node.getOperator()).getName();
        String opName = opId.toString();
        if (!(opId != ASTConstants.OP_cl && !opName.equals("\\land") || isAssumption && !this.conjIsDecomposable(node))) {
            result.type = 0;
            if (opId == ASTConstants.OP_cl) {
                isJunction = true;
            } else {
                isAndOrOr = true;
            }
        } else if (opId == ASTConstants.OP_dl || opName.equals("\\lor")) {
            result.type = 1;
            if (opId == ASTConstants.OP_dl) {
                isJunction = true;
            } else {
                isAndOrOr = true;
            }
        } else if (opName.equals("=>")) {
            result.type = 2;
        } else if (opId == ASTConstants.OP_bf || opId == ASTConstants.OP_uf) {
            result.type = 3;
            isQuantifier = true;
            if (opId == ASTConstants.OP_bf) {
                isBoundedQuantifier = true;
            }
        } else if (opId == ASTConstants.OP_be || opId == ASTConstants.OP_ue) {
            result.type = 4;
            isQuantifier = true;
            if (opId == ASTConstants.OP_be) {
                isBoundedQuantifier = true;
            }
        } else if (opId == ASTConstants.OP_sa) {
            result.type = 5;
        } else {
            return null;
        }
        if (isAndOrOr) {
            DecomposeProofHandler.processAndOrOr(result, (SemanticNode)node, "", opName);
        } else if (isJunction) {
            ExprOrOpArgNode[] juncts = node.getArgs();
            i = 0;
            while (i < juncts.length) {
                result.children.add((SemanticNode)juncts[i]);
                result.namePath.add("!" + (i + 1));
                ++i;
            }
        } else if (isQuantifier) {
            result.children.add((SemanticNode)node.getArgs()[0]);
            Object namePath = "!(";
            result.quantIds = new Vector();
            if (isBoundedQuantifier) {
                result.quantBounds = new Vector();
                result.quantBoundsubexpNames = new Vector();
                FormalParamNode[][] quantIdsArray = node.getBdedQuantSymbolLists();
                ExprNode[] quantBounds = node.getBdedQuantBounds();
                int i2 = 0;
                while (i2 < quantIdsArray.length) {
                    if (node.isBdedQuantATuple()[i2]) {
                        return null;
                    }
                    FormalParamNode[] quantIds = quantIdsArray[i2];
                    int j = 0;
                    while (j < quantIds.length) {
                        result.quantIds.add(quantIds[j]);
                        result.quantBounds.add(quantBounds[i2]);
                        result.quantBoundsubexpNames.add("!" + (i2 + 1));
                        if (i2 != 0 || j != 0) {
                            namePath = (String)namePath + ",";
                        }
                        namePath = (String)namePath + quantIds[j].getName().toString();
                        ++j;
                    }
                    ++i2;
                }
            } else {
                FormalParamNode[] quantIds = node.getUnbdedQuantSymbols();
                int i3 = 0;
                while (i3 < quantIds.length) {
                    result.quantIds.add(quantIds[i3]);
                    if (i3 != 0) {
                        namePath = (String)namePath + ",";
                    }
                    namePath = (String)namePath + quantIds[i3].getName().toString();
                    ++i3;
                }
            }
            namePath = (String)namePath + ")";
            result.namePath.add((String)namePath);
        } else if (result.type == 2 || result.type == 5) {
            result.children.add((SemanticNode)node.getArgs()[0]);
            result.namePath.add("!1");
            result.children.add((SemanticNode)node.getArgs()[1]);
            result.namePath.add("!2");
        }
        return result;
    }

    private boolean conjIsDecomposable(OpApplNode node) {
        ExprOrOpArgNode[] conjuncts = node.getArgs();
        int i = 0;
        while (i < conjuncts.length) {
            if (conjuncts[i] instanceof OpApplNode) {
                OpApplNode curNode = (OpApplNode)conjuncts[i];
                if (curNode.getOperator().getKind() == 5 && ((OpDefNode)curNode.getOperator()).getBody() instanceof OpApplNode) {
                    curNode = (OpApplNode)((OpDefNode)curNode.getOperator()).getBody();
                }
                if (curNode.getOperator() instanceof OpDefNode) {
                    UniqueString opId = ((OpDefNode)curNode.getOperator()).getName();
                    String opName = opId.toString();
                    if (!this.state.splitChosen() && (opId == ASTConstants.OP_dl || opName.equals("\\lor") || opId == ASTConstants.OP_sa) || opId == ASTConstants.OP_be || opId == ASTConstants.OP_ue || (opId == ASTConstants.OP_cl || opName.equals("\\land")) && this.conjIsDecomposable(curNode)) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private boolean conjContainsExists(OpApplNode node) {
        ExprOrOpArgNode[] conjuncts = node.getArgs();
        int i = 0;
        while (i < conjuncts.length) {
            if (conjuncts[i] instanceof OpApplNode) {
                OpApplNode curNode = (OpApplNode)conjuncts[i];
                if (curNode.getOperator().getKind() == 5 && ((OpDefNode)curNode.getOperator()).getBody() instanceof OpApplNode) {
                    curNode = (OpApplNode)((OpDefNode)curNode.getOperator()).getBody();
                }
                if (curNode.getOperator() instanceof OpDefNode) {
                    UniqueString opId = ((OpDefNode)curNode.getOperator()).getName();
                    String opName = opId.toString();
                    if (opId == ASTConstants.OP_be || opId == ASTConstants.OP_ue || (opId == ASTConstants.OP_cl || opName.equals("\\land")) && this.conjContainsExists(curNode)) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private static void processAndOrOr(Decomposition decomp, SemanticNode node, String namePathPrefix, String op) {
        if (!(node instanceof OpApplNode)) {
            decomp.children.add(node);
            decomp.namePath.add(namePathPrefix);
            return;
        }
        OpApplNode aonode = (OpApplNode)node;
        SymbolNode sym = aonode.getOperator();
        UniqueString opId = null;
        String opName = null;
        if (sym instanceof OpDefNode) {
            opId = ((OpDefNode)sym).getName();
            opName = opId.toString();
        }
        if (opName == null || !opName.equals(op)) {
            decomp.children.add(node);
            decomp.namePath.add(namePathPrefix);
            return;
        }
        DecomposeProofHandler.processAndOrOr(decomp, (SemanticNode)aonode.getArgs()[0], namePathPrefix + "!1", op);
        decomp.children.add((SemanticNode)aonode.getArgs()[1]);
        decomp.namePath.add(namePathPrefix + "!2");
    }

    private static int colToLoc(int col, Vector<MappingPair> vec) {
        int loc = col;
        int i = 0;
        while (i < vec.size() && vec.elementAt((int)i).col <= col) {
            loc += vec.elementAt((int)i).inc;
            ++i;
        }
        return loc;
    }

    private static void adjustMappingPairVector(int col, int incr, Vector<MappingPair> vec) {
        int i = 0;
        while (i < vec.size() && vec.elementAt((int)i).col < col) {
            ++i;
        }
        if (i == vec.size()) {
            vec.add(new MappingPair(col, incr));
        } else if (vec.elementAt((int)i).col == col) {
            vec.elementAt((int)i).inc += incr;
        } else {
            vec.insertElementAt(new MappingPair(col, incr), i);
        }
    }

    private static Vector<MappingPair> cloneMappingPairVector(Vector<MappingPair> vec) {
        Vector<MappingPair> result = new Vector<MappingPair>();
        int i = 0;
        while (i < vec.size()) {
            result.add(vec.elementAt(i).clone());
            ++i;
        }
        return result;
    }

    static int newInsertPos(int oldPos, Insertion ins) {
        if (oldPos <= ins.pos) {
            return oldPos;
        }
        if (oldPos < ins.pos + ins.oldLen) {
            if (oldPos < ins.pos + ins.newLen) {
                return oldPos;
            }
            return ins.pos + ins.newLen - ins.oldLen;
        }
        return oldPos + ins.newLen - ins.oldLen;
    }

    static int newVecInsertPos(int oldPos, Vector<Insertion> vec) {
        return DecomposeProofHandler.innerNewVecInsertPos(oldPos, 0, vec);
    }

    static int innerNewVecInsertPos(int oldPos, int idx, Vector<Insertion> vec) {
        if (vec.size() <= idx) {
            return oldPos;
        }
        return DecomposeProofHandler.innerNewVecInsertPos(DecomposeProofHandler.newInsertPos(oldPos, vec.elementAt(idx)), idx + 1, vec);
    }

    static void adjustIndentation(NodeTextRep oldTextRep, NodeTextRep newTextRep, Vector<Insertion>[] insVecArray) {
        int numOfLines = insVecArray.length;
        int[] startingPos = new int[numOfLines];
        int i = 0;
        while (i < numOfLines) {
            int coveringLine;
            String str = oldTextRep.nodeText[i];
            startingPos[i] = StringHelper.leadingSpaces((String)str);
            if (startingPos[i] == str.length()) {
                startingPos[i] = -1;
            }
            if (startingPos[i] == -1) {
                coveringLine = -1;
            } else {
                int j = i - 1;
                while (j >= 0 && (startingPos[j] > startingPos[i] || startingPos[j] == -1)) {
                    --j;
                }
                coveringLine = j;
            }
            int addSpace = coveringLine == -1 ? 0 : DecomposeProofHandler.newVecInsertPos(startingPos[i], insVecArray[coveringLine]) - startingPos[i];
            str = newTextRep.nodeText[i];
            if (addSpace > 0) {
                newTextRep.nodeText[i] = StringHelper.copyString((String)" ", (int)addSpace) + str;
            } else if (addSpace < 0) {
                newTextRep.nodeText[i] = str.substring(-addSpace);
            }
            DecomposeProofHandler.adjustMappingPairVector(1, addSpace, newTextRep.mapping[i]);
            ++i;
        }
    }

    public static String stringArrayToString(String[] A) {
        if (A.length == 0) {
            return A[0];
        }
        Object result = A[0];
        int i = 1;
        while (i < A.length) {
            result = (String)result + "\n" + A[i];
            ++i;
        }
        return result;
    }

    public static String stringArrayToIndentedString(String[] A, int indent) {
        if (A.length == 0) {
            return A[0];
        }
        Object result = A[0];
        int i = 1;
        while (i < A.length) {
            result = (String)result + "\n" + StringHelper.copyString((String)" ", (int)indent) + A[i];
            ++i;
        }
        return result;
    }

    private void setupMenuButton(Button button, int whichOne, String text) {
        button.addSelectionListener((SelectionListener)new DecomposeProofButtonListener(this, new Integer(whichOne), 1));
        button.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 5;
        button.setLayoutData((Object)gridData);
    }

    private void setupCheckButton(Button button, String text) {
        button.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 10;
        button.setLayoutData((Object)gridData);
    }

    private void setupActionButton(Button button, NodeRepresentation nodeRep, String text) {
        button.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.verticalAlignment = 128;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new DecomposeProofButtonListener(this, nodeRep.nodeRepPath(), 2));
        button.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        if (text.equals("  ")) {
            button.setEnabled(false);
        }
    }

    static int getBeginLine(SemanticNode nd) {
        if (nd.stn == null) {
            System.out.println("getBeginLine called on node with null stn field.");
            return -1;
        }
        return nd.stn.getLocation().beginLine();
    }

    static int getEndLine(SemanticNode nd) {
        if (nd.stn == null) {
            System.out.println("getEndLine called on node with null stn field.");
            return -1;
        }
        return nd.stn.getLocation().endLine();
    }

    static int stepLevel(SemanticNode nd) {
        String stepStr = ((SyntaxTreeNode)nd.stn).getHeirs()[0].image.toString();
        String stepNum = stepStr.substring(stepStr.indexOf(60) + 1, stepStr.indexOf(62));
        return Integer.valueOf(stepNum);
    }

    static boolean primingNeedsParens(SemanticNode node) {
        if (!(node instanceof OpApplNode)) {
            return false;
        }
        if (((OpApplNode)node).getArgs().length == 0) {
            return false;
        }
        SymbolNode ops = ((OpApplNode)node).getOperator();
        if (ops instanceof OpDefNode) {
            OpDefNode odn = (OpDefNode)ops;
            return odn.getKind() == 7 || !StringHelper.isIdentifier((String)odn.getName().toString());
        }
        return false;
    }

    public boolean existDirtyModules() {
        LinkedList<IEditorReference> dirtyEditors = new LinkedList<IEditorReference>();
        IEditorReference[] references = UIHelper.getActivePage().getEditorReferences();
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                try {
                    if (references[i].isDirty() && references[i].getEditorInput().getName().endsWith(".tla")) {
                        dirtyEditors.add(references[i]);
                    }
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError("Error getting unsaved resources.", (Throwable)e);
                }
                ++i;
            }
        }
        return dirtyEditors.size() > 0;
    }

    static OpDeclNode[] OpDeclNodeVectorToArray(Vector<OpDeclNode> vec) {
        OpDeclNode[] result = new OpDeclNode[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            result[i] = vec.elementAt(i);
            ++i;
        }
        return result;
    }

    static String[] StringVectorToArray(Vector<String> vec) {
        String[] result = new String[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            result[i] = vec.elementAt(i);
            ++i;
        }
        return result;
    }

    public class DecomposeProofButtonListener
    extends SelectionAdapter
    implements SelectionListener {
        DecomposeProofHandler decomposeHandler;
        int type;
        Object object;

        public Object execute(ExecutionEvent event) throws ExecutionException {
            return null;
        }

        public DecomposeProofButtonListener(DecomposeProofHandler dHandler, Object but, int tp) {
            this.decomposeHandler = dHandler;
            this.type = tp;
            this.object = but;
        }

        public void widgetSelected(SelectionEvent e) {
            DecomposeProofHandler.this.readButtons();
            block0 : switch (this.type) {
                case 1: {
                    int buttonId = (Integer)this.object;
                    switch (buttonId) {
                        case 1: {
                            DecomposeProofHandler.this.state = DecomposeProofHandler.this.state.previousState;
                            DecomposeProofHandler.this.raiseWindow();
                            break;
                        }
                        case 2: {
                            DecomposeProofHandler.this.makeProof(null, false, true);
                            break;
                        }
                        case 3: {
                            System.out.println("button is " + DecomposeProofHandler.this.showContextButton.getSelection());
                            DecomposeProofHandler.this.readButtons();
                            DecomposeProofHandler.this.raiseWindow();
                            break;
                        }
                        case 99: {
                            DecomposeProofHandler.this.windowShell = this.decomposeHandler.windowShell;
                            this.decomposeHandler.location = DecomposeProofHandler.this.windowShell.getLocation();
                            DecomposeProofHandler.this.windowShell.close();
                            if (DecomposeProofHandler.this.windowShell != null) {
                                if (DecomposeProofHandler.this.windowShell.isDisposed()) {
                                    System.out.println("closing disposes of window");
                                } else {
                                    DecomposeProofHandler.this.windowShell.dispose();
                                }
                                if (DecomposeProofHandler.this.windowShell == null) {
                                    System.out.println("Closing nullifies");
                                }
                            }
                            DecomposeProofHandler.this.raiseWindow();
                        }
                    }
                    break;
                }
                case 2: {
                    DecompositionState newState = DecomposeProofHandler.this.state.clone();
                    newState.previousState = DecomposeProofHandler.this.state;
                    DecomposeProofHandler.this.state = newState;
                    DecomposeProofHandler.this.state.hasChanged = true;
                    NodeRepresentation nodeObj = DecomposeProofHandler.this.pathToNodeRep((Vector)this.object);
                    if (nodeObj.nodeType == 2) {
                        this.decomposeHandler.caseAction(nodeObj);
                        break;
                    }
                    switch (nodeObj.nodeSubtype) {
                        case 0: {
                            this.decomposeHandler.andAction(nodeObj);
                            break block0;
                        }
                        case 1: {
                            this.decomposeHandler.orAction(nodeObj);
                            break block0;
                        }
                        case 2: {
                            this.decomposeHandler.impliesAction(nodeObj);
                            break block0;
                        }
                        case 3: {
                            this.decomposeHandler.forAllAction(nodeObj);
                            break block0;
                        }
                        case 4: {
                            this.decomposeHandler.existsAction(nodeObj);
                            break block0;
                        }
                        case 5: {
                            this.decomposeHandler.sqsubAction(nodeObj);
                            break block0;
                        }
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public class DecomposeProofRunnable
    implements Runnable {
        DecomposeProofHandler handler;

        DecomposeProofRunnable(DecomposeProofHandler h) {
            this.handler = h;
        }

        @Override
        public void run() {
            try {
                this.handler.editor = EditorUtil.getTLAEditorWithFocus();
                this.handler.doc = DecomposeProofHandler.this.editor.getDocumentProvider().getDocument((Object)DecomposeProofHandler.this.editor.getEditorInput());
                this.handler.selectionProvider = DecomposeProofHandler.this.editor.getSelectionProvider();
                this.handler.selection = (TextSelection)DecomposeProofHandler.this.selectionProvider.getSelection();
                this.handler.offset = DecomposeProofHandler.this.selection.getOffset();
                String moduleName = DecomposeProofHandler.this.editor.getModuleName();
                this.handler.moduleNode = ResourceHelper.getModuleNode((String)moduleName);
                this.handler.realExecute();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    class Decomposition {
        int type;
        String definedOp = null;
        FormalParamNode[] formalParams = null;
        String[] arguments = null;
        SemanticNode[] argNodes = null;
        NodeTextRep definedOpRep = null;
        Renaming renaming = new Renaming();
        InstanceSubstitution instantiationSubstitutions;
        String moduleName;
        Vector<SemanticNode> children;
        Vector<String> namePath;
        Vector<FormalParamNode> quantIds;
        Vector<ExprNode> quantBounds;
        Vector<String> quantBoundsubexpNames;
        boolean primed;

        Decomposition() {
            this.instantiationSubstitutions = new InstanceSubstitution();
            this.moduleName = null;
            this.children = new Vector();
            this.namePath = new Vector();
            this.quantIds = null;
            this.quantBounds = null;
            this.quantBoundsubexpNames = null;
            this.primed = false;
        }

        public Decomposition clone() {
            Decomposition result = new Decomposition();
            result.definedOpRep = null;
            if (this.definedOpRep != null) {
                result.definedOpRep = this.definedOpRep.clone();
            }
            result.renaming = null;
            if (this.renaming != null) {
                result.renaming = this.renaming.clone();
            }
            result.type = this.type;
            result.definedOp = this.definedOp;
            result.formalParams = this.formalParams;
            result.arguments = this.arguments;
            result.argNodes = this.argNodes;
            result.moduleName = this.moduleName;
            result.children = this.children;
            result.namePath = this.namePath;
            result.quantIds = this.quantIds;
            result.quantBounds = this.quantBounds;
            result.quantBoundsubexpNames = this.quantBoundsubexpNames;
            result.primed = this.primed;
            result.instantiationSubstitutions = this.instantiationSubstitutions.clone();
            return result;
        }

        public String toString() {
            String val = "type: " + DecomposeProofHandler.nodeSubTypeToString(this.type);
            if (this.definedOp != null) {
                val = val + "\ndefinedOp: " + this.definedOp;
                val = val + "\ndefinedOpRep: " + this.definedOpRep.toString();
            }
            val = val + "\nmoduleName: " + this.moduleName;
            val = val + "\nchildren: ";
            int i = 0;
            while (i < this.children.size()) {
                val = val + "\nchildren[" + i + "]:\n " + this.children.elementAt(i).toString();
                ++i;
            }
            val = val + "\nnamePath: " + this.namePath.toString();
            if (this.quantIds != null) {
                val = val + "\nquantIds: ";
                i = 0;
                while (i < this.quantIds.size()) {
                    if (i != 0) {
                        val = val + ", ";
                    }
                    val = val + this.quantIds.elementAt(i).getName().toString();
                    ++i;
                }
            }
            if (this.quantBounds != null) {
                i = 0;
                while (i < this.quantBounds.size()) {
                    val = val + "\nquantBounds[" + i + "]:\n " + this.quantBounds.elementAt(i).toString();
                    ++i;
                }
                val = val + "quantBoundsubexpNames: ";
                i = 0;
                while (i < this.quantBounds.size()) {
                    val = val + (i == 0 ? "" : ", ") + this.quantBoundsubexpNames.elementAt(i);
                    ++i;
                }
            }
            val = val + "\nprimed: " + this.primed;
            return val;
        }
    }

    private class DecompositionState {
        DecompositionState previousState = null;
        boolean hasChanged;
        private Vector<NodeRepresentation> assumeReps;
        private NodeRepresentation goalRep;
        private int numberOfContextAssumptions;
        private int firstAddedAssumption;
        private StringSet goalDefinitions;
        private HashSet<String> assumpDefinitions;
        Renaming renaming = new Renaming();

        private DecompositionState() {
        }

        boolean splitChosen() {
            return this.assumeReps.size() > 0 && this.assumeReps.elementAt((int)(this.assumeReps.size() - 1)).nodeType == 2;
        }

        public DecompositionState clone() {
            DecompositionState result = new DecompositionState();
            result.hasChanged = this.hasChanged;
            result.assumeReps = new Vector();
            int i = 0;
            while (i < this.assumeReps.size()) {
                result.assumeReps.addElement(this.assumeReps.elementAt(i).deepClone(null, result.assumeReps));
                ++i;
            }
            result.goalRep = this.goalRep.deepClone(null, null);
            result.numberOfContextAssumptions = this.numberOfContextAssumptions;
            result.firstAddedAssumption = this.firstAddedAssumption;
            result.goalDefinitions = this.goalDefinitions.clone();
            result.assumpDefinitions = (HashSet)this.assumpDefinitions.clone();
            result.renaming = this.renaming.clone();
            return result;
        }
    }

    private static class Insertion {
        int pos;
        int oldLen;
        int newLen;

        private Insertion(int pos, int oldLen, int newLen) {
            this.pos = pos;
            this.oldLen = oldLen;
            this.newLen = newLen;
        }

        public String toString() {
            return "[pos: " + this.pos + ", oldLen: " + this.oldLen + ", newLen: " + this.newLen + "]";
        }
    }

    public class InstanceSubstitution {
        Vector<OpDeclNode> params = new Vector();
        Vector<String> substs = new Vector();
        String prefix = "";

        String[] defPrefixes() {
            String[] split = this.prefix.split("!");
            String[] result = new String[split.length + 1];
            int i = 0;
            while (i < result.length) {
                result[i] = i == 0 ? "" : result[i - 1] + split[i - 1];
                if (i != 0) {
                    result[i] = result[i] + "!";
                }
                ++i;
            }
            return result;
        }

        public InstanceSubstitution clone() {
            InstanceSubstitution result = new InstanceSubstitution();
            int i = 0;
            while (i < this.params.size()) {
                result.params.add(this.params.elementAt(i));
                result.substs.add(this.substs.elementAt(i));
                ++i;
            }
            result.prefix = this.prefix;
            return result;
        }
    }

    private static class MappingPair {
        int col;
        int inc;

        MappingPair(int c, int p) {
            this.col = c;
            this.inc = p;
        }

        public MappingPair clone() {
            return new MappingPair(this.col, this.inc);
        }

        public String toString() {
            return "<" + this.col + ", " + this.inc + ">";
        }
    }

    public class NodeRepresentation {
        SemanticNode semanticNode;
        String[] nodeText;
        Vector<MappingPair>[] mapping;
        InstanceSubstitution instantiationSubstitutions;
        private static final int EXPR_NODE = 0;
        private static final int NEW_NODE = 1;
        private static final int OR_DECOMP = 2;
        private static final int PROOF_NODE = 4;
        private static final int OTHER_NODE = 5;
        private int nodeType;
        private static final int AND_TYPE = 0;
        private static final int IMPLIES_TYPE = 2;
        private static final int FORALL_TYPE = 3;
        private static final int OR_TYPE = 1;
        private static final int EXISTS_TYPE = 4;
        private static final int SQSUB_TYPE = 5;
        private static final int OTHER_TYPE = 99;
        public int nodeSubtype;
        public String newId;
        int initialPosition;
        Vector<Vector<NodeRepresentation>> children;
        NodeRepresentation parentNode;
        private Vector<NodeRepresentation> parentVector;
        boolean isCreated;
        String contextStepName;
        boolean fromGoal;
        boolean fromExists;
        StringSet fromDefs;
        boolean onSameLineAsNext;
        boolean isPrimed;
        boolean isSubexpressionName;
        Decomposition decomposition;

        NodeTextRep toNodeTextRep() {
            NodeTextRep result = new NodeTextRep(this.nodeText, this.mapping);
            if (this.decomposition != null) {
                result.renaming = this.decomposition.renaming;
            }
            return result;
        }

        Vector<NodeRepresentation> getParentVector() {
            return this.parentVector;
        }

        void setParentVector(Vector<NodeRepresentation> parentVector) {
            this.parentVector = parentVector;
        }

        Vector<Integer> nodeRepPath() {
            Vector<Integer> result = new Vector<Integer>();
            NodeRepresentation currNR = this;
            while (currNR.parentNode != null) {
                int idx1 = currNR.getParentIndex();
                result.addElement(new Integer(idx1));
                Vector<NodeRepresentation> parVec = currNR.getParentVector();
                currNR = currNR.parentNode;
                Vector<Vector<NodeRepresentation>> childs = currNR.children;
                boolean notFound = true;
                int idx2 = 0;
                while (notFound && idx2 < childs.size()) {
                    if (childs.elementAt(idx2) == parVec) {
                        notFound = false;
                        continue;
                    }
                    ++idx2;
                }
                if (notFound) {
                    MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 5865 of DecomposeProofHandler.");
                    return null;
                }
                result.addElement(new Integer(idx2));
            }
            if (currNR.getParentVector() == null) {
                result.addElement(new Integer(-1));
            } else {
                result.addElement(new Integer(currNR.getParentIndex()));
            }
            return result;
        }

        int getParentIndex() {
            if (this.getParentVector() == null) {
                return -1;
            }
            int i = 0;
            while (i < this.getParentVector().size()) {
                if (this == this.getParentVector().elementAt(i)) {
                    return i;
                }
                ++i;
            }
            return -2;
        }

        NodeRepresentation subNodeRep(SemanticNode sn, Vector<NodeRepresentation> vec, NodeRepresentation father, NodeTextRep setNodeText, Decomposition decomp, boolean isAssumption) {
            NodeRepresentation result = new NodeRepresentation();
            result.parentNode = father;
            result.setParentVector(vec);
            result.semanticNode = sn;
            result.isPrimed = this.isPrimed;
            result.isSubexpressionName = this.isSubexpressionName;
            result.isCreated = this.isCreated;
            NodeTextRep nodeTextRep = setNodeText;
            if (nodeTextRep == null) {
                nodeTextRep = this.subNodeText(sn);
            } else {
                result.isSubexpressionName = true;
            }
            result.nodeText = nodeTextRep.nodeText;
            result.mapping = nodeTextRep.mapping;
            result.instantiationSubstitutions = this.instantiationSubstitutions;
            switch (sn.getKind()) {
                case 9: {
                    result.nodeType = 0;
                    result.decomposition = DecomposeProofHandler.this.decompose(result, decomp, isAssumption);
                    if (result.decomposition == null) {
                        result.nodeSubtype = 99;
                        break;
                    }
                    result.nodeSubtype = result.decomposition.type;
                    break;
                }
                case 22: {
                    result.nodeType = 1;
                    NewSymbNode newNode = (NewSymbNode)sn;
                    result.newId = newNode.getOpDeclNode().getName().toString();
                    break;
                }
                case 33: {
                    result.nodeType = 4;
                    break;
                }
                default: {
                    result.nodeType = 5;
                }
            }
            return result;
        }

        NodeTextRep subNodeText(SemanticNode sn) {
            NodeTextRep result = new NodeTextRep();
            int beginIdx = DecomposeProofHandler.getBeginLine(sn) - DecomposeProofHandler.getBeginLine(this.semanticNode);
            result.nodeText = new String[DecomposeProofHandler.getEndLine(sn) - DecomposeProofHandler.getBeginLine(sn) + 1];
            result.mapping = new Vector[result.nodeText.length];
            int beginCol = sn.stn.getLocation().beginColumn();
            int beginPos = DecomposeProofHandler.colToLoc(beginCol, this.mapping[beginIdx]);
            result.nodeText[0] = this.nodeText[beginIdx].substring(beginPos);
            Vector<MappingPair> mv = DecomposeProofHandler.cloneMappingPairVector(this.mapping[beginIdx]);
            DecomposeProofHandler.adjustMappingPairVector(beginCol, -beginPos, mv);
            result.mapping[0] = mv;
            int minPos = beginPos;
            int i = 1;
            while (i < result.mapping.length) {
                result.nodeText[i] = this.nodeText[i + beginIdx];
                if (!StringHelper.onlySpaces((String)result.nodeText[i])) {
                    minPos = Math.min(minPos, StringHelper.leadingSpaces((String)result.nodeText[i]));
                }
                result.mapping[i] = new Vector();
                int j = 0;
                while (j < this.mapping[i + beginIdx].size()) {
                    result.mapping[i].add(this.mapping[i + beginIdx].elementAt(j).clone());
                    ++j;
                }
                ++i;
            }
            result.nodeText[result.nodeText.length - 1] = result.nodeText[result.nodeText.length - 1].substring(0, DecomposeProofHandler.colToLoc(sn.stn.getLocation().endColumn() + 1, result.mapping[result.mapping.length - 1]));
            int spacesAddedToFirstLine = beginPos - minPos;
            result.nodeText[0] = StringHelper.copyString((String)" ", (int)spacesAddedToFirstLine) + result.nodeText[0];
            DecomposeProofHandler.adjustMappingPairVector(beginCol, spacesAddedToFirstLine, result.mapping[0]);
            int i2 = 1;
            while (i2 < result.nodeText.length) {
                if (!StringHelper.onlySpaces((String)result.nodeText[i2])) {
                    result.nodeText[i2] = result.nodeText[i2].substring(minPos);
                    DecomposeProofHandler.adjustMappingPairVector(1, -minPos, result.mapping[i2]);
                }
                ++i2;
            }
            return result;
        }

        String[] primedNodeText() {
            if (!this.isPrimed) {
                return this.nodeText;
            }
            boolean needsParens = !this.isSubexpressionName && DecomposeProofHandler.primingNeedsParens(this.semanticNode);
            String[] result = (String[])this.nodeText.clone();
            if (needsParens) {
                result = DecomposeProofHandler.prependToStringArray(result, "(");
                result[result.length - 1] = StringHelper.trimEnd((String)result[result.length - 1]) + ")'";
            } else {
                result[result.length - 1] = StringHelper.trimEnd((String)result[result.length - 1]) + "'";
            }
            return result;
        }

        NodeRepresentation(IDocument document, SemanticNode node) throws BadLocationException {
            this.instantiationSubstitutions = new InstanceSubstitution();
            this.nodeType = 0;
            this.nodeSubtype = 99;
            this.newId = null;
            this.initialPosition = -1;
            this.children = null;
            this.parentNode = null;
            this.parentVector = null;
            this.isCreated = false;
            this.fromGoal = false;
            this.fromExists = false;
            this.fromDefs = new StringSet();
            this.onSameLineAsNext = false;
            this.isPrimed = false;
            this.isSubexpressionName = false;
            this.decomposition = null;
            this.semanticNode = node;
            Location location = node.stn.getLocation();
            this.nodeText = new String[location.endLine() - location.beginLine() + 1];
            this.mapping = new Vector[this.nodeText.length];
            int i = 0;
            while (i < this.mapping.length) {
                this.mapping[i] = new Vector();
                this.mapping[i].add(new MappingPair(1, -node.stn.getLocation().beginColumn()));
                ++i;
            }
            if (location.beginLine() == location.endLine()) {
                String str;
                IRegion thmregion = EditorUtil.getRegionOf(document, node.stn.getLocation());
                this.nodeText[0] = str = document.get(thmregion.getOffset(), thmregion.getLength());
                return;
            }
            IRegion region = document.getLineInformation(location.beginLine() - 1);
            this.nodeText[0] = document.get(region.getOffset() + location.beginColumn() - 1, region.getLength() - location.beginColumn() + 1);
            int minCol = location.beginColumn() - 1;
            int i2 = 1;
            while (i2 < this.nodeText.length) {
                region = document.getLineInformation(location.beginLine() - 1 + i2);
                this.nodeText[i2] = document.get(region.getOffset(), region.getLength());
                if (!StringHelper.onlySpaces((String)this.nodeText[i2])) {
                    minCol = Math.min(minCol, StringHelper.leadingSpaces((String)this.nodeText[i2]));
                }
                ++i2;
            }
            this.nodeText[this.nodeText.length - 1] = this.nodeText[this.nodeText.length - 1].substring(0, location.endColumn());
            int spacesAddedToFirstLine = location.beginColumn() - minCol - 1;
            this.nodeText[0] = StringHelper.copyString((String)" ", (int)spacesAddedToFirstLine) + this.nodeText[0];
            this.mapping[0].elementAt((int)0).inc = -minCol - 1;
            int i3 = 1;
            while (i3 < this.nodeText.length) {
                if (!StringHelper.onlySpaces((String)this.nodeText[i3])) {
                    this.nodeText[i3] = this.nodeText[i3].substring(minCol);
                    this.mapping[i3].elementAt((int)0).inc = -1 - minCol;
                }
                ++i3;
            }
        }

        public NodeRepresentation() {
            this.instantiationSubstitutions = new InstanceSubstitution();
            this.nodeType = 0;
            this.nodeSubtype = 99;
            this.newId = null;
            this.initialPosition = -1;
            this.children = null;
            this.parentNode = null;
            this.parentVector = null;
            this.isCreated = false;
            this.fromGoal = false;
            this.fromExists = false;
            this.fromDefs = new StringSet();
            this.onSameLineAsNext = false;
            this.isPrimed = false;
            this.isSubexpressionName = false;
            this.decomposition = null;
        }

        protected NodeRepresentation deepClone(NodeRepresentation parNode, Vector<NodeRepresentation> parVector) {
            NodeRepresentation result = new NodeRepresentation();
            result.semanticNode = this.semanticNode;
            result.nodeText = new String[this.nodeText.length];
            int i = 0;
            while (i < result.nodeText.length) {
                result.nodeText[i] = this.nodeText[i];
                ++i;
            }
            result.mapping = null;
            if (this.mapping != null) {
                result.mapping = (Vector[])this.mapping.clone();
                i = 0;
                while (i < result.mapping.length) {
                    result.mapping[i] = new Vector();
                    int j = 0;
                    while (j < this.mapping[i].size()) {
                        result.mapping[i].add(this.mapping[i].elementAt(j).clone());
                        ++j;
                    }
                    ++i;
                }
            }
            result.children = null;
            if (this.children != null) {
                result.children = new Vector();
                i = 0;
                while (i < this.children.size()) {
                    Vector<NodeRepresentation> oldParVec = this.children.elementAt(i);
                    Vector<NodeRepresentation> newParVec = new Vector<NodeRepresentation>();
                    int j = 0;
                    while (j < oldParVec.size()) {
                        newParVec.addElement(oldParVec.elementAt(j).deepClone(result, newParVec));
                        ++j;
                    }
                    result.children.addElement(newParVec);
                    ++i;
                }
            }
            result.instantiationSubstitutions = this.instantiationSubstitutions.clone();
            result.nodeType = this.nodeType;
            result.nodeSubtype = this.nodeSubtype;
            result.newId = this.newId;
            result.initialPosition = this.initialPosition;
            result.contextStepName = this.contextStepName;
            result.fromGoal = this.fromGoal;
            result.fromExists = this.fromExists;
            result.parentNode = parNode;
            result.parentVector = parVector;
            result.isCreated = this.isCreated;
            result.onSameLineAsNext = this.onSameLineAsNext;
            result.isPrimed = this.isPrimed;
            result.isSubexpressionName = this.isSubexpressionName;
            result.fromDefs = this.fromDefs.clone();
            result.decomposition = null;
            if (this.decomposition != null) {
                result.decomposition = this.decomposition.clone();
            }
            if (result.children != null) {
                i = 0;
                while (i < result.children.size()) {
                    Vector<NodeRepresentation> pvec = result.children.elementAt(i);
                    int j = 0;
                    while (j < pvec.size()) {
                        NodeRepresentation nr = pvec.elementAt(j);
                        if (nr.parentNode != result || nr.parentVector != pvec) {
                            MessageDialog.openError((Shell)UIHelper.getShellProvider().getShell(), (String)"Decompose Proof Command", (String)"An error that should not happen has occurred in line 6347 of DecomposeProofHandler.");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return result;
        }

        public String toString() {
            Object val = "";
            val = (String)val + "nodeText: |=\n" + DecomposeProofHandler.stringArrayToString(this.nodeText) + "=|";
            int i = 0;
            while (i < this.mapping.length) {
                val = (String)val + "\n" + i + ":";
                int j = 0;
                while (j < this.mapping[i].size()) {
                    val = (String)val + "  " + this.mapping[i].elementAt(j).toString();
                    ++j;
                }
                ++i;
            }
            return val;
        }
    }

    static class NodeTextRep {
        String[] nodeText = null;
        Vector<MappingPair>[] mapping = null;
        Renaming renaming = new Renaming();

        public NodeTextRep(String[] text, Vector<MappingPair>[] map) {
            this.nodeText = text;
            this.mapping = map;
        }

        public NodeTextRep() {
        }

        public NodeTextRep clone() {
            NodeTextRep result = new NodeTextRep();
            result.nodeText = new String[this.nodeText.length];
            int i = 0;
            while (i < result.nodeText.length) {
                result.nodeText[i] = this.nodeText[i];
                ++i;
            }
            result.mapping = null;
            if (this.mapping != null) {
                result.mapping = (Vector[])this.mapping.clone();
                i = 0;
                while (i < result.mapping.length) {
                    result.mapping[i] = new Vector();
                    int j = 0;
                    while (j < this.mapping[i].size()) {
                        result.mapping[i].add(this.mapping[i].elementAt(j).clone());
                        ++j;
                    }
                    ++i;
                }
            }
            result.renaming = this.renaming.clone();
            return result;
        }

        public String toString() {
            Object val = "";
            val = (String)val + "nodeText: |=\n" + DecomposeProofHandler.stringArrayToString(this.nodeText) + "=|";
            int i = 0;
            while (i < this.mapping.length) {
                val = (String)val + "\n" + i + ":";
                int j = 0;
                while (j < this.mapping[i].size()) {
                    val = (String)val + "  " + this.mapping[i].elementAt(j).toString();
                    ++j;
                }
                ++i;
            }
            return val;
        }
    }

    static class QuantifierDecomposition {
        Vector<NodeRepresentation> news;
        NodeRepresentation body;

        QuantifierDecomposition() {
        }
    }

    private static class Renaming {
        Vector<FormalParamNode> identifiers = new Vector();
        Vector<String> newNames = new Vector();

        private Renaming() {
        }

        public Renaming addAll(Renaming renaming) {
            Renaming result = this.clone();
            int i = 0;
            while (i < renaming.identifiers.size()) {
                int j = 0;
                boolean notFound = true;
                while (j < this.identifiers.size() && notFound) {
                    if (renaming.identifiers.elementAt(i) == this.identifiers.elementAt(j)) {
                        notFound = false;
                    }
                    ++j;
                }
                if (notFound) {
                    result.identifiers.add(renaming.identifiers.elementAt(i));
                    result.newNames.add(renaming.newNames.elementAt(i));
                }
                ++i;
            }
            return result;
        }

        public Renaming clone() {
            Renaming result = new Renaming();
            result.identifiers = (Vector)this.identifiers.clone();
            result.newNames = (Vector)this.newNames.clone();
            return result;
        }

        public String toString() {
            Object result = "[";
            int i = 0;
            while (i < this.newNames.size()) {
                if (i > 0) {
                    result = (String)result + ", ";
                }
                result = (String)result + String.valueOf(this.identifiers.elementAt(i).getName()) + " <- \"" + this.newNames.elementAt(i) + "\"";
                ++i;
            }
            return (String)result + "]";
        }
    }

    class WindowDisposeListener
    implements DisposeListener {
        DecomposeProofHandler commandHandler;

        WindowDisposeListener(DecomposeProofHandler handler) {
            this.commandHandler = handler;
        }

        public void widgetDisposed(DisposeEvent e) {
            this.commandHandler.location = DecomposeProofHandler.this.windowShell.getLocation();
            this.commandHandler.editorIFile.setReadOnly(false);
        }
    }
}

