/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.UIHelper;
import tla2sany.semantic.DefStepNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LeafProofNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.semantic.UseOrHideNode;
import tla2sany.st.Location;
import util.StringHelper;

public class RenumberProofHandler
extends AbstractHandler
implements IHandler {
    private IDocument doc;
    private String text;
    private ISelectionProvider selectionProvider;
    private TextSelection selection;
    private TheoremNode node;
    private NonLeafProofNode pfNode;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block43: {
            block41: {
                block42: {
                    if (!this.setFields(true)) {
                        return null;
                    }
                    try {
                        thmRegion = AdapterFactory.locationToRegion((IDocument)this.doc, (Location)this.node.getLocation());
                        if (this.text.substring(thmRegion.getOffset(), thmRegion.getOffset() + thmRegion.getLength()).indexOf(9) != -1) {
                            this.displayRenumberError("The Renumber Command does not work on a proof containing tabs.\nYou should not use tab characters in specifications.\nSee the General section of the  Getting Started > Preferences  help page.");
                            return null;
                        }
                    }
                    catch (BadLocationException thmRegion) {
                        // empty catch block
                    }
                    store = Activator.getDefault().getPreferenceStore();
                    try {
                        stepLoc = null;
                        steps = this.pfNode.getSteps();
                        replace = new ArrayList<StringReplacement>(15);
                        addSpaces = new ArrayList<E>(40);
                        stepNumber = 1;
                        i = 0;
lbl19:
                        // 2 sources

                        while (true) {
                            block45: {
                                block44: {
                                    if (i < steps.length) break block44;
                                    replaceArray = new StringReplacement[replace.size()];
                                    i = 0;
                                    if (true) ** GOTO lbl123
                                }
                                uname = null;
                                if (steps[i] instanceof TheoremNode) {
                                    stepPf = ((TheoremNode)steps[i]).getProof();
                                    if (stepPf != null && stepPf instanceof LeafProofNode) {
                                        stepLoc = leafPfLoc = stepPf.getLocation();
                                        ir = AdapterFactory.locationToRegion((IDocument)this.doc, (Location)leafPfLoc);
                                        leafPfStr = this.doc.get(ir.getOffset(), ir.getLength());
                                        if (leafPfStr.indexOf("<*>") > -1) {
                                            this.displayRenumberError("Cannot renumber proof that refers to <*> step numbers.");
                                            return null;
                                        }
                                    }
                                    uname = ((TheoremNode)steps[i]).getName();
                                } else if (steps[i] instanceof DefStepNode) {
                                    uname = ((DefStepNode)steps[i]).getStepNumber();
                                } else if (steps[i] instanceof UseOrHideNode) {
                                    uname = ((UseOrHideNode)steps[i]).getStepName();
                                } else if (steps[i] instanceof InstanceNode) {
                                    uname = ((InstanceNode)steps[i]).getStepName();
                                }
                                if (uname == null) break block41;
                                oldName = uname.toString();
                                suffix = oldName.substring(oldName.indexOf(62) + 1);
                                rename = true;
                                preference = store.getString("renumber_proof_option");
                                if (preference == "renumber_proof_first_digit") {
                                    rename = Character.isDigit(suffix.charAt(0));
                                    break block42;
                                }
                                if (preference != "renumber_proof_some_digit") break block45;
                                j = 0;
                                dontRename = true;
                                if (true) ** GOTO lbl73
                            }
                            if (preference == "renumber_proof_all_digits") {
                                j = 0;
                                while (rename && j < suffix.length()) {
                                    if (!Character.isDigit(suffix.charAt(j))) {
                                        rename = false;
                                    }
                                    ++j;
                                }
                            }
                            break block42;
                            break;
                        }
                    }
                    catch (BadLocationException var3_5) {
                        // empty catch block
                        break block43;
                    }
                    do {
                        if (Character.isDigit(suffix.charAt(j))) {
                            dontRename = false;
                        }
                        ++j;
lbl73:
                        // 2 sources

                    } while (rename && j < suffix.length());
                    v0 = rename = dontRename == false;
                }
                if (rename) {
                    newName = oldName.substring(0, oldName.indexOf(62) + 1) + stepNumber;
                    ++stepNumber;
                    replace.add(new StringReplacement(oldName, newName));
                    if (steps[i] instanceof TheoremNode) {
                        tstep = (TheoremNode)steps[i];
                        ncoc = newName.length() - oldName.length();
                        ls = tstep.stn.getLocation().beginLine();
                        thmLoc = tstep.getTheorem().stn.getLocation();
                        l0 = thmLoc.beginLine();
                        c0 = thmLoc.beginColumn();
                        n = thmLoc.endLine() - l0;
                        if (ncoc != 0 && l0 == ls && n > 0) {
                            newaddSpaces = new ArrayList<IntPair>(10);
                            shouldAdd = true;
                            j = 1;
                            while (shouldAdd && j <= n) {
                                lineOffset = this.doc.getLineOffset(l0 + j - 1);
                                lineLength = this.doc.getLineLength(l0 + j - 1);
                                line = this.doc.get(lineOffset, lineLength);
                                line = StringHelper.trimEnd((String)line);
                                lineLength = line.length();
                                k = 0;
                                while (shouldAdd && k < c0 - 1 && k < lineLength) {
                                    if (line.charAt(k) != ' ') {
                                        shouldAdd = false;
                                    }
                                    ++k;
                                }
                                if (lineLength >= c0 - 1) {
                                    newaddSpaces.add(new IntPair(l0 + j, ncoc));
                                }
                                ++j;
                            }
                            if (shouldAdd) {
                                j = 0;
                                while (j < newaddSpaces.size()) {
                                    addSpaces.add(newaddSpaces.get(j));
                                    ++j;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
            ** while (true)
            do {
                replaceArray[i] = (StringReplacement)replace.get(i);
                ++i;
lbl123:
                // 2 sources

            } while (i < replaceArray.length);
            Arrays.sort(replaceArray);
            pfRegion = AdapterFactory.locationToRegion((IDocument)this.doc, (Location)this.pfNode.getLocation());
            startRegion = pfRegion.getOffset();
            endRegion = startRegion + pfRegion.getLength();
            replacementOffsets = new ArrayList<IntPair>(40);
            i = 0;
            while (i < replaceArray.length) {
                searchFrom = startRegion;
                nextInsert = 0;
                done = false;
                oldString = replaceArray[i].oldStr;
                while (!done) {
                    nextFound = this.text.indexOf(oldString, searchFrom);
                    if (nextFound != -1 && nextFound < endRegion) ** GOTO lbl141
                    done = true;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ++nextInsert;
lbl141:
                        // 2 sources

                        ** while (nextInsert < replacementOffsets.size() && ((IntPair)replacementOffsets.get((int)nextInsert)).one < nextFound)
                    }
lbl142:
                    // 1 sources

                    if (nextInsert == replacementOffsets.size() || ((IntPair)replacementOffsets.get((int)nextInsert)).one != nextFound) {
                        replacementOffsets.add(nextInsert, new IntPair(nextFound, i));
                        ++nextInsert;
                    }
                    searchFrom = nextFound + 1;
                }
                ++i;
            }
            i = replacementOffsets.size() - 1;
            while (i > -1) {
                pair = (IntPair)replacementOffsets.get(i);
                rep = replaceArray[pair.two];
                this.doc.replace(pair.one, rep.oldStr.length(), rep.newStr);
                --i;
            }
            i = 0;
            while (i < addSpaces.size()) {
                pair = (IntPair)addSpaces.get(i);
                lineOffset = this.doc.getLineOffset(pair.one - 1);
                if (pair.two > 0) {
                    this.doc.replace(lineOffset, 0, StringHelper.copyString((String)" ", (int)pair.two));
                } else {
                    this.doc.replace(lineOffset, -pair.two, "");
                }
                ++i;
            }
        }
        this.resetFields();
        if (store.getBoolean("renumber_proof_save")) {
            UIHelper.getActiveEditor().doSave((IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    public void setEnabled(Object context) {
        Spec spec = Activator.getSpecManager().getSpecLoaded();
        this.setBaseEnabled(this.setFields(false) && spec.getStatus() == 0);
    }

    private boolean setFields(boolean reallySet) {
        TLAEditor editor = EditorUtil.getTLAEditorWithFocus();
        if (editor == null) {
            return false;
        }
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String text = doc.get();
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        TextSelection selection = (TextSelection)selectionProvider.getSelection();
        TheoremNode node = EditorUtil.getCurrentTheoremNode();
        if (node == null) {
            return false;
        }
        ProofNode pf = node.getProof();
        if (!(pf instanceof NonLeafProofNode)) {
            return false;
        }
        this.pfNode = (NonLeafProofNode)pf;
        if (reallySet) {
            this.doc = doc;
            this.text = text;
            this.selectionProvider = selectionProvider;
            this.selection = selection;
            this.node = node;
        }
        return true;
    }

    private void resetFields() {
        this.doc = null;
        this.text = null;
        this.selectionProvider = null;
        this.selection = null;
        this.node = null;
    }

    void displayRenumberError(String msg) {
        Shell shell = UIHelper.getShellProvider().getShell();
        MessageDialog.openError((Shell)shell, (String)"Renumbering Error", (String)msg);
        this.resetFields();
    }

    private static class IntPair {
        int one;
        int two;

        IntPair(int o, int t) {
            this.one = o;
            this.two = t;
        }
    }

    private static class StringReplacement
    implements Comparable {
        String oldStr;
        String newStr;

        public int compareTo(Object arg0) {
            return ((StringReplacement)arg0).oldStr.compareTo(this.oldStr);
        }

        StringReplacement(String o, String n) {
            this.oldStr = o;
            this.newStr = n;
        }

        public String toString() {
            return "`" + this.oldStr + "' -> `" + this.newStr + "'";
        }
    }
}

