/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.DocumentHelper;

public class ExampleEditCommandHandler
extends AbstractHandler
implements VerifyKeyListener,
FocusListener {
    private TLAEditor editor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray2[0] = 3;
        nArray2[1] = 2;
        nArray[0] = ColorPredicate.numberOfState(nArray2);
        int[] nArray3 = new int[3];
        nArray3[0] = 2;
        nArray3[1] = 3;
        nArray[1] = ColorPredicate.numberOfState(nArray3);
        nArray[2] = 1;
        int[] states = nArray;
        int i = 0;
        while (i < ColorPredicate.PREDEFINED_MACROS.length) {
            ColorPredicate cp = new ColorPredicate(ColorPredicate.PREDEFINED_MACROS[i][0]);
            System.out.println(ColorPredicate.PREDEFINED_MACROS[i][0] + " value: " + cp.satisfiedByObligations(states));
            ++i;
        }
        ColorPredicate cp = new ColorPredicate(" leaf None");
        System.out.println(cp.toString());
        return null;
    }

    public void verifyKey(VerifyEvent event) {
        try {
            event.doit = false;
            if (event.stateMask == 0 && Character.isDigit(event.character)) {
                int input = Character.getNumericValue(event.character);
                ISelection selection = this.editor.getSelectionProvider().getSelection();
                if (selection != null && selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                    if (textSelection.getLength() == 0 && document != null) {
                        try {
                            DocumentHelper.WordRegion region = DocumentHelper.getRegionExpandedBoth(document, textSelection.getOffset());
                            String insertionText = " " + document.get(region.getOffset(), region.getLength());
                            StringBuilder sb = new StringBuilder();
                            int i = 0;
                            while (i < input) {
                                sb.append(insertionText);
                                ++i;
                            }
                            document.replace(region.getOffset() + region.getLength(), 0, sb.toString());
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        finally {
            this.uninstall();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.uninstall();
    }

    public void install() {
        this.editor.getViewer().prependVerifyKeyListener((VerifyKeyListener)this);
        this.editor.getViewer().getTextWidget().addFocusListener((FocusListener)this);
        this.editor.setStatusMessage("Example command.");
    }

    private void uninstall() {
        this.editor.getViewer().removeVerifyKeyListener((VerifyKeyListener)this);
        this.editor.getViewer().getTextWidget().removeFocusListener((FocusListener)this);
        this.editor.setStatusMessage("");
    }

    public static class ColorPredicate {
        public boolean isLeaf;
        public boolean isSome;
        public long set;
        public static final String[] PROVER_NAMES = new String[]{"isabelle", "other_backend", "tlapm"};
        public static final String UNTRIED_STATUS = "untried";
        public static final String PROVING_STATUS = "proving";
        public static final String PROVED_STATUS = "proved";
        public static final String FAILED_STATUS = "failed";
        public static final String STOPPED_STATUS = "stopped";
        public static final String[] ISABELLE_STATUSES = new String[]{"untried", "proving", "proved", "failed", "stopped"};
        public static final String[] OTHER_PROVER_STATUSES = ISABELLE_STATUSES;
        public static final String[] TLAPM_STATUSES = new String[]{"untried", "proved"};
        public static final String[][] PROVER_STATUSES = new String[][]{ISABELLE_STATUSES, OTHER_PROVER_STATUSES, TLAPM_STATUSES};
        public static final int NUMBER_OF_PROVERS = PROVER_NAMES.length;
        public static final String[][] PREDEFINED_MACROS = new String[][]{{"None", "some"}, {"All", "every (,,)"}, {"Proved", "every (proved, , ) (,proved,) (,,proved)"}, {"ProvedOrOmitted", "every omitted (proved, , ) (,proved,) (,,proved)"}, {"NotProved", "some (-proved, -proved, -proved)"}, {"FailedUnproved", "some (failed,-proved,-proved) (-proved,failed,-proved)"}, {"FailedOrStoppedUnproved", "some (failed stopped,-proved,-proved) (-proved,failed stopped,-proved)"}, {"Failed", "some (failed,,) (,failed,)"}, {"FailedOrStopped", "some (failed stopped,,) (,failed stopped,)"}, {"BeingProved", "some (proving,,) (,proving,)"}, {"Missing", "some missing"}, {"Omitted", "some omitted"}, {"MissingOrOmitted", "some missing omitted"}, {"ProvedByIsabelle", "every (proved,,)"}, {"Stopped", "some (stopped,,) (,stopped,)"}, {"StoppedUnproved", "some (stopped,-proved,-proved) (-proved,stopped,-proved)"}};
        public static final int NUMBER_OF_MISSING_STATE = 0;
        public static final int NUMBER_OF_OMITTED_STATE = 1;

        public static final String getMacro(String macroName) {
            int i = 0;
            while (i < PREDEFINED_MACROS.length) {
                if (macroName.equalsIgnoreCase(PREDEFINED_MACROS[i][0])) {
                    return PREDEFINED_MACROS[i][1];
                }
                ++i;
            }
            return null;
        }

        public static final int numberOfProverStatus(int proverNumber, String statusName) throws IllegalArgumentException {
            if (proverNumber > NUMBER_OF_PROVERS || proverNumber < 0) {
                throw new IllegalArgumentException("No prover number " + proverNumber);
            }
            int i = 0;
            while (i < PROVER_STATUSES[proverNumber].length) {
                if (statusName.equals(PROVER_STATUSES[proverNumber][i])) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException("Prover " + PROVER_NAMES[proverNumber] + " has no status " + statusName);
        }

        public static final int numberOfState(int[] statuses) throws IllegalArgumentException {
            if (statuses.length != NUMBER_OF_PROVERS) {
                throw new IllegalArgumentException("Wrong number of provers specified");
            }
            int multiplier = 1;
            int result = 2;
            int i = 0;
            while (i < NUMBER_OF_PROVERS) {
                if (statuses[i] >= PROVER_STATUSES[i].length || statuses[i] < 0) {
                    throw new IllegalArgumentException("Prover " + PROVER_NAMES[i] + " does not have status number " + statuses[i]);
                }
                result += multiplier * statuses[i];
                multiplier *= PROVER_STATUSES[i].length;
                ++i;
            }
            return result;
        }

        public static final int numberOfState(String[] statuses) throws IllegalArgumentException {
            int[] statusNumbers = new int[statuses.length];
            int i = 0;
            while (i < statuses.length) {
                statusNumbers[i] = ColorPredicate.numberOfProverStatus(i, statuses[i]);
                ++i;
            }
            return ColorPredicate.numberOfState(statusNumbers);
        }

        public static final String numberToState(int stateNumber) {
            if (stateNumber == 0) {
                return "Missing";
            }
            if (stateNumber == 1) {
                return "Omitted";
            }
            int[] array = new int[3];
            if (3 != NUMBER_OF_PROVERS) {
                Activator.getDefault().logDebug("Method ColorPredicate.numberToState must be reimplemented when number of provers changes");
            }
            int i = 0;
            while (i < PROVER_STATUSES[0].length) {
                array[0] = i;
                int j = 0;
                while (j < PROVER_STATUSES[1].length) {
                    array[1] = j;
                    int k = 0;
                    while (k < PROVER_STATUSES[2].length) {
                        array[2] = k++;
                        if (ColorPredicate.numberOfState(array) != stateNumber) continue;
                        return "(" + PROVER_STATUSES[0][i] + ", " + PROVER_STATUSES[1][j] + ", " + PROVER_STATUSES[2][k] + ")";
                    }
                    ++j;
                }
                ++i;
            }
            return "No state with number " + stateNumber;
        }

        public static final long bitVectorOfStates(int[][] statuses) throws IllegalArgumentException {
            if (statuses.length != NUMBER_OF_PROVERS) {
                Activator.getDefault().logDebug("Method ColorPredicate.bitVectorOfStates must be reimplemented when number of provers changes");
            }
            long result = 0L;
            int[] array = new int[3];
            int i = 0;
            while (i < statuses[0].length) {
                array[0] = statuses[0][i];
                int j = 0;
                while (j < statuses[1].length) {
                    array[1] = statuses[1][j];
                    int k = 0;
                    while (k < statuses[2].length) {
                        array[2] = statuses[2][k];
                        result |= 1L << ColorPredicate.numberOfState(array);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }

        public static final long bitVectorOfStates(String[][] statuses) throws IllegalArgumentException {
            int[][] arg = new int[statuses.length][];
            int i = 0;
            while (i < arg.length) {
                arg[i] = new int[statuses[i].length];
                int j = 0;
                while (j < arg[i].length) {
                    arg[i][j] = ColorPredicate.numberOfProverStatus(i, statuses[i][j]);
                    ++j;
                }
                ++i;
            }
            return ColorPredicate.bitVectorOfStates(arg);
        }

        public static final void printBitVectorOfStates(long vector) {
            System.out.println(ColorPredicate.bitVectorOfStatesToString(vector));
        }

        public static final String bitVectorOfStatesToString(long vector) {
            long rest = vector;
            Object result = "";
            int i = 0;
            while (i < 60) {
                if ((rest & 1L) == 1L) {
                    result = (String)result + ColorPredicate.numberToState(i) + "\n";
                }
                rest >>>= 1;
                ++i;
            }
            return result;
        }

        public boolean satisfiedByObligations(int[] obligationStateNumbers) {
            boolean[] childValues = new boolean[obligationStateNumbers.length];
            int i = 0;
            while (i < obligationStateNumbers.length) {
                long bit = 1L << obligationStateNumbers[i];
                childValues[i] = (bit & this.set) != 0L;
                ++i;
            }
            return this.satisfiedBasedOnChildrenValues(childValues);
        }

        public boolean satisfiedBasedOnChildren(boolean[] childValues) {
            if (this.isLeaf) {
                return false;
            }
            return this.satisfiedBasedOnChildrenValues(childValues);
        }

        public boolean satisfiedBasedOnChildrenValues(boolean[] childValues) {
            boolean result;
            boolean bl = result = !this.isSome;
            if (this.isSome) {
                int i = 0;
                while (i < childValues.length) {
                    result = result || childValues[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < childValues.length) {
                    result = result && childValues[i];
                    ++i;
                }
            }
            return result;
        }

        public ColorPredicate(String input) throws IllegalArgumentException {
            String rest = input.trim().toLowerCase();
            if (rest.startsWith("leaf")) {
                this.isLeaf = true;
                rest = rest.substring(4).trim();
            } else {
                this.isLeaf = false;
            }
            int endOfStartToken = 0;
            while (endOfStartToken < rest.length() && Character.isLetter(rest.charAt(endOfStartToken))) {
                ++endOfStartToken;
            }
            String startToken = rest.substring(0, endOfStartToken);
            String macro = ColorPredicate.getMacro(startToken);
            if (macro != null) {
                rest = macro;
            }
            if (rest.startsWith("some")) {
                this.isSome = true;
                rest = rest.substring(4).trim();
            } else if (rest.startsWith("every")) {
                this.isSome = false;
                rest = rest.substring(5).trim();
            } else {
                throw new IllegalArgumentException("Color predicate must have `every' or `some' specifier.");
            }
            this.set = 0L;
            while (!rest.equals("")) {
                if (rest.startsWith("omitted")) {
                    this.set |= 2L;
                    rest = rest.substring(7).trim();
                    continue;
                }
                if (rest.startsWith("missing")) {
                    this.set |= 1L;
                    rest = rest.substring(7).trim();
                    continue;
                }
                if (rest.startsWith("(")) {
                    rest = rest.substring(1).trim();
                    int[][] stateSetSpec = new int[NUMBER_OF_PROVERS][];
                    int i = 0;
                    while (i < NUMBER_OF_PROVERS) {
                        boolean invert = false;
                        if (rest.startsWith("-")) {
                            invert = true;
                            rest = rest.substring(1).trim();
                        }
                        boolean[] appears = new boolean[PROVER_STATUSES[i].length];
                        int j = 0;
                        while (j < appears.length) {
                            appears[j] = invert;
                            ++j;
                        }
                        String endChar = i == NUMBER_OF_PROVERS - 1 ? ")" : ",";
                        while (rest.length() > 0 && !rest.startsWith(endChar)) {
                            int endOfToken = 0;
                            while (endOfToken < rest.length() && Character.isLetter(rest.charAt(endOfToken))) {
                                ++endOfToken;
                            }
                            String token = rest.substring(0, endOfToken);
                            rest = rest.substring(endOfToken).trim();
                            try {
                                int statusNumber = ColorPredicate.numberOfProverStatus(i, token);
                            }
                            catch (IllegalArgumentException e) {
                                String errorMsg = "Was expecting status of prover " + PROVER_NAMES[i] + " but found `" + token + "' followed by: \n `" + rest + "'";
                                throw new IllegalArgumentException(errorMsg);
                            }
                            boolean bl = appears[statusNumber] = !invert;
                        }
                        if (rest.length() == 0) {
                            throw new IllegalArgumentException("Color predicate specifier ended before `(...)' expression complete");
                        }
                        rest = rest.substring(1).trim();
                        int count = 0;
                        int j2 = 0;
                        while (j2 < appears.length) {
                            if (appears[j2]) {
                                ++count;
                            }
                            ++j2;
                        }
                        if (count == 0) {
                            if (invert) {
                                throw new IllegalArgumentException("A `-' must be followed by one or more statuses");
                            }
                            count = appears.length;
                            j2 = 0;
                            while (j2 < count) {
                                appears[j2] = true;
                                ++j2;
                            }
                        }
                        stateSetSpec[i] = new int[count];
                        int k = 0;
                        int j3 = 0;
                        while (j3 < appears.length) {
                            if (appears[j3]) {
                                stateSetSpec[i][k] = j3;
                                ++k;
                            }
                            ++j3;
                        }
                        ++i;
                    }
                    this.set |= ColorPredicate.bitVectorOfStates(stateSetSpec);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected token at: `" + rest + "'");
            }
        }

        public String toString() {
            String result = "leaf: " + this.isLeaf + "\n";
            result = result + "type: " + (this.isSome ? "some" : "every") + "\n";
            result = result + "set of states:\n";
            try {
                result = result + ColorPredicate.bitVectorOfStatesToString(this.set);
            }
            catch (IllegalArgumentException e) {
                result = result + "Illegal Bit Vector\n";
            }
            return result;
        }
    }
}

