/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.lamport.tla.toolbox.editor.basic.tla.ITLAReserveredWords;
import org.lamport.tla.toolbox.editor.basic.util.DocumentHelper;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.SymbolMatcher;
import tla2sany.semantic.SymbolNode;
import util.UniqueString;

public abstract class ToolboxCompletionProcessor {
    protected final SortedMap<String, List<CompletionProposalTemplate>> proposals = new TreeMap<String, List<CompletionProposalTemplate>>();
    protected final SymbolMatcher.NameAndTypeMatcher matcher = new SymbolMatcher.NameAndTypeMatcher();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        ArrayList<ICompletionProposal> propList = new ArrayList<ICompletionProposal>();
        try {
            int caretRowIndex = document.getLineOfOffset(offset);
            int carretColumnIndex = offset - document.getLineOffset(caretRowIndex);
            if (selectedRange.y > 0) {
                String text = document.get(selectedRange.x, selectedRange.y);
                this.computeWordProposals(text, offset, carretColumnIndex, propList);
            } else {
                IRegion wordRegion = DocumentHelper.getRegionExpandedBackwards(document, offset, DocumentHelper.getDefaultWordDetector());
                String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
                this.computeWordProposals(word, offset, carretColumnIndex, propList);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return propList.toArray(new ICompletionProposal[propList.size()]);
    }

    private void computeWordProposals(String word, int offset, int carretColumnIndex, List<ICompletionProposal> propositionList) {
        int qualifierLength = word.length();
        int replacementOffset = offset - qualifierLength;
        for (List<CompletionProposalTemplate> list : ToolboxCompletionProcessor.filterPrefix(this.proposals, word).values()) {
            for (CompletionProposalTemplate template : list) {
                propositionList.add(template.getProposal(replacementOffset, carretColumnIndex - qualifierLength, qualifierLength));
            }
        }
        SpecObj specObj = ToolboxHandle.getSpecObj();
        if (specObj != null && specObj.getRootModule() != null) {
            ModuleNode rootModule = specObj.getRootModule();
            Collection symbols = rootModule.getSymbols((SymbolMatcher)this.matcher.setPrefix(word));
            for (SymbolNode symbolNode : symbols) {
                propositionList.add(new CompletionProposalTemplate(symbolNode.getSignature(), symbolNode.getName(), symbolNode.getHumanReadableImage()).getProposal(replacementOffset, carretColumnIndex - qualifierLength, qualifierLength));
            }
        }
    }

    public static SortedMap<String, List<CompletionProposalTemplate>> filterPrefix(SortedMap<String, List<CompletionProposalTemplate>> baseMap, String prefix) {
        if (prefix.length() > 0) {
            char nextLetter = (char)(prefix.charAt(prefix.length() - 1) + '\u0001');
            String end = prefix.substring(0, prefix.length() - 1) + nextLetter;
            return baseMap.subMap(prefix, end);
        }
        return baseMap;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.y > 0) {
            ContextInformation[] contextInfos = new ContextInformation[ITLAReserveredWords.ALL_WORDS_ARRAY.length];
            int i = 0;
            while (i < ITLAReserveredWords.ALL_WORDS_ARRAY.length) {
                contextInfos[i] = new ContextInformation(null, ITLAReserveredWords.ALL_WORDS_ARRAY[i] + " Style");
                ++i;
            }
            return contextInfos;
        }
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected static class CompletionProposalTemplate {
        private final String fReplacementString;
        private final Image fImage;
        private final IContextInformation fContextInformation;
        private final String fAdditionalProposalInfo;
        private final String fDisplayString;

        public CompletionProposalTemplate(String replacementString, Image image, String dipslayString, IContextInformation contextInformation, String additionalProposalInfo) {
            this.fReplacementString = replacementString;
            this.fImage = image;
            this.fDisplayString = dipslayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        public CompletionProposalTemplate(String replacementString, Image image, String dipslayString, String additionalProposalInfo) {
            this.fReplacementString = replacementString;
            this.fImage = image;
            this.fDisplayString = dipslayString;
            this.fContextInformation = null;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        public CompletionProposalTemplate(UniqueString replacementString, UniqueString dipslayString, String additionalProposalInfo) {
            this(replacementString.toString(), dipslayString.toString(), additionalProposalInfo);
        }

        public CompletionProposalTemplate(String replacementString, UniqueString dipslayString, String additionalProposalInfo) {
            this(replacementString, dipslayString.toString(), additionalProposalInfo);
        }

        public CompletionProposalTemplate(String replacementString, String dipslayString, String additionalProposalInfo) {
            this.fReplacementString = replacementString;
            this.fImage = null;
            this.fDisplayString = dipslayString;
            this.fContextInformation = null;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        public CompletionProposalTemplate(String replacementString) {
            this.fReplacementString = replacementString;
            this.fImage = null;
            this.fContextInformation = null;
            this.fAdditionalProposalInfo = null;
            this.fDisplayString = null;
        }

        public ICompletionProposal getProposal(int replacementOffset, int wordStartColumnIndex, int qualifierLength) {
            String indent = CharBuffer.allocate(wordStartColumnIndex).toString().replace('\u0000', ' ');
            String indentedReplacementString = this.fReplacementString.replace("\n", "\n" + indent);
            return new ToolboxCompletionProposal(indentedReplacementString, replacementOffset, qualifierLength, indentedReplacementString.length(), this.fImage, this.fDisplayString, this.fContextInformation, this.fAdditionalProposalInfo);
        }
    }

    public static class ToolboxCompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension5,
    ICompletionProposalExtension7 {
        private String fDisplayString;
        private String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;

        public ToolboxCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
            this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
        }

        public ToolboxCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
            Assert.isNotNull((Object)replacementString);
            Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
            Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
            Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return this.fAdditionalProposalInfo;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return this.getAdditionalProposalInfo();
        }

        public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
            StyledString styledString = new StyledString();
            styledString.append(this.getDisplayString());
            styledString.append(": ");
            styledString.append(this.fReplacementString.replaceAll("\n[ ]*", " "), StyledString.COUNTER_STYLER);
            return styledString;
        }
    }
}

