/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;

public class TLAReconcilingStrategy
implements IPropertyChangeListener,
IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final String BLOCK_COMMENT_DELIMITER_REGEX = "^[ \\t]*\\(\\*{3}\\**\\)\\s*$";
    private static final String SINGLE_LINE_COMMENT = "^[ \\t]*\\\\\\*";
    private static final String PCAL_TRANSLATION_PREFIX_REGEX = "^\\\\\\*+ BEGIN TRANSLATION.*$";
    private static final String PCAL_TRANSLATION_SUFFIX_REGEX = "^\\\\\\*+ END TRANSLATION.*$";
    private IDocument document;
    protected final List<TLCProjectionAnnotation> currentAnnotations;
    private TLAEditor editor;
    private ProjectionViewer projectionViewer;
    private final AtomicBoolean foldBlockComments;
    private final AtomicBoolean foldPlusCalAlgorithm;
    private final AtomicBoolean foldTranslatedPlusCalBlock;

    public TLAReconcilingStrategy() {
        IPreferenceStore store = PreferenceStoreHelper.getInstancePreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.currentAnnotations = new ArrayList<TLCProjectionAnnotation>();
        this.foldBlockComments = new AtomicBoolean(store.getBoolean("foldingBlockComments"));
        this.foldPlusCalAlgorithm = new AtomicBoolean(store.getBoolean("foldingPCalAlg"));
        this.foldTranslatedPlusCalBlock = new AtomicBoolean(store.getBoolean("foldingPCalTranslated"));
    }

    public void dispose() {
        IPreferenceStore store = PreferenceStoreHelper.getInstancePreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean reconcile;
        if ("foldingBlockComments".equals(event.getProperty())) {
            this.foldBlockComments.set((Boolean)event.getNewValue());
            reconcile = true;
        } else if ("foldingPCalAlg".equals(event.getProperty())) {
            this.foldPlusCalAlgorithm.set((Boolean)event.getNewValue());
            reconcile = true;
        } else if ("foldingPCalTranslated".equals(event.getProperty())) {
            this.foldTranslatedPlusCalBlock.set((Boolean)event.getNewValue());
            reconcile = true;
        } else {
            reconcile = false;
        }
        if (reconcile) {
            this.reconcile(null, null, null);
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile(partition, null, null);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(null, dirtyRegion, subRegion);
    }

    public void setDocument(IDocument id) {
        this.document = id;
    }

    public void initialReconcile() {
        this.reconcile(null, null, null);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void setEditor(TLAEditor tlaEditor) {
        this.editor = tlaEditor;
    }

    public void setProjectionViewer(ProjectionViewer viewer) {
        this.projectionViewer = viewer;
        this.projectionViewer.setData(this.getClass().toString(), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile(IRegion partition, DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.editor != null) {
            Annotation[] deletions;
            HashMap<TLCProjectionAnnotation, Position> regionMap = this.determineFoldingRegions(partition, dirtyRegion, subRegion);
            final HashMap<TLCProjectionAnnotation, Position> regionsToAdd = new HashMap<TLCProjectionAnnotation, Position>();
            List<TLCProjectionAnnotation> list = this.currentAnnotations;
            synchronized (list) {
                for (Map.Entry<TLCProjectionAnnotation, Position> me : regionMap.entrySet()) {
                    if (this.currentAnnotations.remove((Object)me.getKey())) continue;
                    regionsToAdd.put(me.getKey(), me.getValue());
                }
                deletions = this.currentAnnotations.toArray(new Annotation[this.currentAnnotations.size()]);
                this.currentAnnotations.clear();
                this.currentAnnotations.addAll(regionMap.keySet());
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TLAReconcilingStrategy.this.editor.modifyProjectionAnnotations(deletions, regionsToAdd);
                    if (TLAReconcilingStrategy.this.projectionViewer != null) {
                        ProjectionAnnotationModel model = TLAReconcilingStrategy.this.projectionViewer.getProjectionAnnotationModel();
                        boolean block = TLAReconcilingStrategy.this.foldBlockComments.get();
                        boolean pcal = TLAReconcilingStrategy.this.foldPlusCalAlgorithm.get();
                        boolean translated = TLAReconcilingStrategy.this.foldTranslatedPlusCalBlock.get();
                        if (block || pcal || translated) {
                            for (TLCProjectionAnnotation annotation : TLAReconcilingStrategy.this.currentAnnotations) {
                                boolean collapse;
                                switch (annotation.getTLCType()) {
                                    case BLOCK_COMMENT: {
                                        collapse = block;
                                        break;
                                    }
                                    case PCAL_BLOCK: {
                                        collapse = pcal;
                                        break;
                                    }
                                    default: {
                                        collapse = translated;
                                    }
                                }
                                if (!collapse) continue;
                                model.collapse((Annotation)annotation);
                            }
                        }
                    }
                }
            });
        }
    }

    private HashMap<TLCProjectionAnnotation, Position> determineFoldingRegions(IRegion partition, DirtyRegion dirtyRegion, IRegion subRegion) {
        IRegion find2;
        HashMap<TLCProjectionAnnotation, Position> additions = new HashMap<TLCProjectionAnnotation, Position>();
        FindReplaceDocumentAdapter search = new FindReplaceDocumentAdapter(this.document);
        try {
            int pcalStartLocation;
            find2 = search.find(0, "--algorithm", true, true, false, false);
            if (find2 == null) {
                find2 = search.find(0, "--fair", true, true, false, false);
            }
            if (find2 != null && (find2 = search.find(pcalStartLocation = find2.getOffset(), "^\\(\\*", false, true, false, true)) != null) {
                int startLocation = find2.getOffset();
                find2 = search.find(pcalStartLocation, "^\\s?\\*+\\)$", true, true, false, true);
                this.addProjectionAdditionToMap(additions, startLocation, find2, AnnotationType.PCAL_BLOCK);
            }
        }
        catch (BadLocationException find2) {
            // empty catch block
        }
        try {
            int translationStartLocation;
            find2 = search.find(0, PCAL_TRANSLATION_PREFIX_REGEX, true, true, false, true);
            if (find2 != null && (find2 = search.find(translationStartLocation = find2.getOffset(), PCAL_TRANSLATION_SUFFIX_REGEX, true, true, false, true)) != null) {
                this.addProjectionAdditionToMap(additions, translationStartLocation, find2, AnnotationType.TRANSLATED_PCAL_BLOCK);
            }
        }
        catch (BadLocationException find3) {
            // empty catch block
        }
        try {
            boolean inBlock = false;
            int lastFoundIndex = 0;
            IRegion find4 = search.find(lastFoundIndex, BLOCK_COMMENT_DELIMITER_REGEX, true, true, false, true);
            while (find4 != null) {
                if (inBlock) {
                    this.addProjectionAdditionToMap(additions, lastFoundIndex, find4, AnnotationType.BLOCK_COMMENT);
                }
                inBlock = !inBlock;
                lastFoundIndex = find4.getOffset();
                find4 = search.find(lastFoundIndex + find4.getLength(), BLOCK_COMMENT_DELIMITER_REGEX, true, true, false, true);
            }
        }
        catch (BadLocationException inBlock) {
            // empty catch block
        }
        try {
            int lastFoundIndex = 0;
            IRegion find5 = search.find(lastFoundIndex, SINGLE_LINE_COMMENT, true, true, false, true);
            int contiguousLineCount = 1;
            int firstMatchingOffset = -1;
            while (find5 != null) {
                IRegion lineEnding;
                if (firstMatchingOffset == -1) {
                    firstMatchingOffset = find5.getOffset();
                }
                if ((lineEnding = search.find((lastFoundIndex = find5.getOffset()) + find5.getLength(), "\\n", true, true, false, true)) != null) {
                    lastFoundIndex = lineEnding.getOffset();
                    find5 = search.find(lastFoundIndex + 1, SINGLE_LINE_COMMENT, true, true, false, true);
                } else {
                    lastFoundIndex += find5.getLength();
                    find5 = null;
                }
                boolean addProjection = contiguousLineCount > 1;
                boolean reset = true;
                if (find5 != null && find5.getOffset() == lastFoundIndex + 1) {
                    ++contiguousLineCount;
                    addProjection = false;
                    reset = false;
                }
                if (addProjection) {
                    this.addProjectionAdditionToMap(additions, firstMatchingOffset, lastFoundIndex, AnnotationType.MULTIPLE_SINGLE_LINE_COMMENT);
                }
                if (!reset) continue;
                contiguousLineCount = 1;
                firstMatchingOffset = -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return additions;
    }

    private void addProjectionAdditionToMap(Map<TLCProjectionAnnotation, Position> additions, int startLocation, IRegion find, AnnotationType type) throws BadLocationException {
        if (find != null) {
            int endLocation = find.getOffset() + find.getLength() + 1;
            this.addProjectionAdditionToMap(additions, startLocation, endLocation, type);
        }
    }

    private void addProjectionAdditionToMap(Map<TLCProjectionAnnotation, Position> additions, int startLocation, int endLocation, AnnotationType type) throws BadLocationException {
        int length = endLocation - startLocation;
        int positionLength = length + (this.document.getLength() > endLocation ? 1 : 0);
        Position position = new Position(startLocation, positionLength);
        additions.put(new TLCProjectionAnnotation(this.document.get(startLocation, length), type), position);
    }

    private static enum AnnotationType {
        BLOCK_COMMENT,
        MULTIPLE_SINGLE_LINE_COMMENT,
        PCAL_BLOCK,
        TRANSLATED_PCAL_BLOCK;

    }

    private static class TLCProjectionAnnotation
    extends ProjectionAnnotation {
        private final AnnotationType type;

        TLCProjectionAnnotation(String text, AnnotationType annotationType) {
            this.setText(text);
            this.type = annotationType;
        }

        AnnotationType getTLCType() {
            return this.type;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!Annotation.class.isAssignableFrom(other.getClass())) {
                return false;
            }
            Annotation otherAnnotation = (Annotation)other;
            String otherText = otherAnnotation.getText();
            return Objects.equals(this.getText(), otherText);
        }

        public int hashCode() {
            String text = this.getText();
            if (text == null) {
                return 0;
            }
            return text.hashCode();
        }
    }
}

