/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.DocumentHelper;

public class ExampleEditorAction
extends TextEditorAction
implements VerifyKeyListener {
    private IStatusLineManager statusLine;

    public ExampleEditorAction(ResourceBundle bundle, String prefix, TLAEditor editor, IStatusLineManager statusLine) {
        super(bundle, prefix, (ITextEditor)editor);
        this.statusLine = statusLine;
    }

    public void run() {
        ((TLAEditor)this.getTextEditor()).getViewer().prependVerifyKeyListener((VerifyKeyListener)this);
        this.statusLine.setMessage("Example Command");
    }

    public void verifyKey(VerifyEvent event) {
        event.doit = false;
        if (event.stateMask == 0 && Character.isDigit(event.character)) {
            int input = Character.getNumericValue(event.character);
            ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
            if (selection != null && selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
                if (textSelection.getLength() == 0 && document != null) {
                    try {
                        DocumentHelper.WordRegion region = DocumentHelper.getRegionExpandedBoth(document, textSelection.getOffset());
                        String insertionText = " " + document.get(region.getOffset(), region.getLength());
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < input) {
                            sb.append(insertionText);
                            ++i;
                        }
                        document.replace(region.getOffset() + region.getLength(), 0, sb.toString());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ((TLAEditor)this.getTextEditor()).getViewer().removeVerifyKeyListener((VerifyKeyListener)this);
        this.statusLine.setMessage("");
    }
}

