/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.editor.basic.TLAEditorMessages;
import org.lamport.tla.toolbox.editor.basic.TLAReconcilingStrategy;
import org.lamport.tla.toolbox.editor.basic.TLASourceViewerConfiguration;
import org.lamport.tla.toolbox.editor.basic.actions.ToggleCommentAction;
import org.lamport.tla.toolbox.editor.basic.proof.TLAProofFoldingStructureProvider;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.editor.basic.util.ElementStateAdapter;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.TLAtoPCalMarker;
import org.lamport.tla.toolbox.util.UIHelper;
import pcal.PCalLocation;
import pcal.TLAtoPCalMapping;
import tlc2.output.SpecWriterUtilities;
import util.StringHelper;

public class TLAEditor
extends TextEditor {
    public static final String SAVE_EVENT = "TLAEditor/save";
    public static final String PRE_SAVE_EVENT = "TLAEditor/presave";
    public static final String ID = "org.lamport.tla.toolbox.editor.basic.TLAEditor";
    private IContextService contextService = null;
    private IContextActivation contextActivation = null;
    private ProjectionSupport projectionSupport;
    private Image rootImage = TLAEditorActivator.imageDescriptorFromPlugin((String)"org.lamport.tla.toolbox.editor.basic", (String)"/icons/root_file.gif").createImage();
    private ProjectionAnnotationModel annotationModel;
    private TLAProofFoldingStructureProvider proofStructureProvider;
    private final List<IUndoableOperation> lastUndoOperations = new ArrayList<IUndoableOperation>(2);
    private IResourceChangeListener moduleFileChangeListener;
    private IEventBroker service;

    public TLAEditor() {
        this.setHelpContextId("org.lamport.tla.toolbox.editor.basic.main_editor_window");
    }

    protected void setDocumentProvider(IEditorInput input) {
        super.setDocumentProvider(input);
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            provider.addElementStateListener((IElementStateListener)new ElementStateAdapter(){

                @Override
                public void elementDirtyStateChanged(Object element, boolean isDirty) {
                    if (isDirty) {
                        TLAEditor.this.contextService.deactivateContext(TLAEditor.this.contextActivation);
                    } else {
                        TLAEditor.this.contextActivation = TLAEditor.this.contextService.activateContext("toolbox.contexts.cleaneditor");
                    }
                }
            });
        }
    }

    protected TLASourceViewerConfiguration getTLASourceViewerConfiguration(IPreferenceStore preferenceStore) {
        return new TLASourceViewerConfiguration(preferenceStore, this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ChainedPreferenceStore preferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{TLAEditorActivator.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()});
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.getTLASourceViewerConfiguration((IPreferenceStore)preferenceStore));
        this.setPreferenceStore((IPreferenceStore)preferenceStore);
        this.initEditorNameAndDescription(input);
        this.contextService = (IContextService)this.getSite().getService(IContextService.class);
        Assert.isNotNull((Object)this.contextService);
        this.contextActivation = this.contextService.activateContext("toolbox.contexts.cleaneditor");
        Assert.isNotNull((Object)this.contextActivation);
        this.moduleFileChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] markerChanges = event.findMarkerDeltas("org.lamport.tla.toolbox.editor.basic.readOnly", false);
                int i = 0;
                while (i < markerChanges.length) {
                    if (TLAEditor.this.getEditorInput() instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)TLAEditor.this.getEditorInput();
                        if (markerChanges[i].getResource().equals((Object)iFileEditorInput.getFile())) {
                            UIHelper.runUIAsync((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TLAEditor.this.refresh();
                                }
                            });
                        }
                    } else if (TLAEditor.this.getEditorInput() instanceof FileStoreEditorInput) {
                        FileStoreEditorInput fsei = (FileStoreEditorInput)TLAEditor.this.getEditorInput();
                        if (markerChanges[i].getResource().getLocationURI().equals(fsei.getURI())) {
                            UIHelper.runUIAsync((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TLAEditor.this.refresh();
                                }
                            });
                        }
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.moduleFileChangeListener);
        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().addOperationHistoryListener(new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation currentUndoOperation;
                if (event.getEventType() == 10 && TLAEditor.this.lastUndoOperations.contains(currentUndoOperation = event.getOperation())) {
                    try {
                        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().undo(TLAEditor.this.getUndoContext(), (IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (ExecutionException e) {
                        TLAEditor.this.lastUndoOperations.clear();
                    }
                }
            }
        });
    }

    protected void initEditorNameAndDescription(IEditorInput input) {
        FileEditorInput finput;
        if (input instanceof FileEditorInput && (finput = (FileEditorInput)input) != null) {
            IPath path = finput.getPath();
            this.setContentDescription(path.toString());
            if (ResourceHelper.isRoot((IFile)finput.getFile())) {
                this.setTitleImage(this.rootImage);
            }
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager;
        if (this.getSourceViewer() instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)this.getSourceViewer()).getUndoManager()) instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        if (viewer.canDoOperation(19)) {
            viewer.doOperation(19);
        }
        this.annotationModel = viewer.getProjectionAnnotationModel();
        this.proofStructureProvider = new TLAProofFoldingStructureProvider(this);
        this.refresh();
        this.service = (IEventBroker)this.getSite().getService(IEventBroker.class);
    }

    protected void createActions() {
        super.createActions();
        Object a = new TextOperationAction(TLAEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(TLAEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new ToggleCommentAction(TLAEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        a.setActionDefinitionId("org.lamport.tla.toolbox.editor.basic.ToggleCommentAction");
        this.setAction("ToggleComment", (IAction)a);
        this.markAsStateDependentAction("ToggleComment", true);
        this.markAsSelectionDependentAction("ToggleComment", true);
        ((ToggleCommentAction)((Object)a)).configure(this.getSourceViewer(), this.getSourceViewerConfiguration());
        if (this.getSourceViewerConfiguration().getContentFormatter(this.getSourceViewer()) != null) {
            a = new TextOperationAction(TLAEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
            a.setActionDefinitionId("org.lamport.tla.toolbox.editor.basic.FormatAction");
            this.setAction("Format", (IAction)a);
            this.markAsStateDependentAction("Format", true);
            this.markAsSelectionDependentAction("Format", true);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menuManager) {
        super.editorContextMenuAboutToShow(menuManager);
        IContributionItem additions = menuManager.find("additions");
        if (additions != null) {
            menuManager.insertAfter("additions", (IContributionItem)new Separator("foldCommands"));
        } else {
            menuManager.add((IContributionItem)new Separator("foldCommands"));
        }
        if (menuManager instanceof ContributionManager) {
            ContributionManager cm = (ContributionManager)menuManager;
            this.removeTopLevelMenuWithDisplayText("Open W&ith", cm);
            this.removeTopLevelMenuWithDisplayText("Sho&w In", cm);
            boolean cfr_ignored_0 = menuManager instanceof MenuManager;
            Runnable r = () -> {
                MenuManager mm = (MenuManager)cm;
                ArrayList menuCountFerry = new ArrayList();
                Display d = PlatformUI.getWorkbench().getDisplay();
                d.syncExec(() -> {
                    menuCountFerry.clear();
                    Menu m = mm.getMenu();
                    menuCountFerry.add(m != null ? m.getItemCount() : 0);
                });
                while ((Integer)menuCountFerry.get(0) == 0) {
                    try {
                        Thread.sleep(40L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    d.syncExec(() -> {
                        menuCountFerry.clear();
                        Menu m = mm.getMenu();
                        menuCountFerry.add(m != null ? m.getItemCount() : 0);
                    });
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Menu menu = mm.getMenu();
                    this.removeMenuItemWithDisplayText("&Run As", menu);
                    this.removeMenuItemWithDisplayText("&Debug As", menu);
                    this.removeMenuItemWithDisplayText("Import SWTBot", menu);
                    this.removeMenuItemWithDisplayText("T&eam", menu);
                    this.removeMenuItemWithDisplayText("Rep&lace With", menu);
                    this.removeMenuItemWithDisplayText("Comp&are With", menu);
                });
            };
            new Thread(r).start();
        }
        menuManager.remove("ShiftRight");
        menuManager.remove("ShiftLeft");
    }

    private void removeMenuItemWithDisplayText(String text, Menu menu) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            String menuItemText = item.getText();
            if (menuItemText != null && menuItemText.startsWith(text)) {
                item.dispose();
                return;
            }
            ++n2;
        }
    }

    private void removeTopLevelMenuWithDisplayText(String text, ContributionManager cm) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = cm.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuManager mm;
            String menuText;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof MenuManager && (menuText = (mm = (MenuManager)item).getMenuText()) != null && menuText.startsWith(text)) {
                cm.remove(item);
                return;
            }
            ++n2;
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.service.send(PRE_SAVE_EVENT, (Object)this);
        IEditorInput editorInput = this.getEditorInput();
        IDocument doc = this.getDocumentProvider().getDocument((Object)editorInput);
        String text = doc.get();
        int historyStart = text.indexOf(SpecWriterUtilities.MODIFICATION_HISTORY);
        if (historyStart > -1) {
            int newEntryStart = historyStart + SpecWriterUtilities.MODIFICATION_HISTORY.length();
            String user = System.getProperty("user.name");
            String searchString = SpecWriterUtilities.MODIFIED_BY + user;
            int searchStringLength = searchString.length();
            boolean found = false;
            int nextEntry = newEntryStart - 1;
            int endOfLine = -1;
            while (!found) {
                if ((nextEntry = text.indexOf(SpecWriterUtilities.LAST_MODIFIED, nextEntry + 1)) < 0) break;
                endOfLine = text.indexOf(StringHelper.PLATFORM_NEWLINE, nextEntry + 1);
                if (endOfLine < 0) {
                    endOfLine = text.length();
                }
                int realEOL = endOfLine;
                while (text.charAt(realEOL - 1) == ' ') {
                    --realEOL;
                }
                if (nextEntry + searchStringLength >= realEOL || !searchString.equals(text.substring(realEOL - searchStringLength, realEOL))) continue;
                found = true;
            }
            try {
                if (found) {
                    doc.replace(nextEntry, endOfLine - nextEntry, "");
                }
                doc.replace(newEntryStart, 0, SpecWriterUtilities.LAST_MODIFIED + String.valueOf(new Date()) + searchString);
                this.lastUndoOperations.clear();
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                IUndoableOperation[] undoHistory = operationHistory.getUndoHistory(this.getUndoContext());
                if (found) {
                    this.lastUndoOperations.add(undoHistory[undoHistory.length - 2]);
                }
                this.lastUndoOperations.add(undoHistory[undoHistory.length - 1]);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.doSave(progressMonitor);
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)editorInput;
            IFile spec = fei.getFile();
            this.service.post(SAVE_EVENT, (Object)spec);
        }
    }

    public void modifyProjectionAnnotations(Annotation[] deletions, Map<? extends ProjectionAnnotation, ? extends Position> additions) {
        this.annotationModel.modifyAnnotations(deletions, additions, null);
    }

    public void modifyProjectionAnnotations(Annotation[] modifications) {
        this.annotationModel.modifyAnnotations(null, null, modifications);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        Path newPath;
        Shell shell;
        IFile file;
        block13: {
            File newFile;
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            shell = UIHelper.getShellProvider().getShell();
            Path specRootPrefix = new Path(ResourceHelper.getParentDirName((IResource)ToolboxHandle.getRootModule()));
            FileDialog saveAsDialog = null;
            while (true) {
                saveAsDialog = new FileDialog(shell, 8192);
                saveAsDialog.setOverwrite(true);
                saveAsDialog.setText("Select the new filename...");
                saveAsDialog.setFilterExtensions(new String[]{"*.tla"});
                saveAsDialog.setFilterNames(new String[]{"TLA+ Files"});
                saveAsDialog.setFilterPath(file.getLocation().toOSString());
                String result = saveAsDialog.open();
                saveAsDialog = null;
                if (result == null) return;
                newPath = new Path(result);
                if (!specRootPrefix.isPrefixOf((IPath)newPath)) {
                    MessageDialog.openError((Shell)shell, (String)"Wrong location selected", (String)"The provided filename point to the same directory as the specification root file");
                    continue;
                }
                if (!"tla".equals(newPath.getFileExtension())) {
                    newPath = newPath.addFileExtension("tla");
                }
                if (!(newFile = newPath.toFile()).exists()) break;
                boolean confirmOverwrite = MessageDialog.openQuestion((Shell)shell, (String)"Overwrite file?", (String)("The provided filename already exists. The existing file will be overwritten.\nDo you want to overwrite the file " + newPath.toOSString() + "?"));
                if (!confirmOverwrite) {
                    continue;
                }
                break block13;
                break;
            }
            boolean newFileCreated = false;
            try {
                newFileCreated = newFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!newFileCreated) {
                MessageDialog.openError((Shell)shell, (String)"Error saving a file", (String)"File could not be created");
                return;
            }
        }
        IFile newResource = ResourceHelper.getLinkedFile((IProject)file.getProject(), (String)newPath.toOSString());
        FileEditorInput newInput = new FileEditorInput(newResource);
        IDocumentProvider provider = this.getDocumentProvider();
        boolean saveAsSuccess = false;
        try {
            try {
                provider.aboutToChange((Object)newInput);
                provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)this.getEditorInput()), true);
                saveAsSuccess = true;
                return;
            }
            catch (CoreException x) {
                MessageDialog.openError((Shell)shell, (String)"Error saving a file", (String)"File could not be created");
                provider.changed((Object)newInput);
                if (!saveAsSuccess) return;
                this.setInput((IEditorInput)newInput);
            }
            return;
        }
        finally {
            provider.changed((Object)newInput);
            if (saveAsSuccess) {
                this.setInput((IEditorInput)newInput);
            }
        }
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        if (ISelectionProvider.class.equals((Object)required)) {
            return this.getSelectionProvider();
        }
        return super.getAdapter(required);
    }

    public void dispose() {
        this.proofStructureProvider.dispose();
        this.rootImage.dispose();
        TLAReconcilingStrategy reconciler = (TLAReconcilingStrategy)this.getViewer().getData(TLAReconcilingStrategy.class.toString());
        if (reconciler != null) {
            reconciler.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.moduleFileChangeListener);
        super.dispose();
    }

    public void selectAndReveal(pcal.Region aRegion) throws BadLocationException {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        PCalLocation begin = aRegion.getBegin();
        int startLineOffset = document.getLineOffset(begin.getLine());
        int startOffset = startLineOffset + begin.getColumn();
        PCalLocation end = aRegion.getEnd();
        int endLineOffset = document.getLineOffset(end.getLine());
        int endOffset = endLineOffset + end.getColumn();
        int length = endOffset - startOffset;
        this.selectAndReveal(startOffset, length);
    }

    public TLAtoPCalMapping getTpMapping() {
        Spec spec = ToolboxHandle.getCurrentSpec();
        return spec.getTpMapping(this.getModuleName() + ".tla");
    }

    public void gotoMarker(IMarker marker) {
        if (marker instanceof TLAtoPCalMarker) {
            TLAtoPCalMarker tlaToPCalMarker = (TLAtoPCalMarker)marker;
            try {
                pcal.Region region = tlaToPCalMarker.getRegion();
                if (region != null) {
                    this.selectAndReveal(region);
                    return;
                }
                UIHelper.setStatusLineMessage((String)"No valid TLA to PCal mapping found for current selection");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        super.gotoMarker(marker);
    }

    public String getModuleName() {
        IPath path;
        URI uri;
        IEditorInput iei = this.getEditorInput();
        if (iei instanceof FileEditorInput) {
            IFile moduleFile = ((FileEditorInput)iei).getFile();
            return ResourceHelper.getModuleName((IResource)moduleFile);
        }
        if (iei instanceof IURIEditorInput && (uri = ((IURIEditorInput)iei).getURI()) != null && (path = URIUtil.toPath((URI)uri)) != null) {
            IFile moduleFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            return ResourceHelper.getModuleName((IResource)moduleFile);
        }
        return "";
    }

    public TextViewer getViewer() {
        return (TextViewer)this.getSourceViewer();
    }

    public void setStatusMessage(String message) {
        this.getStatusLineManager().setMessage(message);
    }

    public void runFoldOperation(String commandId) {
        if (this.getSelectionProvider().getSelection() instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
            this.proofStructureProvider.runFoldOperation(commandId, selection);
        }
    }

    public TLAProofFoldingStructureProvider getProofStructureProvider() {
        return this.proofStructureProvider;
    }

    private void refresh() {
        if (this.getSourceViewer() != null) {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
                this.getSourceViewer().setEditable(!EditorUtil.isReadOnly((IResource)fileEditorInput.getFile()));
            } else {
                this.getSourceViewer().setEditable(false);
            }
        }
    }

    public ISourceViewer publicGetSourceViewer() {
        return this.getSourceViewer();
    }

    public boolean hasPlusCal() {
        IRegion find;
        FindReplaceDocumentAdapter search;
        block4: {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            search = new FindReplaceDocumentAdapter(doc);
            find = search.find(0, "--algorithm", true, true, false, false);
            if (find == null) break block4;
            return true;
        }
        try {
            find = search.find(0, "--fair", true, true, false, false);
            if (find != null) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public static final class OpenDeclarationHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) throws ExecutionException {
            IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            TLAEditor tlaEditor = (TLAEditor)((Object)activeEditor.getAdapter(TLAEditor.class));
            ITextSelection selection = (ITextSelection)tlaEditor.getSelectionProvider().getSelection();
            Region region = new Region(selection.getOffset(), selection.getLength());
            ISourceViewer internalSourceViewer = tlaEditor.getSourceViewer();
            IHyperlinkDetector[] hyperlinkDetectors = tlaEditor.getSourceViewerConfiguration().getHyperlinkDetectors(internalSourceViewer);
            if (hyperlinkDetectors != null) {
                int i = 0;
                while (i < hyperlinkDetectors.length) {
                    IHyperlink[] hyperlinks = hyperlinkDetectors[i].detectHyperlinks((ITextViewer)internalSourceViewer, (IRegion)region, false);
                    if (hyperlinks != null && hyperlinks.length > 0) {
                        IHyperlink hyperlink = hyperlinks[0];
                        hyperlink.open();
                        break;
                    }
                    ++i;
                }
            }
            return null;
        }
    }
}

