/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.proof;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.proof.TLAProofPosition;
import org.lamport.tla.toolbox.spec.parser.IParseResultListener;
import org.lamport.tla.toolbox.spec.parser.ParseResult;
import org.lamport.tla.toolbox.spec.parser.ParseResultBroadcaster;
import org.lamport.tla.toolbox.util.AdapterFactory;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.NonLeafProofNode;
import tla2sany.semantic.ProofNode;
import tla2sany.semantic.TheoremNode;
import tla2sany.st.Location;
import util.UniqueString;

public class TLAProofFoldingStructureProvider
implements IParseResultListener,
IDocumentListener {
    private TLAEditor editor;
    private IDocument document;
    private Vector<TLAProofPosition> foldPositions;
    private long documentLastModified;
    private boolean canPerformFoldingCommands = true;

    public TLAProofFoldingStructureProvider(TLAEditor editor) {
        this.editor = editor;
        this.document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.foldPositions = new Vector();
        this.document.addDocumentListener((IDocumentListener)this);
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
            IPath location = editorInput.getFile().getLocation();
            ParseResult parseResult = ParseResultBroadcaster.getParseResultBroadcaster().getParseResult(location);
            if (parseResult != null) {
                this.newParseResult(parseResult);
            }
        }
        ParseResultBroadcaster.getParseResultBroadcaster().addParseResultListener((IParseResultListener)this);
    }

    private void computeProofFoldPositions(TheoremNode theoremNode, Map<ProjectionAnnotation, TLAProofPosition> additions, List<TLAProofPosition> foldsInCurrentTree, List<TLAProofPosition> previousFolds) throws BadLocationException {
        if (theoremNode.getProof() == null) {
            return;
        }
        IRegion theoremStatementRegion = AdapterFactory.locationToRegion((IDocument)this.document, (Location)theoremNode.getTheorem().getLocation());
        IRegion theoremRegion = AdapterFactory.locationToRegion((IDocument)this.document, (Location)theoremNode.getLocation());
        ProofNode proofNode = theoremNode.getProof();
        IRegion proofNodeRegion = AdapterFactory.locationToRegion((IDocument)this.document, (Location)proofNode.getLocation());
        if (this.document.getLineOfOffset(theoremStatementRegion.getOffset() + theoremStatementRegion.getLength()) == this.document.getLineOfOffset(proofNodeRegion.getOffset() + proofNodeRegion.getLength())) {
            return;
        }
        TLAProofPosition matchingPosition = null;
        Iterator<TLAProofPosition> it = previousFolds.iterator();
        while (it.hasNext()) {
            TLAProofPosition proofPosition = it.next();
            if (!proofPosition.isSamePosition(proofNodeRegion, this.document)) continue;
            matchingPosition = proofPosition;
            foldsInCurrentTree.add(matchingPosition);
            it.remove();
            break;
        }
        if (matchingPosition == null) {
            matchingPosition = new TLAProofPosition(proofNodeRegion.getOffset(), proofNodeRegion.getLength(), theoremRegion.getOffset(), theoremStatementRegion.getOffset() + theoremStatementRegion.getLength() - theoremRegion.getOffset(), new ProjectionAnnotation(), this.document);
            additions.put(matchingPosition.getAnnotation(), matchingPosition);
            foldsInCurrentTree.add(matchingPosition);
        }
        if (proofNode instanceof NonLeafProofNode) {
            NonLeafProofNode nonLeafProofNode = (NonLeafProofNode)proofNode;
            LevelNode[] steps = nonLeafProofNode.getSteps();
            int i = 0;
            while (i < steps.length) {
                if (steps[i] instanceof TheoremNode) {
                    this.computeProofFoldPositions((TheoremNode)steps[i], additions, foldsInCurrentTree, previousFolds);
                }
                ++i;
            }
        }
    }

    public void newParseResult(ParseResult parseResult) {
        if (this.editor == null) {
            Activator.getDefault().logDebug("Null editor in proof structure provider.");
            return;
        }
        if (this.editor.getEditorInput() == null) {
            Activator.getDefault().logDebug("Null editor input in proof structure provider.");
            return;
        }
        if (!(this.editor.getEditorInput() instanceof IFileEditorInput)) {
            return;
        }
        if (!parseResult.getParsedResource().getLocation().removeLastSegments(1).equals((Object)((IFileEditorInput)this.editor.getEditorInput()).getFile().getLocation().removeLastSegments(1))) {
            return;
        }
        String moduleName = ResourceHelper.getModuleName((IResource)((IFileEditorInput)this.editor.getEditorInput()).getFile());
        if (this.editor.isDirty() || parseResult.getParserCalled() < this.documentLastModified || parseResult.getParserCalled() < ((FileEditorInput)this.editor.getEditorInput()).getFile().getLocalTimeStamp()) {
            return;
        }
        SpecObj specObj = parseResult.getSpecObj();
        if (specObj == null || parseResult.getParseErrors() != null && parseResult.getParseErrors().isFailure() || parseResult.getSemanticErrors() != null && parseResult.getSemanticErrors().isFailure()) {
            return;
        }
        Assert.isNotNull((Object)specObj.getExternalModuleTable());
        ModuleNode moduleNode = specObj.getExternalModuleTable().getModuleNode(UniqueString.uniqueStringOf((String)moduleName));
        if (moduleNode == null) {
            return;
        }
        this.canPerformFoldingCommands = false;
        HashMap<ProjectionAnnotation, TLAProofPosition> additions = new HashMap<ProjectionAnnotation, TLAProofPosition>();
        Vector<TLAProofPosition> foldsInCurrentTree = new Vector<TLAProofPosition>();
        TheoremNode[] theorems = moduleNode.getTheorems();
        int i = 0;
        while (i < theorems.length) {
            TheoremNode theoremNode = theorems[i];
            try {
                if (theoremNode.getLocation().source().equals(moduleName)) {
                    this.computeProofFoldPositions(theoremNode, additions, foldsInCurrentTree, this.foldPositions);
                }
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error converting theorem location to region in module " + moduleName, (Throwable)e);
            }
            ++i;
        }
        ProjectionAnnotation[] deletions = new ProjectionAnnotation[this.foldPositions.size()];
        int i2 = 0;
        for (TLAProofPosition proofPosition : this.foldPositions) {
            proofPosition.remove(this.document);
            deletions[i2] = proofPosition.getAnnotation();
        }
        this.foldPositions = foldsInCurrentTree;
        this.editor.modifyProjectionAnnotations((Annotation[])deletions, additions);
        int currentOffset = -1;
        boolean isSorted = true;
        for (TLAProofPosition proofPosition : this.foldPositions) {
            if (proofPosition.getOffset() >= currentOffset) {
                currentOffset = proofPosition.getOffset();
                continue;
            }
            isSorted = false;
            break;
        }
        if (!isSorted) {
            Collections.sort(this.foldPositions, new Comparator<TLAProofPosition>(){

                @Override
                public int compare(TLAProofPosition arg0, TLAProofPosition arg1) {
                    return arg0.getOffset() - arg1.getOffset();
                }
            });
        }
        this.canPerformFoldingCommands = true;
    }

    public void dispose() {
        ParseResultBroadcaster.getParseResultBroadcaster().removeParseResultListener((IParseResultListener)this);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.documentLastModified = System.currentTimeMillis();
    }

    public void documentChanged(DocumentEvent event) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containedByStep(int caretOffset) {
        try {
            int i = 0;
            while (true) {
                if (i >= this.foldPositions.size()) {
                    return false;
                }
                TLAProofPosition proofPosition = this.foldPositions.get(i);
                if (proofPosition.containsBeforeProof(caretOffset, this.document)) {
                    return true;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError("Error computing if selection is in proof step.", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containedByStepOrProof(int caretOffset) {
        try {
            int i = 0;
            while (true) {
                if (i >= this.foldPositions.size()) {
                    return false;
                }
                TLAProofPosition proofPosition = this.foldPositions.get(i);
                if (proofPosition.containsInProofOrStatement(caretOffset, this.document)) {
                    return true;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError("Error computing if selection is in proof step.", (Throwable)e);
        }
        return false;
    }

    public boolean canRunFoldOperation(String commandId, ITextSelection selection) {
        if (!this.canPerformFoldingCommands || selection == null) {
            return false;
        }
        int caretOffset = selection.getOffset() + selection.getLength();
        if (commandId.equals("org.lamport.tla.toolbox.editor.basic.FocusOnStep")) {
            return this.containedByStepOrProof(caretOffset);
        }
        if (commandId.equals("org.lamport.tla.toolbox.editor.basic.FoldAllProofs")) {
            return true;
        }
        if (commandId.equals("org.lamport.tla.toolbox.editor.basic.ExpandAllProofs")) {
            return true;
        }
        if (commandId.equals("org.lamport.tla.toolbox.editor.basic.ExpandSubtree")) {
            return this.containedByStep(caretOffset);
        }
        if (commandId.equals("org.lamport.tla.toolbox.editor.basic.CollapseSubtree")) {
            return this.containedByStep(caretOffset);
        }
        if (commandId.equals("org.lamport.tla.toolbox.editor.basic.ShowImmediate")) {
            return this.containedByStep(caretOffset);
        }
        return true;
    }

    public void runFoldOperation(String commandId, ITextSelection selection) {
        if (this.canPerformFoldingCommands && selection != null) {
            int caretOffset = selection.getOffset() + selection.getLength();
            if (commandId.equals("org.lamport.tla.toolbox.editor.basic.FocusOnStep")) {
                this.foldEverythingUnusable(caretOffset);
            } else if (commandId.equals("org.lamport.tla.toolbox.editor.basic.FoldAllProofs")) {
                this.foldAllProofs();
            } else if (commandId.equals("org.lamport.tla.toolbox.editor.basic.ExpandAllProofs")) {
                this.expandAllProofs();
            } else if (commandId.equals("org.lamport.tla.toolbox.editor.basic.ExpandSubtree")) {
                this.expandCurrentSubtree(caretOffset);
            } else if (commandId.equals("org.lamport.tla.toolbox.editor.basic.CollapseSubtree")) {
                this.hideCurrentSubtree(caretOffset);
            } else if (commandId.equals("org.lamport.tla.toolbox.editor.basic.ShowImmediate")) {
                this.showImmediateDescendants(caretOffset);
            }
        }
    }

    private void foldEverythingUnusable(int cursorOffset) {
        Vector<ProjectionAnnotation> modifiedAnnotations = new Vector<ProjectionAnnotation>();
        for (TLAProofPosition proofPosition : this.foldPositions) {
            try {
                if (proofPosition.containsInProofOrStatement(cursorOffset, this.document)) {
                    if (!proofPosition.getAnnotation().isCollapsed()) continue;
                    proofPosition.getAnnotation().markExpanded();
                    modifiedAnnotations.add(proofPosition.getAnnotation());
                    continue;
                }
                if (proofPosition.getAnnotation().isCollapsed()) continue;
                proofPosition.getAnnotation().markCollapsed();
                modifiedAnnotations.add(proofPosition.getAnnotation());
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error changing expansion state of proofs.", (Throwable)e);
            }
        }
        this.editor.modifyProjectionAnnotations((Annotation[])modifiedAnnotations.toArray(new ProjectionAnnotation[modifiedAnnotations.size()]));
    }

    private void foldAllProofs() {
        Vector<ProjectionAnnotation> modifiedAnnotations = new Vector<ProjectionAnnotation>();
        for (TLAProofPosition proofPosition : this.foldPositions) {
            if (proofPosition.getAnnotation().isCollapsed()) continue;
            proofPosition.getAnnotation().markCollapsed();
            modifiedAnnotations.add(proofPosition.getAnnotation());
        }
        this.editor.modifyProjectionAnnotations((Annotation[])modifiedAnnotations.toArray(new ProjectionAnnotation[modifiedAnnotations.size()]));
    }

    private void expandAllProofs() {
        Vector<ProjectionAnnotation> modifiedAnnotations = new Vector<ProjectionAnnotation>();
        for (TLAProofPosition proofPosition : this.foldPositions) {
            if (!proofPosition.getAnnotation().isCollapsed()) continue;
            proofPosition.getAnnotation().markExpanded();
            modifiedAnnotations.add(proofPosition.getAnnotation());
        }
        this.editor.modifyProjectionAnnotations((Annotation[])modifiedAnnotations.toArray(new ProjectionAnnotation[modifiedAnnotations.size()]));
    }

    private void expandCurrentSubtree(int offset) {
        ArrayList<ProjectionAnnotation> modifiedAnnotations = new ArrayList<ProjectionAnnotation>();
        TLAProofPosition found = null;
        for (TLAProofPosition proofPosition : this.foldPositions) {
            try {
                if (found == null && proofPosition.containsBeforeProof(offset, this.document)) {
                    found = proofPosition;
                    if (!found.getAnnotation().isCollapsed()) continue;
                    found.getAnnotation().markExpanded();
                    modifiedAnnotations.add(found.getAnnotation());
                    continue;
                }
                if (found == null || !found.contains(proofPosition) || !proofPosition.getAnnotation().isCollapsed()) continue;
                proofPosition.getAnnotation().markExpanded();
                modifiedAnnotations.add(proofPosition.getAnnotation());
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error changing expansion state of proofs.", (Throwable)e);
            }
        }
        this.editor.modifyProjectionAnnotations((Annotation[])modifiedAnnotations.toArray(new ProjectionAnnotation[modifiedAnnotations.size()]));
    }

    private void hideCurrentSubtree(int offset) {
        ArrayList<ProjectionAnnotation> modifiedAnnotations = new ArrayList<ProjectionAnnotation>();
        TLAProofPosition found = null;
        for (TLAProofPosition proofPosition : this.foldPositions) {
            try {
                if (found == null && proofPosition.containsBeforeProof(offset, this.document)) {
                    found = proofPosition;
                    if (found.getAnnotation().isCollapsed()) continue;
                    found.getAnnotation().markCollapsed();
                    modifiedAnnotations.add(found.getAnnotation());
                    continue;
                }
                if (found == null || !found.contains(proofPosition) || proofPosition.getAnnotation().isCollapsed()) continue;
                proofPosition.getAnnotation().markCollapsed();
                modifiedAnnotations.add(proofPosition.getAnnotation());
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error changing expansion state of proofs.", (Throwable)e);
            }
        }
        this.editor.modifyProjectionAnnotations((Annotation[])modifiedAnnotations.toArray(new ProjectionAnnotation[modifiedAnnotations.size()]));
    }

    private void showImmediateDescendants(int offset) {
        ArrayList<ProjectionAnnotation> modifiedAnnotations = new ArrayList<ProjectionAnnotation>();
        TLAProofPosition found = null;
        for (TLAProofPosition proofPosition : this.foldPositions) {
            try {
                if (found == null && proofPosition.containsBeforeProof(offset, this.document)) {
                    found = proofPosition;
                    if (!found.getAnnotation().isCollapsed()) continue;
                    found.getAnnotation().markExpanded();
                    modifiedAnnotations.add(found.getAnnotation());
                    continue;
                }
                if (found == null || !found.contains(proofPosition) || proofPosition.getAnnotation().isCollapsed()) continue;
                proofPosition.getAnnotation().markCollapsed();
                modifiedAnnotations.add(proofPosition.getAnnotation());
            }
            catch (BadLocationException e) {
                Activator.getDefault().logError("Error changing expansion state of proofs.", (Throwable)e);
            }
        }
        this.editor.modifyProjectionAnnotations((Annotation[])modifiedAnnotations.toArray(new ProjectionAnnotation[modifiedAnnotations.size()]));
    }
}

