/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.ResourceHelper;

public class GotoMatchingParenHandler
extends AbstractHandler
implements IHandler {
    public static String PAREN_ERROR_MARKER_TYPE = "org.lamport.tla.toolbox.editor.basic.showParenError";
    private IDocument document;
    private int currLoc;
    private int regionType;
    private int currLineNum;
    private int beginCurrRegion;
    private int endCurrRegion;
    private int currRegionNumber;
    private int beginLineLoc;
    private int endLineLoc;
    private int lineCommentLoc;
    private int[] leftQuoteLocs = new int[1000];
    private int[] rightQuoteLocs = new int[1000];
    private int numberOfStrings;
    private static String[] PARENS = new String[]{"(*", "<<", "(", "[", "{", "*)", ">>", ")", "]", "}"};
    private static int PCOUNT = 5;
    private static int COMMENT_BEGIN_IDX = 0;
    private static int LEFT_ROUND_PAREN_IDX = 2;
    private static int BEGIN_MULTILINE_COMMENT_IDX = 0;
    private static int MAIN_REGION = 0;
    private static int COMMENT_REGION = 1;
    private static int STRING_REGION = 2;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block8: {
            TLAEditor tlaEditor = EditorUtil.getTLAEditorWithFocus();
            this.document = tlaEditor.publicGetSourceViewer().getDocument();
            try {
                ITextSelection selection = (ITextSelection)tlaEditor.getSelectionProvider().getSelection();
                Region selectedRegion = new Region(selection.getOffset(), selection.getLength());
                int selectedParenIdx = this.getSelectedParen(selectedRegion);
                int lineNumber = selection.getStartLine();
                if (lineNumber < 0) {
                    throw new ParenErrorException("Toolbox bug: bad selected line computed", null, null);
                }
                this.setLineRegions(lineNumber);
                this.setRegionInfo();
                if (selectedParenIdx < PCOUNT) {
                    this.findMatchingRightParen(selectedParenIdx);
                } else {
                    this.findMatchingLeftParen(selectedParenIdx);
                }
                tlaEditor.selectAndReveal(this.currLoc, 0);
            }
            catch (ParenErrorException e) {
                IResource resource = ResourceHelper.getResourceByModuleName((String)tlaEditor.getModuleName());
                ErrorMessageEraser listener = new ErrorMessageEraser(tlaEditor, resource);
                tlaEditor.getViewer().getTextWidget().addCaretListener((CaretListener)listener);
                tlaEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(e.message);
                Region[] regions = e.regions;
                if (regions[0] == null) break block8;
                try {
                    Spec spec = ToolboxHandle.getCurrentSpec();
                    spec.setMarkersToShow(null);
                    IMarker[] markersToShow = new IMarker[2];
                    int i = 0;
                    while (i < 2) {
                        IMarker marker = resource.createMarker(PAREN_ERROR_MARKER_TYPE);
                        HashMap<String, Integer> markerAttributes = new HashMap<String, Integer>(2);
                        markerAttributes.put("charStart", new Integer(regions[i].getOffset()));
                        markerAttributes.put("charEnd", new Integer(regions[i].getOffset() + regions[i].getLength()));
                        marker.setAttributes(markerAttributes);
                        markersToShow[i] = marker;
                        ++i;
                    }
                    spec.setMarkersToShow(markersToShow);
                }
                catch (CoreException exc) {
                    System.out.println("GotoMatchingParenHandler.execute threw CoreException");
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        if (EditorUtil.getTLAEditorWithFocus() == null) {
            return false;
        }
        return super.isEnabled();
    }

    private void findMatchingRightParen(int parenIdx) throws ParenErrorException {
        int pidx;
        int savedCurrLoc = this.currLoc;
        while (true) {
            ++this.currLoc;
            pidx = -1;
            while (this.currLoc <= this.endCurrRegion && (pidx = this.getParenToLeftOf(this.currLoc)) == -1) {
                ++this.currLoc;
            }
            if (pidx == -1) {
                this.getNextRegion();
                this.currLoc = this.beginCurrRegion;
                continue;
            }
            if (pidx == LEFT_ROUND_PAREN_IDX && this.getParenToLeftOf(this.currLoc + 1) == BEGIN_MULTILINE_COMMENT_IDX) {
                ++this.currLoc;
                pidx = BEGIN_MULTILINE_COMMENT_IDX;
            }
            if (pidx >= PCOUNT) break;
            this.findMatchingRightParen(pidx);
        }
        if ((pidx - parenIdx) % PCOUNT == 0) {
            return;
        }
        throw new ParenErrorException(PARENS[parenIdx] + " matched by " + PARENS[pidx], new Region(this.currLoc - PARENS[pidx].length(), PARENS[pidx].length()), new Region(savedCurrLoc - PARENS[parenIdx].length(), PARENS[parenIdx].length()));
    }

    private void findMatchingLeftParen(int parenIdx) throws ParenErrorException {
        int pidx;
        int savedCurrLoc = this.currLoc;
        int lastParenSearched = parenIdx;
        boolean justWentToPrevRegion = false;
        while (true) {
            if (!justWentToPrevRegion) {
                this.currLoc -= PARENS[lastParenSearched].length();
            }
            pidx = -1;
            while (this.currLoc > this.beginCurrRegion && (pidx = this.getParenToLeftOf(this.currLoc)) == -1) {
                --this.currLoc;
            }
            if (pidx == -1) {
                this.getPrevRegion();
                this.currLoc = this.endCurrRegion;
                justWentToPrevRegion = true;
                continue;
            }
            if (pidx < PCOUNT) break;
            this.findMatchingLeftParen(pidx);
            lastParenSearched = pidx;
            justWentToPrevRegion = false;
        }
        if ((pidx - parenIdx) % PCOUNT == 0) {
            return;
        }
        throw new ParenErrorException(PARENS[pidx] + " matches " + PARENS[parenIdx], new Region(this.currLoc - PARENS[pidx].length(), PARENS[pidx].length()), new Region(savedCurrLoc - PARENS[parenIdx].length(), PARENS[parenIdx].length()));
    }

    private int getParenToLeftOf(int location) {
        int i = 0;
        while (i < PARENS.length) {
            try {
                if (this.document.get(location - PARENS[i].length(), PARENS[i].length()).equals(PARENS[i])) {
                    return i;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        return -1;
    }

    private void setLineRegions(int lineNumber) throws ParenErrorException {
        this.currLineNum = lineNumber;
        try {
            this.beginLineLoc = this.document.getLineOffset(lineNumber);
            this.lineCommentLoc = this.endLineLoc = this.beginLineLoc + this.document.getLineLength(lineNumber);
            this.numberOfStrings = 0;
            boolean inString = false;
            int loc = this.beginLineLoc;
            while (loc < this.endLineLoc) {
                block9: {
                    char ch;
                    block7: {
                        block8: {
                            ch = this.document.getChar(loc);
                            if (!inString) break block7;
                            if (ch != '\"') break block8;
                            inString = false;
                            this.rightQuoteLocs[this.numberOfStrings - 1] = loc;
                            break block9;
                        }
                        if (ch != '\\') break block9;
                        ++loc;
                        break block9;
                    }
                    if (ch == '\"') {
                        this.leftQuoteLocs[this.numberOfStrings] = loc;
                        ++this.numberOfStrings;
                        inString = true;
                    } else if (ch == '\\' && loc + 1 < this.endLineLoc && this.document.getChar(loc + 1) == '*') {
                        this.lineCommentLoc = loc;
                        break;
                    }
                }
                ++loc;
            }
            if (inString) {
                this.rightQuoteLocs[this.numberOfStrings - 1] = this.endLineLoc;
            }
        }
        catch (BadLocationException e) {
            throw new ParenErrorException("Unmatched paren", null, null);
        }
    }

    private void setRegionInfo() {
        this.currRegionNumber = 0;
        this.beginCurrRegion = this.beginLineLoc;
        this.endCurrRegion = this.endLineLoc;
        this.regionType = MAIN_REGION;
        boolean notDone = true;
        while (notDone && this.currRegionNumber < this.numberOfStrings) {
            if (this.currLoc <= this.leftQuoteLocs[this.currRegionNumber]) {
                notDone = false;
                this.endCurrRegion = this.leftQuoteLocs[this.currRegionNumber];
                continue;
            }
            if (this.currLoc <= this.rightQuoteLocs[this.currRegionNumber]) {
                notDone = false;
                this.regionType = STRING_REGION;
                this.beginCurrRegion = this.leftQuoteLocs[this.currRegionNumber] + 1;
                this.endCurrRegion = this.rightQuoteLocs[this.currRegionNumber];
                continue;
            }
            this.beginCurrRegion = this.rightQuoteLocs[this.currRegionNumber] + 1;
            ++this.currRegionNumber;
        }
        if (notDone || this.numberOfStrings == 0) {
            if (this.lineCommentLoc < this.currLoc) {
                this.regionType = COMMENT_REGION;
                this.beginCurrRegion = this.lineCommentLoc + 2;
            } else {
                this.endCurrRegion = this.lineCommentLoc;
            }
        }
    }

    private void getNextRegion() throws ParenErrorException {
        if (this.regionType == MAIN_REGION) {
            if (this.currRegionNumber < this.numberOfStrings) {
                this.beginCurrRegion = this.rightQuoteLocs[this.currRegionNumber] + 1;
                ++this.currRegionNumber;
                this.endCurrRegion = this.currRegionNumber == this.numberOfStrings ? this.lineCommentLoc : this.leftQuoteLocs[this.currRegionNumber];
            } else {
                this.setLineRegions(this.currLineNum + 1);
                this.currRegionNumber = 0;
                this.beginCurrRegion = this.beginLineLoc;
                this.endCurrRegion = this.numberOfStrings == 0 ? this.lineCommentLoc : this.leftQuoteLocs[0];
            }
        } else if (this.regionType == STRING_REGION) {
            if (this.currRegionNumber < this.numberOfStrings - 1) {
                ++this.currRegionNumber;
            } else {
                this.setLineRegions(this.currLineNum + 1);
                while (this.numberOfStrings == 0) {
                    this.setLineRegions(this.currLineNum + 1);
                }
                this.currRegionNumber = 0;
            }
            this.beginCurrRegion = this.leftQuoteLocs[this.currRegionNumber] + 1;
            this.endCurrRegion = this.rightQuoteLocs[this.currRegionNumber];
        } else {
            this.setLineRegions(this.currLineNum + 1);
            while (this.lineCommentLoc == this.endLineLoc) {
                this.setLineRegions(this.currLineNum + 1);
            }
            this.beginCurrRegion = this.lineCommentLoc + 2;
            this.endCurrRegion = this.endLineLoc;
        }
    }

    private void getPrevRegion() throws ParenErrorException {
        if (this.regionType == MAIN_REGION) {
            if (this.currRegionNumber > 0) {
                --this.currRegionNumber;
                this.endCurrRegion = this.leftQuoteLocs[this.currRegionNumber];
                this.beginCurrRegion = this.currRegionNumber == 0 ? this.beginLineLoc : this.rightQuoteLocs[this.currRegionNumber - 1] + 1;
            } else {
                this.setLineRegions(this.currLineNum - 1);
                this.currRegionNumber = this.numberOfStrings;
                this.endCurrRegion = this.lineCommentLoc;
                this.beginCurrRegion = this.numberOfStrings == 0 ? this.beginLineLoc : this.rightQuoteLocs[this.numberOfStrings - 1] + 1;
            }
        } else if (this.regionType == STRING_REGION) {
            if (this.currRegionNumber > 0) {
                --this.currRegionNumber;
            } else {
                this.setLineRegions(this.currLineNum - 1);
                while (this.numberOfStrings == 0) {
                    this.setLineRegions(this.currLineNum - 1);
                }
                this.currRegionNumber = this.numberOfStrings - 1;
            }
            this.beginCurrRegion = this.leftQuoteLocs[this.currRegionNumber] + 1;
            this.endCurrRegion = this.rightQuoteLocs[this.currRegionNumber];
        } else {
            this.setLineRegions(this.currLineNum - 1);
            while (this.lineCommentLoc == this.endLineLoc) {
                this.setLineRegions(this.currLineNum - 1);
            }
            this.beginCurrRegion = this.lineCommentLoc + 2;
            this.endCurrRegion = this.endLineLoc;
        }
    }

    private int getSelectedParen(Region selectedRegion) throws ParenErrorException {
        int selectedParenIdx;
        this.currLoc = selectedRegion.getOffset();
        if (selectedRegion.getLength() == 0) {
            selectedParenIdx = this.getParenToLeftOf(this.currLoc);
            if (selectedParenIdx == -1) {
                int tryNext = this.getParenToLeftOf(this.currLoc + 1);
                if (tryNext == -1 || PARENS[tryNext].length() == 1) {
                    throw new ParenErrorException("Paren not selected", null, null);
                }
                ++this.currLoc;
                return tryNext;
            }
        } else {
            String selection = null;
            try {
                selection = this.document.get(selectedRegion.getOffset(), selectedRegion.getLength());
            }
            catch (BadLocationException e) {
                System.out.println("BadLocationException in GotoMatchingParenHandler.getSelectedParen");
            }
            selectedParenIdx = 0;
            boolean notDone = true;
            while (notDone && selectedParenIdx < PARENS.length) {
                if (selection.equals(PARENS[selectedParenIdx])) {
                    notDone = false;
                    continue;
                }
                ++selectedParenIdx;
            }
            if (notDone) {
                throw new ParenErrorException("Selection is not a paren", null, null);
            }
            this.currLoc += selectedRegion.getLength();
        }
        if (selectedParenIdx == LEFT_ROUND_PAREN_IDX && this.getParenToLeftOf(this.currLoc + 1) == COMMENT_BEGIN_IDX) {
            ++this.currLoc;
            return BEGIN_MULTILINE_COMMENT_IDX;
        }
        return selectedParenIdx;
    }

    private static class ErrorMessageEraser
    implements CaretListener {
        TLAEditor editor;
        IResource resource;

        private ErrorMessageEraser(TLAEditor e, IResource res) {
            this.editor = e;
            this.resource = res;
        }

        public void caretMoved(CaretEvent event) {
            this.editor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
            this.editor.getViewer().getTextWidget().removeCaretListener((CaretListener)this);
            try {
                this.resource.deleteMarkers(PAREN_ERROR_MARKER_TYPE, false, 99);
            }
            catch (CoreException e) {
                System.out.println("caretMoved threw exception");
            }
        }
    }

    private static class ParenErrorException
    extends Exception {
        String message;
        Region[] regions = new Region[2];

        private ParenErrorException(String message, Region region1, Region region2) {
            this.message = message;
            this.regions[0] = region1;
            this.regions[1] = region2;
        }
    }
}

