/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.tla;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.actions.OpenDeclarationAction;
import org.lamport.tla.toolbox.editor.basic.actions.OpenDeclarationInCurrentAction;
import org.lamport.tla.toolbox.editor.basic.tla.TokenSpec;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import util.FilenameToStream;

public class TLAHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        block10: {
            String editorId;
            FileEditorInput editorInput;
            FileDocumentProvider documentProvider;
            SyntaxTreeNode csNode;
            SymbolNode resolvedSymbol;
            String label;
            block11: {
                TLAEditor tlaEditor;
                if (ToolboxHandle.getSpecObj() == null) {
                    return null;
                }
                TokenSpec currentTokenSpec = TokenSpec.findCurrentTokenSpec(region);
                if (currentTokenSpec == null) {
                    return null;
                }
                region = new Region(currentTokenSpec.leftPos, currentTokenSpec.rightPos - currentTokenSpec.leftPos);
                label = currentTokenSpec.token;
                resolvedSymbol = currentTokenSpec.resolvedSymbol;
                if (resolvedSymbol == null) {
                    resolvedSymbol = ResourceHelper.getModuleNode((String)label);
                }
                if (resolvedSymbol == null) break block10;
                csNode = (SyntaxTreeNode)resolvedSymbol.getTreeNode();
                if (resolvedSymbol instanceof ModuleNode) {
                    csNode = (SyntaxTreeNode)resolvedSymbol.stn.heirs()[0];
                }
                if ((tlaEditor = EditorUtil.getTLAEditorWithFocus()) != null && csNode.getLocation().source().equals(tlaEditor.getModuleName())) {
                    IDocument document = tlaEditor.getDocumentProvider().getDocument((Object)tlaEditor.getEditorInput());
                    int[] region2 = this.getRegion(this.getCS(resolvedSymbol, csNode), document);
                    return new IHyperlink[]{new OpenDeclarationInCurrentAction(tlaEditor, (IRegion)new Region(region2[0], region2[1] - region2[0]), label, region)};
                }
                documentProvider = null;
                editorInput = null;
                editorId = "";
                FilenameToStream resolver = ToolboxHandle.getSpecObj().getResolver();
                if (ToolboxHandle.isUserModule((String)ResourceHelper.getModuleFileName((String)csNode.getFilename()))) {
                    editorId = "org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer";
                    editorInput = new FileEditorInput((IFile)ResourceHelper.getResourceByModuleName((String)csNode.getFilename()));
                    documentProvider = new FileDocumentProvider();
                    break block11;
                }
                if (resolver.isStandardModule(csNode.getFilename())) {
                    editorId = "org.lamport.tla.toolbox.editor.basic.TLAEditorReadOnly";
                    File resolved = resolver.resolve(csNode.getFilename(), true);
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(resolved.getAbsolutePath()));
                    editorInput = new FileStoreEditorInput(fileStore);
                    documentProvider = new TextFileDocumentProvider();
                    break block11;
                }
                return null;
            }
            try {
                int[] region2 = this.getDocumentAndRegion(this.getCS(resolvedSymbol, csNode), (IDocumentProvider)documentProvider, (IEditorInput)editorInput);
                return new IHyperlink[]{new OpenDeclarationAction(editorId, (IEditorInput)editorInput, (IRegion)new Region(region2[0], region2[1] - region2[0]), label, region)};
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private int[] getDocumentAndRegion(SyntaxTreeNode csNode, IDocumentProvider documentProvider, IEditorInput editorInput) throws CoreException {
        IDocument document;
        try {
            documentProvider.connect((Object)editorInput);
            document = documentProvider.getDocument((Object)editorInput);
        }
        finally {
            documentProvider.disconnect((Object)editorInput);
        }
        return this.getRegion(csNode, document);
    }

    private int[] getRegion(SyntaxTreeNode csNode, IDocument document) {
        try {
            IRegion startLineRegion = document.getLineInformation(csNode.getLocation().beginLine() - 1);
            IRegion endLineRegion = document.getLineInformation(csNode.getLocation().endLine() - 1);
            int startOffset = startLineRegion.getOffset() + csNode.getLocation().beginColumn() - 1;
            int endOffset = endLineRegion.getOffset() + csNode.getLocation().endColumn();
            return new int[]{startOffset, endOffset};
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return new int[2];
        }
    }

    private SyntaxTreeNode getCS(SymbolNode resolvedSymbol, SyntaxTreeNode csNode) {
        if (resolvedSymbol instanceof OpDefNode && csNode.getHeirs().length >= 1) {
            if ((csNode = csNode.getHeirs()[0]).getKind() == 366) {
                csNode = csNode.getHeirs()[0];
            } else if (csNode.getKind() == 372 || csNode.getKind() == 396) {
                csNode = csNode.getHeirs()[1];
            }
        } else if (resolvedSymbol instanceof ThmOrAssumpDefNode && csNode.getHeirs().length >= 2 && (csNode.getKind() == 422 || csNode.getKind() == 332)) {
            csNode = csNode.getHeirs()[1];
        }
        return csNode;
    }
}

