/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.proof;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.lamport.tla.toolbox.Activator;

public class TLAProofPosition
extends Position
implements IProjectionPosition {
    private Position positionOfStatement;
    private Position positionOfProof;
    private ProjectionAnnotation annotation;

    public TLAProofPosition(int initProofOffset, int initProofLength, int initTheoremOffset, int initLengthToEndOfStatement, ProjectionAnnotation annotation, IDocument document) {
        IRegion region = this.alignRegion((IRegion)new Region(initTheoremOffset, initProofOffset + initProofLength - initTheoremOffset), document);
        this.offset = region.getOffset();
        this.length = region.getLength();
        this.positionOfStatement = new Position(initTheoremOffset, initLengthToEndOfStatement);
        this.positionOfProof = new Position(initProofOffset, initProofLength);
        this.annotation = annotation;
        try {
            document.addPosition(this.positionOfProof);
            document.addPosition(this.positionOfStatement);
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError("Error installing positions for proof fold at " + String.valueOf((Object)this), (Throwable)e);
        }
    }

    public int computeCaptionOffset(IDocument document) throws BadLocationException {
        return 0;
    }

    public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
        int lastLine;
        int firstLine = document.getLineOfOffset(this.positionOfStatement.getOffset() + this.positionOfStatement.getLength()) + 1;
        if (firstLine > (lastLine = document.getLineOfOffset(this.positionOfProof.getOffset() + this.positionOfProof.getLength()))) {
            return null;
        }
        int firstLineOffset = document.getLineOffset(firstLine);
        IRegion lastLineInfo = document.getLineInformation(lastLine);
        IRegion toFold = this.alignRegion((IRegion)new Region(firstLineOffset, lastLineInfo.getOffset() + lastLineInfo.getLength() - firstLineOffset), document);
        this.length = toFold.getOffset() + toFold.getLength() - this.offset;
        return new IRegion[]{toFold};
    }

    public ProjectionAnnotation getAnnotation() {
        return this.annotation;
    }

    public boolean isSamePosition(IRegion proofRegion, IDocument document) throws BadLocationException {
        return document.getLineOfOffset(this.positionOfProof.getOffset()) == document.getLineOfOffset(proofRegion.getOffset()) && document.getLineOfOffset(this.positionOfProof.getOffset() + this.positionOfProof.getLength()) == document.getLineOfOffset(proofRegion.getOffset() + proofRegion.getLength());
    }

    public void remove(IDocument document) {
        document.removePosition(this.positionOfProof);
        document.removePosition(this.positionOfStatement);
    }

    public boolean containsInProofOrStatement(int offset, IDocument document) throws BadLocationException {
        int startLine = document.getLineOfOffset(this.offset);
        int endLine = document.getLineOfOffset(this.offset + this.length) - 1;
        int lineOfOffset = document.getLineOfOffset(offset);
        return lineOfOffset >= startLine && lineOfOffset <= endLine;
    }

    public boolean containsInProof(int offset, IDocument document) throws BadLocationException {
        int startLine = document.getLineOfOffset(this.positionOfProof.getOffset());
        int endLine = document.getLineOfOffset(this.positionOfProof.getOffset() + this.positionOfProof.getLength());
        int lineOfOffset = document.getLineOfOffset(offset);
        return lineOfOffset >= startLine && lineOfOffset <= endLine;
    }

    public boolean containsBeforeProof(int offset, IDocument document) throws BadLocationException {
        int startLine = document.getLineOfOffset(this.positionOfStatement.getOffset());
        int endLine = document.getLineOfOffset(this.positionOfProof.getOffset());
        int lineOfOffset = document.getLineOfOffset(offset);
        return lineOfOffset >= startLine && lineOfOffset < endLine;
    }

    public boolean contains(TLAProofPosition proofPosition) {
        return this.offset <= proofPosition.getOffset() && this.offset + this.length >= proofPosition.getOffset() + proofPosition.getLength();
    }

    protected final IRegion alignRegion(IRegion region, IDocument document) {
        int end;
        int start;
        block4: {
            if (region == null) {
                return null;
            }
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start <= end) break block4;
                return null;
            }
            catch (BadLocationException x) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }
}

