/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.lamport.tla.toolbox.editor.basic.TLAEditor;
import org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.util.UIHelper;

public class OpenDeclarationAction
extends Action
implements IHyperlink {
    private final IEditorInput editorInput;
    private final IRegion location;
    private final String label;
    private final IRegion hyperlinkLocation;
    private final String editorId;

    public OpenDeclarationAction(String editorId, IEditorInput editorInput, IRegion targetLocation, String hyperlinkLabel, IRegion hyperlinkLocation) {
        this.editorId = editorId;
        this.editorInput = editorInput;
        this.location = targetLocation;
        this.label = hyperlinkLabel;
        this.hyperlinkLocation = hyperlinkLocation;
    }

    public void run() {
        EditorUtil.setReturnFromOpenDecl();
        IEditorPart editor = UIHelper.openEditor((String)this.editorId, (IEditorInput)this.editorInput);
        if (editor instanceof TLAEditorAndPDFViewer) {
            ((TLAEditorAndPDFViewer)editor).getTLAEditor().selectAndReveal(this.location.getOffset(), this.location.getLength());
        } else if (editor instanceof TLAEditor) {
            ((TLAEditor)editor).selectAndReveal(this.location.getOffset(), this.location.getLength());
        } else {
            TLAEditor adapter = (TLAEditor)((Object)editor.getAdapter(TLAEditor.class));
            if (adapter != null) {
                adapter.selectAndReveal(this.location.getOffset(), this.location.getLength());
            }
        }
    }

    public IRegion getHyperlinkRegion() {
        return this.hyperlinkLocation;
    }

    public String getHyperlinkText() {
        return this.label;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        this.run();
    }
}

