/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.doc.handler;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.lamport.tla.toolbox.doc.HelpActivator;
import org.lamport.tla.toolbox.ui.view.PDFBrowser;
import org.lamport.tla.toolbox.util.UIHelper;
import org.osgi.framework.Bundle;

public class HelpPDFHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final String pdf = event.getParameter("org.lamport.tla.toolbox.doc.pdf.file");
        final String name = event.getParameter("org.lamport.tla.toolbox.doc.pdf.name");
        final boolean useEmbeddedViewer = Platform.getPreferencesService().getBoolean("org.lamport.tla.toolbox.tool.tla2tex", "embeddedViewer", false, null);
        final boolean osOpensPDF = Platform.getPreferencesService().getBoolean("org.lamport.tla.toolbox.tool.tla2tex", "osHandlesPDF", false, null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    File pdfFile = HelpPDFHandler.this.getDocFile("/pdfs/" + pdf);
                    if (osOpensPDF) {
                        String[] openCommand = new String[]{"open", pdfFile.getAbsolutePath()};
                        Runtime.getRuntime().exec(openCommand);
                    } else if (useEmbeddedViewer) {
                        UIHelper.openEditorUnchecked((String)"de.vonloesch.pdf4eclipse.editors.PDFEditor", (File)pdfFile, (String)name, (boolean)false);
                    } else {
                        IViewPart view = UIHelper.openViewNoFocus((String)"org.lamport.tla.toolbox.PDFBrowser", (String)name);
                        ((PDFBrowser)view).setInput(name, pdfFile.toURI().toURL().toString());
                    }
                }
                catch (PartInitException e) {
                    HelpActivator.getDefault().logError(e.getMessage(), e);
                }
                catch (IOException e) {
                    HelpActivator.getDefault().logError(e.getMessage(), e);
                }
                catch (URISyntaxException e) {
                    HelpActivator.getDefault().logError(e.getMessage(), e);
                }
            }
        });
        return null;
    }

    private File getDocFile(String bundleRelativePath) throws IOException, URISyntaxException {
        Bundle bundle = Platform.getBundle((String)"org.lamport.tla.toolbox.doc");
        return new File(FileLocator.resolve((URL)bundle.getEntry(bundleRelativePath)).getFile());
    }
}

