/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.source;

import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITypedRegion;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.ITLCOutputListener;
import org.lamport.tla.toolbox.tool.tlc.output.source.ITLCOutputSource;

public class CachingTLCOutputSource
implements ITLCOutputSource {
    private Vector<ListenerProgressHolder> listenerHolders = new Vector();
    private boolean done = false;
    private final Vector<TypedRegionAndText> detectedRegions = new Vector();
    private final Model model;
    private final int priority;

    public CachingTLCOutputSource(Model model, int priority) {
        Assert.isNotNull((Object)model);
        this.model = model;
        this.priority = priority;
    }

    public synchronized void onOutput(ITypedRegion region, String regionText) {
        Assert.isTrue((!this.done ? 1 : 0) != 0, (String)"Output source is not accepting new output after it reported the finalization");
        this.detectedRegions.add(new TypedRegionAndText(region, regionText));
        int i = 0;
        while (i < this.listenerHolders.size()) {
            this.onOutput(this.listenerHolders.get(i), region, regionText);
            ++i;
        }
    }

    public synchronized void onDone() {
        this.done = true;
        int i = 0;
        while (i < this.listenerHolders.size()) {
            this.listenerHolders.get((int)i).listener.onDone();
            ++i;
        }
    }

    private synchronized void onOutput(ListenerProgressHolder holder, ITypedRegion region, String regionText) {
        holder.listener.onOutput(region, regionText);
    }

    @Override
    public void addTLCOutputListener(ITLCOutputListener listener) {
        ListenerProgressHolder holder = new ListenerProgressHolder(listener);
        if (this.listenerHolders.contains(holder)) {
            this.removeTLCOutputListener(listener);
        }
        this.listenerHolders.add(holder);
        int i = 0;
        while (i < this.detectedRegions.size()) {
            this.onOutput(holder, this.detectedRegions.get(i).getRegion(), this.detectedRegions.get(i).getText());
            ++i;
        }
        if (this.done) {
            holder.listener.onDone();
        }
    }

    @Override
    public void removeTLCOutputListener(ITLCOutputListener listener) {
        this.listenerHolders.remove(new ListenerProgressHolder(listener));
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public ITLCOutputListener[] getListeners() {
        ITLCOutputListener[] listeners = new ITLCOutputListener[this.listenerHolders.size()];
        int i = 0;
        while (i < listeners.length) {
            listeners[i] = this.listenerHolders.get((int)i).listener;
            ++i;
        }
        return listeners;
    }

    @Override
    public int getSourcePrio() {
        return this.priority;
    }

    class ListenerProgressHolder {
        ITLCOutputListener listener;

        public ListenerProgressHolder(ITLCOutputListener listener) {
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListenerProgressHolder) {
                return this.listener.equals(((ListenerProgressHolder)obj).listener);
            }
            if (obj instanceof ITLCOutputListener) {
                return this.listener.equals(obj);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public String toString() {
            return this.listener.toString();
        }
    }

    private class TypedRegionAndText {
        private ITypedRegion region;
        private String text;

        private TypedRegionAndText(ITypedRegion region, String text) {
            this.region = region;
            this.text = text;
        }

        public ITypedRegion getRegion() {
            return this.region;
        }

        public String getText() {
            return this.text;
        }
    }
}

