/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariableValue;

public class TLCVariable {
    private static final Comparator<TLCVariable> comparator = new Comparator<TLCVariable>(){

        @Override
        public int compare(TLCVariable v1, TLCVariable v2) {
            if (v1.isTraceExplorerVar() && v2.isTraceExplorerVar()) {
                return v1.getName().compareTo(v2.getName());
            }
            if (v1.isTraceExplorerVar()) {
                return -1;
            }
            if (v2.isTraceExplorerVar()) {
                return 1;
            }
            return v1.getName().compareTo(v2.getName());
        }
    };
    private static final Pattern pattern = Pattern.compile("^(\\/\\\\ )?(?<lhs>\\w+) = (?<rhs>.[^\\/\\\\]*)", 40);
    private String name;
    private TLCVariableValue value;
    private boolean isTraceExplorerVar;

    public static List<TLCVariable> parseVariables(String variablesText) {
        ArrayList<TLCVariable> vars = new ArrayList<TLCVariable>();
        Matcher matcher = pattern.matcher(variablesText);
        while (matcher.find()) {
            String lhs = matcher.group("lhs");
            String rhs = matcher.group("rhs").trim();
            vars.add(new TLCVariable(lhs, TLCVariableValue.parseValue(rhs)));
        }
        Collections.sort(vars, comparator);
        return vars;
    }

    private TLCVariable(String name, TLCVariableValue value) {
        this.name = name;
        this.value = value;
        this.isTraceExplorerVar = false;
    }

    public String getName() {
        return this.name;
    }

    public TLCVariableValue getValue() {
        return this.value;
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(TLCVariableValue value) {
        this.value = value;
    }

    public boolean isTraceExplorerVar() {
        return this.isTraceExplorerVar;
    }

    public String getSingleLineName() {
        return this.name.replaceAll("\n", "").replaceAll("\r", "");
    }

    public void setTraceExplorerVar(boolean isTraceExplorerVar) {
        this.isTraceExplorerVar = isTraceExplorerVar;
    }

    public int getChildCount() {
        return this.value.getChildCount();
    }

    public final boolean isChanged() {
        return this.value.isAdded() || this.value.isDeleted() || this.value.isChanged();
    }

    public boolean representsTheSameAs(TLCVariable other) {
        return this.isTraceExplorerVar == other.isTraceExplorerVar && Objects.equals(this.name, other.name);
    }
}

