/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.SemanticNode;
import tlc2.overrides.Evaluation;
import tlc2.overrides.Functions;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.tool.TLCState;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IBoolValue;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueVec;

public final class SequencesExt {
    private SequencesExt() {
    }

    @TLAPlusOperator(identifier="SetToSeq", module="SequencesExt", warn=false)
    public static Value SetToSeq(Value value) {
        SetEnumValue setEnumValue = (SetEnumValue)value.toSetEnum().normalize();
        return new TupleValue(setEnumValue.elems.toArray());
    }

    @TLAPlusOperator(identifier="SetToSeqs", module="SequencesExt", warn=false)
    public static Value SetToSeqs(Value value) {
        SetEnumValue setEnumValue = (SetEnumValue)value.toSetEnum();
        if (setEnumValue == null) {
            throw new EvalException(2176, new String[]{"SetToSeqs", "a finite set", Values.ppr((String)value.toString())});
        }
        setEnumValue.normalize();
        ValueVec valueVec = setEnumValue.elems;
        int n = valueVec.size();
        if (n == 0) {
            Value[] valueArray = new Value[]{FcnRcdValue.EmptyFcn};
            return new SetEnumValue(valueArray, true);
        }
        int n2 = 1;
        Value[] valueArray = new Value[n];
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            valueArray[i] = valueVec.elementAt(i);
            nArray[i] = i;
            blArray[i] = true;
            n2 *= i + 1;
        }
        ValueVec valueVec2 = new ValueVec(n2);
        block1: while (true) {
            int n3;
            int n4;
            int n5;
            Value[] valueArray2 = new Value[n];
            for (n5 = 0; n5 < n; ++n5) {
                valueArray2[n5] = valueArray[nArray[n5]];
            }
            valueVec2.addElement((Value)new TupleValue(valueArray2));
            for (n5 = n - 1; n5 >= 0; --n5) {
                n4 = 0;
                for (n3 = nArray[n5] + 1; n3 < n; ++n3) {
                    if (blArray[n3]) continue;
                    blArray[n3] = true;
                    blArray[nArray[n5]] = false;
                    nArray[n5] = n3;
                    n4 = 1;
                    break;
                }
                if (n4 != 0) break;
                if (n5 == 0) break block1;
                blArray[nArray[n5]] = false;
            }
            n4 = n5 + 1;
            while (true) {
                if (n4 >= n) continue block1;
                for (n3 = 0; n3 < n; ++n3) {
                    if (blArray[n3]) continue;
                    blArray[n3] = true;
                    nArray[n4] = n3;
                    break;
                }
                ++n4;
            }
            break;
        }
        return new SetEnumValue(valueVec2, false);
    }

    @TLAPlusOperator(identifier="Contains", module="SequencesExt", warn=false)
    public static Value Contains(Value value, Value value2) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2283, new String[]{"Contains", "sequence", Values.ppr((String)value.toString())});
        }
        for (int i = 0; i < tupleValue.elems.length; ++i) {
            if (!tupleValue.elems[i].equals(value2)) continue;
            return BoolValue.ValTrue;
        }
        return BoolValue.ValFalse;
    }

    public String longestCommonPrefix(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            while (stringArray[i].indexOf(string) != 0) {
                if (!(string = string.substring(0, string.length() - 1)).isEmpty()) continue;
                return "";
            }
        }
        return string;
    }

    @TLAPlusOperator(identifier="LongestCommonPrefix", module="SequencesExt", warn=false)
    public static Value longestCommonPrefix(Value value) {
        SetEnumValue setEnumValue = (SetEnumValue)value.toSetEnum();
        if (setEnumValue == null) {
            throw new EvalException(2283, new String[]{"LongestCommonPrefix", "non-empty set", Values.ppr((String)value.toString())});
        }
        setEnumValue.normalize();
        ValueVec valueVec = setEnumValue.elems;
        if (setEnumValue.elems.isEmpty()) {
            throw new EvalException(2283, new String[]{"LongestCommonPrefix", "non-empty set", Values.ppr((String)value.toString())});
        }
        try {
            Value value2 = valueVec.elementAt(0);
            if (value2 instanceof StringValue) {
                return SequencesExt.longestCommonPrefix((StringValue)value2, valueVec);
            }
            Value[] valueArray = ((TupleValue)value2.toTuple()).elems;
            int n = valueArray.length;
            for (int i = 1; i < valueVec.size(); ++i) {
                Value[] valueArray2 = ((TupleValue)valueVec.elementAt((int)i).toTuple()).elems;
                for (int j = 0; j < n; ++j) {
                    if (valueArray[j].equals(valueArray2[j]) || (n = j) != 0) continue;
                    return TupleValue.EmptyTuple;
                }
            }
            if (n == 0) {
                return TupleValue.EmptyTuple;
            }
            Value[] valueArray3 = new Value[n];
            System.arraycopy(valueArray, 0, valueArray3, 0, n);
            return new TupleValue(valueArray3);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            throw new EvalException(2283, new String[]{"LongestCommonPrefix", "sequence", Values.ppr((String)value.toString())});
        }
    }

    private static Value longestCommonPrefix(StringValue stringValue, ValueVec valueVec) {
        String string = stringValue.val.toString();
        int n = string.length();
        for (int i = 1; i < valueVec.size(); ++i) {
            String string2 = ((StringValue)valueVec.elementAt((int)i)).val.toString();
            for (int j = 0; j < n; ++j) {
                if (string.charAt(j) == string2.charAt(j) || (n = j) != 0) continue;
                return new StringValue("");
            }
        }
        if (n == 0) {
            return new StringValue("");
        }
        return new StringValue(string.substring(0, n));
    }

    @TLAPlusOperator(identifier="FoldSeq", module="SequencesExt", warn=false)
    public static Value foldSeq(OpValue opValue, Value value, Value value2) {
        return Functions.foldFunction(opValue, value, value2);
    }

    @TLAPlusOperator(identifier="FoldLeft", module="SequencesExt", warn=false)
    public static Value foldLeft(OpValue opValue, Value value, Value value2) {
        TupleValue tupleValue = (TupleValue)value2.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"third", "FoldLeft", "sequence", Values.ppr((String)value2.toString())});
        }
        Value[] valueArray = new Value[2];
        valueArray[0] = value;
        Value[] valueArray2 = tupleValue.elems;
        for (int i = 0; i < valueArray2.length; ++i) {
            valueArray[1] = valueArray2[i];
            valueArray[0] = opValue.eval(valueArray, 0);
        }
        return valueArray[0];
    }

    @TLAPlusOperator(identifier="FoldRight", module="SequencesExt", warn=false)
    public static Value foldRight(OpValue opValue, Value value, Value value2) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"second", "FoldRight", "sequence", Values.ppr((String)value.toString())});
        }
        Value[] valueArray = new Value[2];
        valueArray[1] = value2;
        Value[] valueArray2 = tupleValue.elems;
        for (int i = valueArray2.length - 1; i >= 0; --i) {
            valueArray[0] = valueArray2[i];
            valueArray[1] = opValue.eval(valueArray, 0);
        }
        return valueArray[1];
    }

    @TLAPlusOperator(identifier="FoldLeftDomain", module="SequencesExt", warn=false)
    public static Value foldLeftDomain(OpValue opValue, Value value, Value value2) {
        TupleValue tupleValue = (TupleValue)value2.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"third", "FoldLeftDomain", "sequence", Values.ppr((String)value2.toString())});
        }
        Value[] valueArray = new Value[2];
        valueArray[0] = value;
        for (int i = 0; i < tupleValue.size(); ++i) {
            valueArray[1] = IntValue.gen((int)(i + 1));
            valueArray[0] = opValue.eval(valueArray, 0);
        }
        return valueArray[0];
    }

    @TLAPlusOperator(identifier="FoldRightDomain", module="SequencesExt", warn=false)
    public static Value foldRightDomain(OpValue opValue, Value value, Value value2) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"second", "FoldRightDomain", "sequence", Values.ppr((String)value.toString())});
        }
        Value[] valueArray = new Value[2];
        valueArray[1] = value2;
        for (int i = tupleValue.size() - 1; i >= 0; --i) {
            valueArray[0] = IntValue.gen((int)(i + 1));
            valueArray[1] = opValue.eval(valueArray, 0);
        }
        return valueArray[1];
    }

    @Evaluation(definition="ReplaceFirstSubSeq", module="SequencesExt", warn=false, silent=true)
    public static Value replaceFirstSubSeq(Tool tool, ExprOrOpArgNode[] exprOrOpArgNodeArray, Context context, TLCState tLCState, TLCState tLCState2, int n, CostModel costModel) {
        Value value = tool.eval((SemanticNode)exprOrOpArgNodeArray[0], context, tLCState, tLCState2, n, costModel);
        Value value2 = tool.eval((SemanticNode)exprOrOpArgNodeArray[1], context, tLCState, tLCState2, n, costModel);
        Value value3 = tool.eval((SemanticNode)exprOrOpArgNodeArray[2], context, tLCState, tLCState2, n, costModel);
        if (value instanceof StringValue && value2 instanceof StringValue && value3 instanceof StringValue) {
            String string = ((StringValue)value3).getVal().toString();
            String string2 = ((StringValue)value2).getVal().toString();
            String string3 = ((StringValue)value).getVal().toString();
            if (string2.equals("")) {
                return new StringValue(string3 + string);
            }
            try {
                return new StringValue(StringUtils.replaceOnce(string, string2, string3));
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return null;
            }
        }
        return null;
    }

    @Evaluation(definition="ReplaceAllSubSeqs", module="SequencesExt", warn=false, silent=true)
    public static Value replaceAllSubSeq(Tool tool, ExprOrOpArgNode[] exprOrOpArgNodeArray, Context context, TLCState tLCState, TLCState tLCState2, int n, CostModel costModel) {
        Value value = tool.eval((SemanticNode)exprOrOpArgNodeArray[0], context, tLCState, tLCState2, n, costModel);
        Value value2 = tool.eval((SemanticNode)exprOrOpArgNodeArray[1], context, tLCState, tLCState2, n, costModel);
        Value value3 = tool.eval((SemanticNode)exprOrOpArgNodeArray[2], context, tLCState, tLCState2, n, costModel);
        if (value instanceof StringValue && value2 instanceof StringValue && value3 instanceof StringValue) {
            String string = ((StringValue)value3).getVal().toString();
            String string2 = ((StringValue)value2).getVal().toString();
            String string3 = ((StringValue)value).getVal().toString();
            if (string2.equals("")) {
                StringBuilder stringBuilder = new StringBuilder(string3);
                for (int i = 0; i < string.length(); ++i) {
                    if (i != 0) {
                        stringBuilder.append(string3);
                    }
                    stringBuilder.append(string.charAt(i));
                }
                return new StringValue(stringBuilder.toString());
            }
            return new StringValue(StringUtils.replace(string, string2, string3));
        }
        return null;
    }

    @TLAPlusOperator(identifier="IsPrefix", module="SequencesExt", warn=false)
    public static Value isPrefix(Value value, Value value2) {
        if (value instanceof StringValue && value2 instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            StringValue stringValue2 = (StringValue)value2;
            if (stringValue2.getVal().toString().startsWith(stringValue.getVal().toString())) {
                return BoolValue.ValTrue;
            }
            return BoolValue.ValFalse;
        }
        TupleValue tupleValue = (TupleValue)value.toTuple();
        TupleValue tupleValue2 = (TupleValue)value2.toTuple();
        if (tupleValue.size() <= tupleValue2.size()) {
            for (int i = 0; i < tupleValue.size(); ++i) {
                Value value3 = tupleValue.elems[i];
                Value value4 = tupleValue2.elems[i];
                if (value3.equals(value4)) continue;
                return BoolValue.ValFalse;
            }
            return BoolValue.ValTrue;
        }
        return BoolValue.ValFalse;
    }

    @TLAPlusOperator(identifier="SelectInSeq", module="SequencesExt", warn=false)
    public static Value selectInSeq(Value value, OpValue opValue) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"first", "SelectInSeq", "sequence", Values.ppr((String)value.toString())});
        }
        int n = tupleValue.size();
        Value[] valueArray = new Value[1];
        for (int i = 0; i < n; ++i) {
            valueArray[0] = tupleValue.elems[i];
            Value value2 = opValue.eval(valueArray, 0);
            if (!(value2 instanceof IBoolValue)) {
                throw new EvalException(2169, new String[]{"third", "SelectInSeq", "boolean-valued operator", Values.ppr((String)opValue.toString())});
            }
            if (!((BoolValue)value2).val) continue;
            return IntValue.gen((int)(i + 1));
        }
        return IntValue.ValZero;
    }

    @TLAPlusOperator(identifier="SelectInSubSeq", module="SequencesExt", warn=false)
    public static Value SelectInSubSeq(Value value, Value value2, Value value3, OpValue opValue) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"first", "SelectInSubSeq", "sequence", Values.ppr((String)value.toString())});
        }
        if (!(value2 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"second", "SelectInSubSeq", "natural", Values.ppr((String)value2.toString())});
        }
        if (!(value3 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"third", "SelectInSubSeq", "natural", Values.ppr((String)value3.toString())});
        }
        int n = ((IntValue)value2).val;
        int n2 = ((IntValue)value3).val;
        if (n > n2) {
            return IntValue.ValZero;
        }
        if (n < 1 || n > tupleValue.size()) {
            throw new EvalException(2183, new String[]{"second", "SelectInSubSeq", "first", Values.ppr((String)value.toString()), Values.ppr((String)value2.toString())});
        }
        if (n2 < 1 || n2 > tupleValue.size()) {
            throw new EvalException(2183, new String[]{"third", "SelectInSubSeq", "first", Values.ppr((String)value.toString()), Values.ppr((String)value3.toString())});
        }
        Value[] valueArray = new Value[1];
        while (n <= n2) {
            valueArray[0] = tupleValue.elems[n - 1];
            Value value4 = opValue.eval(valueArray, 0);
            if (!(value4 instanceof IBoolValue)) {
                throw new EvalException(2169, new String[]{"fourth", "SelectInSubSeq", "boolean-valued operator", Values.ppr((String)opValue.toString())});
            }
            if (((BoolValue)value4).val) {
                return IntValue.gen((int)n);
            }
            ++n;
        }
        return IntValue.ValZero;
    }

    @TLAPlusOperator(identifier="SelectLastInSeq", module="SequencesExt", warn=false)
    public static Value selectLastInSeq(Value value, OpValue opValue) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"first", "SelectLastInSeq", "sequence", Values.ppr((String)value.toString())});
        }
        Value[] valueArray = new Value[1];
        for (int i = tupleValue.size() - 1; i >= 0; --i) {
            valueArray[0] = tupleValue.elems[i];
            Value value2 = opValue.eval(valueArray, 0);
            if (!(value2 instanceof IBoolValue)) {
                throw new EvalException(2169, new String[]{"third", "SelectLastInSeq", "boolean-valued function", Values.ppr((String)opValue.toString())});
            }
            if (!((BoolValue)value2).val) continue;
            return IntValue.gen((int)(i + 1));
        }
        return IntValue.ValZero;
    }

    @TLAPlusOperator(identifier="SelectLastInSubSeq", module="SequencesExt", warn=false)
    public static Value SelectLastInSubSeq(Value value, Value value2, Value value3, OpValue opValue) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"first", "SelectLastInSubSeq", "sequence", Values.ppr((String)value.toString())});
        }
        if (!(value2 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"second", "SelectLastInSubSeq", "natural", Values.ppr((String)value2.toString())});
        }
        if (!(value3 instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"third", "SelectLastInSubSeq", "natural", Values.ppr((String)value3.toString())});
        }
        int n = ((IntValue)value2).val;
        int n2 = ((IntValue)value3).val;
        if (n > n2) {
            return IntValue.ValZero;
        }
        if (n < 1 || n > tupleValue.size()) {
            throw new EvalException(2183, new String[]{"second", "SelectLastInSubSeq", "first", Values.ppr((String)value.toString()), Values.ppr((String)value2.toString())});
        }
        if (n2 < 1 || n2 > tupleValue.size()) {
            throw new EvalException(2183, new String[]{"third", "SelectLastInSubSeq", "first", Values.ppr((String)value.toString()), Values.ppr((String)value3.toString())});
        }
        Value[] valueArray = new Value[1];
        while (n2 >= n) {
            valueArray[0] = tupleValue.elems[n2 - 1];
            Value value4 = opValue.eval(valueArray, 0);
            if (!(value4 instanceof IBoolValue)) {
                throw new EvalException(2169, new String[]{"fourth", "SelectLastInSubSeq", "boolean-valued function", Values.ppr((String)opValue.toString())});
            }
            if (((BoolValue)value4).val) {
                return IntValue.gen((int)n2);
            }
            --n2;
        }
        return IntValue.ValZero;
    }

    @TLAPlusOperator(identifier="RemoveFirst", module="SequencesExt", warn=false)
    public static Value removeFirst(Value value, Value value2) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"first", "RemoveFirst", "sequence", Values.ppr((String)value.toString())});
        }
        ArrayList<Value> arrayList = new ArrayList<Value>(tupleValue.elems.length);
        boolean bl = false;
        for (int i = 0; i < tupleValue.elems.length; ++i) {
            if (!bl && tupleValue.elems[i].equals(value2)) {
                bl = true;
                continue;
            }
            arrayList.add(tupleValue.elems[i]);
        }
        return new TupleValue((Value[])arrayList.toArray(Value[]::new));
    }

    @TLAPlusOperator(identifier="RemoveFirstMatch", module="SequencesExt", warn=false)
    public static Value removeFirstMatch(Value value, OpValue opValue) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"first", "RemoveFirstMatch", "sequence", Values.ppr((String)value.toString())});
        }
        Value[] valueArray = new Value[1];
        ArrayList<Value> arrayList = new ArrayList<Value>(tupleValue.elems.length);
        boolean bl = false;
        for (int i = 0; i < tupleValue.elems.length; ++i) {
            if (!bl) {
                valueArray[0] = tupleValue.elems[i];
                Value value2 = opValue.eval(valueArray, 0);
                if (!(value2 instanceof IBoolValue)) {
                    throw new EvalException(2169, new String[]{"second", "RemoveFirstMatch", "boolean-valued function", Values.ppr((String)opValue.toString())});
                }
                if (((BoolValue)value2).val) {
                    bl = true;
                    continue;
                }
            }
            arrayList.add(tupleValue.elems[i]);
        }
        return new TupleValue((Value[])arrayList.toArray(Value[]::new));
    }

    @TLAPlusOperator(identifier="Suffixes", module="SequencesExt", warn=false)
    public static Value Suffixes(Value value) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2283, new String[]{"Suffixes", "sequence", Values.ppr((String)value.toString())});
        }
        Value[] valueArray = new Value[tupleValue.elems.length + 1];
        valueArray[0] = TupleValue.EmptyTuple;
        for (int i = tupleValue.elems.length - 1; i >= 0; --i) {
            Value[] valueArray2 = new Value[tupleValue.elems.length - i];
            System.arraycopy(tupleValue.elems, i, valueArray2, 0, tupleValue.elems.length - i);
            valueArray[tupleValue.elems.length - i] = new TupleValue(valueArray2);
        }
        return new SetEnumValue(valueArray, true);
    }

    @TLAPlusOperator(identifier="AllSubSeqs", module="SequencesExt", warn=false)
    public static Value AllSubSeqs(Value value) {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2283, new String[]{"AllSubSeqs", "sequence", Values.ppr((String)value.toString())});
        }
        int n = tupleValue.elems.length;
        Value[] valueArray = new Value[(int)Math.pow(2.0, n)];
        for (int i = 0; i < 1 << n; ++i) {
            int n2 = 0;
            Value[] valueArray2 = new Value[Long.bitCount(i)];
            for (int j = 0; j < n; ++j) {
                if ((i & 1 << j) == 0) continue;
                valueArray2[n2++] = tupleValue.elems[j];
            }
            valueArray[i] = new TupleValue(valueArray2);
        }
        return new SetEnumValue(valueArray, false);
    }
}

