/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.value.IValue;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class Json {
    @TLAPlusOperator(identifier="ToJson", module="Json", warn=false)
    public static StringValue toJson(IValue iValue) throws IOException {
        return new StringValue(Json.getNode(iValue).toString());
    }

    @TLAPlusOperator(identifier="ToJsonArray", module="Json", warn=false)
    public static StringValue toJsonArray(IValue iValue) throws IOException {
        return new StringValue(Json.getArrayNode(iValue).toString());
    }

    @TLAPlusOperator(identifier="ToJsonObject", module="Json", warn=false)
    public static StringValue toJsonObject(IValue iValue) throws IOException {
        return new StringValue(Json.getObjectNode(iValue).toString());
    }

    @TLAPlusOperator(identifier="ndJsonDeserialize", module="Json", warn=false)
    public static IValue ndDeserialize(StringValue stringValue) throws IOException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(stringValue.val.toString())));){
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!"".equals(string = string.trim())) {
                    JsonElement jsonElement = JsonParser.parseString(string);
                    arrayList.add(Json.getValue(jsonElement));
                }
                string = bufferedReader.readLine();
            }
        }
        return new TupleValue(arrayList.toArray(new Value[arrayList.size()]));
    }

    @TLAPlusOperator(identifier="JsonDeserialize", module="Json", warn=false)
    public static IValue deserialize(StringValue stringValue) throws IOException {
        JsonElement jsonElement = JsonParser.parseReader(new FileReader(new File(stringValue.val.toString())));
        return Json.getValue(jsonElement);
    }

    @TLAPlusOperator(identifier="ndJsonSerialize", module="Json", warn=false)
    public static synchronized BoolValue ndSerialize(StringValue stringValue, Value value) throws IOException {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2169, new String[]{"second", "ndJsonSerialize", "sequence", Values.ppr((String)value.toString())});
        }
        File file = new File(stringValue.val.toString());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(stringValue.val.toString())));){
            for (int i = 0; i < tupleValue.elems.length; ++i) {
                bufferedWriter.write(Json.getNode((IValue)tupleValue.elems[i]).toString() + "\n");
            }
        }
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="JsonSerialize", module="Json", warn=false)
    public static synchronized BoolValue serialize(StringValue stringValue, Value value) throws IOException {
        Value value2 = value.toTuple();
        if (value2 == null) {
            value2 = value.toRcd();
        }
        if (value2 == null) {
            throw new EvalException(2169, new String[]{"second", "JsonSerialize", "sequence or record", Values.ppr((String)value.toString())});
        }
        File file = new File(stringValue.val.toString());
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(stringValue.val.toString())));){
            bufferedWriter.write(Json.getNode((IValue)value).toString());
        }
        return BoolValue.ValTrue;
    }

    private static JsonElement getNode(IValue iValue) throws IOException {
        if (iValue instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)iValue);
        }
        if (iValue instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)iValue);
        }
        if (iValue instanceof StringValue) {
            return new JsonPrimitive(((StringValue)iValue).val.toString());
        }
        if (iValue instanceof ModelValue) {
            return new JsonPrimitive(((ModelValue)iValue).val.toString());
        }
        if (iValue instanceof IntValue) {
            return new JsonPrimitive(((IntValue)iValue).val);
        }
        if (iValue instanceof BoolValue) {
            return new JsonPrimitive(((BoolValue)iValue).val);
        }
        if (iValue instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)iValue);
        }
        if (iValue instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)iValue).toFcnRcd());
        }
        if (iValue instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)iValue);
        }
        if (iValue instanceof EnumerableValue) {
            return Json.getArrayNode((SetEnumValue)((EnumerableValue)iValue).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + iValue.getClass().getName());
    }

    private static boolean isValidSequence(FcnRcdValue fcnRcdValue) {
        Value[] valueArray;
        for (Value value : valueArray = fcnRcdValue.getDomainAsValues()) {
            if (value instanceof IntValue) continue;
            return false;
        }
        fcnRcdValue.normalize();
        for (int i = 0; i < valueArray.length; ++i) {
            if (((IntValue)valueArray[i]).val == i + 1) continue;
            return false;
        }
        return true;
    }

    private static JsonElement getObjectNode(IValue iValue) throws IOException {
        if (iValue instanceof RecordValue) {
            return Json.getObjectNode((RecordValue)iValue);
        }
        if (iValue instanceof TupleValue) {
            return Json.getObjectNode((TupleValue)iValue);
        }
        if (iValue instanceof FcnRcdValue) {
            return Json.getObjectNode((FcnRcdValue)iValue);
        }
        if (iValue instanceof FcnLambdaValue) {
            return Json.getObjectNode((FcnRcdValue)((FcnLambdaValue)iValue).toFcnRcd());
        }
        throw new IOException("Cannot convert value: unsupported value type " + iValue.getClass().getName());
    }

    private static JsonElement getObjectNode(FcnRcdValue fcnRcdValue) throws IOException {
        if (Json.isValidSequence(fcnRcdValue)) {
            return Json.getArrayNode(fcnRcdValue);
        }
        Value[] valueArray = fcnRcdValue.getDomainAsValues();
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < valueArray.length; ++i) {
            Value value = valueArray[i];
            if (value instanceof StringValue) {
                jsonObject.add(((StringValue)value).val.toString(), Json.getNode((IValue)fcnRcdValue.values[i]));
                continue;
            }
            jsonObject.add(value.toString(), Json.getNode((IValue)fcnRcdValue.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(RecordValue recordValue) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < recordValue.names.length; ++i) {
            jsonObject.add(recordValue.names[i].toString(), Json.getNode((IValue)recordValue.values[i]));
        }
        return jsonObject;
    }

    private static JsonElement getObjectNode(TupleValue tupleValue) throws IOException {
        JsonObject jsonObject = new JsonObject();
        for (int i = 0; i < tupleValue.elems.length; ++i) {
            jsonObject.add(String.valueOf(i), Json.getNode((IValue)tupleValue.elems[i]));
        }
        return jsonObject;
    }

    private static JsonElement getArrayNode(IValue iValue) throws IOException {
        if (iValue instanceof TupleValue) {
            return Json.getArrayNode((TupleValue)iValue);
        }
        if (iValue instanceof FcnRcdValue) {
            return Json.getArrayNode((FcnRcdValue)iValue);
        }
        if (iValue instanceof FcnLambdaValue) {
            return Json.getArrayNode((FcnRcdValue)((FcnLambdaValue)iValue).toFcnRcd());
        }
        if (iValue instanceof SetEnumValue) {
            return Json.getArrayNode((SetEnumValue)iValue);
        }
        if (iValue instanceof EnumerableValue) {
            return Json.getArrayNode((SetEnumValue)((EnumerableValue)iValue).toSetEnum());
        }
        throw new IOException("Cannot convert value: unsupported value type " + iValue.getClass().getName());
    }

    private static JsonElement getArrayNode(TupleValue tupleValue) throws IOException {
        JsonArray jsonArray = new JsonArray(tupleValue.elems.length);
        for (int i = 0; i < tupleValue.elems.length; ++i) {
            jsonArray.add(Json.getNode((IValue)tupleValue.elems[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(FcnRcdValue fcnRcdValue) throws IOException {
        if (!Json.isValidSequence(fcnRcdValue)) {
            return Json.getObjectNode(fcnRcdValue);
        }
        fcnRcdValue.normalize();
        JsonArray jsonArray = new JsonArray(fcnRcdValue.values.length);
        for (int i = 0; i < fcnRcdValue.values.length; ++i) {
            jsonArray.add(Json.getNode((IValue)fcnRcdValue.values[i]));
        }
        return jsonArray;
    }

    private static JsonElement getArrayNode(SetEnumValue setEnumValue) throws IOException {
        setEnumValue.normalize();
        Value[] valueArray = setEnumValue.elems.toArray();
        JsonArray jsonArray = new JsonArray(valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            jsonArray.add(Json.getNode((IValue)valueArray[i]));
        }
        return jsonArray;
    }

    private static Value getValue(JsonElement jsonElement) throws IOException {
        if (jsonElement.isJsonArray()) {
            return Json.getTupleValue(jsonElement);
        }
        if (jsonElement.isJsonObject()) {
            return Json.getRecordValue(jsonElement);
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return IntValue.gen((int)jsonPrimitive.getAsInt());
            }
            if (jsonPrimitive.isBoolean()) {
                return new BoolValue(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return new StringValue(jsonPrimitive.getAsString());
            }
        }
        throw new IOException("Cannot convert value: unsupported JSON value " + jsonElement.toString());
    }

    private static TupleValue getTupleValue(JsonElement jsonElement) throws IOException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            arrayList.add(Json.getValue(jsonArray.get(i)));
        }
        return new TupleValue(arrayList.toArray(new Value[arrayList.size()]));
    }

    private static RecordValue getRecordValue(JsonElement jsonElement) throws IOException {
        ArrayList<UniqueString> arrayList = new ArrayList<UniqueString>();
        ArrayList<Value> arrayList2 = new ArrayList<Value>();
        for (Map.Entry<String, JsonElement> entry : jsonElement.getAsJsonObject().entrySet()) {
            arrayList.add(UniqueString.uniqueStringOf((String)entry.getKey()));
            arrayList2.add(Json.getValue(entry.getValue()));
        }
        return new RecordValue(arrayList.toArray(new UniqueString[arrayList.size()]), arrayList2.toArray(new Value[arrayList2.size()]), false);
    }

    @Deprecated
    static final void resolves() {
    }
}

