/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import org.apache.commons.math3.util.ArithmeticUtils;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.value.Values;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class DyadicRationals {
    private static final StringValue DEN = new StringValue("den");
    private static final StringValue NUM = new StringValue("num");

    @TLAPlusOperator(identifier="Reduce", module="DyadicRationals", warn=false)
    public static Value reduce(Value value) {
        if (!(value instanceof RecordValue)) {
            throw new EvalException(2283, new String[]{"Half", "record", Values.ppr((String)value.toString())});
        }
        RecordValue recordValue = (RecordValue)value;
        recordValue.normalize();
        IntValue intValue = (IntValue)recordValue.apply((Value)DEN, 0);
        IntValue intValue2 = (IntValue)recordValue.apply((Value)NUM, 0);
        int n = ArithmeticUtils.gcd(intValue2.val, intValue.val);
        if (n == 1) {
            return recordValue;
        }
        UniqueString[] uniqueStringArray = new UniqueString[]{DyadicRationals.DEN.val, DyadicRationals.NUM.val};
        Value[] valueArray = new Value[]{IntValue.gen((int)(intValue.val / n)), IntValue.gen((int)(intValue2.val / n))};
        return new RecordValue(uniqueStringArray, valueArray, false);
    }
}

