/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VerticalAlignment<V, E> {
    private static final Logger log = LoggerFactory.getLogger(VerticalAlignment.class);
    protected Map<LV<V>, LV<V>> rootMap = new HashMap<LV<V>, LV<V>>();
    protected Map<LV<V>, LV<V>> alignMap = new HashMap<LV<V>, LV<V>>();
    protected LV<V>[][] layers;
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected Set<LE<V, E>> markedSegments;
    protected NeighborCache<LV<V>, LE<V, E>> neighborCache;

    public Map<LV<V>, LV<V>> getRootMap() {
        return this.rootMap;
    }

    public Map<LV<V>, LV<V>> getAlignMap() {
        return this.alignMap;
    }

    public abstract void align();

    protected VerticalAlignment(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
        this.layers = layers;
        this.svGraph = svGraph;
        this.neighborCache = new NeighborCache<LV<LV<V>>, LE<LV<V>, LE<V, E>>>(svGraph);
        this.markedSegments = markedSegments;
        Arrays.stream(layers).flatMap(Arrays::stream).forEach(v -> {
            this.rootMap.put((LV<LV>)v, (LV<LV>)v);
            this.alignMap.put((LV<LV>)v, (LV<LV>)v);
        });
    }

    protected boolean notMarked(LE<V, E> edge) {
        return !this.markedSegments.contains(edge);
    }

    protected LV<V> root(LV<V> v) {
        return this.rootMap.get(v);
    }

    protected void root(LV<V> k, LV<V> v) {
        this.rootMap.put(k, v);
    }

    protected LV<V> align(LV<V> v) {
        return this.alignMap.get(v);
    }

    protected void align(LV<V> k, LV<V> v) {
        this.alignMap.put(k, v);
    }

    protected int pos(LV<V> v) {
        return v.getIndex();
    }

    protected int alignMoveCursor(LV<V> um, LV<V> vkofi) {
        this.align(um, vkofi);
        this.root(vkofi, this.root(um));
        this.align(vkofi, this.root(vkofi));
        return this.pos(um);
    }

    public static class RightmostLower<V, E>
    extends VerticalAlignment<V, E> {
        public RightmostLower(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = this.layers.length - 2; i >= 0; --i) {
                LV[] currentLayer = this.layers[i];
                LV[] previousLayerInSweep = this.layers[i + 1];
                int r = previousLayerInSweep.length + 1;
                block1: for (int k = currentLayer.length - 1; k >= 0; --k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.successorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{ceil, floor}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && this.notMarked(edge = (LE)this.svGraph.getEdge(vkofi, um = (LV)neighbors.get(m))) && r > this.pos(um)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }

    public static class LeftmostLower<V, E>
    extends VerticalAlignment<V, E> {
        public LeftmostLower(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = this.layers.length - 2; i >= 0; --i) {
                int r = -1;
                LV[] currentLayer = this.layers[i];
                block1: for (int k = 0; k < currentLayer.length; ++k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.successorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{floor, ceil}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && this.notMarked(edge = (LE)this.svGraph.getEdge(vkofi, um = (LV)neighbors.get(m))) && r < this.pos(um)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }

    public static class RightmostUpper<V, E>
    extends VerticalAlignment<V, E> {
        public RightmostUpper(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = 1; i <= this.layers.length - 1; ++i) {
                LV[] currentLayer = this.layers[i];
                LV[] previousLayerInSweep = this.layers[i - 1];
                int r = previousLayerInSweep.length + 1;
                block1: for (int k = currentLayer.length - 1; k >= 0; --k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.predecessorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{ceil, floor}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && this.notMarked(edge = (LE)this.svGraph.getEdge(um = (LV)neighbors.get(m), vkofi)) && r > this.pos(um)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }

    public static class LeftmostUpper<V, E>
    extends VerticalAlignment<V, E> {
        public LeftmostUpper(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = 0; i <= this.layers.length - 1; ++i) {
                int r = -1;
                LV[] currentLayer = this.layers[i];
                block1: for (int k = 0; k <= currentLayer.length - 1; ++k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = this.neighborCache.predecessorsOf(vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{floor, ceil}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && this.notMarked(edge = (LE)this.svGraph.getEdge(um = (LV)neighbors.get(m), vkofi)) && r < this.pos(um)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }
}

