/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCycles<V, E> {
    private static final Logger log = LoggerFactory.getLogger(RemoveCycles.class);
    protected Graph<V, E> graph;
    protected Set<V> stack = new HashSet<V>();
    protected Set<V> marked = new HashSet<V>();
    protected List<E> edges;
    protected final List<E> feedbackEdges = new ArrayList();

    public RemoveCycles(Graph<V, E> graph) {
        this.graph = graph;
        this.edges = new LinkedList<E>(graph.edgeSet());
    }

    public Graph<V, E> removeCycles() {
        this.graph.vertexSet().forEach(this::remove);
        return this.buildGraph(this.edges);
    }

    public List<E> getFeedbackEdges() {
        return this.feedbackEdges;
    }

    private Graph<V, E> buildGraph(List<E> edges) {
        Graph newGraph = GraphTypeBuilder.forGraph(this.graph).buildGraph();
        for (E edge : edges) {
            V source = this.graph.getEdgeSource(edge);
            V target = this.graph.getEdgeTarget(edge);
            newGraph.addVertex(source);
            newGraph.addVertex(target);
            newGraph.addEdge(source, target, edge);
        }
        this.graph.vertexSet().stream().filter(v -> !newGraph.containsVertex(v)).forEach(newGraph::addVertex);
        return newGraph;
    }

    private void remove(V v) {
        if (this.marked.add(v)) {
            this.stack.add(v);
            for (E edge : this.graph.outgoingEdgesOf(v)) {
                V target = this.graph.getEdgeTarget(edge);
                if (this.stack.contains(target)) {
                    this.edges.remove(edge);
                    this.feedbackEdges.add(edge);
                    continue;
                }
                if (this.marked.contains(target)) continue;
                this.remove(target);
            }
            this.stack.remove(v);
        }
    }
}

