/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentVertex;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VerticalAlignmentDeprecated<V, E>
extends VerticalAlignment<V, E> {
    private static final Logger log = LoggerFactory.getLogger(VerticalAlignmentDeprecated.class);

    protected VerticalAlignmentDeprecated(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
        super(layers, svGraph, markedSegments);
    }

    @Override
    protected int alignMoveCursor(LV<V> neighbor, LV<V> vertex) {
        this.align(neighbor, vertex);
        this.root(vertex, this.root(neighbor));
        this.align(vertex, this.root(vertex));
        return this.pos(neighbor);
    }

    protected int alignSegmentVertexMoveCursor(SegmentVertex<V> segmentVertex, LV<V> vertex) {
        SegmentVertex neighborSegmentVertex = segmentVertex instanceof PVertex ? segmentVertex.segment.qVertex : segmentVertex.segment.pVertex;
        this.root(vertex, this.root(neighborSegmentVertex));
        this.align(vertex, this.root(neighborSegmentVertex));
        return this.pos(neighborSegmentVertex);
    }

    @Override
    protected int pos(LV<V> v) {
        return v.getPos();
    }

    protected int idx(LV<V> v) {
        return v.getIndex();
    }

    public static class RightmostLower<V, E>
    extends VerticalAlignmentDeprecated<V, E> {
        public RightmostLower(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = this.layers.length - 2; i >= 0; --i) {
                LV[] currentLayer = this.layers[i];
                LV[] previousLayerInSweep = this.layers[i + 1];
                int r = this.pos(previousLayerInSweep[previousLayerInSweep.length - 1]) + 1;
                block1: for (int k = currentLayer.length - 1; k >= 0; --k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = Graphs.successorListOf(this.svGraph, vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{ceil, floor}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && (this.notMarked(edge = (LE)this.svGraph.getEdge(vkofi, um = (LV)neighbors.get(m))) && r > this.pos(um) || vkofi instanceof PVertex)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }

    public static class LeftmostLower<V, E>
    extends VerticalAlignmentDeprecated<V, E> {
        public LeftmostLower(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = this.layers.length - 2; i >= 0; --i) {
                int r = -1;
                LV[] currentLayer = this.layers[i];
                block1: for (int k = 0; k < currentLayer.length; ++k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = Graphs.successorListOf(this.svGraph, vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{floor, ceil}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && (this.notMarked(edge = (LE)this.svGraph.getEdge(vkofi, um = (LV)neighbors.get(m))) && r < this.pos(um) || vkofi instanceof PVertex)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }

    public static class RightmostUpper<V, E>
    extends VerticalAlignmentDeprecated<V, E> {
        public RightmostUpper(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = 1; i < this.layers.length; ++i) {
                LV[] currentLayer = this.layers[i];
                LV[] previousLayerInSweep = this.layers[i - 1];
                int r = this.pos(previousLayerInSweep[previousLayerInSweep.length - 1]) + 1;
                block1: for (int k = currentLayer.length - 1; k >= 0; --k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = Graphs.predecessorListOf(this.svGraph, vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{ceil, floor}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && (this.notMarked(edge = (LE)this.svGraph.getEdge(um = (LV)neighbors.get(m), vkofi)) && r > this.pos(um) || vkofi instanceof QVertex)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }

    public static class LeftmostUpper<V, E>
    extends VerticalAlignmentDeprecated<V, E> {
        public LeftmostUpper(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Set<LE<V, E>> markedSegments) {
            super(layers, svGraph, markedSegments);
        }

        @Override
        public void align() {
            for (int i = 0; i < this.layers.length; ++i) {
                int r = -1;
                LV[] currentLayer = this.layers[i];
                block1: for (int k = 0; k <= currentLayer.length - 1; ++k) {
                    LV vkofi = currentLayer[k];
                    List neighbors = Graphs.predecessorListOf(this.svGraph, vkofi).stream().sorted(Comparator.comparingInt(LV::getIndex)).collect(Collectors.toList());
                    int d = neighbors.size();
                    if (d <= 0) continue;
                    int floor = (int)Math.floor((double)(d - 1) / 2.0);
                    int ceil = (int)Math.ceil((double)(d - 1) / 2.0);
                    for (int m : new int[]{floor, ceil}) {
                        LV um;
                        LE edge;
                        if (this.align(vkofi) == vkofi && (this.notMarked(edge = (LE)this.svGraph.getEdge(um = (LV)neighbors.get(m), vkofi)) && r < this.pos(um) || vkofi instanceof QVertex)) {
                            r = this.alignMoveCursor(um, vkofi);
                        }
                        if (floor == ceil) continue block1;
                    }
                }
            }
        }
    }
}

