/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.HorizontalCompaction;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.VerticalAlignment;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AverageMedian;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalCoordinateAssignment<V, E>
extends org.jungrapht.visualization.layout.algorithms.sugiyama.HorizontalCoordinateAssignment<V, E> {
    private static Logger log = LoggerFactory.getLogger(HorizontalCoordinateAssignment.class);
    protected Graph<LV<V>, Integer> compactionGraph;
    protected Set<LV<V>> isolatedCompactionGraphVertices;

    public HorizontalCoordinateAssignment(LV<V>[][] layers, Graph<LV<V>, LE<V, E>> svGraph, Graph<LV<V>, Integer> compactionGraph, Set<LE<V, E>> markedSegments, int horizontalOffset, int verticalOffset) {
        super(layers, svGraph, markedSegments, horizontalOffset, verticalOffset);
        this.horizontalBalancing = true;
        this.compactionGraph = compactionGraph;
        Set<Integer> compactionGraphEdges = compactionGraph.edgeSet();
        this.isolatedCompactionGraphVertices = compactionGraph.vertexSet().stream().filter(v -> compactionGraph.degreeOf((LV)v) == 0).collect(Collectors.toSet());
    }

    @Override
    public void horizontalCoordinateAssignment() {
        VerticalAlignment.LeftmostUpper upLeft = new VerticalAlignment.LeftmostUpper(VerticalAlignment.HDirection.LtoR, VerticalAlignment.VDirection.TtoB, this.layers, this.compactionGraph, this.svGraph, this.markedSegments);
        upLeft.align();
        HorizontalCompaction upLeftCompaction = new HorizontalCompaction(VerticalAlignment.HDirection.LtoR, VerticalAlignment.VDirection.TtoB, this.svGraph, this.compactionGraph, this.layers, upLeft.getRootMap(), upLeft.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        upLeftCompaction.horizontalCompaction();
        if (log.isTraceEnabled()) {
            log.trace("upLeft");
            log.trace("alignMap:{}", (Object)upLeft.getAlignMap());
            log.trace("rootMap:{}", (Object)upLeft.getRootMap());
            log.trace("shift:{}", (Object)upLeftCompaction.getShift());
            log.trace("sink:{}", (Object)upLeftCompaction.getSink());
        }
        VerticalAlignment.RightmostUpper upRight = new VerticalAlignment.RightmostUpper(VerticalAlignment.HDirection.RtoL, VerticalAlignment.VDirection.TtoB, this.layers, this.compactionGraph, this.svGraph, this.markedSegments);
        upRight.align();
        HorizontalCompaction upRightCompaction = new HorizontalCompaction(VerticalAlignment.HDirection.RtoL, VerticalAlignment.VDirection.TtoB, this.svGraph, this.compactionGraph, this.layers, upRight.getRootMap(), upRight.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        upRightCompaction.horizontalCompaction();
        upRightCompaction.checkValuesInLayersForSameX(this.layers);
        if (log.isTraceEnabled()) {
            log.trace("upRight");
            log.trace("alignMap:{}", (Object)upRight.getAlignMap());
            log.trace("rootMap:{}", (Object)upRight.getRootMap());
            log.trace("shift:{}", (Object)upRightCompaction.getShift());
            log.trace("sink:{}", (Object)upRightCompaction.getSink());
        }
        VerticalAlignment.LeftmostLower downLeft = new VerticalAlignment.LeftmostLower(VerticalAlignment.HDirection.LtoR, VerticalAlignment.VDirection.BtoT, this.layers, this.compactionGraph, this.svGraph, this.markedSegments);
        downLeft.align();
        HorizontalCompaction downLeftCompaction = new HorizontalCompaction(VerticalAlignment.HDirection.LtoR, VerticalAlignment.VDirection.BtoT, this.svGraph, this.compactionGraph, this.layers, downLeft.getRootMap(), downLeft.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        downLeftCompaction.horizontalCompaction();
        downLeftCompaction.checkValuesInLayersForSameX(this.layers);
        if (log.isTraceEnabled()) {
            log.trace("downLeft");
            log.trace("alignMap:{}", (Object)downLeft.getAlignMap());
            log.trace("rootMap:{}", (Object)downLeft.getRootMap());
            log.trace("shift:{}", (Object)downLeftCompaction.getShift());
            log.trace("sink:{}", (Object)downLeftCompaction.getSink());
        }
        VerticalAlignment.RightmostLower downRight = new VerticalAlignment.RightmostLower(VerticalAlignment.HDirection.RtoL, VerticalAlignment.VDirection.BtoT, this.layers, this.compactionGraph, this.svGraph, this.markedSegments);
        downRight.align();
        HorizontalCompaction downRightCompaction = new HorizontalCompaction(VerticalAlignment.HDirection.RtoL, VerticalAlignment.VDirection.BtoT, this.svGraph, this.compactionGraph, this.layers, downRight.getRootMap(), downRight.getAlignMap(), this.horizontalOffset, this.verticalOffset);
        downRightCompaction.horizontalCompaction();
        downRightCompaction.checkValuesInLayersForSameX(this.layers);
        if (log.isTraceEnabled()) {
            log.trace("downRight");
            log.trace("alignMap:{}", (Object)downRight.getAlignMap());
            log.trace("rootMap:{}", (Object)downRight.getRootMap());
            log.trace("shift:{}", (Object)downRightCompaction.getShift());
            log.trace("sink:{}", (Object)downRightCompaction.getSink());
        }
        if (this.horizontalBalancing) {
            this.horizontalBalancing(upLeftCompaction, upRightCompaction, downLeftCompaction, downRightCompaction);
        }
        for (int i = 0; i < this.layers.length; ++i) {
            for (int j = 0; j < this.layers[i].length; ++j) {
                LV v = this.layers[i][j];
                Point upLeftPoint = upLeftCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point upRightPoint = upRightCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point downLeftPoint = downLeftCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point downRightPoint = downRightCompaction.getPoint(v).add(this.horizontalOffset, this.verticalOffset);
                Point balancedPoint = AverageMedian.averageMedianPoint(upLeftPoint, upRightPoint, downLeftPoint, downRightPoint);
                v.setPoint(balancedPoint);
            }
        }
        int offset = this.horizontalOffset;
        for (int i = 0; i < 10; ++i) {
            int sum = 0;
            log.trace("try {}", (Object)i);
            sum += this.correctOverlappedVertices(offset);
            sum += this.edgeOverlapCorrection(offset);
            if ((sum += this.moveVerticesThatOverlapInnerEdges(offset)) == 0) {
                log.trace("done after {} tries ", (Object)i);
                break;
            }
            offset = (int)((double)offset * 0.9);
        }
    }

    private Set<LE<V, E>> getInnerEdges() {
        List pVertices = Arrays.stream(this.layers).flatMap(Arrays::stream).filter(v -> v instanceof PVertex).collect(Collectors.toList());
        Set<LE<V, E>> innerEdges = pVertices.stream().map(v -> (LE)this.svGraph.outgoingEdgesOf(v).stream().findFirst().get()).collect(Collectors.toSet());
        return innerEdges;
    }

    private int edgeOverlapCorrection(int offset) {
        int moved = 0;
        List pVertices = Arrays.stream(this.layers).flatMap(Arrays::stream).filter(v -> v instanceof PVertex).map(v -> (PVertex)v).collect(Collectors.toList());
        HashSet<Double> xValues = new HashSet<Double>();
        log.trace("checking {} pVertices", (Object)pVertices.size());
        for (PVertex pVertex : pVertices) {
            if (xValues.contains(pVertex.getPoint().x)) {
                QVertex qVertex = (QVertex)this.neighborCache.successorsOf(pVertex).stream().findFirst().get();
                log.trace("got q  check {}", (Object)qVertex);
                pVertex.setPoint(pVertex.getPoint().add(offset, 0.0));
                qVertex.setPoint(qVertex.getPoint().add(offset, 0.0));
                log.trace("edge ol moved {} {} for edge overlap", (Object)pVertex, (Object)qVertex);
                ++moved;
            }
            xValues.add(pVertex.getPoint().x);
        }
        log.trace("done checking");
        return moved;
    }

    private int moveVerticesThatOverlapInnerEdges(int offset) {
        int moved = 0;
        Set<LE<V, E>> innerEdges = this.getInnerEdges();
        Map<Double, LE> innerEdgeMap = innerEdges.stream().collect(Collectors.toMap(e -> ((LV)this.svGraph.getEdgeSource(e)).getPoint().x, e -> e, (a, b) -> b));
        for (LV v : this.svGraph.vertexSet()) {
            double vy;
            double x;
            if (v instanceof PVertex || v instanceof QVertex || !innerEdgeMap.containsKey(x = v.getPoint().x)) continue;
            double lowy = innerEdgeMap.get((Object)Double.valueOf((double)x)).getSource().getPoint().y;
            double hiy = innerEdgeMap.get((Object)Double.valueOf((double)x)).getTarget().getPoint().y;
            if (lowy > hiy) {
                double temp = lowy;
                lowy = hiy;
                hiy = temp;
            }
            if (!(lowy <= (vy = v.getPoint().y)) || !(vy <= hiy)) continue;
            v.setPoint(v.getPoint().add(offset, 0.0));
            log.trace("moved {}", (Object)v);
            ++moved;
        }
        return moved;
    }

    private int correctOverlappedVertices(int offset) {
        int moved = 0;
        HashSet<Point> usedPoints = new HashSet<Point>();
        for (LV v : this.svGraph.vertexSet()) {
            if (v instanceof PVertex || v instanceof QVertex) continue;
            Point balancedPoint = v.getPoint();
            if (usedPoints.contains(balancedPoint)) {
                log.trace("changed {} point ", (Object)v);
                log.trace(" from {} ", (Object)balancedPoint);
                balancedPoint = balancedPoint.add(offset, 0.0);
                log.trace("   to {}", (Object)balancedPoint);
                ++moved;
            }
            usedPoints.add(balancedPoint);
        }
        return moved;
    }

    protected int boundsWidth(Collection<Integer> xValues) {
        int[] bounds = this.bounds(xValues);
        return bounds[1] - bounds[0];
    }

    @Override
    protected int pos(LV<V> v) {
        return v.getPos();
    }

    protected int idx(LV<V> v) {
        return v.getIndex();
    }

    @Override
    protected boolean incidentToInnerSegment(LV<V> v) {
        return v instanceof QVertex;
    }

    protected List<LV<V>> misAligned(Map<LV<V>, Point> pointMap) {
        ArrayList<LV<V>> misAligned = new ArrayList<LV<V>>();
        for (Map.Entry<LV<V>, Point> entry : pointMap.entrySet()) {
            if (!this.misAligned(entry.getKey(), pointMap)) continue;
            misAligned.add(entry.getKey());
        }
        return misAligned;
    }

    protected List<LV<V>> misAligned(LV<V>[][] layers) {
        ArrayList<LV<V>> misAligned = new ArrayList<LV<V>>();
        for (int i = 0; i < layers.length; ++i) {
            for (int j = 0; j < layers[i].length; ++j) {
                LV<V> v = layers[i][j];
                if (!this.misAligned(v)) continue;
                misAligned.add(v);
            }
        }
        return misAligned;
    }

    protected boolean misAligned(LV<V> v) {
        if (v instanceof SegmentVertex) {
            SegmentVertex segmentVertex = (SegmentVertex)v;
            PVertex pVertex = segmentVertex.getSegment().pVertex;
            QVertex qVertex = segmentVertex.getSegment().qVertex;
            Point p = pVertex.getPoint();
            Point q = qVertex.getPoint();
            if (p.x != q.x) {
                return true;
            }
        }
        return false;
    }

    protected boolean misAligned(LV<V> v, Map<LV<V>, Point> map) {
        if (v instanceof SegmentVertex) {
            SegmentVertex segmentVertex = (SegmentVertex)v;
            PVertex pVertex = segmentVertex.getSegment().pVertex;
            QVertex qVertex = segmentVertex.getSegment().qVertex;
            Point p = map.get(pVertex);
            Point q = map.get(qVertex);
            if (p.x != q.x && log.isTraceEnabled()) {
                log.trace("segment {} misaligned with p at {} and q at {}", segmentVertex.getSegment(), p, q);
                return true;
            }
        }
        return false;
    }
}

