/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.AbstractTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EdgeAwareLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EdgePredicated;
import org.jungrapht.visualization.layout.algorithms.EdgeSorting;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.VertexPredicated;
import org.jungrapht.visualization.layout.algorithms.VertexSorting;
import org.jungrapht.visualization.layout.algorithms.util.ComponentGrouping;
import org.jungrapht.visualization.layout.algorithms.util.TreeView;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.DefaultLayoutModel;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.Caching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TidierTreeLayoutAlgorithm<V, E>
extends AbstractTreeLayoutAlgorithm<V>
implements LayoutAlgorithm<V>,
TreeLayout<V>,
VertexBoundsFunctionConsumer<V>,
EdgeAwareLayoutAlgorithm<V, E>,
EdgeSorting<E>,
EdgePredicated<E>,
VertexSorting<V>,
VertexPredicated<V> {
    private static final Logger log = LoggerFactory.getLogger(TidierTreeLayoutAlgorithm.class);
    private static final Rectangle IDENTITY_SHAPE = Rectangle.of(-5, -5, 10, 10);
    protected Rectangle bounds = Rectangle.IDENTITY;
    protected List<Integer> heights = new ArrayList<Integer>();
    protected List<V> roots;
    protected Predicate<V> builderRootPredicate;
    protected Predicate<V> vertexPredicate;
    protected Predicate<E> edgePredicate;
    protected Comparator<V> vertexComparator;
    protected Comparator<E> edgeComparator;
    protected Graph<V, E> tree;
    protected NeighborCache<V, E> neighborCache;
    protected LayoutModel<V> layoutModel;
    private Set<V> visitedVertices = new HashSet<V>();
    private final Map<V, VertexData<V>> vertexData = new HashMap<V, VertexData<V>>();

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return new Builder();
    }

    public TidierTreeLayoutAlgorithm() {
        this(TidierTreeLayoutAlgorithm.edgeAwareBuilder());
    }

    protected TidierTreeLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.vertexPredicate = builder.vertexPredicate;
        this.vertexComparator = builder.vertexComparator;
        this.edgePredicate = builder.edgePredicate;
        this.edgeComparator = builder.edgeComparator;
    }

    protected void clearMetadata() {
        this.heights.clear();
        this.visitedVertices.clear();
        this.baseBounds.clear();
        this.vertexData.clear();
        this.bounds = Rectangle.IDENTITY;
    }

    @Override
    public void setEdgePredicate(Predicate<E> edgePredicate) {
        this.edgePredicate = edgePredicate;
    }

    @Override
    public void setEdgeComparator(Comparator<E> edgeComparator) {
        this.edgeComparator = edgeComparator;
    }

    @Override
    public void setVertexPredicate(Predicate<V> vertexPredicate) {
        this.vertexPredicate = vertexPredicate;
    }

    @Override
    public void setVertexComparator(Comparator<V> vertexComparator) {
        this.vertexComparator = vertexComparator;
    }

    @Override
    public Map<V, Rectangle> getBaseBounds() {
        if (this.baseBounds.isEmpty()) {
            for (V root : this.roots) {
                Point p = (Point)this.layoutModel.apply(root);
                Rectangle r = (Rectangle)this.vertexBoundsFunction.apply(root);
                r = Rectangle.of(r.x - r.width / 2.0 + p.x, r.y - r.height / 2.0 + p.y, r.width, r.height);
                this.baseBounds.put(root, this.union(r, this.neighborCache.successorsOf(root)));
            }
        }
        return this.baseBounds;
    }

    private Rectangle union(Rectangle r, Collection<V> in) {
        for (V v : in) {
            Point p = (Point)this.layoutModel.apply(v);
            Rectangle vr = (Rectangle)this.vertexBoundsFunction.apply(v);
            r = Rectangle.of(vr.x - vr.width / 2.0 + p.x, vr.y - vr.height / 2.0 + p.y, vr.width, vr.height);
            r = r.union(vr);
            r = this.union(r, this.successors(v));
            this.baseBounds.put(v, this.union(r, this.neighborCache.successorsOf(v)));
        }
        return r;
    }

    private VertexData<V> vertexData(V v) {
        if (!this.vertexData.containsKey(v)) {
            this.vertexData.put(v, new VertexData());
        }
        return this.vertexData.get(v);
    }

    private void firstWalk(V v, V leftSibling) {
        if (log.isTraceEnabled()) {
            this.visitedVertices.add(v);
        }
        log.trace("firstWalk({}, {})", (Object)v, (Object)leftSibling);
        if (this.successors(v).isEmpty()) {
            if (leftSibling != null) {
                this.vertexData(v).x = this.vertexData(leftSibling).x + this.getDistance(v, leftSibling);
            }
        } else {
            V defaultAncestor = this.firstChild(v).get();
            V previousChild = null;
            for (V w : this.successors(v)) {
                this.firstWalk(w, previousChild);
                defaultAncestor = this.apportion(w, defaultAncestor, previousChild, v);
                previousChild = w;
            }
            this.shift(v);
            int midpoint = (this.vertexData(this.firstChild(v).get()).x + this.vertexData(this.lastChild(v).get()).x) / 2;
            log.trace("midpoint for {} is {}", (Object)v, (Object)midpoint);
            if (leftSibling != null) {
                this.vertexData(v).x = this.vertexData(leftSibling).x + this.getDistance(v, leftSibling);
                this.vertexData(v).mod = this.vertexData(v).x - midpoint;
            } else {
                this.vertexData(v).x = midpoint;
            }
        }
    }

    private void secondWalk(V v, int m, int depth, int yOffset) {
        if (log.isTraceEnabled()) {
            this.visitedVertices.add(v);
        }
        log.trace("secondWalk({}, {}, {}, {})", v, m, depth, yOffset);
        int levelHeight = this.heights.get(depth);
        int x = this.vertexData(v).x + m;
        int y = yOffset + levelHeight / 2;
        if (v != null) {
            this.layoutModel.set(v, Point.of(x, y));
        }
        this.updateBounds(v, x, y);
        if (!this.successors(v).isEmpty()) {
            yOffset += levelHeight + this.verticalVertexSpacing;
            for (V w : this.successors(v)) {
                this.secondWalk(w, m + this.vertexData(v).mod, depth + 1, yOffset);
            }
        }
    }

    private Rectangle shape(Object in) {
        if (in == null) {
            return IDENTITY_SHAPE;
        }
        return (Rectangle)this.vertexBoundsFunction.apply(in);
    }

    private void updateBounds(V vertex, int centerX, int centerY) {
        log.trace("updateBounds({}, {}, {})", vertex, centerX, centerY);
        Rectangle shape = this.shape(vertex);
        int width = (int)shape.width;
        int height = (int)shape.height;
        int left = centerX - width / 2;
        int right = centerX + width / 2;
        int top = centerY - height / 2;
        int bottom = centerY + height / 2;
        Rectangle bounds = Rectangle.of(left, top, right - left, bottom - top);
        this.bounds = this.bounds.union(bounds);
        log.trace("updated bounds to {} ({}, {}, {}, {})", bounds, bounds.x, bounds.maxX, bounds.y, bounds.maxY);
    }

    private Point normalize(Point p) {
        return Point.of(p.x - this.bounds.x, p.y - this.bounds.y);
    }

    private void computeMaxHeights(V vertex, int depth) {
        int previous;
        log.trace("computeMaxHeights({}, {})", (Object)vertex, (Object)depth);
        if (this.heights.size() > depth) {
            previous = this.heights.get(depth);
        } else {
            this.heights.add(0);
            previous = 0;
        }
        int height = (int)this.shape(vertex).height;
        this.heights.set(depth, Math.max(height, previous));
        this.successors(vertex).forEach(v -> this.computeMaxHeights(v, depth + 1));
    }

    private void moveSubtree(V leftVertex, V rightVertex, V parentVertex, int shift) {
        log.trace("moveSubtree({}, {}, {}, {})", leftVertex, rightVertex, parentVertex, shift);
        int subtreeCount = this.childPosition(rightVertex, parentVertex) - this.childPosition(leftVertex, parentVertex);
        if (subtreeCount > 0) {
            VertexData<V> rightData = this.vertexData(rightVertex);
            VertexData<V> leftData = this.vertexData(leftVertex);
            rightData.change -= shift / subtreeCount;
            rightData.shift += shift;
            leftData.change += shift / subtreeCount;
            rightData.x = this.vertexData(rightVertex).x + shift;
            rightData.mod += shift;
        }
    }

    private int childPosition(V vertex, V parentNode) {
        if (parentNode == null) {
            log.trace("childPosition({}, {}) = {}", vertex, parentNode, this.roots.indexOf(vertex) + 1);
            return this.roots.indexOf(vertex) + 1;
        }
        if (this.vertexData(vertex).childCount != 0) {
            log.trace("childPosition({}, {}) = {}", vertex, parentNode, this.vertexData(vertex).childCount);
            return this.vertexData(vertex).childCount;
        }
        int i = 1;
        for (V v : this.successors(parentNode)) {
            this.vertexData(v).childCount = i++;
        }
        log.trace("childPosition({}, {}) = {}", vertex, parentNode, this.vertexData(vertex).childCount);
        return this.vertexData(vertex).childCount;
    }

    private V ancestor(V vil, V parentOfV, V defaultAncestor) {
        log.trace("ancestor({}, {}, {})", vil, parentOfV, defaultAncestor);
        Object ancestor = Optional.ofNullable(this.vertexData(vil).ancestor).orElse(vil);
        for (Object vp : this.predecessors(ancestor)) {
            if (vp != parentOfV) continue;
            log.trace("ancestor({}, {}, {}) = {}", vil, parentOfV, ancestor, ancestor);
            return ancestor;
        }
        log.trace("ancestor({}, {}, {}) = {}", vil, parentOfV, defaultAncestor, defaultAncestor);
        return defaultAncestor;
    }

    private V apportion(V v, V defaultAncestor, V leftSibling, V parentOfV) {
        log.trace("apportion({}, {}, {}, {})", v, defaultAncestor, leftSibling, parentOfV);
        if (leftSibling == null) {
            log.trace("...apportion returning passed Default Ancestor:{}", (Object)defaultAncestor);
            return defaultAncestor;
        }
        V vor = v;
        V vir = v;
        V vil = leftSibling;
        V vol = this.successors(parentOfV).stream().findFirst().get();
        int innerRight = this.vertexData(vir).mod;
        int outerRight = this.vertexData(vor).mod;
        int innerLeft = this.vertexData(vil).mod;
        int outerLeft = this.vertexData(vol).mod;
        V nextRightOfVil = this.rightChild(vil);
        V nextLeftOfVir = this.leftChild(vir);
        while (nextRightOfVil != null && nextLeftOfVir != null) {
            vil = nextRightOfVil;
            vir = nextLeftOfVir;
            vol = this.leftChild(vol);
            vor = this.rightChild(vor);
            this.vertexData(vor).ancestor = v;
            int shift = this.vertexData(vil).x + innerLeft - (this.vertexData(vir).x + innerRight) + this.getDistance(vil, vir);
            if (shift > 0) {
                this.moveSubtree(this.ancestor(vil, parentOfV, defaultAncestor), v, parentOfV, shift);
                innerRight += shift;
                outerRight += shift;
            }
            innerLeft += this.vertexData(vil).mod;
            innerRight += this.vertexData(vir).mod;
            outerLeft += this.vertexData(vol).mod;
            outerRight += this.vertexData(vor).mod;
            nextRightOfVil = this.rightChild(vil);
            nextLeftOfVir = this.leftChild(vir);
        }
        if (nextRightOfVil != null && this.rightChild(vor) == null) {
            this.vertexData(vor).thread = nextRightOfVil;
            this.vertexData(vor).mod = this.vertexData(vor).mod + innerLeft - outerRight;
        }
        if (nextLeftOfVir != null && this.leftChild(vol) == null) {
            this.vertexData(vol).thread = nextLeftOfVir;
            this.vertexData(vol).mod += innerRight - outerLeft;
            defaultAncestor = v;
        }
        log.trace("...apportion returning new defaultAncestor:{}", (Object)defaultAncestor);
        return defaultAncestor;
    }

    private void shift(V v) {
        log.trace("shift({})", (Object)v);
        int shift = 0;
        int change = 0;
        ArrayList<V> children = new ArrayList<V>(this.successors(v));
        Collections.reverse(children);
        for (Object w : children) {
            this.vertexData(w).x += shift;
            this.vertexData(w).mod += shift;
            shift += this.vertexData(w).shift + (change += this.vertexData(w).change);
        }
    }

    private Collection<V> successors(V v) {
        List successors;
        if (v == null) {
            log.trace("successors({}) = {}", (Object)v, (Object)this.roots);
            return this.roots;
        }
        if (log.isTraceEnabled()) {
            log.trace("successors({}) = {}", (Object)v, (Object)this.neighborCache.successorsOf(v));
        }
        if (this.edgePredicate != null) {
            List outgoingEdges = this.tree.outgoingEdgesOf(v).stream().sorted(this.edgeComparator).filter(this.edgePredicate).collect(Collectors.toList());
            successors = outgoingEdges.stream().map(this.tree::getEdgeTarget).collect(Collectors.toList());
        } else {
            successors = this.neighborCache.successorsOf(v).stream().collect(Collectors.toList());
        }
        return successors;
    }

    private Collection<V> predecessors(V v) {
        if (this.roots.contains(v)) {
            log.trace("predecessors({}) = {}", (Object)v, (Object)Collections.singletonList(null));
            return Collections.singletonList(null);
        }
        if (log.isTraceEnabled()) {
            log.trace("predecessors({}) = {}", (Object)v, (Object)this.neighborCache.predecessorsOf(v));
        }
        return this.neighborCache.predecessorsOf(v);
    }

    private V leftChild(V v) {
        log.trace("leftChild({}) = {}", (Object)v, (Object)this.firstChild(v).orElse(this.vertexData(v).thread));
        return this.firstChild(v).orElse(this.vertexData(v).thread);
    }

    private V rightChild(V v) {
        log.trace("rightChild({}) = {}", (Object)v, (Object)this.lastChild(v).orElse(this.vertexData(v).thread));
        return this.lastChild(v).orElse(this.vertexData(v).thread);
    }

    private Optional<V> firstChild(V v) {
        log.trace("firstChild({}) = {}", (Object)v, (Object)this.successors(v).stream().findFirst());
        return this.successors(v).stream().findFirst();
    }

    private Optional<V> lastChild(V v) {
        log.trace("lastChild({}) = {}", (Object)v, (Object)this.successors(v).stream().reduce((first, second) -> second));
        return this.successors(v).stream().reduce((first, second) -> second);
    }

    private int getDistance(V v, V w) {
        log.trace("getDistance({}, {})", (Object)v, (Object)w);
        int sizeOfNodes = (int)this.shape(v).width + (int)this.shape(w).width;
        int distance = sizeOfNodes / 2 + this.horizontalVertexSpacing;
        log.trace("getDistance({}, {}) = {}", v, w, distance);
        return distance;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
        Graph graph = layoutModel.getGraph();
        if (layoutModel.getGraph().getType().isUndirected() || this.getRoots(layoutModel.getGraph()).size() == 0) {
            Graph tree = TreeLayoutAlgorithm.getSpanningTree(layoutModel.getGraph());
            DefaultLayoutModel<V> treeLayoutModel = DefaultLayoutModel.from(layoutModel);
            treeLayoutModel.setGraph(tree);
            this.visit(treeLayoutModel);
            layoutModel.setSize(treeLayoutModel.getWidth(), treeLayoutModel.getHeight());
            layoutModel.setInitializer(treeLayoutModel);
        } else {
            super.visit(layoutModel);
            this.buildTree(layoutModel);
        }
        if (this.correctOverlap) {
            this.moveVerticesThatOverlapVerticalEdges(layoutModel, this.horizontalVertexSpacing / 4);
        }
        if (this.expandLayout) {
            this.expandToFill(layoutModel);
        }
        this.runAfter();
        this.clearMetadata();
    }

    protected void buildTree(LayoutModel<V> layoutModel) {
        if (layoutModel instanceof Caching) {
            ((Caching)((Object)layoutModel)).clear();
        }
        this.layoutModel = layoutModel;
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            this.expandLayout = false;
            this.correctOverlap = false;
            return;
        }
        if (graph.vertexSet().size() == 1) {
            Object loner = graph.vertexSet().stream().findFirst().get();
            layoutModel.set(loner, layoutModel.getWidth() / 2, layoutModel.getHeight() / 2);
            this.roots = new ArrayList<V>(graph.vertexSet());
            this.expandLayout = false;
            this.correctOverlap = false;
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("this graph has {} vertices", (Object)graph.vertexSet().size());
        }
        this.vertexData.clear();
        this.heights.clear();
        if (this.vertexBoundsFunction != null) {
            Dimension averageVertexSize = this.computeAverageVertexDimension(graph, this.vertexBoundsFunction);
            this.horizontalVertexSpacing = averageVertexSize.width * 2;
            this.verticalVertexSpacing = averageVertexSize.height * 2;
        }
        Object builder = ((TreeView.Builder)((TreeView.Builder)((TreeView.Builder)((TreeView.Builder)TreeView.builder().rootPredicate(this.rootPredicate)).edgePredicate(this.edgePredicate)).edgeComparator(this.edgeComparator)).vertexComparator(this.vertexComparator)).vertexPredicate(this.vertexPredicate);
        if (graph.vertexSet().size() == 1) {
            Object loner = graph.vertexSet().stream().findFirst().get();
            layoutModel.set(loner, Point.of(layoutModel.getWidth() / 2, layoutModel.getHeight() / 2));
            this.clearMetadata();
            return;
        }
        this.roots = graph.vertexSet().stream().filter(this.rootPredicate).sorted(Comparator.comparingInt(v -> TreeLayout.vertexIsolationScore(graph, v))).collect(Collectors.toList());
        this.roots = ComponentGrouping.groupByComponents(graph, this.roots);
        if (this.roots.size() == 0) {
            Graph tree = TreeLayoutAlgorithm.getSpanningTree(graph);
            layoutModel.setGraph(tree);
            this.visit(layoutModel);
            return;
        }
        Object treeView = ((TreeView.Builder)((TreeView.Builder)((TreeView.Builder)((TreeView.Builder)((TreeView.Builder)((TreeView.Builder)builder).rootPredicate(this.rootPredicate)).edgeComparator(this.edgeComparator)).edgePredicate(this.edgePredicate)).vertexComparator(this.vertexComparator)).vertexPredicate(this.vertexPredicate)).build();
        this.tree = ((TreeView)treeView).buildTree(graph);
        this.neighborCache = new NeighborCache<V, E>(this.tree);
        V root = null;
        if (this.roots.size() == 1) {
            root = this.roots.get(0);
        }
        this.firstWalk(root, null);
        this.computeMaxHeights(root, 0);
        this.secondWalk(root, -this.vertexData(root).x, 0, 0);
        Rectangle extent = this.computeLayoutExtent(layoutModel);
        log.trace("extent is {}", (Object)extent);
        log.trace("bounds is {}", (Object)this.bounds);
        log.trace("layoutModel bounds: {} {}", (Object)layoutModel.getWidth(), (Object)layoutModel.getHeight());
        int xoffset = this.horizontalVertexSpacing;
        int yoffset = (int)(-extent.min().y) + this.verticalVertexSpacing;
        for (Map.Entry<V, Point> entry : layoutModel.getLocations().entrySet()) {
            Point p = entry.getValue();
            Point np = this.normalize(p);
            np = np.add(xoffset, yoffset);
            layoutModel.set(entry.getKey(), np);
        }
        layoutModel.setSize((int)extent.width, (int)extent.height);
        if (log.isTraceEnabled()) {
            log.trace("visited {} vertices", (Object)this.visitedVertices.size());
            log.trace("vertices that were not visited: {}", (Object)graph.vertexSet().stream().filter(v -> !this.visitedVertices.contains(v)).collect(Collectors.toSet()));
        }
    }

    public static class Builder<V, E, T extends TidierTreeLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends AbstractTreeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B>,
    EdgeAwareLayoutAlgorithm.Builder<V, E, T, B> {
        protected Predicate<V> vertexPredicate = Layered.truePredicate;
        protected Predicate<E> edgePredicate = Layered.truePredicate;
        protected Comparator<V> vertexComparator = Layered.noopComparator;
        protected Comparator<E> edgeComparator = Layered.noopComparator;

        public B vertexPredicate(Predicate<V> vertexPredicate) {
            this.vertexPredicate = vertexPredicate;
            return (B)((Builder)this.self());
        }

        public B edgePredicate(Predicate<E> edgePredicate) {
            this.edgePredicate = edgePredicate;
            return (B)((Builder)this.self());
        }

        public B vertexComparator(Comparator<V> vertexComparator) {
            this.vertexComparator = vertexComparator;
            return (B)((Builder)this.self());
        }

        public B edgeComparator(Comparator<E> edgeComparator) {
            this.edgeComparator = edgeComparator;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new TidierTreeLayoutAlgorithm(this);
        }
    }

    private static class VertexData<V> {
        private int mod;
        private V thread;
        private int shift;
        private V ancestor;
        private int x;
        private int change;
        private int childCount;

        private VertexData() {
        }
    }
}

