/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.TextState;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputHelper;
import org.jpedal.render.output.OutputImageController;
import org.jpedal.render.output.OutputShape;
import org.jpedal.render.output.TextBlock;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class OutputDisplay
extends BaseDisplay {
    protected int[] pageoffsets;
    protected int newTotalHeight = 0;
    protected int pageGap = 50;
    String lastGlyf = "";
    public static final int TEXT_AS_TEXT = -1;
    public static final int TEXT_ON_CANVAS = 1;
    protected String clip = null;
    protected static OutputHelper Helper = null;
    FontMapper fontMapper = null;
    String lastFontUsed = "";
    protected boolean includeClip = false;
    protected int rasterizeText = -1;
    protected Map embeddedFontsByFontID = new HashMap();
    private Map glyfsRasterized = new HashMap();
    public static final int MaxNumberOfDecimalPlaces = 0;
    public static final int FontMode = 1;
    public static final int PercentageScaling = 2;
    public static final int IncludeJSFontResizingCode = 4;
    public static final int PutTextOnCanvas = 5;
    public static final int ExcludeMetadata = 6;
    public static final int EmbedImageAsBase64Stream = 7;
    public static final int AddNavBar = 8;
    public static final int SingleFileOutput = 9;
    public static final int UseCharSpacing = 10;
    public static final int UseWordSpacing = 11;
    public static final int UseFontResizing = 12;
    public static final int HasJavascript = 13;
    public static final int ConvertSpacesTonbsp = 14;
    public static final int EncloseContentInDiv = 15;
    public static final int IncludeClip = 16;
    public static final int UseImagesOnNavBar = 17;
    public static final int RasterizeText = 18;
    protected static int defaultMode = 3;
    protected int fontMode = 3;
    protected boolean putTextOnCanvas = false;
    protected boolean isSingleFileOutput = false;
    protected boolean embedImageAsBase64 = false;
    private boolean groupGlyphsInTJ = true;
    protected boolean writeEveryGlyf = false;
    public boolean inlineCSS = true;
    public static final boolean debugForms = false;
    private static final boolean DISABLE_IMAGES = false;
    private static final boolean DISABLE_SHAPE = false;
    private static final boolean DISABLE_TEXT = false;
    protected static final boolean DEBUG_TEXT_AREA = false;
    protected static final boolean DEBUG_DRAW_PAGE_BORDER = false;
    public static final int TOFILE = 0;
    public static final int TOP_SECTION = 1;
    public static final int SCRIPT = 2;
    public static final int FORM = 3;
    public static final int CSS = 4;
    public static final int IMAGE = 5;
    public static final int TEXT = 6;
    public static final int KEEP_GLYFS_SEPARATE = 7;
    public static final int SET_ENCODING_USED = 8;
    public static final int JSIMAGESPECIAL = 9;
    public static final int SAVE_EMBEDDED_FONT = 10;
    public static final int PAGEDATA = 11;
    public static final int IMAGE_CONTROLLER = 12;
    public static final int JAVAFXMLMETHODS = 13;
    public static final int FONT_AS_SHAPE = 14;
    protected OutputImageController imageController = null;
    protected BufferedWriter output = null;
    protected StringBuffer script = new StringBuffer(10000);
    protected StringBuffer fonts_as_shapes = new StringBuffer(10000);
    protected StringBuffer form = new StringBuffer(10000);
    protected StringBuffer testDivs = new StringBuffer(10000);
    protected StringBuffer images = new StringBuffer(10000);
    protected StringBuffer css = new StringBuffer(10000);
    protected StringBuffer topSection = new StringBuffer(10000);
    protected StringBuffer javaFXMLMethods = new StringBuffer(10000);
    protected boolean userControlledImageScaling = false;
    protected int textID = 1;
    protected int shadeId = 0;
    protected int dpCount = 0;
    public String rootDir = null;
    public String fileName = null;
    protected int dx;
    protected int dy;
    protected int dr;
    protected boolean excludeMetadata = false;
    private boolean convertSpacesTonbsp = false;
    protected boolean addNavBar = false;
    protected boolean useImagesOnNavBar = false;
    protected TextBlock currentTextBlock;
    protected TextBlock previousTextBlock;
    protected Rectangle cropBox;
    protected Point2D midPoint;
    protected int currentColor = 0;
    protected String[] encodingType = new String[]{"UTF-8", "utf-8"};
    protected static final int JAVA_TYPE = 0;
    protected static final int OUTPUT_TYPE = 1;
    public static final int FORM_TAG = 0;
    protected float scaling = 1.0f;
    protected int fontChangeNeeded = -1;
    float w;
    protected float h;
    protected String[] tag = new String[]{"<form>"};
    protected boolean jsImagesAdded = false;
    protected String pageNumberAsString = null;
    protected PdfPageData pageData;
    private int currentTokenNumber = -1;
    private int lastTokenNumber = 496;
    protected boolean includeJSFontResizingCode = true;
    protected static final boolean debugSigg = false;
    protected int fontSize;
    protected float[][] Trm;
    protected float[][] ctm;
    protected String imageName;
    protected String id;
    protected int iw;
    protected int ih;
    protected double[] coords;
    protected String customSinglePageHeader = System.getProperty("org.jpedal.pdf2html.customSinglePageHeader");
    protected String customSingleFileName = System.getProperty("org.jpedal.pdf2html.customSingleFileName");
    protected float[][] lastTrm;

    public OutputDisplay(int n, Point2D point2D, Rectangle rectangle, boolean bl, int n2, ObjectStore objectStore) {
        this.fontMode = defaultMode;
        this.type = 3;
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.cropBox = rectangle;
        this.midPoint = point2D;
        this.areas = new Vector_Rectangle(n2);
    }

    public void setValue(int n, int n2) {
        switch (n) {
            case 0: {
                this.dpCount = n2;
                break;
            }
            case 1: {
                this.fontMode = n2;
                break;
            }
            case 2: {
                this.scaling = (float)n2 / 100.0f;
                this.newTotalHeight = (int)(((float)this.cropBox.height * this.scaling + (float)this.pageGap) * (float)(this.pageNumber - 1));
                break;
            }
            case 18: {
                this.rasterizeText = n2;
                break;
            }
            case 12: {
                this.fontChangeNeeded = n2;
            }
        }
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 8: {
                this.addNavBar = bl;
                break;
            }
            case 14: {
                this.convertSpacesTonbsp = bl;
                break;
            }
            case 6: {
                this.excludeMetadata = bl;
                break;
            }
            case 16: {
                this.includeClip = bl;
                break;
            }
            case 17: {
                this.useImagesOnNavBar = bl;
            }
        }
    }

    public int getValue(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = this.fontMode;
                break;
            }
            case 18: {
                n2 = this.rasterizeText;
            }
        }
        return n2;
    }

    public void setTag(int n, String string) {
        throw new RuntimeException("Unknown tag value " + n);
    }

    public void init(int n, int n2, int n3, Color color) {
        if (n3 == 90 || n3 == 270) {
            this.h = (float)n * this.scaling;
            this.w = (float)n2 * this.scaling;
        } else {
            this.w = (float)n * this.scaling;
            this.h = (float)n2 * this.scaling;
        }
        this.pageRotation = n3;
        this.pageRotationInRadians = (float)(Math.PI * (double)n3 / 180.0);
        this.backgroundColor = color;
        this.shadeId = 0;
        this.currentTextBlock = new TextBlock(this.putTextOnCanvas);
        this.previousTextBlock = new TextBlock(this.putTextOnCanvas);
    }

    public synchronized void writeCustom(int n, Object object) {
        switch (n) {
            case 11: {
                this.pageData = (PdfPageData)object;
                this.dx = this.pageData.getCropBoxX(this.pageNumber);
                this.dy = this.pageData.getCropBoxY(this.pageNumber);
                this.dr = this.pageData.getRotation(this.pageNumber);
                if (!this.isSingleFileOutput || this.pageData.getPageCount() == 1) break;
                int n2 = this.pageData.getPageCount() + 1;
                this.pageoffsets = new int[n2];
                for (int i = 2; i < n2; ++i) {
                    this.pageoffsets[i] = (int)((float)this.pageoffsets[i - 1] + (float)this.pageData.getCropBoxHeight(this.pageNumber) * this.scaling + (float)this.pageGap);
                }
                break;
            }
            case 12: {
                this.imageController = (OutputImageController)object;
                this.userControlledImageScaling = this.imageController != null;
                break;
            }
            default: {
                throw new RuntimeException("Option " + n + " not recognised");
            }
        }
    }

    public synchronized void flagDecodingFinished() {
        if (this.output != null) {
            this.completeOutput();
        }
    }

    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        Object object;
        Object object2;
        this.flushText();
        boolean bl2 = false;
        float f = graphicsState.CTM[2][0] * this.scaling;
        float f2 = graphicsState.CTM[2][1] * this.scaling;
        this.iw = (int)(graphicsState.CTM[0][0] * this.scaling);
        if (this.iw == 0) {
            this.iw = (int)(graphicsState.CTM[1][0] * this.scaling);
            if (this.iw < 0) {
                this.iw = -this.iw;
            }
        }
        this.ih = (int)(graphicsState.CTM[1][1] * this.scaling);
        if (this.ih == 0) {
            this.ih = (int)(graphicsState.CTM[0][1] * this.scaling);
        }
        if (this.iw < 0) {
            this.iw *= -1;
        }
        if (this.iw < 1) {
            this.iw = 1;
        }
        if (this.ih == 0) {
            this.ih = 1;
        }
        if (this.ih < 1) {
            f2 += (float)this.ih;
            this.ih = Math.abs(this.ih);
        }
        if (graphicsState.CTM[0][0] < 0.0f) {
            f -= (float)this.iw;
        }
        if (graphicsState.CTM[0][0] == 0.0f && graphicsState.CTM[1][1] == 0.0f && graphicsState.CTM[0][1] > 0.0f && graphicsState.CTM[1][0] < 0.0f) {
            f -= (float)this.iw;
            bl2 = true;
        }
        if (graphicsState.CTM[0][0] == 0.0f && graphicsState.CTM[1][1] == 0.0f && graphicsState.CTM[0][1] > 0.0f && graphicsState.CTM[1][0] > 0.0f) {
            f -= (float)(this.pageData.getCropBoxX(n) / 2);
            f2 -= (float)this.pageData.getCropBoxY(n);
        }
        Graphics2D graphics2D = null;
        BufferedImage bufferedImage2 = bufferedImage;
        Image image = null;
        if (!this.userControlledImageScaling) {
            AffineTransform affineTransform;
            int n4 = bufferedImage.getType();
            object2 = null;
            object = graphicsState.getClippingShape();
            if (object != null) {
                if (this.scaling != 1.0f) {
                    ((Area)object).transform(AffineTransform.getScaleInstance(this.scaling, this.scaling));
                }
                object2 = ((Area)object).getBounds();
            }
            boolean bl3 = false;
            if (object2 != null && ((float)((Rectangle)object2).x > f || (float)((Rectangle)object2).y > f2 || ((RectangularShape)object2).getMaxX() < (double)(f + (float)this.iw) || ((RectangularShape)object2).getMaxY() < (double)(f2 + (float)this.ih))) {
                bl3 = true;
                n4 = 2;
            }
            image = bufferedImage.getScaledInstance(this.iw, this.ih, 4);
            bufferedImage2 = new BufferedImage(this.iw, this.ih, n4);
            graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            if (bl3) {
                affineTransform = graphics2D.getTransform();
                AffineTransform affineTransform2 = new AffineTransform();
                affineTransform2.scale(1.0, -1.0);
                affineTransform2.translate(0.0, -this.ih);
                graphics2D.transform(affineTransform2);
                graphics2D.transform(AffineTransform.getTranslateInstance(-f, -f2));
                graphics2D.setClip(graphicsState.getClippingShape());
                graphics2D.setTransform(affineTransform);
            }
            if (bl2) {
                affineTransform = new AffineTransform();
                affineTransform.scale(this.scaling, -this.scaling);
                affineTransform.translate(0.0, -this.ih);
                graphics2D.setTransform(affineTransform);
            }
        }
        this.coords = new double[]{f / this.scaling, f2 / this.scaling};
        this.correctCoords(this.coords);
        this.coords[0] = this.coords[0] * (double)this.scaling;
        this.coords[1] = this.coords[1] * (double)this.scaling;
        this.coords[1] = this.coords[1] - (double)this.ih;
        Rectangle rectangle = new Rectangle((int)(this.coords[0] / (double)this.scaling), (int)(this.coords[1] / (double)this.scaling), (int)((float)this.iw / this.scaling), (int)((float)this.ih / this.scaling));
        if (this.cropBox.intersects(rectangle)) {
            if (!this.userControlledImageScaling) {
                graphics2D.drawImage(image, 0, 0, null);
                if (this.pageRotation == 90 || this.pageRotation == 270) {
                    bufferedImage2 = this.rotateImage(bufferedImage2);
                }
            }
            bufferedImage = bufferedImage2;
            this.id = string + '_' + n;
            if (!this.embedImageAsBase64) {
                object2 = this.type == 5 ? "/img/pix/" + this.pageNumberAsString + "/" : this.fileName + "/img/" + this.pageNumberAsString + "/";
                object = new File(this.rootDir + (String)object2);
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                this.imageName = (String)object2 + string + ".png";
                try {
                    ImageIO.write((RenderedImage)bufferedImage2, "PNG", new File(this.rootDir + this.imageName));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return -2;
        }
        return -1;
    }

    protected BufferedImage rotateImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.rotate(Math.toRadians(this.pageRotation), n / 2, n2 / 2);
        int n3 = (n - n2) / 2;
        graphics2D.drawImage((Image)bufferedImage, n3, n3, null);
        bufferedImage = bufferedImage2;
        return bufferedImage;
    }

    protected String setPrecision(double d) {
        String string = String.valueOf(d);
        int n = string.indexOf(".");
        int n2 = string.length();
        int n3 = n2 - n - 1;
        if (n > 0 && n3 > this.dpCount) {
            string = this.dpCount == 0 ? string.substring(0, n + this.dpCount) : string.substring(0, n + this.dpCount + 1);
        }
        return string;
    }

    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont) {
        float f;
        int n3;
        float f2;
        int n4 = -1;
        int n5 = -1;
        TextState textState = graphicsState.getTextState();
        if (textState != null) {
            float f3 = fArray[0][0];
            f2 = textState.getCharacterSpacing();
            float f4 = textState.getWordSpacing();
            float f5 = f3 - (float)((int)f3);
            if (f3 > 1.0f) {
                if (n == 9 && f5 == 0.5f && (double)f2 > -0.2 && f4 == 0.0f && n != (int)f3) {
                    n4 = (int)f3;
                    n5 = 1;
                } else if (n == 8 && f3 > 8.0f && f2 > 0.0f && f5 < 0.3f && f4 == 0.0f) {
                    n4 = n + 1;
                    n5 = 2;
                }
            }
        }
        if (this.currentTokenNumber == this.lastTokenNumber && string.equals(" ") && this.lastGlyf.equals(" ")) {
            this.flushText();
            return;
        }
        if (Helper != null && string.length() > 3 && !StandardFonts.isValidGlyphName(string)) {
            string = Helper.mapNonstandardGlyfName(string, pdfFont);
        }
        this.Trm = fArray;
        this.ctm = graphicsState.CTM;
        if (fArray[0][0] != fArray[1][1] && fArray[1][0] == 0.0f && fArray[0][1] == 0.0f) {
            n = (int)fArray[0][0];
        }
        this.fontSize = n;
        Area area = graphicsState.getClippingShape();
        if (area != null && !area.getBounds().contains(new Point((int)fArray[2][0] + 1, (int)fArray[2][1] + 1)) && !area.getBounds().contains(new Point((int)fArray[2][0] + n / 2, (int)fArray[2][1] + n / 2))) {
            return;
        }
        if (this.rasterizeText != -1) {
            if (string.length() > 0) {
                this.rasterizeTextAsShape(fArray, n, pdfGlyph, graphicsState, pdfFont, string, affineTransform);
            }
            return;
        }
        if (string.length() == 0 || TextBlock.ignoreGlyf(string)) {
            return;
        }
        if (fArray[0][0] != fArray[1][1] && fArray[1][0] == 0.0f && fArray[0][1] == 0.0f) {
            n = (int)fArray[0][0];
        }
        if (n < 0) {
            n = -n;
        }
        f2 = (float)n * pdfFont.getWidth(-1);
        if (!pdfFont.getBaseFontName().equals(this.lastFontUsed)) {
            this.fontMapper = this.getFontMapper(pdfFont);
            this.lastFontUsed = pdfFont.getBaseFontName();
            String string2 = (String)this.embeddedFontsByFontID.get(this.lastFontUsed);
            if (string2 == null) {
                this.embeddedFontsByFontID.put(this.lastFontUsed, "browser");
            } else if (!string2.contains("browser")) {
                this.embeddedFontsByFontID.put(this.lastFontUsed, string2 + "," + "browser");
            }
        }
        int n6 = (n3 = graphicsState.getTextRenderType()) == 1 ? graphicsState.getStrokeColor().getRGB() : graphicsState.getNonstrokeColor().getRGB();
        double[] dArray = new double[]{fArray[2][0], fArray[2][1]};
        this.correctCoords(dArray);
        if (this.lastTrm != null && fArray[0][0] == this.lastTrm[0][0] && fArray[0][1] == this.lastTrm[0][1] && fArray[1][0] == this.lastTrm[1][0] && fArray[1][1] == this.lastTrm[1][1] && string.equals(this.lastGlyf)) {
            f = Math.abs(fArray[2][0] - this.lastTrm[2][0]);
            float f6 = Math.abs(fArray[2][1] - this.lastTrm[2][1]);
            float f7 = 1.0f;
            if (f < f7 && f6 < f7) {
                return;
            }
        }
        if (this.writeEveryGlyf || !this.currentTextBlock.isSameFont(n, this.fontMapper, fArray, n6) || !this.currentTextBlock.appendText(this.pageRotation, string, f2, (float)dArray[0], (float)dArray[1], this.putTextOnCanvas, this.groupGlyphsInTJ, !this.groupGlyphsInTJ || this.currentTokenNumber != this.lastTokenNumber)) {
            this.flushText();
            if (!string.equals(" ")) {
                f = (float)n * pdfFont.getCurrentFontSpaceWidth();
                this.currentTextBlock = new TextBlock(string, n, this.fontMapper, fArray, (float)dArray[0], (float)dArray[1], f2, n6, f, this.cropBox, this.putTextOnCanvas, this.pageRotationInRadians, fArray, this.ctm, n4, n5);
                if (this.convertSpacesTonbsp) {
                    this.currentTextBlock.convertSpacesTonbsp(true);
                }
                if (!this.putTextOnCanvas && this.currentTextBlock.getRotationAngle() == 0.0f) {
                    this.currentTextBlock.adjustY(-n);
                }
            } else {
                this.currentTextBlock = new TextBlock(this.putTextOnCanvas);
            }
        }
        this.lastTokenNumber = this.currentTokenNumber;
        this.lastGlyf = string;
        this.lastTrm = fArray;
    }

    private void rasterizeTextAsShape(float[][] fArray, int n, PdfGlyph pdfGlyph, GraphicsState graphicsState, PdfFont pdfFont, String string, AffineTransform affineTransform) {
        if (pdfGlyph != null && pdfGlyph.getShape() != null && !string.equals(" ")) {
            int n2;
            int n3;
            String string2;
            GraphicsState graphicsState2 = graphicsState;
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetterOrDigit(string.charAt(i))) {
                    bl = true;
                }
                if (bl) break;
            }
            if (!Character.isLetter((string2 = bl ? pdfFont.getFontID() + Integer.toHexString(string.charAt(0)) : pdfFont.getFontID() + string).charAt(0))) {
                string2 = "s" + string2;
            }
            String string3 = pdfFont.getBaseFontName() + '.' + string2;
            boolean bl2 = this.glyfsRasterized.containsKey(string3);
            Area area = (Area)pdfGlyph.getShape().clone();
            graphicsState2.setClippingShape(null);
            graphicsState2.setFillType(graphicsState.getTextRenderType());
            float[] fArray2 = new float[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]};
            float f = 1000.0f;
            float[] fArray3 = pdfFont.getFontBounds();
            if (area.getBounds().height > 2000) {
                f *= 100.0f;
            }
            for (int i = 0; i < 4; ++i) {
                fArray2[i] = fArray2[i] / f;
            }
            this.writeCustom(2, "pdf.save();");
            double[] dArray = new double[]{fArray[2][0], fArray[2][1]};
            this.correctCoords(dArray);
            double d = 0.0;
            double d2 = 0.0;
            if (pdfFont.getFontType() == 1228944677) {
                double d3;
                double d4 = fArray3[3] - fArray3[1];
                if (d4 > 1000.0) {
                    d2 = (double)n + (d4 - 1000.0) / 100.0;
                }
                if ((d3 = (double)(fArray3[2] - fArray3[0])) > 1000.0) {
                    d = (double)n - (double)n * ((d3 - 1000.0) / 1000.0);
                }
            }
            switch (this.pageRotation) {
                case 90: {
                    n3 = (int)((double)((int)(dArray[0] * (double)1.33f)) + d);
                    n2 = (int)(((double)this.cropBox.height - dArray[1]) * (double)1.33f - d2);
                    break;
                }
                default: {
                    n2 = (int)((double)((int)(dArray[0] * (double)1.33f)) + d);
                    n3 = (int)(dArray[1] * (double)1.33f - d2);
                }
            }
            if (fArray[0][1] == 0.0f && fArray[1][0] == 0.0f) {
                this.writeCustom(2, "pdf.translate(" + n2 + "," + n3 + ");");
                this.writeCustom(2, "pdf.scale(" + fArray2[0] + " , " + fArray2[3] + ");");
            } else {
                this.writeCustom(2, "pdf.transform(" + fArray2[0] + " , " + -fArray2[1] + ", " + -fArray2[2] + " , " + fArray2[3] + ", " + n2 + " , " + n3 + ");");
            }
            this.writeCustom(2, string2 + "(pdf);");
            int n4 = graphicsState.getFillType();
            if (n4 == 2 || n4 == 3) {
                this.writeCustom(2, "pdf.fillStyle = '" + OutputShape.rgbToCSSColor(graphicsState.nonstrokeColorSpace.getColor().getRGB()) + "';");
                this.writeCustom(2, "pdf.fill();");
            }
            if (n4 == 1 || n4 == 1) {
                this.writeCustom(2, "pdf.strokeStyle = '" + OutputShape.rgbToCSSColor(graphicsState.strokeColorSpace.getColor().getRGB()) + "';");
                this.writeCustom(2, "pdf.stroke();");
            }
            if (!bl2) {
                this.drawNonPatternedShape(area, graphicsState2, 21610, string2);
                this.glyfsRasterized.put(string3, "x");
            }
            this.writeCustom(2, "pdf.restore();");
        }
    }

    protected FontMapper getFontMapper(PdfFont pdfFont) {
        return null;
    }

    protected void flushText() {
    }

    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        if (shape.getBounds().height < 1 && graphicsState.getLineWidth() * graphicsState.CTM[0][0] > 0.5f) {
            shape = new Rectangle(shape.getBounds().x, shape.getBounds().y, shape.getBounds().width, 1);
        }
        this.ctm = graphicsState.CTM;
        if (!this.isObjectVisible(shape.getBounds(), graphicsState.getClippingShape())) {
            return;
        }
        this.flushText();
        if (graphicsState.getNonstrokeColor().isPattern() || graphicsState.nonstrokeColorSpace.getID() == 1146450818) {
            this.drawPatternedShape(shape, graphicsState);
        } else {
            this.drawNonPatternedShape(shape, graphicsState, n, null);
        }
    }

    protected void drawNonPatternedShape(Shape shape, GraphicsState graphicsState, int n, String string) {
    }

    protected void drawPatternedShape(Shape shape, GraphicsState graphicsState) {
    }

    private boolean isObjectVisible(Rectangle rectangle, Area area) {
        boolean bl = true;
        if (bl && this.dx == 0 && this.dy == 0 && this.dr == 0) {
            Rectangle rectangle2 = null;
            rectangle2 = area != null ? area.getBounds() : null;
            if (this.cropBox != null && !this.cropBox.intersects(rectangle) && Math.abs(this.cropBox.getMaxX() - rectangle.getMaxX()) > 1.0 || rectangle2 != null && !rectangle2.intersects(rectangle) && Math.abs(rectangle2.getMaxX() - rectangle.getMaxX()) > 1.0) {
                return false;
            }
        }
        return true;
    }

    public final void drawXForm(DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
        this.flushText();
    }

    protected void completeOutput() {
    }

    public void setOutputDir(String string, String string2, String string3) {
        this.rootDir = string;
        this.fileName = string2;
        this.pageNumberAsString = string3;
    }

    protected String coordsToStringParam(double[] dArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = string + ",";
            }
            string = string + this.setPrecision(dArray[i]);
        }
        return string;
    }

    private void correctCoords(double[] dArray) {
        dArray[0] = dArray[0] - this.midPoint.getX();
        dArray[0] = dArray[0] + (double)(this.cropBox.width / 2);
        dArray[1] = dArray[1] - this.midPoint.getY();
        dArray[1] = 0.0 - dArray[1];
        dArray[1] = dArray[1] + (double)(this.cropBox.height / 2);
    }

    protected static String rgbToColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return "rgb(" + n2 + "," + n3 + "," + n4 + ")";
    }

    protected void drawTextArea() {
    }

    protected void drawPageBorder() {
    }

    public void flagCommand(int n, int n2) {
        switch (n) {
            case 16980: {
                break;
            }
            case 21610: {
                this.currentTokenNumber = n2;
            }
        }
    }

    protected String replaceTokenValues(String string) {
        String string2 = this.rootDir.substring(0, this.rootDir.length() - 1);
        int n = string2.lastIndexOf("\\");
        int n2 = string2.lastIndexOf("/");
        if (n2 > n) {
            n = n2;
        }
        string2 = string2.substring(n + 1);
        if (string != null && string.contains("$")) {
            String string3 = string2;
            String string4 = this.pageNumberAsString;
            String string5 = String.valueOf(this.pageData.getPageCount());
            string = string.replace("$fileName$", string3);
            string = string.replace("$currentPageNumber$", string4);
            string = string.replace("$totalPageNumber$", string5);
        }
        return string;
    }

    public boolean isScalingControlledByUser() {
        return this.userControlledImageScaling;
    }
}

