/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.formData.ComponentData;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.StringUtils;

public class ReadOnlyTextIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private int alignment = -1;
    private static final long serialVersionUID = 8946195842453749725L;
    private BufferedImage rootImage = null;
    private BufferedImage finalImage = null;
    private PdfObject fakeObj = null;
    private boolean textChanged = false;
    private String preFontStream = "";
    private String betweenFontAndTextStream = "";
    private String afterTextStream = "";
    private String text = "";
    private String fontName = "";
    private String fontSize = "";
    private String fontCommand = "";
    private String fullCommandString;
    private PdfObjectReader currentpdffile = null;
    private int subtype = -1;
    private PdfObject resources;

    public ReadOnlyTextIcon(int n, PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        super(n);
        this.currentpdffile = pdfObjectReader;
        this.resources = pdfObject;
    }

    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage bufferedImage = this.finalImage;
        return bufferedImage;
    }

    public BufferedImage drawToBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        this.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = (BufferedImage)this.getImage();
        if (bufferedImage == null) {
            return;
        }
        if (component != null && component.isEnabled()) {
            graphics.setColor(component.getBackground());
        } else {
            graphics.setColor(Color.gray);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int n3 = this.iconWidth;
            int n4 = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                n3 = this.iconHeight;
                n4 = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float f;
                float f2 = (float)n3 / (float)bufferedImage.getWidth(null);
                if (f2 < (f = (float)n4 / (float)bufferedImage.getHeight(null))) {
                    n3 = (int)(f2 * (float)bufferedImage.getWidth(null));
                    n4 = (int)(f2 * (float)bufferedImage.getHeight(null));
                } else {
                    n3 = (int)(f * (float)bufferedImage.getWidth(null));
                    n4 = (int)(f * (float)bufferedImage.getHeight(null));
                }
            }
            int n5 = 0;
            int n6 = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    n5 = (this.iconHeight - n3) / 2;
                    n6 = (this.iconWidth - n4) / 2;
                } else {
                    n5 = (this.iconWidth - n3) / 2;
                    n6 = (this.iconHeight - n4) / 2;
                }
            }
            if (this.alignment == 2) {
                n5 = 0;
            }
            int n7 = 0;
            n7 = this.displaySingle ? ReadOnlyTextIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            if (n7 == 270) {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(-n3, 0);
                graphics2D.drawImage(bufferedImage, -n5, n6, n3, n4, null);
            } else if (n7 == 90) {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0, -n4);
                graphics2D.drawImage(bufferedImage, n5, -n6, n3, n4, null);
            } else if (n7 == 180) {
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-n3, -n4);
                graphics2D.drawImage(bufferedImage, -n5, -n6, n3, n4, null);
            } else {
                graphics2D.drawImage(bufferedImage, n5, n6, n3, n4, null);
            }
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        graphics2D.translate(-n, -n2);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int n = this.iconWidth;
        int n2 = this.iconHeight;
        if (this.textChanged || this.rootImage == null || n > this.rootImage.getWidth(null) || n2 > this.rootImage.getHeight(null) || (float)n < (float)this.rootImage.getWidth(null) / MAXSCALEFACTOR || (float)n2 < (float)this.rootImage.getHeight(null) / MAXSCALEFACTOR) {
            this.rootImage = FormStream.decode(this.currentpdffile, this.fakeObj, this.subtype, n, n2, 0, this.iconRotation, 1.0f);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    public void setFont(String string, float f, String string2) {
        this.fontName = string;
        this.fontSize = string.length() != 0 ? " " + f + ' ' : "";
        this.fontCommand = string2;
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.text)) {
            return;
        }
        this.textChanged = true;
        this.text = string;
        this.fullCommandString = this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + "(" + this.text + ")Tj " + this.afterTextStream;
        this.fakeObj.setDecodedStream(StringUtils.toBytes(this.fullCommandString));
    }

    public String getText() {
        return this.text;
    }

    public boolean decipherAppObject(FormObject formObject) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        String string = "";
        PdfObject pdfObject = formObject.getDictionary(4384).getDictionary(30);
        if (pdfObject != null && (object = pdfObject.getDecodedStream()) != null) {
            int n5 = -1;
            int n6 = -1;
            n4 = -1;
            n3 = -1;
            n2 = ((Object)object).length;
            for (n = 0; n < n2 - 1; ++n) {
                if ((char)object[n] != 'T' || (char)object[n + 1] != 'f' || n + 2 < n2 && object[n + 2] != 10 && object[n + 2] != 13 && object[n + 2] != 32) continue;
                n6 = n + 2;
                break;
            }
            if (n6 == -1) {
                n5 = 0;
                n6 = 0;
            } else {
                for (n = n6 - 3; n > n5; --n) {
                    if (object[n] != 47) continue;
                    n5 = n;
                    break;
                }
            }
            for (n = n6; n < n2 - 1; ++n) {
                if ((char)object[n] != 'T' || (char)object[n + 1] != 'j' || n + 2 < n2 && object[n + 2] != 10 && object[n + 2] != 13 && object[n + 2] != 32) continue;
                n3 = n + 2;
                break;
            }
            if (n3 == -1) {
                n4 = n6;
                n3 = n6;
            } else {
                n4 = n6;
                n = 0;
                boolean bl = false;
                for (int i = n3 - 3; i > n4; --i) {
                    if (object[i] == 32 || object[i] == 10 || object[i] == 13) {
                        if (!bl || n != 0) continue;
                        n4 = i + 1;
                        break;
                    }
                    if (object[i] == 41) {
                        ++n;
                        continue;
                    }
                    if (object[i] == 40) {
                        if (--n != 0 || !bl) continue;
                        n4 = i;
                        break;
                    }
                    bl = true;
                }
            }
            for (n = n6; n < n4; ++n) {
                if (object[n] == 32 || object[n] == 10 || object[n] == 13 || object[n] > 47 && object[n] < 58) continue;
                if (object[n] == 103 && n + 1 < n4 && (object[n + 1] == 32 || object[n + 1] == 10 || object[n + 1] == 13)) {
                    n6 = n + 1;
                    break;
                }
                if (object[n] != 114 || n + 2 >= n4 || object[n + 1] != 103 || object[n + 2] != 32 && object[n + 2] != 10 && object[n + 2] != 13) break;
                n6 = n + 2;
                break;
            }
            if (n3 != n6) {
                if (n6 == 0) {
                    this.preFontStream = new String((byte[])object, 0, n4);
                    this.betweenFontAndTextStream = " ";
                } else {
                    this.preFontStream = new String((byte[])object, 0, n5);
                    string = new String((byte[])object, n5, n6 - n5);
                    this.betweenFontAndTextStream = new String((byte[])object, n6, n4 - n6);
                }
                this.text = new String((byte[])object, n4, n3 - 3 - n4);
                this.afterTextStream = new String((byte[])object, n3, ((Object)object).length - n3);
            } else if (n6 == 0) {
                this.preFontStream = new String((byte[])object);
            } else {
                this.preFontStream = new String((byte[])object, 0, n5);
                string = new String((byte[])object, n5, n6 - n5);
                this.betweenFontAndTextStream = new String((byte[])object, n6, ((Object)object).length - n6);
            }
        }
        if ((object = (Object)formObject.getTextStreamValue(5137)) == null || ((String)object).length() == 0) {
            if (string.length() != 0) {
                formObject.setTextStreamValue(5137, StringUtils.toBytes(string));
                FormStream.decodeFontCommandObj(string, formObject);
            }
            return false;
        }
        if (string.length() == 0) {
            string = ((String)object).trim();
        } else {
            String string2 = ((String)object).substring(0, ((String)object).indexOf(" "));
            String string3 = string.substring(string.indexOf(" "), string.length());
            string = string2 + string3;
            string.trim();
        }
        this.fakeObj = new XObject(formObject.getObjectRefAsString());
        if (this.resources != null) {
            this.fakeObj.setDictionary(2004251818, this.resources);
        }
        Rectangle rectangle = formObject.getBoundingRectangle();
        this.fakeObj.setFloatArray(303185736, new float[]{rectangle.width, 0.0f, 0.0f, rectangle.height, 0.0f, 0.0f});
        this.subtype = -1;
        if (this.preFontStream.length() == 0 || this.preFontStream.indexOf("BT") == -1) {
            this.preFontStream = "BT 0 0 0 RG 1 TFS ";
            this.betweenFontAndTextStream = " 1 0 0 1 0 0 Tm ";
            this.afterTextStream = "";
        }
        int n7 = string.indexOf(32);
        n4 = -1;
        n3 = 0;
        for (n2 = n7; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            if (n == 32 || n == 10 || n == 13) {
                if (n3 == 0) continue;
                n4 = n2;
                break;
            }
            n3 = 1;
        }
        float f = 12.0f;
        if (n4 != -1) {
            this.fontName = string.substring(0, n7);
            this.fontCommand = string.substring(n4);
            f = Float.parseFloat(string.substring(n7, n4));
        }
        if (this.fontName.length() == 0) {
            Font font = formObject.getTextFont();
            this.fontName = "/" + font.getFontName();
            this.fontCommand = "Tf ";
        }
        if (f == 0.0f || f == -1.0f) {
            f = ComponentData.calculateFontSize(rectangle.height, rectangle.width, false, this.text);
        }
        this.fontSize = " " + f + ' ';
        return true;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }
}

