/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.TocFragmentServlet;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class ChildLinkInserter {
    private HttpServletRequest req;
    private OutputStream out;
    private static final String NO_CHILDREN = "no_child_topics";
    private static final String HAS_CHILDREN = "has_child_topics";
    private AbstractHelpScope scope;

    public ChildLinkInserter(HttpServletRequest req, OutputStream out) {
        this.req = req;
        this.out = out;
        this.scope = RequestScope.getScope(req, null, false);
    }

    public void addContents(String encoding) throws IOException {
        String path = this.req.getParameter("cp");
        ITopic[] subtopics = this.getSubtopics();
        if (subtopics.length == 0) {
            return;
        }
        StringBuilder links = new StringBuilder("\n<ul class=\"childlinks\">\n");
        int i = 0;
        while (i < subtopics.length) {
            if (ScopeUtils.showInTree((ITopic)subtopics[i], (AbstractHelpScope)this.scope)) {
                links.append("\n<li><a href=\"");
                Object href = subtopics[i].getHref();
                if (href == null) {
                    href = path != null && path.length() > 0 ? "/../nav/" + path + "_" + i : "nav.html";
                } else {
                    href = XMLGenerator.xmlEscape((String)href);
                    if (path != null && path.length() > 0) {
                        href = TocFragmentServlet.fixupHref((String)href, path + "_" + i);
                    }
                }
                links.append(this.getBackpath(this.req.getPathInfo()));
                links.append((String)href);
                links.append("\">" + subtopics[i].getLabel() + "</a></li>\n");
            }
            ++i;
        }
        links.append("\n</ul>\n");
        String linkString = links.toString();
        try {
            if (encoding != null) {
                this.out.write(linkString.getBytes(encoding));
            } else {
                this.out.write(linkString.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.out.write(linkString.getBytes());
        }
    }

    private ITopic[] getSubtopics() {
        Toc[] tocs;
        String locale = UrlUtil.getLocale(this.req, null);
        String pathInfo = this.req.getPathInfo();
        String servletPath = this.req.getServletPath();
        if ("/nav".equals(servletPath)) {
            return new ITopic[0];
        }
        Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(locale);
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            Toc toc = tocArray[n2];
            if (pathInfo.equals(toc.getTopic())) {
                return toc.getTopics();
            }
            ITopic topic = toc.getTopic(pathInfo);
            if (topic != null) {
                return topic.getSubtopics();
            }
            ++n2;
        }
        return new ITopic[0];
    }

    private String getBackpath(String path) {
        int num = IPath.fromOSString((String)path).segmentCount() - 1;
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < num) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append("..");
            ++i;
        }
        return buf.toString();
    }

    public void addStyle() throws IOException {
        ITopic[] subtopics;
        ITopic[] iTopicArray = subtopics = this.getSubtopics();
        int n = subtopics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic subtopic = iTopicArray[n2];
            if (ScopeUtils.showInTree((ITopic)subtopic, (AbstractHelpScope)this.scope)) {
                this.out.write(HAS_CHILDREN.getBytes(StandardCharsets.UTF_8));
                return;
            }
            ++n2;
        }
        this.out.write(NO_CHILDREN.getBytes(StandardCharsets.UTF_8));
    }
}

