/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.queue.IStateQueue;

public abstract class StateQueue
implements IStateQueue {
    protected long len = 0L;
    private int numWaiting = 0;
    private volatile boolean finish = false;
    private boolean stop = false;
    private Object mu = new Object();

    @Override
    public final void enqueue(TLCState state) {
        this.enqueueInner(state);
        ++this.len;
    }

    @Override
    public final TLCState dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        TLCState state = this.dequeueInner();
        --this.len;
        return state;
    }

    @Override
    public final synchronized void sEnqueue(TLCState state) {
        this.enqueueInner(state);
        ++this.len;
        if (this.numWaiting > 0 && !this.stop) {
            this.notifyAll();
        }
    }

    @Override
    public final synchronized void sEnqueue(TLCState[] states) {
        for (int i = 0; i < states.length; ++i) {
            this.enqueueInner(states[i]);
        }
        this.len += (long)states.length;
        if (this.numWaiting > 0 && !this.stop) {
            this.notifyAll();
        }
    }

    @Override
    public final synchronized void sEnqueue(StateVec stateVec) {
        int cnt = 0;
        for (int j = 0; j < stateVec.size(); ++j) {
            TLCState state = stateVec.elementAt(j);
            if (state == null) continue;
            this.enqueueInner(state);
            ++cnt;
        }
        this.len += (long)cnt;
        if (this.numWaiting > 0 && !this.stop) {
            this.notifyAll();
        }
    }

    @Override
    public final synchronized TLCState sPeek() {
        if (this.isAvail()) {
            return this.peekInner();
        }
        return null;
    }

    @Override
    public final synchronized TLCState sDequeue() {
        if (this.isAvail()) {
            TLCState state = this.dequeueInner();
            assert (state != null) : "Null state found on queue";
            --this.len;
            return state;
        }
        return null;
    }

    @Override
    public final synchronized TLCState[] sDequeue(int cnt) {
        assert (cnt > 0) : "Nonpositive number of states requested.";
        if (this.isAvail()) {
            int idx;
            if ((long)cnt > this.len) {
                cnt = (int)this.len;
            }
            TLCState[] states = new TLCState[cnt];
            for (idx = 0; idx < cnt && this.len > 0L; ++idx) {
                states[idx] = this.dequeueInner();
                --this.len;
            }
            if (idx == cnt) {
                return states;
            }
            TLCState[] res = new TLCState[idx];
            for (int i = 0; i < idx; ++i) {
                res[i] = states[i];
            }
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isAvail() {
        if (this.finish) {
            return false;
        }
        while (this.isEmpty() || this.stop) {
            ++this.numWaiting;
            if (this.numWaiting >= TLCGlobals.getNumWorkers()) {
                if (this.isEmpty()) {
                    --this.numWaiting;
                    return false;
                }
                Object object = this.mu;
                synchronized (object) {
                    this.mu.notify();
                }
            }
            try {
                this.wait();
            }
            catch (Exception e) {
                MP.printError(1000, "making a worker wait for a state from the queue", (Throwable)e);
                System.exit(1);
            }
            --this.numWaiting;
            if (!this.finish) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finishAll() {
        this.finish = true;
        this.notifyAll();
        Object object = this.mu;
        synchronized (object) {
            this.mu.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean suspendAll() {
        boolean needWait = false;
        Object object = this;
        synchronized (object) {
            if (this.finish) {
                return false;
            }
            this.stop = true;
            needWait = this.needsWaiting();
        }
        while (needWait) {
            object = this.mu;
            synchronized (object) {
                try {
                    if (this.finish) {
                        return false;
                    }
                    this.mu.wait();
                }
                catch (Exception e) {
                    MP.printError(1000, "waiting for a worker to wake up", (Throwable)e);
                    System.exit(1);
                }
            }
            object = this;
            synchronized (object) {
                if (this.finish) {
                    return false;
                }
                needWait = this.needsWaiting();
            }
        }
        return true;
    }

    private boolean needsWaiting() {
        return this.numWaiting < TLCGlobals.getNumWorkers();
    }

    @Override
    public final synchronized void resumeAll() {
        this.stop = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAllStuck() {
        Object object;
        if (this.stop) {
            object = this.mu;
            synchronized (object) {
                this.mu.notifyAll();
            }
        }
        if (!this.stop && !this.isEmpty() && this.numWaiting > 0) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    @Override
    public final long size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len < 1L;
    }

    abstract void enqueueInner(TLCState var1);

    abstract TLCState dequeueInner();

    abstract TLCState peekInner();

    @Override
    public abstract void beginChkpt() throws IOException;

    @Override
    public abstract void commitChkpt() throws IOException;

    @Override
    public abstract void recover() throws IOException;

    @Override
    public void delete() throws IOException {
    }
}

