/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.coverage;

import tla2sany.semantic.LetInNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SubstInNode;
import tla2sany.st.Location;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.coverage.CostModelNode;

public final class ActionWrapper
extends CostModelNode {
    private final Action action;
    private final Relation relation;

    public ActionWrapper(Action action, Relation rel) {
        this.action = action;
        this.relation = rel;
    }

    @Override
    protected Location getLocation() {
        if (this.action.isDeclared()) {
            return this.action.getDeclaration();
        }
        return this.action.pred.getLocation();
    }

    private String printLocation() {
        Location actual;
        if (!this.action.isDeclared()) {
            return this.action.toString();
        }
        Location declaration = this.action.getDeclaration();
        Location definition = this.action.getOpDef().getBody().getLocation();
        if (definition.equals(actual = this.action.pred.getLocation())) {
            return String.format("<%s %s>", this.action.getName(), declaration);
        }
        return String.format("<%s %s (%s %s %s %s)>", this.action.getName(), declaration, actual.beginLine(), actual.beginColumn(), actual.endLine(), actual.endColumn());
    }

    @Override
    public CostModelNode getRoot() {
        return this;
    }

    @Override
    public final CostModel get(SemanticNode eon) {
        if (eon instanceof SubstInNode) {
            SubstInNode sin = (SubstInNode)eon;
            return this.children.getOrDefault(sin.getBody(), this);
        }
        if (eon instanceof LetInNode) {
            LetInNode lin = (LetInNode)eon;
            return this.children.getOrDefault(lin.getBody(), this);
        }
        return this.children.getOrDefault(eon, this);
    }

    @Override
    SemanticNode getNode() {
        return this.action.pred;
    }

    @Override
    boolean isRoot() {
        return true;
    }

    @Override
    public CostModel report() {
        if (this.relation == Relation.PROP) {
            assert (this.getEvalCount() == 0L && this.secondary.getCount() == 0L);
            MP.printMessage(2774, new String[]{this.printLocation()});
        } else if (this.relation == Relation.INIT) {
            MP.printMessage(2773, this.printLocation(), String.valueOf(this.getEvalCount()), String.valueOf(this.getEvalCount() + this.secondary.getCount()));
        } else if (this.relation == Relation.CONSTRAINT) {
            MP.printMessage(2778, this.printLocation(), String.valueOf(this.secondary.getCount()), String.valueOf(this.getEvalCount() + this.secondary.getCount()));
        } else {
            MP.printMessage(2772, this.printLocation(), String.valueOf(this.secondary.getCount()), String.valueOf(this.getEvalCount()));
        }
        assert (this.action.pred instanceof SubstInNode || this.action.pred instanceof LetInNode ? !this.children.isEmpty() : this.children.size() == 1);
        this.children.values().forEach(c -> c.report());
        return this;
    }

    public boolean is(Relation r) {
        return r == this.relation;
    }

    public static enum Relation {
        INIT,
        NEXT,
        PROP,
        CONSTRAINT;

    }
}

