/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.debug.DebugTLCVariable;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCCapabilities;
import tlc2.debug.TLCDebugger;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.debug.TLCStateStackFrame;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.util.SetOfStates;
import tlc2.value.impl.RecordValue;

public class TLCNextStatesStackFrame
extends TLCStateStackFrame {
    protected final transient Action a;
    protected final transient Map<Integer, TLCState> idToStateMap = new HashMap<Integer, TLCState>();
    protected final transient INextStateFunctor fun;
    public static final String SCOPE = "Successors";

    public TLCNextStatesStackFrame(TLCStackFrame parent, SemanticNode node, Context ctxt, Tool tool, TLCState s, INextStateFunctor fun, Action act) {
        super(parent, node, ctxt, tool, s);
        this.a = act;
        this.fun = fun;
        this.setName(node.toString());
    }

    @Override
    protected boolean addT() {
        return true;
    }

    @Override
    protected String getScope() {
        return SCOPE;
    }

    @Override
    Variable[] getStateVariables() {
        return new Variable[]{this.toVariable()};
    }

    @Override
    public boolean handle(TLCDebugger debugger) {
        return true;
    }

    @Override
    protected boolean hasScope() {
        return !this.getSuccessors().isEmpty();
    }

    protected Set<TLCState> getSuccessors() {
        return this.fun.getStates().toSet();
    }

    @Override
    public void preHalt(TLCDebugger debugger) {
        debugger.sendCapabilities(TLCCapabilities.NO_STEP_BACK);
        debugger.setGranularity(IDebugTarget.Granularity.State);
    }

    @Override
    public void postHalt(TLCDebugger debugger) {
        debugger.sendCapabilities(TLCCapabilities.STEP_BACK);
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
    }

    @Override
    public Variable[] getVariables(int vr) {
        if (vr == this.stateId) {
            return this.tool.eval(() -> {
                TreeSet<TLCState> successors = new TreeSet<TLCState>((s1, s2) -> {
                    String a2;
                    String a1 = s1.hasAction() ? s1.getAction().getLocation() : "<???>";
                    int cmp = a1.compareTo(a2 = s2.hasAction() ? s2.getAction().getLocation() : "<???>");
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.toString().compareTo(s2.toString());
                });
                successors.addAll(this.getSuccessors());
                Variable[] vars = new Variable[successors.size()];
                int width = String.valueOf(successors.size()).length();
                Iterator itr = successors.iterator();
                for (int i = 0; i < vars.length; ++i) {
                    TLCState t = (TLCState)itr.next();
                    RecordValue r = new RecordValue(t);
                    vars[i] = this.getStateAsVariable(r, t.getLevel() + "." + String.format("%0" + width + "d", i + 1) + ": " + (t.hasAction() ? t.getAction().getLocation() : "<???>"));
                    this.idToStateMap.put(vars[i].getVariablesReference(), t);
                }
                return vars;
            });
        }
        if (vr == this.stateId + 1 && TLCGlobals.simulator != null) {
            return this.tool.eval(() -> {
                TLCState t = this.getT();
                TLCStateInfo[] prefix = (TLCStateInfo[])TLCGlobals.simulator.getUncompressedTrace(t).stream().filter(s -> s.allAssigned()).map(s -> new TLCStateInfo((TLCState)s)).collect(Collectors.toList()).toArray(TLCStateInfo[]::new);
                int width = String.valueOf(prefix.length).length();
                ArrayDeque<DebugTLCVariable> trace = new ArrayDeque<DebugTLCVariable>();
                for (int i = prefix.length - 1; i >= 0; --i) {
                    TLCStateInfo ti = prefix[i];
                    DebugTLCVariable stateAsVariable = this.getStateAsVariable(new RecordValue(ti.state), String.format("%0" + width + "d", ti.state.getLevel()) + ": " + ti.info.toString());
                    this.idToStateMap.put(stateAsVariable.getVariablesReference(), ti.state);
                    trace.add(stateAsVariable);
                }
                return trace.toArray(new Variable[trace.size()]);
            });
        }
        return super.getVariables(vr);
    }

    Variable[] getTraceVariables() {
        return this.getVariables(this.stateId + 1);
    }

    Variable[] getSuccessorVariables() {
        return this.getVariables(this.stateId);
    }

    private static int hammingDistance(TLCState s1, TLCState s2) {
        char[] a = s1.toString().toCharArray();
        char[] b = s2.toString().toCharArray();
        int minLen = Math.min(a.length, b.length);
        int distance = Math.abs(a.length - b.length);
        for (int i = 0; i < minLen; ++i) {
            distance += (a[i] ^ b[i]) == 0 ? 0 : 1;
        }
        return distance;
    }

    @Override
    public synchronized CompletableFuture<Void> stepIn(TLCDebugger debugger) {
        this.fun.setElement(this.fun.getStates().toSet().stream().min(Comparator.comparingInt(s -> TLCNextStatesStackFrame.hammingDistance(this.getS(), s))).orElseThrow());
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepOver(TLCDebugger debugger) {
        this.fun.setElement(this.fun.getStates().toSet().stream().max(Comparator.comparingInt(s -> TLCNextStatesStackFrame.hammingDistance(this.getS(), s))).orElseThrow());
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepOut(TLCDebugger debugger) {
        TLCState predecessor = this.getS().getPredecessor();
        if (predecessor == null) {
            this.fun.halt();
        } else {
            this.fun.setElement(predecessor);
        }
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
        debugger.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> gotoState(TLCDebugger debugger, int id) {
        TLCState tlcState = this.idToStateMap.get(id);
        if (tlcState != null) {
            this.fun.setElement(tlcState);
        }
        return super.gotoState(debugger, id);
    }

    @Override
    protected boolean matchesExpression(TLCSourceBreakpoint bp, boolean fire) {
        SetOfStates states = this.fun.getStates();
        return (states.size() == 0 ? Stream.of(TLCState.Empty) : states.toSet().stream()).filter(t -> bp.matchesExpression(this.tool, this.getS(), (TLCState)t, this.getContext(), fire)).findAny().isPresent();
    }
}

