/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.CapabilitiesEventArguments;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionBreakpointsFilter;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.ReverseContinueArguments;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackFramePresentationHint;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepBackArguments;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tlc2.TLCGlobals;
import tlc2.debug.AbstractDebugger;
import tlc2.debug.AttachingDebugger;
import tlc2.debug.GotoStateEvent;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCActionStackFrame;
import tlc2.debug.TLCCapabilities;
import tlc2.debug.TLCInitStatesStackFrame;
import tlc2.debug.TLCNextStatesStackFrame;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.debug.TLCStateStackFrame;
import tlc2.debug.TLCSyntheticStateStackFrame;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.StatefulRuntimeException;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.Value;

public abstract class TLCDebugger
extends AbstractDebugger
implements IDebugTarget {
    protected static Logger LOGGER = Logger.getLogger(TLCDebugger.class.getName());
    protected PipedOutputStream pipedOutputStream;
    protected Launcher<IDebugProtocolClient> launcher;
    private Tool tool;
    protected final Map<String, List<TLCSourceBreakpoint>> breakpoints = new HashMap<String, List<TLCSourceBreakpoint>>();
    protected final LinkedList<TLCStackFrame> stack = new LinkedList();
    private volatile TLCStackFrame sourceFrame;
    private volatile IDebugTarget.Step step = IDebugTarget.Step.In;
    private volatile IDebugTarget.Granularity granularity = IDebugTarget.Granularity.Formula;
    private volatile boolean haltExp;
    private volatile boolean haltInv;
    private volatile TLCSourceBreakpoint haltSpec;
    private volatile TLCSourceBreakpoint haltUnsat;
    private volatile boolean executionIsHalted = false;

    public TLCDebugger() {
        this.step = IDebugTarget.Step.In;
        this.haltExp = true;
        this.haltInv = true;
    }

    public TLCDebugger(IDebugTarget.Step s, boolean halt) {
        this.step = s;
        this.haltExp = halt;
        this.haltInv = halt;
    }

    TLCDebugger(IDebugTarget.Step s, boolean halt, boolean executionIsHalted) {
        this.step = s;
        this.haltExp = halt;
        this.haltInv = halt;
        this.executionIsHalted = executionIsHalted;
    }

    @Override
    public IDebugTarget setTool(Tool tool) {
        this.tool = tool;
        return this;
    }

    @Override
    public synchronized CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        LOGGER.finer("initialize");
        TLCCapabilities capabilities = new TLCCapabilities();
        capabilities.setSupportsGotoState(TLCGlobals.simulator != null);
        capabilities.setSupportsEvaluateForHovers(true);
        capabilities.setSupportsTerminateRequest(true);
        capabilities.setSupportsExceptionInfoRequest(false);
        capabilities.setExceptionBreakpointFilters(this.getExceptionBreakpointFilters());
        capabilities.setSupportsExceptionFilterOptions(true);
        capabilities.setSupportsHitConditionalBreakpoints(true);
        capabilities.setSupportsConditionalBreakpoints(true);
        capabilities.setSupportsLogPoints(false);
        capabilities.setSupportsStepBack(true);
        capabilities.setSupportsValueFormattingOptions(false);
        capabilities.setSupportsSteppingGranularity(false);
        capabilities.setSupportsGotoTargetsRequest(false);
        capabilities.setSupportsDataBreakpoints(false);
        capabilities.setSupportsFunctionBreakpoints(false);
        capabilities.setSupportsInstructionBreakpoints(false);
        capabilities.setSupportsDisassembleRequest(false);
        capabilities.setSupportsClipboardContext(true);
        return CompletableFuture.completedFuture(capabilities);
    }

    private ExceptionBreakpointsFilter[] getExceptionBreakpointFilters() {
        ExceptionBreakpointsFilter filter = new ExceptionBreakpointsFilter();
        filter.setDefault_(this.haltExp);
        filter.setFilter("ExceptionBreakpointsFilter");
        filter.setLabel("Halt (break) on exceptions");
        filter.setDescription("TLC will halt when it encounters a silly expression");
        ExceptionBreakpointsFilter unsat = new ExceptionBreakpointsFilter();
        unsat.setDefault_(this.haltUnsat != null);
        unsat.setFilter("UnsatisfiedBreakpointsFilter");
        unsat.setLabel("Halt (break) on unsatisfied");
        unsat.setDescription("TLC will halt when a successor state does not satisfy the next-state relation.");
        unsat.setConditionDescription("A constant, state, or action level formula");
        unsat.setSupportsCondition(true);
        ExceptionBreakpointsFilter spec = new ExceptionBreakpointsFilter();
        spec.setDefault_(this.haltSpec != null);
        spec.setFilter("SpecBreakpointsFilter");
        spec.setLabel("Halt (break) after Init and Next");
        spec.setDescription("TLC will halt after initial- and next-states have been generated.");
        spec.setConditionDescription("Init: constant or state formula. Next: constant, state, or action-level formula.");
        spec.setSupportsCondition(true);
        if (this.tool.getMode() == Tool.Mode.MC_DEBUG) {
            return new ExceptionBreakpointsFilter[]{filter, unsat, spec};
        }
        ExceptionBreakpointsFilter violations = new ExceptionBreakpointsFilter();
        violations.setDefault_(this.haltInv);
        violations.setFilter("InvariantBreakpointsFilter");
        violations.setLabel("Halt (break) on violations");
        violations.setDescription("TLC will halt when an invariant is violated.");
        return new ExceptionBreakpointsFilter[]{filter, unsat, violations, spec};
    }

    @Override
    public synchronized CompletableFuture<SetExceptionBreakpointsResponse> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        Set asSet = Arrays.stream(args.getFilterOptions()).map(fo -> fo.getFilterId()).collect(Collectors.toSet());
        this.haltExp = asSet.contains("ExceptionBreakpointsFilter");
        this.haltInv = asSet.contains("InvariantBreakpointsFilter");
        this.haltSpec = Arrays.stream(args.getFilterOptions()).filter(fo -> fo.getFilterId().equals("SpecBreakpointsFilter")).map(fo -> new TLCSourceBreakpoint(this.tool.getSpecProcessor(), fo.getCondition() != null && !fo.getCondition().isBlank() ? fo.getCondition() : "TRUE")).findAny().orElse(null);
        this.haltUnsat = Arrays.stream(args.getFilterOptions()).filter(fo -> fo.getFilterId().equals("UnsatisfiedBreakpointsFilter")).map(fo -> new TLCSourceBreakpoint(this.tool.getSpecProcessor(), fo.getCondition() != null && !fo.getCondition().isBlank() ? fo.getCondition() : "TRUE")).findAny().orElse(null);
        return CompletableFuture.completedFuture(new SetExceptionBreakpointsResponse());
    }

    @Override
    public synchronized CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        if ("hover".equals(args.getContext()) && args.getExpression().startsWith("tlaplus://")) {
            return CompletableFuture.completedFuture(this.stack.stream().filter(f -> f.getId() == args.getFrameId().intValue()).findAny().map(f -> f.get(args)).orElse(new EvaluateResponse()));
        }
        if ("repl".equals(args.getContext())) {
            return CompletableFuture.completedFuture(this.stack.stream().filter(f -> f.getId() == args.getFrameId().intValue()).findAny().map(f -> f.evaluate(args.getExpression())).orElse(new EvaluateResponse()));
        }
        if ("variables".equals(args.getContext())) {
            EvaluateResponse response = new EvaluateResponse();
            response.setResult(args.getExpression());
            return CompletableFuture.completedFuture(response);
        }
        if ("clipboard".equals(args.getContext())) {
            return CompletableFuture.completedFuture(this.stack.stream().filter(f -> f.getId() == args.getFrameId().intValue()).findAny().map(f -> f.evaluate(args.getExpression())).orElse(new EvaluateResponse()));
        }
        if ("watch".equals(args.getContext())) {
            return CompletableFuture.completedFuture(this.stack.stream().filter(f -> f.getId() == args.getFrameId().intValue()).findAny().map(f -> f.evaluate(args.getExpression())).orElse(new EvaluateResponse()));
        }
        return CompletableFuture.completedFuture(new EvaluateResponse());
    }

    @Override
    public synchronized CompletableFuture<Void> terminate(TerminateArguments args) {
        LOGGER.finer("terminate");
        if (TLCGlobals.mainChecker != null) {
            TLCGlobals.mainChecker.stop();
        }
        if (TLCGlobals.simulator != null) {
            TLCGlobals.simulator.stop();
        }
        if (this.launcher != null) {
            this.launcher.getRemoteProxy().terminated(new TerminatedEventArguments());
        }
        return this.disconnect(new DisconnectArguments());
    }

    @Override
    public synchronized CompletableFuture<Void> disconnect(DisconnectArguments args) {
        LOGGER.finer("disconnect");
        this.breakpoints.clear();
        this.sourceFrame = null;
        this.step = IDebugTarget.Step.Continue;
        this.haltExp = false;
        this.haltInv = false;
        this.haltSpec = null;
        this.haltUnsat = null;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        LOGGER.finer("configurationDone");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        LOGGER.finer("setBreakpoints");
        String module = args.getSource().getName().replaceFirst(".tla$", "");
        if (args.getBreakpoints() != null && args.getBreakpoints().length > 0) {
            this.breakpoints.computeIfAbsent(module, key -> new ArrayList()).clear();
            ModuleNode moduleNode = this.tool.getModule(module);
            SourceBreakpoint[] sbps = args.getBreakpoints();
            Breakpoint[] bp = new Breakpoint[sbps.length];
            for (int j = 0; j < sbps.length; ++j) {
                OpDefNode odn;
                final TLCSourceBreakpoint sbp = new TLCSourceBreakpoint(this.tool.getSpecProcessor(), module, sbps[j], moduleNode);
                this.breakpoints.get(module).add(sbp);
                Breakpoint breakpoint = new Breakpoint();
                breakpoint.setColumn(sbp.getColumn());
                breakpoint.setLine(sbp.getLine());
                breakpoint.setId(j);
                breakpoint.setVerified(moduleNode == null || moduleNode.walkChildren(new SemanticNode.ChildrenVisitor<Boolean>(){
                    private boolean verified = false;

                    @Override
                    public void preVisit(SemanticNode node) {
                        Location location = node.getLocation();
                        if (location.beginLine() == sbp.getLine() && location.endLine() == sbp.getLine()) {
                            this.verified = true;
                        }
                    }

                    @Override
                    public boolean preempt(SemanticNode node) {
                        return this.verified || !node.getLocation().includes(sbp.getLocation());
                    }

                    @Override
                    public Boolean get() {
                        return this.verified;
                    }
                }).get() != false);
                Action nextPred = this.tool.getSpecProcessor().getNextPred();
                Location loc = nextPred.getDefinition();
                if (loc.includes(sbp.getLocation()) && sbp.getHits() > 0) {
                    breakpoint.setVerified(false);
                    breakpoint.setMessage("A Next breakpoint does not support a hit condition.");
                }
                if (moduleNode != null && sbp.getCondition() != null && !sbp.getCondition().isEmpty() && (odn = moduleNode.getOpDef(sbp.getCondition())) == null) {
                    breakpoint.setVerified(false);
                    breakpoint.setMessage(String.format("The  %s  definition, used as the breakpoint expression, could not be found in the specification  %s.", sbp.getCondition(), module));
                }
                Source source = args.getSource();
                breakpoint.setSource(source);
                bp[j] = breakpoint;
            }
            SetBreakpointsResponse response = new SetBreakpointsResponse();
            response.setBreakpoints(bp);
            return CompletableFuture.completedFuture(response);
        }
        ((List)this.breakpoints.getOrDefault(module, new ArrayList())).clear();
        return CompletableFuture.completedFuture(new SetBreakpointsResponse());
    }

    @Override
    public synchronized CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        int req;
        LOGGER.finer(String.format("stackTrace frame: %s, levels: %s\n", args.getStartFrame(), args.getLevels()));
        StackTraceResponse res = new StackTraceResponse();
        if (!this.executionIsHalted) {
            res.setStackFrames(new StackFrame[0]);
            res.setTotalFrames(0);
            return CompletableFuture.completedFuture(res);
        }
        if (!(this.stack.peekLast() instanceof TLCSyntheticStateStackFrame) && this.stack.peek() instanceof TLCStateStackFrame) {
            this.stack.addAll(((TLCStateStackFrame)this.stack.peek()).getTraceAsStackFrames());
        }
        int from = 0;
        if (args.getStartFrame() != null) {
            int req2 = args.getStartFrame();
            if (req2 < 0 || this.stack.size() - 1 < req2) {
                res.setStackFrames(new StackFrame[0]);
                return CompletableFuture.completedFuture(res);
            }
            from = req2;
        }
        int to = this.stack.size();
        if (args.getLevels() != null && (req = args.getLevels().intValue()) > 0 && from + req < to) {
            to = from + req;
        }
        List frames = this.stack.subList(from, to);
        res.setStackFrames(frames.toArray(new StackFrame[frames.size()]));
        res.setTotalFrames(this.stack.size());
        return CompletableFuture.completedFuture(res);
    }

    @Override
    public synchronized CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        LOGGER.finer(String.format("scopes frame %s\n", args.getFrameId()));
        ScopesResponse response = new ScopesResponse();
        this.stack.stream().filter(s -> s.getId() == args.getFrameId()).findFirst().ifPresent(frame -> response.setScopes(frame.getScopes()));
        return CompletableFuture.completedFuture(response);
    }

    @Override
    public synchronized CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        int vr = args.getVariablesReference();
        VariablesResponse value = new VariablesResponse();
        ArrayList<Variable> collect = new ArrayList<Variable>();
        for (TLCStackFrame frame : this.stack) {
            collect.addAll(Arrays.asList(frame.getVariables(vr)));
        }
        value.setVariables(collect.toArray(new Variable[collect.size()]));
        return CompletableFuture.completedFuture(value);
    }

    @Override
    public synchronized CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        LOGGER.finer("setVariable");
        return CompletableFuture.completedFuture(new SetVariableResponse());
    }

    @Override
    public synchronized CompletableFuture<ThreadsResponse> threads() {
        LOGGER.finer("threads");
        org.eclipse.lsp4j.debug.Thread thread = new org.eclipse.lsp4j.debug.Thread();
        thread.setId(0);
        thread.setName("worker");
        ThreadsResponse res = new ThreadsResponse();
        res.setThreads(new org.eclipse.lsp4j.debug.Thread[]{thread});
        return CompletableFuture.completedFuture(res);
    }

    @Override
    public synchronized CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        LOGGER.finer("continue_");
        if (!this.stack.isEmpty() && this.stack.peek().handle(this)) {
            return this.stack.peek().continue_(this);
        }
        this.sourceFrame = null;
        this.step = IDebugTarget.Step.Continue;
        this.notify();
        return CompletableFuture.completedFuture(new ContinueResponse());
    }

    @Override
    public synchronized CompletableFuture<Void> next(NextArguments args) {
        LOGGER.finer("next/stepOver");
        if (!this.stack.isEmpty() && this.stack.peek().handle(this)) {
            return this.stack.peek().stepOver(this);
        }
        this.sourceFrame = this.stack.peek();
        this.step = IDebugTarget.Step.Over;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepIn(StepInArguments args) {
        LOGGER.finer("stepIn");
        if (!this.stack.isEmpty() && this.stack.peek().handle(this)) {
            return this.stack.peek().stepIn(this);
        }
        this.step = IDebugTarget.Step.In;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepOut(StepOutArguments args) {
        LOGGER.finer("stepOut");
        if (!this.stack.isEmpty()) {
            if (this.stack.peek().handle(this)) {
                return this.stack.peek().stepOut(this);
            }
            this.sourceFrame = this.stack.peek().parent;
            this.step = IDebugTarget.Step.Out;
        }
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> pause(PauseArguments args) {
        LOGGER.finer("pause");
        Executors.newSingleThreadExecutor().submit(() -> {
            LOGGER.finer("pause -> stopped");
            StoppedEventArguments eventArguments = new StoppedEventArguments();
            eventArguments.setThreadId(0);
            eventArguments.setReason("pause");
            this.launcher.getRemoteProxy().stopped(eventArguments);
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> stepBack(StepBackArguments args) {
        LOGGER.finer("stepBack");
        if (!this.stack.isEmpty() && this.stack.peek().handle(this)) {
            return this.stack.peek().stepBack(this);
        }
        this.step = IDebugTarget.Step.Reset;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> reverseContinue(ReverseContinueArguments args) {
        LOGGER.finer("reverseContinue");
        if (!this.stack.isEmpty() && this.stack.peek().handle(this)) {
            return this.stack.peek().reverseContinue(this);
        }
        this.step = IDebugTarget.Step.Reset_Start;
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> gotoState(GotoStateEvent.GotoStateArgument args) {
        LOGGER.finer("selectSuccessor");
        if (!this.stack.isEmpty() && this.stack.peek().handle(this)) {
            return this.stack.peek().gotoState(this, args.getVariablesReference());
        }
        this.notify();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, SemanticNode expr, Context c) {
        TLCStackFrame frame = new TLCStackFrame(this.stack.peek(), expr, c, tool);
        this.stack.push(frame);
        this.haltExecution(frame, this.stack.size());
        return this;
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, SemanticNode expr, Context c, TLCState s) {
        TLCStateStackFrame frame = new TLCStateStackFrame(this.stack.peek(), expr, c, tool, s);
        this.stack.push(frame);
        this.haltExecution(frame, this.stack.size());
        return this;
    }

    @Override
    public synchronized IDebugTarget pushFrame(Tool tool, SemanticNode expr, Context c, TLCState s, Action a, TLCState t) {
        TLCActionStackFrame frame = new TLCActionStackFrame(this.stack.peek(), expr, c, tool, s, a, t);
        this.stack.push(frame);
        this.haltExecution(frame, this.stack.size());
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, OpDefNode expr, Context c, TLCState s, Action a, INextStateFunctor fun) {
        TLCStackFrame frame = this.stack.peek();
        if (frame != null && this.matches(frame)) {
            this.haltExecution(frame);
        }
        return this.popFrame(s);
    }

    @Override
    public synchronized IDebugTarget pushFrame(TLCState s) {
        TLCStackFrame f = this.stack.peek();
        this.pushFrame(f.getTool(), f.getNode(), f.getContext(), s);
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(TLCState state) {
        TLCStackFrame f = this.stack.peek();
        return this.popFrame(f.getTool(), f.getNode(), f.getContext(), state);
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c) {
        TLCStackFrame pop;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("%s Call popFrame: [%s], level: %s\n", new String(new char[this.stack.size()]).replace('\u0000', '#'), expr, this.stack.size()));
        }
        if ((pop = this.stack.peek()) == this.sourceFrame) {
            this.sourceFrame = null;
            this.step = IDebugTarget.Step.In;
            pop.setName("Exit: " + pop.getName());
            pop.setPresentationHint(StackFramePresentationHint.SUBTLE);
            this.haltExecution(pop);
            pop.setName("Exit: " + pop.getName().replace("Exit: ", ""));
            pop.setPresentationHint(StackFramePresentationHint.NORMAL);
        }
        pop = this.stack.pop();
        assert (pop.matches(expr));
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, Value v) {
        this.popFrame(tool, expr, c);
        TLCStackFrame peeked = this.stack.peek();
        if (peeked != null && peeked.node.myUID == expr.myUID) {
            this.stack.peek().setValue(v);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, TLCState s) {
        return this.popFrame(tool, expr, c);
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, Value v, TLCState t) {
        this.popFrame(tool, expr, c, v);
        return this;
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, TLCState s, TLCState t) {
        return this.popFrame(tool, expr, c);
    }

    @Override
    public synchronized IDebugTarget popFrame(Tool tool, SemanticNode expr, Context c, Value v, TLCState s, TLCState t) {
        this.popFrame(tool, expr, c, v);
        return this;
    }

    @Override
    public synchronized IDebugTarget popExceptionFrame(Tool tool, SemanticNode expr, Context c, Value v, StatefulRuntimeException e) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("%s Call popExceptionFrame: [%s], level: %s\n", new String(new char[this.stack.size()]).replace('\u0000', '#'), expr, this.stack.size()));
        }
        TLCStackFrame pop = this.stack.pop();
        assert (pop.matches(expr, e));
        return this;
    }

    @Override
    public synchronized IDebugTarget popExceptionFrame(Tool tool, SemanticNode expr, Context c, Value v, TLCState s, StatefulRuntimeException e) {
        return this.popExceptionFrame(tool, expr, c, v, e);
    }

    @Override
    public synchronized IDebugTarget popExceptionFrame(Tool tool, SemanticNode expr, Context c, Value v, TLCState s, TLCState t, StatefulRuntimeException e) {
        return this.popExceptionFrame(tool, expr, c, v, e);
    }

    private boolean exceptionNotYetHandled(StatefulRuntimeException e) {
        return !e.setKnown();
    }

    @Override
    public synchronized IDebugTarget pushExceptionFrame(Tool tool, SemanticNode expr, Context c, StatefulRuntimeException e) {
        if (this.exceptionNotYetHandled(e)) {
            return this.pushFrameAndHalt(this.haltExp, new TLCStackFrame(this.stack.peek(), expr, c, tool, e), e);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget pushExceptionFrame(Tool tool, SemanticNode expr, Context c, TLCState state, StatefulRuntimeException e) {
        if (this.exceptionNotYetHandled(e)) {
            return this.pushFrameAndHalt(this.haltExp, new TLCStateStackFrame(this.stack.peek(), expr, c, tool, state, e), e);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget pushExceptionFrame(Tool tool, SemanticNode expr, Context c, TLCState s, Action a, TLCState t, StatefulRuntimeException e) {
        if (this.exceptionNotYetHandled(e)) {
            return this.pushFrameAndHalt(this.haltExp, new TLCActionStackFrame(this.stack.peek(), expr, c, tool, s, a, t, e), e);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget popExceptionFrame(Tool tool, SemanticNode expr, Context c, TLCState s, Action a, TLCState t, StatefulRuntimeException e) {
        return this.popExceptionFrame(tool, expr, c, null, e);
    }

    @Override
    public synchronized IDebugTarget pushNextStatesFrame(Tool tool, INextStateFunctor functor, TLCState state) {
        Action next = tool.getNextStateSpec() == null ? Action.UNKNOWN : tool.getNextStateSpec();
        TLCNextStatesStackFrame frame = new TLCNextStatesStackFrame(this.stack.peek(), next.pred, next.con, tool, state, functor, next);
        this.stack.push(frame);
        return this;
    }

    @Override
    public synchronized IDebugTarget popNextStatesFrame(Tool tool, INextStateFunctor functor, TLCState state) {
        TLCStackFrame frame = this.stack.peek();
        assert (frame instanceof TLCNextStatesStackFrame);
        if (this.haltSpec != null && frame.matches(this.haltSpec)) {
            this.haltExecution(frame);
        }
        this.stack.pop();
        return this;
    }

    @Override
    public synchronized IDebugTarget pushInitStatesFrame(Tool tool, IStateFunctor functor) {
        Action init = tool.getInitStateSpec().isEmpty() ? Action.UNKNOWN : (Action)tool.getInitStateSpec().firstElement();
        TLCInitStatesStackFrame frame = new TLCInitStatesStackFrame(this.stack.peek(), init.pred, init.con, tool, functor);
        this.stack.push(frame);
        return this;
    }

    @Override
    public synchronized IDebugTarget popInitStatesFrame(Tool tool, IStateFunctor functor) {
        assert (this.stack.peek() instanceof TLCInitStatesStackFrame);
        TLCInitStatesStackFrame frame = (TLCInitStatesStackFrame)this.stack.peek();
        if (this.haltSpec != null && !frame.getStates().isEmpty() && frame.matches(this.haltSpec)) {
            this.haltExecution(frame);
        }
        this.stack.pop();
        return this;
    }

    @Override
    public synchronized IDebugTarget pushUnsatisfiedFrame(Tool tool, SemanticNode expr, Context c, TLCState state) {
        TLCStateStackFrame frame = new TLCStateStackFrame(this.stack.peek(), expr, c, tool, state);
        this.stack.push(frame);
        if (this.haltUnsat != null && ((TLCStackFrame)frame).matches(this.haltUnsat)) {
            this.haltExecution(frame);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget pushUnsatisfiedFrame(Tool tool, SemanticNode expr, Context c, TLCState predecessor, Action a, TLCState state) {
        TLCActionStackFrame frame = new TLCActionStackFrame(this.stack.peek(), expr, c, tool, predecessor, a, state);
        this.stack.push(frame);
        if (this.haltUnsat != null && ((TLCStackFrame)frame).matches(this.haltUnsat)) {
            this.haltExecution(frame);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget markInvariantViolatedFrame(Tool debugTool, SemanticNode expr, Context c, TLCState predecessor, Action a, TLCState state, StatefulRuntimeException e) {
        if (this.exceptionNotYetHandled(e)) {
            this.pushFrameAndHalt(this.haltInv, new TLCActionStackFrame(this.stack.peek(), expr, c, this.tool, predecessor, a, state, e), e);
        }
        return this;
    }

    @Override
    public synchronized IDebugTarget markAssumptionViolatedFrame(Tool debugTool, SemanticNode expr, Context c) {
        TLCStackFrame frame = new TLCStackFrame(null, expr, c, this.tool);
        this.stack.push(frame);
        if (this.haltInv) {
            this.haltExecution(frame);
        }
        return this;
    }

    private IDebugTarget pushFrameAndHalt(boolean halt, TLCStackFrame frame, RuntimeException e) {
        this.stack.push(frame);
        if (this.launcher != null) {
            OutputEventArguments oea = new OutputEventArguments();
            oea.setOutput(e.getMessage() == null ? "" : e.getMessage());
            oea.setLine(frame.getLine());
            oea.setColumn(frame.getColumn());
            oea.setSource(frame.getSource());
            oea.setCategory("stderr");
            this.launcher.getRemoteProxy().output(oea);
        }
        if (halt) {
            this.haltExecution(frame);
        }
        return this;
    }

    protected void haltExecution(TLCStackFrame frame, int level) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("%s(%s): [%s]\n", new String(new char[level]).replace('\u0000', '#'), level, frame.getNode()));
        }
        if (TLCDebugger.matches(this.step, this.sourceFrame, frame)) {
            this.haltExecution(frame);
        } else if (this.matches(frame)) {
            this.haltExecution(frame);
        }
    }

    protected void haltExecution(TLCStackFrame frame) {
        frame.preHalt(this);
        this.sendStopped(frame);
        try {
            this.executionIsHalted = true;
            this.wait();
            this.executionIsHalted = false;
        }
        catch (InterruptedException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            Thread.currentThread().interrupt();
        }
        while (!this.stack.isEmpty() && this.stack.peekLast() instanceof TLCSyntheticStateStackFrame) {
            TLCStackFrame f = this.stack.pollLast();
            assert (f instanceof TLCSyntheticStateStackFrame);
        }
        if (IDebugTarget.Step.Reset == this.step) {
            this.step = IDebugTarget.Step.In;
            if (frame.parent != null) {
                throw new IDebugTarget.ResetEvalException(frame.parent);
            }
        } else if (IDebugTarget.Step.Reset_Start == this.step) {
            this.step = IDebugTarget.Step.In;
            throw new IDebugTarget.ResetEvalException(this.stack.getLast());
        }
        frame.postHalt(this);
    }

    protected void sendStopped(TLCStackFrame frame) {
        LOGGER.finer("loadSource -> stopped");
        if (this.launcher != null) {
            StoppedEventArguments eventArguments = frame.getStoppedEventArgument();
            eventArguments.setThreadId(0);
            this.launcher.getRemoteProxy().stopped(eventArguments);
        }
    }

    protected void sendCapabilities(Capabilities capabilities) {
        LOGGER.finer("sendCapabilities");
        if (this.launcher != null) {
            CapabilitiesEventArguments cea = new CapabilitiesEventArguments();
            cea.setCapabilities(capabilities);
            this.launcher.getRemoteProxy().capabilities(cea);
        }
    }

    public void setGranularity(IDebugTarget.Granularity g) {
        this.granularity = g;
    }

    public IDebugTarget.Granularity getGranularity() {
        return this.granularity;
    }

    private static boolean matches(IDebugTarget.Step dir, TLCStackFrame sourceFrame, TLCStackFrame currentFrame) {
        if (dir == IDebugTarget.Step.In) {
            return true;
        }
        if (sourceFrame != null && (dir == IDebugTarget.Step.Over || dir == IDebugTarget.Step.Out)) {
            return sourceFrame.matches(currentFrame);
        }
        return false;
    }

    private boolean matches(TLCStackFrame frame) {
        return ((List)this.breakpoints.getOrDefault(frame.getNode().getLocation().source(), new ArrayList(0))).stream().anyMatch(b -> {
            if (!frame.matches((TLCSourceBreakpoint)b)) {
                return false;
            }
            TLCStackFrame parent = frame.parent;
            while (parent != null) {
                if (parent.matches((TLCSourceBreakpoint)b)) {
                    return false;
                }
                parent = parent.parent;
            }
            return true;
        });
    }

    public static class Factory {
        public static TLCDebugger OVERRIDE;

        public static TLCDebugger getInstance(int port, boolean suspend, boolean halt) throws Exception {
            if (OVERRIDE != null) {
                return OVERRIDE;
            }
            if (suspend) {
                return new AttachingDebugger(port, IDebugTarget.Step.In, halt);
            }
            return new AttachingDebugger(port, IDebugTarget.Step.Continue, halt);
        }
    }
}

