/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.utilities;

import java.util.ArrayList;
import java.util.Enumeration;
import tla2sany.utilities.VectorEnumeration;

public class Vector<E>
extends ArrayList<E> {
    static int defaultSize = 10;

    public Vector() {
        super(defaultSize);
    }

    public Vector(int initialSize) {
        super(initialSize);
    }

    public final void addElement(E obj) {
        super.add(obj);
    }

    public final E firstElement() {
        return this.elementAt(0);
    }

    public final E lastElement() {
        return this.elementAt(this.size() - 1);
    }

    public final E elementAt(int i) {
        this.checkBounds(i);
        return super.get(i);
    }

    public final void removeAllElements() {
        super.clear();
    }

    public final void removeElementAt(int i) {
        this.checkBounds(i);
        super.remove(i);
    }

    public final void insertElementAt(E obj, int i) {
        if (i < 0 || i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        super.add(i, obj);
    }

    public final void setElementAt(E obj, int i) {
        this.checkBounds(i);
        super.set(i, obj);
    }

    @Override
    public final boolean contains(Object obj) {
        for (Object value : this) {
            if (value != obj) continue;
            return true;
        }
        return false;
    }

    public final Enumeration<E> elements() {
        return new VectorEnumeration(new ArrayList(this).iterator());
    }

    public final void append(Vector<E> v) {
        super.addAll(v);
    }

    public final void appendNoRepeats(Vector<E> v) {
        for (int i = 0; i < v.size(); ++i) {
            if (this.contains(v.elementAt(i))) continue;
            this.addElement(v.elementAt(i));
        }
    }

    @Override
    public final String toString() {
        Object ret = "[ ";
        if (this.size() > 0) {
            ret = (String)ret + this.elementAt(0).toString();
        }
        for (int i = 1; i < this.size(); ++i) {
            ret = (String)ret + ", " + this.elementAt(i).toString();
        }
        return (String)ret + " ]";
    }

    private void checkBounds(int i) {
        if (i < 0 || i >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

