/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import pcal.AST;
import pcal.IntPair;
import pcal.PCalTLAGenerator;
import pcal.ParseAlgorithm;
import pcal.PcalCharReader;
import pcal.PcalDebug;
import pcal.PcalParams;
import pcal.TLAtoPCalMapping;
import pcal.exception.ParseAlgorithmException;
import pcal.exception.RemoveNameConflictsException;
import pcal.trans;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.st.Location;

public class Validator {
    static final String PCAL_CHECKSUM = "pcalchecksum";
    static final String TLA_CHECKSUM = "tlachecksum";
    static final String FAIR = "fair";
    static final String CHECKSUM_TEMPLATE_IGNORE = "(chksum(pcal) \\in STRING /\\ chksum(tla) \\in STRING)";
    static final String CHECKSUM_TEMPLATE = "(chksum(pcal) = \"%s\" /\\ chksum(tla) = \"%s\")";
    static final Pattern CHECKSUM_PATTERN = Pattern.compile("\\\\\\* BEGIN TRANSLATION\\s+\\(\\s*((?i)ch(ec)?ksum\\(p(lus)?cal\\)(?-i))\\s*(=\\s*\\\"(?<pcalchecksum>[0-9A-Fa-f]*)\\\"|\\\\in\\s*STRING)\\s*\\/\\\\\\s*((?i)ch(ec)?ksum\\(tla\\+?\\)(?-i))\\s*(=\\s*\\\"(?<tlachecksum>[0-9A-Fa-f]*)\\\"|\\\\in\\s*STRING)\\s*\\)");
    private static final Pattern MODULE_CLOSING_PATTERN = Pattern.compile("^[=]+$");

    public static Set<ValidationResult> validate(ParseUnit parseUnit, InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)(inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream)), StandardCharsets.UTF_8));
        return Validator.validate(parseUnit, reader);
    }

    public static Set<ValidationResult> validate(ParseUnit parseUnit, BufferedReader reader) throws IOException {
        String line;
        Location loc = parseUnit.getParseTree().getLocation();
        ArrayList<String> lines = new ArrayList<String>(loc.endLine() - loc.beginLine());
        boolean seenAlgo = false;
        int cnt = 1;
        while ((line = reader.readLine()) != null) {
            if (loc.beginLine() <= cnt && cnt <= loc.endLine()) {
                if (line.indexOf("--algorithm".substring(2)) > 0) {
                    seenAlgo = true;
                }
                lines.add(line);
            } else if (cnt >= loc.endLine()) break;
            ++cnt;
        }
        if (!seenAlgo) {
            return Validator.setOf(ValidationResult.NO_PLUSCAL_EXISTS);
        }
        return Validator.validate(lines);
    }

    private static Set<ValidationResult> validate(List<String> specificationText) {
        int endTranslationLine;
        String line;
        Matcher m;
        Vector<String> deTabbedSpecification = trans.removeTabs(specificationText);
        IntPair searchLoc = new IntPair(0, 0);
        boolean notDone = true;
        while (notDone) {
            try {
                ParseAlgorithm.FindToken("PlusCal", deTabbedSpecification, searchLoc, "");
                String line2 = ParseAlgorithm.GotoNextNonSpace(deTabbedSpecification, searchLoc);
                String restOfLine = line2.substring(searchLoc.two);
                if (!restOfLine.startsWith("options") || ParseAlgorithm.NextNonIdChar(restOfLine, 0) != 7) continue;
                PcalParams.optionsInFile = true;
                ParseAlgorithm.ProcessOptions(deTabbedSpecification, searchLoc);
                notDone = false;
            }
            catch (ParseAlgorithmException e) {
                notDone = false;
            }
        }
        int algLine = 0;
        int algCol = -1;
        boolean foundBegin = false;
        boolean foundFairBegin = false;
        while (algLine < deTabbedSpecification.size() && !foundBegin && !(m = MODULE_CLOSING_PATTERN.matcher(line = deTabbedSpecification.elementAt(algLine))).matches()) {
            algCol = line.indexOf("--algorithm");
            if (algCol != -1) {
                algCol += "--algorithm".length();
                foundBegin = true;
                continue;
            }
            algCol = line.indexOf("--fair");
            if (algCol != -1) {
                algCol += "--fair".length();
                foundBegin = true;
                foundFairBegin = true;
                continue;
            }
            ++algLine;
        }
        HashSet<ValidationResult> res = new HashSet<ValidationResult>();
        int translationLine = trans.findTokenPair(deTabbedSpecification, 0, "BEGIN", "TRANSLATION");
        if (translationLine == -1) {
            res.add(ValidationResult.NO_TRANSLATION_EXISTS);
        }
        if ((endTranslationLine = trans.findTokenPair(deTabbedSpecification, translationLine + 1, "END", "TRANSLATION")) == -1) {
            res.add(ValidationResult.NO_TRANSLATION_EXISTS);
        }
        if (translationLine == -1 && endTranslationLine == -1) {
            return res;
        }
        if (!foundBegin) {
            res.add(ValidationResult.NO_PLUSCAL_EXISTS);
        } else {
            try {
                ParseAlgorithm.uncomment(deTabbedSpecification, algLine, algCol);
            }
            catch (ParseAlgorithmException e) {
                PcalDebug.reportError(e);
                return Validator.setOf(ValidationResult.ERROR_ENCOUNTERED);
            }
            TLAtoPCalMapping mapping = new TLAtoPCalMapping();
            mapping.algColumn = algCol;
            mapping.algLine = algLine;
            PcalParams.tlaPcalMapping = mapping;
            AST ast = new AST();
            try {
                PcalCharReader reader = new PcalCharReader(deTabbedSpecification, algLine, algCol, specificationText.size(), 0);
                ast = ParseAlgorithm.getAlgorithm(reader, foundFairBegin);
                PCalTLAGenerator pcalTLAGenerator = new PCalTLAGenerator(ast);
                pcalTLAGenerator.removeNameConflicts();
                pcalTLAGenerator.translate();
            }
            catch (ParseAlgorithmException | RemoveNameConflictsException e) {
                PcalDebug.reportError(e);
            }
            Matcher m2 = CHECKSUM_PATTERN.matcher(deTabbedSpecification.get(translationLine));
            if (m2.find()) {
                if (m2.group(PCAL_CHECKSUM) != null) {
                    String chksumPCalAST = Validator.checksum((String)(foundFairBegin ? FAIR : ast.toString()));
                    if (!m2.group(PCAL_CHECKSUM).equals(chksumPCalAST)) {
                        res.add(ValidationResult.PCAL_DIVERGENCE_EXISTS);
                    }
                }
                if (m2.group(TLA_CHECKSUM) != null) {
                    Vector<String> translation = new Vector<String>(specificationText.subList(translationLine + 1, endTranslationLine));
                    String chksumTLATranslation = Validator.checksum(translation);
                    if (!m2.group(TLA_CHECKSUM).equals(chksumTLATranslation)) {
                        res.add(ValidationResult.TLA_DIVERGENCE_EXISTS);
                    }
                }
            } else {
                res.add(ValidationResult.NO_PCAL_CHECKSUMS_EXIST);
            }
        }
        return res.isEmpty() ? Validator.setOf(ValidationResult.NO_DIVERGENCE) : res;
    }

    public static String checksum(Vector<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String str : lines) {
            sb.append(str);
        }
        return Validator.checksum(sb.toString());
    }

    static String checksum(String string) {
        CRC32 crc32 = new CRC32();
        crc32.update(string.getBytes());
        return Long.toHexString(crc32.getValue());
    }

    private static Set<ValidationResult> setOf(ValidationResult ... res) {
        return new HashSet<ValidationResult>(Arrays.asList(res));
    }

    public static enum ValidationResult {
        NO_PLUSCAL_EXISTS,
        NO_TRANSLATION_EXISTS,
        NO_TLA_CHECKSUMS_EXIST,
        NO_PCAL_CHECKSUMS_EXIST,
        TLA_DIVERGENCE_EXISTS,
        PCAL_DIVERGENCE_EXISTS,
        ERROR_ENCOUNTERED,
        NO_DIVERGENCE;

    }
}

