/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.util;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class ExpandableSpaceReclaimer
implements IExpansionListener {
    private static final double MINIMUM_SASH_PART_PERCENTAGE = 0.1;
    private final Section m_section;
    private final SashForm m_sashForm;
    private final int m_sectionIndex;
    private final int m_otherChildrenCount;
    private Point m_lastSectionSizeOnCollapse;

    public ExpandableSpaceReclaimer(Section s, SashForm sf) {
        this.m_section = s;
        this.m_sashForm = sf;
        Control[] children = this.m_sashForm.getChildren();
        int index = -1;
        int i = 0;
        while (i < children.length) {
            if (s == children[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Section could not be found in the sash form.");
        }
        this.m_sectionIndex = index;
        this.m_otherChildrenCount = children.length - 1;
        this.m_section.addExpansionListener((IExpansionListener)this);
        this.m_lastSectionSizeOnCollapse = null;
    }

    public void expansionStateChanging(ExpansionEvent ee) {
        if (!ee.getState()) {
            this.m_lastSectionSizeOnCollapse = this.m_section.getSize();
        }
    }

    public void expansionStateChanged(ExpansionEvent ee) {
        Point sashFormSize = this.m_sashForm.getSize();
        int totalSashConsumption = this.m_sashForm.getSashWidth() * this.m_otherChildrenCount;
        if (ee.getState()) {
            Point desiredSize;
            Point point = desiredSize = this.m_lastSectionSizeOnCollapse != null ? this.m_lastSectionSizeOnCollapse : this.m_section.computeSize(-1, -1, false);
            if (this.m_sashForm.getOrientation() == 512) {
                int minimumHeight = (int)(0.1 * (double)sashFormSize.y);
                int totalMinimumHeight = minimumHeight * this.m_otherChildrenCount + totalSashConsumption;
                double usableSashFormHeight = sashFormSize.y - totalSashConsumption;
                if (desiredSize.y < sashFormSize.y - totalMinimumHeight) {
                    double remainingHeight = usableSashFormHeight - (double)desiredSize.y;
                    int[] weights = this.m_sashForm.getWeights();
                    double sumOfOtherWeights = 0.0;
                    int i = 0;
                    while (i < weights.length) {
                        if (i != this.m_sectionIndex) {
                            sumOfOtherWeights += (double)weights[i];
                        }
                        ++i;
                    }
                    double[] newHeights = new double[weights.length];
                    int heightSum = 0;
                    int i2 = 0;
                    while (i2 < weights.length) {
                        if (i2 != this.m_sectionIndex) {
                            double percentage = (double)weights[i2] / sumOfOtherWeights;
                            newHeights[i2] = (int)(percentage * remainingHeight);
                            heightSum = (int)((double)heightSum + newHeights[i2]);
                        }
                        ++i2;
                    }
                    newHeights[this.m_sectionIndex] = usableSashFormHeight - (double)heightSum;
                    int[] newWeights = new int[weights.length];
                    int i3 = 0;
                    while (i3 < weights.length) {
                        newWeights[i3] = (int)(newHeights[i3] * 100.0 / usableSashFormHeight);
                        ++i3;
                    }
                    this.m_sashForm.setWeights(newWeights);
                }
            } else {
                int minimumWidth = (int)(0.1 * (double)sashFormSize.x);
                int totalMinimumWidth = (minimumWidth + this.m_sashForm.getSashWidth()) * this.m_otherChildrenCount;
                int cfr_ignored_0 = desiredSize.x;
                int cfr_ignored_1 = sashFormSize.x;
            }
        } else {
            Point sectionSize = this.m_section.getSize();
            Point sectionClientSize = this.m_section.getClient().getSize();
            if (this.m_sashForm.getOrientation() == 512) {
                double titleBarHeight = sectionSize.y - sectionClientSize.y;
                double usableSashFormHeight = (double)sashFormSize.y - ((double)totalSashConsumption + titleBarHeight);
                int[] weights = this.m_sashForm.getWeights();
                double sumOfOtherWeights = 0.0;
                int i = 0;
                while (i < weights.length) {
                    if (i != this.m_sectionIndex) {
                        sumOfOtherWeights += (double)weights[i];
                    }
                    ++i;
                }
                double[] newHeights = new double[weights.length];
                int i4 = 0;
                while (i4 < weights.length) {
                    if (i4 != this.m_sectionIndex) {
                        double percentage = (double)weights[i4] / sumOfOtherWeights;
                        newHeights[i4] = (int)(percentage * usableSashFormHeight);
                    }
                    ++i4;
                }
                newHeights[this.m_sectionIndex] = (int)titleBarHeight;
                int[] newWeights = new int[weights.length];
                int i5 = 0;
                while (i5 < weights.length) {
                    newWeights[i5] = (int)(newHeights[i5] * 100.0 / usableSashFormHeight);
                    ++i5;
                }
                this.m_sashForm.setWeights(newWeights);
            }
        }
    }
}

