/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.Comparator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.lamport.tla.toolbox.tool.tlc.output.data.CoverageInformationItem;

public enum Representation {
    INV,
    COST,
    INVCOST,
    STATES,
    STATES_DISTINCT;


    public static Object valuesNoStates() {
        Representation[] values = new Representation[]{INV, COST, INVCOST};
        return values;
    }

    public String getToolTipText() {
        if (this == INV) {
            return "Invocations: %,d\nClick to jump to location %s.";
        }
        if (this == COST) {
            return "Cost: %,d\nClick to jump to location %s.";
        }
        if (this == INVCOST) {
            return "Inv + Cost: %,d\nClick to jump to location %s.";
        }
        if (this == STATES) {
            return "States Found: %,d\nClick to jump to location %s.";
        }
        if (this == STATES_DISTINCT) {
            return "Distinct States: %,d\nClick to jump to location %s.";
        }
        return "";
    }

    public String toString() {
        if (this == INV) {
            return "Invocations";
        }
        if (this == COST) {
            return "Cost";
        }
        if (this == INVCOST) {
            return "Inv + Cost";
        }
        if (this == STATES) {
            return "States Found";
        }
        if (this == STATES_DISTINCT) {
            return "Distinct States";
        }
        return "";
    }

    public long getValue(CoverageInformationItem item, Grouping grouping) {
        if (grouping == Grouping.COMBINED) {
            return this.getTotal(item);
        }
        return this.getValue(item);
    }

    private long getValue(CoverageInformationItem item) {
        if (this == INV) {
            return item.getCount();
        }
        if (this == COST) {
            return item.getCost();
        }
        if (this == INVCOST) {
            return item.getCountAndCost();
        }
        if (this == STATES) {
            return item.getCount();
        }
        if (this == STATES_DISTINCT) {
            return item.getCost();
        }
        return 0L;
    }

    private long getTotal(CoverageInformationItem item) {
        if (this == INV) {
            return item.getTotalCount();
        }
        if (this == COST) {
            return item.getTotalCost();
        }
        if (this == INVCOST) {
            return item.getTotalCost() + item.getTotalCount();
        }
        if (this == STATES) {
            return item.getTotalCount();
        }
        if (this == STATES_DISTINCT) {
            return item.getTotalCost();
        }
        return 0L;
    }

    public Color getColor(CoverageInformationItem cii, Grouping group) {
        Color[] colors = cii.representations.get((Object)this);
        if (colors != null) {
            return colors[group.ordinal()];
        }
        return JFaceResources.getColorRegistry().get("GRAY");
    }

    public Comparator<CoverageInformationItem> getComparator(Grouping grouping) {
        if (this == STATES) {
            return new Comparator<CoverageInformationItem>(){

                @Override
                public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                    return Long.compare(o1.getCount(), o2.getCount());
                }
            };
        }
        if (this == STATES_DISTINCT) {
            return new Comparator<CoverageInformationItem>(){

                @Override
                public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                    return Long.compare(o1.getCost(), o2.getCost());
                }
            };
        }
        if (grouping == Grouping.COMBINED) {
            if (this == INV) {
                return new Comparator<CoverageInformationItem>(){

                    @Override
                    public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                        return Long.compare(o1.getTotalCount(), o2.getTotalCount());
                    }
                };
            }
            if (this == COST) {
                return new Comparator<CoverageInformationItem>(){

                    @Override
                    public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                        return Long.compare(o1.getTotalCost(), o2.getTotalCost());
                    }
                };
            }
            if (this == INVCOST) {
                return new Comparator<CoverageInformationItem>(){

                    @Override
                    public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                        return Long.compare(o1.getTotalCountAndCost(), o2.getTotalCountAndCost());
                    }
                };
            }
        } else {
            if (this == INV) {
                return new Comparator<CoverageInformationItem>(){

                    @Override
                    public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                        return Long.compare(o1.getCount(), o2.getCount());
                    }
                };
            }
            if (this == COST) {
                return new Comparator<CoverageInformationItem>(){

                    @Override
                    public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                        return Long.compare(o1.getCost(), o2.getCost());
                    }
                };
            }
            if (this == INVCOST) {
                return new Comparator<CoverageInformationItem>(){

                    @Override
                    public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                        return Long.compare(o1.getCountAndCost(), o2.getCountAndCost());
                    }
                };
            }
        }
        return new Comparator<CoverageInformationItem>(){

            @Override
            public int compare(CoverageInformationItem o1, CoverageInformationItem o2) {
                return 0;
            }
        };
    }

    public static enum Grouping {
        INDIVIDUAL,
        COMBINED;

    }
}

