/*
 * Decompiled with CFR 0.152.
 */
package tlc2.overrides;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.EvalException;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.UniqueString;

public class CSV {
    @TLAPlusOperator(identifier="CSVWriteRecord", module="CSV", warn=false)
    public static Value writeRecord(Value value2, StringValue stringValue, BoolValue boolValue, StringValue stringValue2) throws IOException {
        String string;
        RecordValue recordValue = (RecordValue)value2.toRcd();
        if (recordValue == null) {
            throw new EvalException(2283, new String[]{"CSVWriteRecord", "record", Values.ppr((String)value2.toString())});
        }
        recordValue.deepNormalize();
        if (boolValue.val) {
            string = Arrays.stream(recordValue.names).map(uniqueString -> uniqueString.toString()).collect(Collectors.joining(stringValue.val.toString()));
            Files.write(Paths.get(stringValue2.val.toString(), new String[0]), (string + System.lineSeparator()).getBytes("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        string = Arrays.stream(recordValue.values).map(value -> value.toString()).collect(Collectors.joining(stringValue.val.toString()));
        Files.write(Paths.get(stringValue2.val.toString(), new String[0]), (string + System.lineSeparator()).getBytes("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="CSVWrite", module="CSV", warn=false)
    public static Value write(StringValue stringValue, Value value, StringValue stringValue2) throws IOException {
        TupleValue tupleValue = (TupleValue)value.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2283, new String[]{"CSVWrite", "sequence", Values.ppr((String)value.toString())});
        }
        tupleValue.deepNormalize();
        Object[] objectArray = Arrays.asList(tupleValue.getElems()).stream().map(iValue -> iValue.toString()).toArray(Object[]::new);
        Files.write(Paths.get(stringValue2.val.toString(), new String[0]), (String.format(stringValue.val.toString(), objectArray) + System.lineSeparator()).getBytes("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="CSVRead", module="CSV", warn=false)
    public static Value read(Value value2, StringValue stringValue, StringValue stringValue2) throws IOException {
        TupleValue tupleValue = (TupleValue)value2.toTuple();
        if (tupleValue == null) {
            throw new EvalException(2283, new String[]{"CSVRead", "sequence", Values.ppr((String)value2.toString())});
        }
        Path path = Paths.get(stringValue2.val.toString(), new String[0]);
        if (!path.toFile().exists()) {
            return TupleValue.EmptyTuple;
        }
        UniqueString[] uniqueStringArray = (UniqueString[])Arrays.asList(tupleValue.elems).stream().map(value -> ((StringValue)value).val).collect(Collectors.toList()).toArray(UniqueString[]::new);
        List<String> list = Files.readAllLines(path);
        Value[] valueArray = new Value[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            StringValue[] stringValueArray = (StringValue[])Arrays.asList(list.get(i).split(stringValue.val.toString())).stream().map(string -> new StringValue(string)).collect(Collectors.toList()).toArray(StringValue[]::new);
            valueArray[i] = new RecordValue(uniqueStringArray, (Value[])stringValueArray, false);
        }
        return new TupleValue(valueArray);
    }

    @TLAPlusOperator(identifier="CSVRecords", module="CSV", warn=false)
    public static Value records(StringValue stringValue) throws IOException {
        Path path = Paths.get(stringValue.val.toString(), new String[0]);
        if (!path.toFile().exists()) {
            return IntValue.ValZero;
        }
        Stream<String> stream = Files.lines(path, StandardCharsets.UTF_8);
        try {
            IntValue intValue = IntValue.gen((int)Math.toIntExact(stream.count()));
            return intValue;
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvalException(2178, Long.toString(stream.count()));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }
}

