/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Segment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.VerticalAlignment;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizontalCompaction<V, E>
extends org.jungrapht.visualization.layout.algorithms.sugiyama.HorizontalCompaction<V> {
    private static final Logger log = LoggerFactory.getLogger(HorizontalCompaction.class);
    protected Graph<LV<V>, LE<V, E>> svGraph;
    protected Graph<LV<V>, Integer> compactionGraph;
    protected final VerticalAlignment.HDirection hDirection;
    protected final VerticalAlignment.VDirection vDirection;

    public HorizontalCompaction(VerticalAlignment.HDirection hDirection, VerticalAlignment.VDirection vDirection, Graph<LV<V>, LE<V, E>> svGraph, Graph<LV<V>, Integer> compactionGraph, LV<V>[][] layers, Map<LV<V>, LV<V>> rootMap, Map<LV<V>, LV<V>> alignMap, int deltaX, int deltaY) {
        super(layers, rootMap, alignMap, deltaX, deltaY);
        this.hDirection = hDirection;
        this.vDirection = vDirection;
        this.svGraph = svGraph;
        this.compactionGraph = compactionGraph;
    }

    @Override
    public void horizontalCompaction() {
        LV<V> root;
        QVertex qVertex;
        PVertex pVertex;
        Segment segment;
        if (log.isTraceEnabled()) {
            Arrays.stream(this.layers).flatMap(Arrays::stream).forEach(v -> log.trace("v:{}, root(v):{} equal: {}", v, this.root(v), v == this.root(v)));
        }
        if (log.isTraceEnabled()) {
            log.trace("compactionGraph vertices: {}", (Object)this.compactionGraph.vertexSet());
        }
        HashSet<LV<V>> verticesInCompactionGraphAndSegmentEnds = new HashSet<LV<V>>();
        for (LV<V> v2 : this.compactionGraph.vertexSet()) {
            if (v2 instanceof Segment) {
                segment = (Segment)v2;
                pVertex = segment.pVertex;
                if (this.root(pVertex) == pVertex) {
                    verticesInCompactionGraphAndSegmentEnds.add(pVertex);
                }
                if (this.root(qVertex = segment.qVertex) != qVertex) continue;
                verticesInCompactionGraphAndSegmentEnds.add(qVertex);
                continue;
            }
            root = this.root(v2);
            if (root != v2) continue;
            verticesInCompactionGraphAndSegmentEnds.add(v2);
        }
        if (log.isTraceEnabled()) {
            log.trace("verticesInCompactionGraphAndSegmentEnds = {}", (Object)verticesInCompactionGraphAndSegmentEnds);
        }
        for (LV<V> v2 : this.compactionGraph.vertexSet()) {
            if (v2 instanceof Segment) {
                segment = (Segment)v2;
                pVertex = segment.pVertex;
                if (this.root(pVertex) == pVertex) {
                    if (log.isTraceEnabled()) {
                        log.trace("(p) will placeBlock({})", (Object)pVertex);
                    }
                    this.placeBlock(pVertex);
                }
                if (this.root(qVertex = segment.qVertex) != qVertex) continue;
                if (log.isTraceEnabled()) {
                    log.trace("(q) will placeBlock({})", (Object)qVertex);
                }
                this.placeBlock(qVertex);
                continue;
            }
            root = this.root(v2);
            if (root != v2) continue;
            if (log.isTraceEnabled()) {
                log.trace("(v) will placeBlock({})", (Object)v2);
            }
            this.placeBlock(v2);
        }
        for (int i = 0; i < this.layers.length; ++i) {
            LV[] list;
            for (LV v3 : list = this.layers[i]) {
                this.x(v3, this.x(this.root(v3)));
                this.y(v3, i * this.deltaY);
                if (this.shift(this.sink(this.root(v3))) >= Integer.MAX_VALUE) continue;
                this.x(v3, this.x(v3) + this.shift(this.sink(this.root(v3))));
            }
        }
    }

    @Override
    protected void placeBlock(LV<V> v) {
        if (!this.x.containsKey(v)) {
            this.x(v, 0);
            LV w = v;
            do {
                SegmentVertex cw;
                if (log.isTraceEnabled()) {
                    log.trace("look for predecessor of {}", (Object)w);
                }
                if (w instanceof SegmentVertex) {
                    SegmentVertex sv = w;
                    cw = sv.segment;
                } else {
                    cw = w;
                }
                if (!this.compactionGraph.containsVertex(cw)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("inDegree of {} is {}", (Object)cw, (Object)this.compactionGraph.inDegreeOf(cw));
                    log.trace("outDegree of {} is {}", (Object)cw, (Object)this.compactionGraph.outDegreeOf(cw));
                }
                if ((this.hDirection != VerticalAlignment.HDirection.LtoR || this.compactionGraph.inDegreeOf(cw) <= 0) && (this.hDirection != VerticalAlignment.HDirection.RtoL || this.compactionGraph.outDegreeOf(cw) <= 0)) continue;
                Set<Integer> edges = this.hDirection == VerticalAlignment.HDirection.LtoR ? this.compactionGraph.incomingEdgesOf(cw) : this.compactionGraph.outgoingEdgesOf(cw);
                for (Integer edge : edges) {
                    LV<V> u;
                    LV<V> pred;
                    LV<V> lV = pred = this.hDirection == VerticalAlignment.HDirection.LtoR ? this.compactionGraph.getEdgeSource(edge) : this.compactionGraph.getEdgeTarget(edge);
                    if (pred instanceof Segment) {
                        Segment segment = (Segment)pred;
                        u = this.vDirection == VerticalAlignment.VDirection.TtoB ? this.root(segment.pVertex) : this.root(segment.qVertex);
                    } else {
                        u = this.root(pred);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("(u) will placeBlock({})", (Object)u);
                    }
                    this.placeBlock(u);
                    if (this.sink(v) == v) {
                        this.sink(v, this.sink(u));
                    }
                    if (this.sink(v) != this.sink(u)) {
                        if (this.hDirection == VerticalAlignment.HDirection.LtoR) {
                            this.shift(this.sink(u), Math.min(this.shift(this.sink(u)), this.x(v) - this.x(u) - this.deltaX));
                            continue;
                        }
                        this.shift(this.sink(u), Math.max(this.shift(this.sink(u)), this.x(u) - this.x(v) - this.deltaX));
                        continue;
                    }
                    if (this.hDirection == VerticalAlignment.HDirection.LtoR) {
                        this.x(v, Math.max(this.x(v), this.x(u) + this.deltaX));
                        continue;
                    }
                    this.x(v, Math.min(this.x(v), this.x(u) - this.deltaX));
                }
            } while ((w = w instanceof Segment ? (this.vDirection == VerticalAlignment.VDirection.TtoB ? ((Segment)w).qVertex : ((Segment)w).pVertex) : (w instanceof PVertex && this.vDirection == VerticalAlignment.VDirection.TtoB ? ((PVertex)w).segment : (w instanceof QVertex && this.vDirection == VerticalAlignment.VDirection.BtoT ? w.segment : this.align(w)))) != v);
        }
    }

    @Override
    protected int pos(LV<V> v) {
        return v.getPos();
    }

    @Override
    protected int idx(LV<V> v) {
        return v.getIndex();
    }

    void checkValuesInLayersForSameX(LV<V>[][] layers) {
        for (LV<V>[] layer : layers) {
            HashMap<Integer, LV<V>> xValuesThisLayer = new HashMap<Integer, LV<V>>();
            for (LV<V> v : layer) {
                int x = this.x(v);
                if (xValuesThisLayer.containsKey(x)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("already seen {} in this layer {}", (Object)x, (Object)layer);
                    continue;
                }
                xValuesThisLayer.put(x, v);
            }
        }
    }
}

