/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.AbstractLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeLayoutAlgorithm<V>
extends AbstractLayoutAlgorithm<V>
implements LayoutAlgorithm<V>,
TreeLayout<V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTreeLayoutAlgorithm.class);
    protected Predicate<V> rootPredicate;
    protected Predicate<V> defaultRootPredicate;
    protected Comparator<V> rootComparator;
    protected Set<V> visitedVertices = new HashSet<V>();
    protected NeighborCache<V, ?> neighborCache;
    protected Map<V, Rectangle> baseBounds = new HashMap<V, Rectangle>();
    protected int horizontalVertexSpacing;
    protected int verticalVertexSpacing;
    protected Function<V, Rectangle> vertexBoundsFunction;
    protected boolean expandLayout;
    protected boolean correctOverlap;

    protected AbstractTreeLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
        Objects.requireNonNull(builder.vertexBoundsFunction);
        this.rootPredicate = builder.rootPredicate;
        this.rootComparator = builder.rootComparator;
        this.horizontalVertexSpacing = builder.horizontalVertexSpacing;
        this.verticalVertexSpacing = builder.verticalVertexSpacing;
        this.vertexBoundsFunction = builder.vertexBoundsFunction;
        this.expandLayout = builder.expandLayout;
        this.correctOverlap = builder.correctOverlap;
    }

    @Override
    public void setRootPredicate(Predicate<V> rootPredicate) {
        this.rootPredicate = rootPredicate;
    }

    @Override
    public void setRootComparator(Comparator<V> rootComparator) {
        this.rootComparator = rootComparator;
    }

    @Override
    public void setVertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
        Objects.requireNonNull(vertexBoundsFunction);
        this.vertexBoundsFunction = vertexBoundsFunction;
    }

    protected List<V> getRoots(Graph<V, ?> graph) {
        return graph.vertexSet().stream().filter(this.rootPredicate).sorted(this.rootComparator).sorted(Comparator.comparingInt(v -> TreeLayout.vertexIsolationScore(graph, v))).collect(Collectors.toList());
    }

    protected void defineRootPredicate(Graph<V, ?> graph) {
        this.defaultRootPredicate = v -> graph.containsVertex(v) && (graph.incomingEdgesOf(v).isEmpty() || TreeLayout.isIsolatedVertex(graph, v));
        this.rootPredicate = this.rootPredicate == null ? this.defaultRootPredicate : this.rootPredicate.or(this.defaultRootPredicate);
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        this.defineRootPredicate(layoutModel.getGraph());
        this.neighborCache = new NeighborCache(layoutModel.getGraph());
    }

    @Override
    public Map<V, Rectangle> getBaseBounds() {
        return this.baseBounds;
    }

    protected void adjustToFill(int largerWidth, int largerHeight) {
        if (largerWidth > largerHeight) {
            double expansion = (double)largerWidth / (double)largerHeight;
            this.verticalVertexSpacing = (int)((double)this.verticalVertexSpacing * expansion);
        } else if (largerWidth < largerHeight) {
            double expansion = (double)largerHeight / (double)largerWidth;
            this.horizontalVertexSpacing = (int)((double)this.horizontalVertexSpacing * expansion);
        }
    }

    @Override
    protected void expandToFill(LayoutModel<V> layoutModel) {
        Rectangle vertexContainingRectangle = this.computeLayoutExtent(layoutModel);
        vertexContainingRectangle = Rectangle.from(vertexContainingRectangle.min().add(-this.horizontalVertexSpacing, -this.verticalVertexSpacing), vertexContainingRectangle.max().add(this.horizontalVertexSpacing, this.verticalVertexSpacing));
        int maxDimension = Math.max((int)vertexContainingRectangle.width, (int)vertexContainingRectangle.height);
        layoutModel.setSize(maxDimension, maxDimension);
        super.expandToFill(layoutModel, vertexContainingRectangle);
    }

    protected <E> int moveVerticesThatOverlapVerticalEdges(LayoutModel<V> layoutModel, int offset) {
        int moved = 0;
        Graph graph = layoutModel.getGraph();
        LinkedHashMap verticalEdgeMap = new LinkedHashMap();
        graph.edgeSet().stream().filter(e -> ((Point)layoutModel.apply(graph.getEdgeSource(e))).x == ((Point)layoutModel.apply(graph.getEdgeTarget(e))).x).forEach(e -> verticalEdgeMap.computeIfAbsent(((Point)layoutModel.apply(graph.getEdgeSource(e))).x, k -> new HashSet()).add(e));
        for (V v : graph.vertexSet()) {
            double x = ((Point)layoutModel.apply(v)).x;
            for (Object edge : verticalEdgeMap.getOrDefault(x, Collections.emptySet())) {
                double vy;
                V source = graph.getEdgeSource(edge);
                V target = graph.getEdgeTarget(edge);
                if (v.equals(source) || v.equals(target)) continue;
                double lowy = ((Point)layoutModel.apply(source)).y;
                double hiy = ((Point)layoutModel.apply(target)).y;
                if (lowy > hiy) {
                    double temp = lowy;
                    lowy = hiy;
                    hiy = temp;
                }
                if (!(lowy <= (vy = ((Point)layoutModel.apply(v)).y)) || !(vy <= hiy)) continue;
                layoutModel.set(v, ((Point)layoutModel.apply(v)).add(offset, 0.0));
                log.trace("moved {}", (Object)v);
                ++moved;
            }
        }
        return moved;
    }

    @Override
    public boolean constrained() {
        return false;
    }

    public static abstract class Builder<V, T extends AbstractTreeLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected Predicate<V> rootPredicate;
        protected Comparator<V> rootComparator = (v1, v2) -> 0;
        protected int horizontalVertexSpacing = TreeLayout.TREE_LAYOUT_HORIZONTAL_SPACING;
        protected int verticalVertexSpacing = TreeLayout.TREE_LAYOUT_VERTICAL_SPACING;
        protected boolean expandLayout = true;
        protected boolean correctOverlap = true;
        protected Function<V, Rectangle> vertexBoundsFunction = v -> Rectangle.of(-5, -5, 10, 10);

        @Override
        protected B self() {
            return (B)this;
        }

        public B rootPredicate(Predicate<V> rootPredicate) {
            this.rootPredicate = rootPredicate;
            return (B)this.self();
        }

        public B rootComparator(Comparator<V> rootComparator) {
            this.rootComparator = rootComparator;
            return (B)this.self();
        }

        public B horizontalVertexSpacing(int horizontalVertexSpacing) {
            if (horizontalVertexSpacing <= 0) {
                throw new IllegalArgumentException("horizontalVertexSpacing must be positive");
            }
            this.horizontalVertexSpacing = horizontalVertexSpacing;
            return (B)this.self();
        }

        public B verticalVertexSpacing(int verticalVertexSpacing) {
            if (verticalVertexSpacing <= 0) {
                throw new IllegalArgumentException("verticalVertexSpacing must be positive");
            }
            this.verticalVertexSpacing = verticalVertexSpacing;
            return (B)this.self();
        }

        public B vertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
            this.vertexBoundsFunction = vertexBoundsFunction;
            return (B)this.self();
        }

        public B expandLayout(boolean expandLayout) {
            this.expandLayout = expandLayout;
            return (B)this.self();
        }

        public B correctOverlap(boolean correctOverlap) {
            this.correctOverlap = correctOverlap;
            return (B)this.self();
        }
    }
}

