/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.graphviz.ui;

import com.abstratt.graphviz.GraphVizActivator;
import com.abstratt.graphviz.ui.FileBrowserField;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GraphVizPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button automaticDotButton;
    private Button specifyDotButton;
    private FileBrowserField dotBrowser;
    private Text commandLineText;

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    private Button createButton(Group group, String label, boolean enabled, GraphVizActivator.DotMethod method) {
        Button button = GraphVizPreferencePage.createRadioButton((Composite)group, label);
        button.setSelection(this.getCurrentDotMethod() == method);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = GraphVizPreferencePage.this.specifyDotButton.getSelection();
                GraphVizPreferencePage.this.dotBrowser.setEnabled(enabled);
                GraphVizPreferencePage.this.dotBrowserChanged(null);
            }
        });
        button.setEnabled(enabled);
        return button;
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.createOpenModeGroup(composite);
        this.createCommandLineExtension(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    private void createCommandLineExtension(Composite composite) {
        Group group = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText("Additional command line options (prepended to options automatically generated)");
        this.commandLineText = new Text((Composite)group, 2052);
        String existing = GraphVizActivator.getInstance().getCommandLineExtension();
        this.commandLineText.setText(existing == null ? "" : existing);
        data = new GridData();
        data.horizontalIndent = 20;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.commandLineText.setLayoutData((Object)data);
    }

    protected void createOpenModeGroup(Composite composite) {
        Group buttonComposite = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setText("Dot executable to use");
        GraphVizActivator graphviz = GraphVizActivator.getInstance();
        String detectedDotLocation = graphviz.autodetectDots();
        boolean dotDetected = detectedDotLocation != null;
        this.automaticDotButton = this.createButton(buttonComposite, "Found in PATH variable: " + (dotDetected ? detectedDotLocation : "(none)"), true, GraphVizActivator.DotMethod.AUTO);
        this.specifyDotButton = this.createButton(buttonComposite, "Specify Manually:", true, GraphVizActivator.DotMethod.MANUAL);
        this.dotBrowser = new FileBrowserField((Composite)buttonComposite){

            @Override
            public void valueChanged() {
                GraphVizPreferencePage.this.dotBrowserChanged(this.getText());
            }
        };
        this.dotBrowser.setText(graphviz.getManualDotPath());
        this.dotBrowser.setEnabled(this.getCurrentDotMethod() == GraphVizActivator.DotMethod.MANUAL);
        data = new GridData();
        data.horizontalIndent = 20;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.dotBrowser.setLayoutData(data);
    }

    public void dotBrowserChanged(String newText) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (newText == null) {
            newText = this.dotBrowser.getText();
        }
        if (this.specifyDotButton.getSelection()) {
            int extensionPos;
            if (newText.length() == 0) {
                this.setErrorMessage("Please enter a path.");
                this.setValid(false);
                return;
            }
            File dotFile = new File(newText);
            String fileName = dotFile.getName();
            while ((extensionPos = fileName.lastIndexOf(46)) > 0) {
                fileName = fileName.substring(0, extensionPos);
            }
            if (!dotFile.exists()) {
                this.setErrorMessage(String.valueOf(newText) + " doesn't exist");
                this.setValid(false);
                return;
            }
            if (dotFile.isDirectory()) {
                this.setErrorMessage(String.valueOf(newText) + " is a directory");
                this.setValid(false);
                return;
            }
            if (!GraphVizActivator.isExecutable((File)dotFile)) {
                this.setMessage(String.valueOf(newText) + " is not executable!", 2);
            } else if (!"dot".equalsIgnoreCase(fileName)) {
                this.setMessage("The file name should be dot", 2);
            }
        }
        this.setValid(true);
    }

    GraphVizActivator.DotMethod getCurrentDotMethod() {
        return GraphVizActivator.getInstance().getDotSearchMethod();
    }

    GraphVizActivator.DotMethod getNewDotMethod() {
        return this.specifyDotButton.getSelection() ? GraphVizActivator.DotMethod.MANUAL : GraphVizActivator.DotMethod.AUTO;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        GraphVizActivator.DotMethod dotMethod = GraphVizActivator.DotMethod.AUTO;
        this.automaticDotButton.setSelection(dotMethod == GraphVizActivator.DotMethod.AUTO);
        this.specifyDotButton.setSelection(dotMethod == GraphVizActivator.DotMethod.MANUAL);
        this.dotBrowser.setText("");
        this.commandLineText.setText("");
        super.performDefaults();
    }

    public boolean performOk() {
        GraphVizActivator graphviz = GraphVizActivator.getInstance();
        graphviz.setDotSearchMethod(this.getNewDotMethod());
        graphviz.setManualDotPath(this.dotBrowser.getText());
        graphviz.setCommandLineExtension(this.commandLineText.getText());
        return true;
    }
}

