/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.team.internal.core.TeamPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class UserStringMappings {
    public static final Integer BINARY = 2;
    public static final Integer TEXT = 1;
    public static final Integer UNKNOWN = 0;
    private static final String PREF_TEAM_SEPARATOR = "\n";
    private static final String EMPTY_PREF = "";
    private final String fKey;
    private Map<String, Integer> fMap;

    public UserStringMappings(String key) {
        this.fKey = key;
        InstanceScope.INSTANCE.getNode("org.eclipse.team.core").addPreferenceChangeListener(this::preferenceChanged);
    }

    public Map<String, Integer> referenceMap() {
        if (this.fMap == null) {
            this.fMap = this.loadMappingsFromPreferences();
        }
        return this.fMap;
    }

    public void addStringMappings(String[] names, int[] types) {
        Assert.isTrue((names.length == types.length ? 1 : 0) != 0);
        Map<String, Integer> map = this.referenceMap();
        int i = 0;
        while (i < names.length) {
            switch (types[i]) {
                case 2: {
                    map.put(names[i], BINARY);
                    break;
                }
                case 1: {
                    map.put(names[i], TEXT);
                    break;
                }
                case 0: {
                    map.put(names[i], UNKNOWN);
                }
            }
            ++i;
        }
        this.save();
    }

    public void setStringMappings(String[] names, int[] types) {
        Assert.isTrue((names.length == types.length ? 1 : 0) != 0);
        this.referenceMap().clear();
        this.addStringMappings(names, types);
    }

    public int getType(String string) {
        if (string == null) {
            return 0;
        }
        Integer type = this.referenceMap().get(string);
        return type != null ? type : 0;
    }

    public void save() {
        StringBuilder buffer = new StringBuilder();
        for (String filename : this.fMap.keySet()) {
            buffer.append(filename);
            buffer.append(PREF_TEAM_SEPARATOR);
            Integer type = this.fMap.get(filename);
            buffer.append(type);
            buffer.append(PREF_TEAM_SEPARATOR);
        }
        try {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.team.core");
            node.put(this.fKey, buffer.toString());
            node.flush();
        }
        catch (BackingStoreException ex) {
            TeamPlugin.log(4, ex.getMessage(), ex);
        }
    }

    protected Map<String, Integer> loadMappingsFromPreferences() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (!this.nodeAccessibleAndExists(this.fKey)) {
            return result;
        }
        StringTokenizer tok = new StringTokenizer(this.mappings(), PREF_TEAM_SEPARATOR);
        try {
            while (tok.hasMoreElements()) {
                String name = tok.nextToken();
                String mode = tok.nextToken();
                result.put(name, Integer.valueOf(mode));
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return result;
    }

    private String mappings() {
        return Optional.ofNullable(InstanceScope.INSTANCE.getNode("org.eclipse.team.core")).map(node -> node.get(this.fKey, null)).orElse(EMPTY_PREF);
    }

    private boolean nodeAccessibleAndExists(String key) {
        try {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.team.core");
            return Stream.of(node.keys()).anyMatch(candidate -> key.equals(candidate));
        }
        catch (BackingStoreException e) {
            TeamPlugin.log(4, e.getMessage(), e);
            return false;
        }
    }

    private void preferenceChanged(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.fKey.equals(event.getKey())) {
            this.fMap = null;
        }
    }
}

