/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.pluginutils;

import com.abstratt.pluginutils.LogUtils;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public abstract class RegistryReader {
    public static final String ATT_CLASS = "class";

    public static String getClassValue(IConfigurationElement configElement, String classAttributeName) {
        String className = configElement.getAttribute(classAttributeName);
        if (className != null) {
            return className;
        }
        IConfigurationElement[] candidateChildren = configElement.getChildren(classAttributeName);
        if (candidateChildren.length == 0) {
            return null;
        }
        return candidateChildren[0].getAttribute(ATT_CLASS);
    }

    public static IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Comparator<IExtension> comparer = new Comparator<IExtension>(){

            @Override
            public int compare(IExtension e1, IExtension e2) {
                return e1.getNamespaceIdentifier().compareToIgnoreCase(e2.getNamespaceIdentifier());
            }
        };
        Arrays.sort(sortedExtension, comparer);
        return sortedExtension;
    }

    protected abstract String getNamespace();

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        LogUtils.logError(this.getNamespace(), buf.toString(), null);
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    public void readRegistry(IExtensionRegistry registry, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        extensions = RegistryReader.orderExtensions(extensions);
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

