/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.graphviz;

import com.abstratt.graphviz.GraphVizActivator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class ProcessController {
    private boolean finished;
    private OutputStream forwardStdErr;
    private InputStream forwardStdIn;
    private OutputStream forwardStdOut;
    private boolean killed;
    private String[] params;
    private Process process;
    private long startupTime;
    private long timeLimit;
    private String[] env;
    private File baseDir;

    public ProcessController(long timeout, String[] params, String[] env, File baseDir) {
        this.timeLimit = timeout;
        this.params = params;
        this.env = env;
        this.baseDir = baseDir;
    }

    private void controlProcess() {
        new Thread("Process controller"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ProcessController.this.isFinished() && !ProcessController.this.timedOut()) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
                ProcessController.this.kill();
            }
        }.start();
    }

    public int execute() throws InterruptedException, IOException, TimeOutException {
        this.startupTime = System.currentTimeMillis();
        this.process = Runtime.getRuntime().exec(this.params, this.env, this.baseDir);
        if (this.forwardStdErr != null) {
            this.forwardStream("stderr", this.process.getErrorStream(), this.forwardStdErr);
        }
        if (this.forwardStdOut != null) {
            this.forwardStream("stdout", this.process.getInputStream(), this.forwardStdOut);
        }
        if (this.forwardStdIn != null) {
            this.forwardStream("stdin", this.forwardStdIn, this.process.getOutputStream());
        }
        if (this.timeLimit > 0L) {
            this.controlProcess();
        }
        try {
            int n = this.process.waitFor();
            return n;
        }
        finally {
            this.markFinished();
            if (this.wasKilled()) {
                throw new TimeOutException();
            }
        }
    }

    public void forwardErrorOutput(OutputStream err) {
        this.forwardStdErr = err;
    }

    public void forwardInput(InputStream in) {
        this.forwardStdIn = in;
    }

    public void forwardOutput(OutputStream out) {
        this.forwardStdOut = out;
    }

    private void forwardStream(String name, final InputStream in, final OutputStream out) {
        new Thread("Stream forwarder [" + name + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                key = UUID.randomUUID().toString();
                System.out.println("Started " + this.getName() + " - " + key);
                try {
                    try {
                        ** GOTO lbl16
                        {
                            out.write(in.read());
                            do {
                                if (this.safeIsAvailable(in) > 0) continue block10;
                                var2_2 = this;
                                synchronized (var2_2) {
                                    this.wait(100L);
                                }
lbl16:
                                // 2 sources

                            } while (!ProcessController.this.isFinished());
                        }
                        out.flush();
                    }
                    catch (IOException e) {
                        GraphVizActivator.logUnexpected(null, e);
                        System.out.println("Finished " + this.getName() + " - " + key);
                    }
                    catch (InterruptedException e) {
                        GraphVizActivator.logUnexpected(null, e);
                        System.out.println("Finished " + this.getName() + " - " + key);
                    }
                }
                finally {
                    System.out.println("Finished " + this.getName() + " - " + key);
                }
            }

            private int safeIsAvailable(InputStream in2) {
                try {
                    return in2.available();
                }
                catch (IOException iOException) {
                    return 0;
                }
            }
        }.start();
    }

    public Process getProcess() {
        return this.process;
    }

    protected synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        ProcessController processController = this;
        synchronized (processController) {
            if (this.isFinished()) {
                return;
            }
            this.killed = true;
        }
        this.process.destroy();
    }

    private synchronized void markFinished() {
        this.finished = true;
        this.notifyAll();
    }

    protected synchronized boolean timedOut() {
        return System.currentTimeMillis() - this.startupTime > this.timeLimit;
    }

    public boolean wasKilled() {
        return this.killed;
    }

    public class TimeOutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TimeOutException() {
        }

        public TimeOutException(String message) {
            super(message);
        }
    }
}

