/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.MethodNameMatchRequestor;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessMethodRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchMethodNameMatch;
import org.eclipse.jdt.internal.core.search.NameMatchRequestorWrapper;

public class MethodNameMatchRequestorWrapper
extends NameMatchRequestorWrapper
implements IRestrictedAccessMethodRequestor {
    MethodNameMatchRequestor requestor;

    public MethodNameMatchRequestorWrapper(MethodNameMatchRequestor requestor, IJavaSearchScope scope) {
        super(scope);
        this.requestor = requestor;
    }

    @Override
    public void acceptMethod(char[] methodName, int parameterCount, char[] declaringQualifier, char[] simpleTypeName, int typeModifiers, char[] packageName, char[] signature, char[][] parameterTypes, char[][] parameterNames, char[] returnType, int modifiers, String path, AccessRestriction access, int methodIndex) {
        char[][] enclosingTypeNames = declaringQualifier != null && declaringQualifier.length > 0 ? CharOperation.splitOn((char)'.', (char[])declaringQualifier) : CharOperation.NO_CHAR_CHAR;
        IType type = this.getType(typeModifiers, packageName, simpleTypeName, enclosingTypeNames, path, access);
        if (type == null) {
            return;
        }
        if (this.scope instanceof HierarchyScope && !((HierarchyScope)this.scope).enclosesFineGrained(type)) {
            return;
        }
        parameterTypes = parameterTypes == null ? CharOperation.NO_CHAR_CHAR : parameterTypes;
        String[] paramTypeSigs = CharOperation.NO_STRINGS;
        if (signature != null) {
            char[][] parTypes = Signature.getParameterTypes(signature);
            if (parTypes.length > 0) {
                int i = 0;
                int l = parTypes.length;
                while (i < l) {
                    CharOperation.replace((char[])parTypes[i], (char)'/', (char)'.');
                    ++i;
                }
            }
            paramTypeSigs = CharOperation.toStrings((char[][])parTypes);
        } else if (parameterTypes.length > 0) {
            int l = parameterTypes.length;
            paramTypeSigs = new String[l];
            int i = 0;
            while (i < l) {
                paramTypeSigs[i] = Signature.createTypeSignature(parameterTypes[i], false);
                ++i;
            }
        }
        IMethod method = type.getMethod(new String(methodName), paramTypeSigs);
        this.requestor.acceptMethodNameMatch(new JavaSearchMethodNameMatch(method, modifiers));
    }
}

