/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.pcal;

import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.jface.dialogs.ForkedProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import pcal.ValidationCallBack;

public class ValidationProgressMonitorDialog
extends ForkedProgressMonitorDialog
implements IRunnableContext,
ValidationCallBack {
    private Button continueButton;
    private Button thirdButton;

    public ValidationProgressMonitorDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Translate PlusCal Algorithm.");
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.thirdButton = this.createButton(parent, 0, "&Overwrite Translation", true);
        this.thirdButton.setEnabled(false);
        this.thirdButton.setVisible(false);
        this.continueButton = this.createButton(parent, 0, "&Overwrite Translation", true);
        this.continueButton.setEnabled(false);
        super.createButtonsForButtonBar(parent);
        this.cancel.setText("&Abort");
        this.getShell().setDefaultButton(this.continueButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldCancel() {
        final Object lock = new Object();
        Listener listener = new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event e) {
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        };
        this.getShell().getDisplay().syncExec(() -> {
            this.getProgressMonitor().setTaskName("Overwrite modified TLA+ translation?");
            this.getProgressMonitor().subTask("The TLA+ translation has been manually modified since its last translation (chksum(tla) mismatch).  Click the \"Overwrite Translation\" button to replace the TLA+ translation anyway or \"Cancel\" to abort re-translation and keep the modified TLA+ translation.");
            this.continueButton.setText("&Overwrite Translation");
            this.continueButton.setEnabled(true);
            this.continueButton.addListener(13, listener);
            this.cancel.setText("&Abort");
            this.cancel.setEnabled(true);
            this.cancel.addListener(13, listener);
        });
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        return this.getProgressMonitor().isCanceled();
    }

    public ValidationCallBack.Generate shouldGenerate() {
        ArrayBlockingQueue q = new ArrayBlockingQueue(1);
        this.getShell().getDisplay().syncExec(() -> {
            this.getProgressMonitor().setTaskName("Add Checksums to TLA+ translation?");
            this.getProgressMonitor().subTask("The PlusCal translator can add checksums to the \\* BEGIN TRANSLATION line of this spec to warn you before model-checking a stale TLA+ translation. Do you want to add checksums, never add checksums, or decide later?");
            this.continueButton.setText("&Add Checksums");
            this.continueButton.setEnabled(true);
            this.continueButton.addListener(13, e -> {
                boolean bl = q.offer(ValidationCallBack.Generate.DO_IT);
            });
            this.cancel.setText("&Later");
            this.cancel.setEnabled(true);
            this.cancel.addListener(13, e -> {
                boolean bl = q.offer(ValidationCallBack.Generate.NOT_NOW);
            });
            this.thirdButton.setText("&Never Add");
            this.thirdButton.setEnabled(true);
            this.thirdButton.setVisible(true);
            this.thirdButton.addListener(13, e -> {
                boolean bl = q.offer(ValidationCallBack.Generate.IGNORE);
            });
        });
        try {
            return (ValidationCallBack.Generate)q.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ValidationCallBack.Generate.NOT_NOW;
        }
    }
}

