/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.editor.basic.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.util.EditorUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;

public class GotoNextUseHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Spec spec = ToolboxHandle.getCurrentSpec();
        if (spec == null) {
            return null;
        }
        IMarker[] markers = spec.getMarkersToShow();
        if (markers == null) {
            return null;
        }
        spec.setCurrentSelection((spec.getCurrentSelection() + 1) % markers.length);
        GotoNextUseHandler.jumpToCurrentSelection(spec);
        return null;
    }

    public boolean isEnabled() {
        Spec spec = ToolboxHandle.getCurrentSpec();
        if (spec == null) {
            return false;
        }
        return spec.getMarkersToShow() != null;
    }

    public static void jumpToCurrentSelection(Spec spec) {
        IResource moduleResource = ResourceHelper.getResourceByModuleName((String)spec.getModuleToShow());
        if (moduleResource != null && moduleResource.exists()) {
            IDocument document = null;
            FileEditorInput fileEditorInput = new FileEditorInput((IFile)moduleResource);
            FileDocumentProvider fileDocumentProvider = new FileDocumentProvider();
            try {
                try {
                    fileDocumentProvider.connect((Object)fileEditorInput);
                    document = fileDocumentProvider.getDocument((Object)fileEditorInput);
                    if (document != null) {
                        IMarker marker = spec.getMarkersToShow()[spec.getCurrentSelection()];
                        Position pos = EditorUtil.getMarkerPosition(marker);
                        int offset = pos.getOffset();
                        int length = pos.getLength();
                        IEditorPart editor = UIHelper.openEditor((String)"org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer", (IEditorInput)new FileEditorInput((IFile)moduleResource));
                        if (editor != null) {
                            ITextEditor textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                            if (textEditor == null && editor instanceof MultiPageEditorPart) {
                                IEditorPart[] editors = ((MultiPageEditorPart)editor).findEditors(editor.getEditorInput());
                                int i = 0;
                                while (i < editors.length) {
                                    if (editors[i] instanceof ITextEditor) {
                                        textEditor = (ITextEditor)editors[i];
                                    }
                                    ++i;
                                }
                            }
                            if (textEditor != null) {
                                if (editor instanceof MultiPageEditorPart) {
                                    ((MultiPageEditorPart)editor).setActiveEditor((IEditorPart)textEditor);
                                }
                                textEditor.selectAndReveal(offset, length);
                            }
                        }
                    }
                }
                catch (CoreException e1) {
                    Activator.getDefault().logDebug("Error going to a module location. This is a bug.");
                    fileDocumentProvider.disconnect((Object)fileEditorInput);
                }
            }
            finally {
                fileDocumentProvider.disconnect((Object)fileEditorInput);
            }
        }
    }
}

