/*
 * Decompiled with CFR 0.152.
 */
package com.abstratt.imageviewer;

import com.abstratt.content.ContentSupport;
import com.abstratt.content.IContentProviderRegistry;
import com.abstratt.imageviewer.Activator;
import com.abstratt.imageviewer.GraphicalViewer;
import com.abstratt.imageviewer.IGraphicalContentProvider;
import com.abstratt.imageviewer.IGraphicalFileProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

public class GraphicalView
extends ViewPart
implements IResourceChangeListener,
IPartListener2,
ISelectionListener {
    public static final String VIEW_ID = "com.abstratt.imageviewer.GraphicalView";
    private Canvas canvas;
    private GraphicalViewer viewer;
    private String basePartName;
    private IFile selectedFile;
    private IContentProviderRegistry.IProviderDescription providerDefinition;
    private boolean autoSync = true;

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.basePartName = this.getPartName();
        this.canvas = new Canvas(parent, 0);
        this.viewer = new GraphicalViewer((Composite)this.canvas);
        this.installResourceListener();
        this.installSelectionListener();
        this.installPartListener();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().removePartListener((IPartListener2)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    private void installPartListener() {
        this.getSite().getPage().addPartListener((IPartListener2)this);
        this.loadFromActivePart();
    }

    private void loadFromActivePart() {
        IWorkbenchPartReference activePartReference = this.getSite().getPage().getActivePartReference();
        if (activePartReference != null) {
            this.reactToPartChange(activePartReference);
        }
    }

    private void installResourceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void installSelectionListener() {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.reactToSelection(selection);
    }

    private void reactToSelection(ISelection selection) {
        if (!this.autoSync) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)selection;
        if (structured.size() != 1) {
            return;
        }
        Object selected = structured.getFirstElement();
        IFile file = (IFile)Platform.getAdapterManager().getAdapter(selected, IFile.class);
        this.reload(file);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        this.reactToPartChange(partRef);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.reactToPartChange(partRef);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
        this.reactToPartChange(partRef);
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        this.reactToPartChange(partRef);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.reactToPartChange(partRef);
    }

    private void reactToPartChange(IWorkbenchPartReference part) {
        if (!this.autoSync) {
            return;
        }
        if (!(part.getPart(false) instanceof IEditorPart)) {
            return;
        }
        IEditorPart editorPart = (IEditorPart)part.getPart(false);
        if (!this.getViewSite().getPage().isPartVisible((IWorkbenchPart)editorPart)) {
            return;
        }
        IGraphicalFileProvider graphicalSource = (IGraphicalFileProvider)editorPart.getAdapter(IGraphicalFileProvider.class);
        this.selectedFile = graphicalSource != null ? graphicalSource.getGraphicalFile() : null;
        if (this.selectedFile == null) {
            IFile asFile = (IFile)editorPart.getAdapter(IFile.class);
            if (asFile == null) {
                asFile = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
            }
            if (asFile == null) {
                return;
            }
            this.selectedFile = asFile;
        }
        this.requestUpdate();
    }

    private void reload(IFile file) {
        IContentDescription contentDescription;
        block6: {
            this.setPartName(this.basePartName);
            this.providerDefinition = null;
            this.selectedFile = null;
            if (file == null || !file.exists()) {
                return;
            }
            if (this.viewer.getContentProvider() != null) {
                this.viewer.setInput(null);
            }
            contentDescription = null;
            try {
                contentDescription = file.getContentDescription();
            }
            catch (CoreException e) {
                if (!Platform.inDebugMode()) break block6;
                Activator.logUnexpected(null, (Exception)((Object)e));
            }
        }
        if (contentDescription == null || contentDescription.getContentType() == null) {
            return;
        }
        IContentProviderRegistry.IProviderDescription providerDefinition = ContentSupport.getContentProviderRegistry().findContentProvider(contentDescription.getContentType(), IGraphicalContentProvider.class);
        if (providerDefinition == null) {
            return;
        }
        IGraphicalContentProvider provider = (IGraphicalContentProvider)providerDefinition.getProvider();
        this.setContents(providerDefinition.read((Object)file), provider);
        this.selectedFile = file;
        this.providerDefinition = providerDefinition;
        this.setPartName(String.valueOf(this.basePartName) + " - " + file.getName());
    }

    public void setContents(Object contents, IGraphicalContentProvider provider) {
        this.selectedFile = null;
        this.providerDefinition = null;
        this.viewer.setContentProvider(provider);
        this.viewer.setInput(contents);
        this.setPartName(this.basePartName);
    }

    Object getInput() {
        return this.viewer.getInput();
    }

    IGraphicalContentProvider getContentProvider() {
        return (IGraphicalContentProvider)this.viewer.getContentProvider();
    }

    private void requestUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphicalView.this.getSite() == null || !GraphicalView.this.getSite().getPage().isPartVisible((IWorkbenchPart)GraphicalView.this)) {
                    return;
                }
                GraphicalView.this.reload(GraphicalView.this.selectedFile);
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.selectedFile == null || !this.selectedFile.exists()) {
            return;
        }
        if (event.getDelta() == null) {
            return;
        }
        IResourceDelta interestingChange = event.getDelta().findMember(this.selectedFile.getFullPath());
        if (interestingChange != null) {
            this.requestUpdate();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public IContentProviderRegistry.IProviderDescription getContentProviderDescription() {
        return this.providerDefinition;
    }

    public IFile getSelectedFile() {
        return this.selectedFile;
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public void setAutoSync(boolean autoSync) {
        this.autoSync = autoSync;
        this.updateAutoSyncToggleButtonState();
    }

    private void updateAutoSyncToggleButtonState() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        ActionContributionItem autoSyncToggleContribution = (ActionContributionItem)toolBarManager.find("com.abstratt.imageviewer.autoUpdate");
        if (autoSyncToggleContribution != null) {
            IAction action = autoSyncToggleContribution.getAction();
            action.setChecked(this.isAutoSync());
        }
    }

    public void toggleSync() {
        this.setAutoSync(!this.isAutoSync());
    }
}

