/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class Type1
extends PdfFont {
    protected boolean isCID = false;
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    private int skipBytes = 4;
    public static final String[] T1CcharCodes1Byte = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closePathT1", "callsubr", "return", "escape", "hsbwT1", "endchar", "-Reserved-", "blend", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "intint", "callgsubr", "vhcurveto", "hvcurveto"};
    public static final String[] T1C = new String[]{"dotSection", "vstem3", "hstem3", "and", "or", "not", "seacT1", "swbT1", "store", "abs", "add", "sub", "div", "load", "neg", "eq", "callothersubT1", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpointT1", "hflex", "flex", "hflex1", "flex1"};
    boolean trackIndices = false;

    public Type1(PdfObjectReader pdfObjectReader, String string) {
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    public Type1() {
    }

    protected final void readType1FontFile(byte[] byArray) throws Exception {
        block13: {
            String string;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Embedded Type1 font used " + this.getBaseFontName());
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.startsWith("/Encoding 256 array")) {
                    this.readDiffEncoding(bufferedReader);
                    continue;
                }
                if (string.startsWith("/lenIV")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    this.skipBytes = Integer.parseInt(stringTokenizer.nextToken());
                    continue;
                }
                if (string.indexOf("/FontMatrix") == -1) continue;
                String string2 = "";
                int n2 = string.indexOf(91);
                if (n2 != -1) {
                    n = string.indexOf(93);
                    string2 = string.substring(n2 + 1, n);
                } else {
                    n2 = string.indexOf(123);
                    if (n2 != -1) {
                        n = string.indexOf(125);
                        string2 = string.substring(n2 + 1, n);
                    }
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                for (int i = 0; i < 6; ++i) {
                    this.FontMatrix[i] = Double.parseDouble(stringTokenizer.nextToken());
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception " + exception + " closing stream");
                }
            }
        }
        int n = 0;
        if (this.renderPage) {
            n = this.readEncodedContent(byArray);
        }
        this.glyphs.setGlyphCount(n);
        if (!this.renderPage || n > 0) {
            this.isFontEmbedded = true;
        }
        this.glyphs.setFontEmbedded(true);
    }

    private void readDiffEncoding(BufferedReader bufferedReader) throws Exception {
        String string;
        while ((string = bufferedReader.readLine()) != null && !(string = string.trim()).startsWith("readonly")) {
            int n;
            StringTokenizer stringTokenizer;
            if (!string.startsWith("dup") || !string.contains("/") || (stringTokenizer = new StringTokenizer(string, " /")).countTokens() < 3) continue;
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(35);
            if (n2 == -1) {
                n = Integer.parseInt(string2);
            } else {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1, string2.length());
                n = Integer.parseInt(string4, Integer.parseInt(string3));
            }
            String string5 = stringTokenizer.nextToken();
            this.putChar(n, string5);
            char c = string5.charAt(0);
            if (c != 'B' && c != 'C' && c != 'c' && c != 'G') continue;
            int n3 = 1;
            int n4 = string5.length();
            while (!this.isHex && n3 < n4) {
                this.isHex = Character.isLetter(string5.charAt(n3++));
            }
        }
    }

    protected final void putChar(int n, String string) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[n] = string;
        if (!this.hasEncoding && !this.isCID && StandardFonts.getUnicodeName(string) != null) {
            this.putMappedChar(n, string);
        }
    }

    private int readEncodedContent(byte[] byArray) throws Exception {
        String string;
        int n;
        int n2 = 0;
        String string2 = "rd";
        String string3 = "nd";
        int n3 = byArray.length;
        int n4 = -1;
        int n5 = -1;
        for (n = 4; n < n3; ++n) {
            if (byArray[n - 3] != 101 || byArray[n - 2] != 120 || byArray[n - 1] != 101 || byArray[n] != 99) continue;
            n4 = n + 1;
            while (byArray[n4] == 10 || byArray[n4] == 13) {
                ++n4;
            }
            n = n3;
        }
        if (n4 != -1) {
            for (n = n4; n < n3 - 10; ++n) {
                if (byArray[n] != 99 || byArray[n + 1] != 108 || byArray[n + 2] != 101 || byArray[n + 3] != 97 || byArray[n + 4] != 114 || byArray[n + 5] != 116 || byArray[n + 6] != 111 || byArray[n + 7] != 109 || byArray[n + 8] != 97 || byArray[n + 9] != 114 || byArray[n + 10] != 107) continue;
                n5 = n - 1;
                while (byArray[n5] == 10 || byArray[n5] == 13) {
                    --n5;
                }
                n = n3;
            }
        }
        if (n5 == -1) {
            n5 = n3;
        }
        int n6 = 55665;
        int n7 = 4;
        boolean bl = true;
        for (n = n4; n < n4 + n7 * 2; ++n) {
            char c = (char)byArray[n];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            bl = false;
            break;
        }
        if (n4 != -1) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5 - n4);
            if (this.isFontSubstituted && !bl) {
                n4 = n4 + 2 + this.skipBytes;
            }
            for (n = n4; n < n5; ++n) {
                int n8;
                if (!bl) {
                    n8 = byArray[n] & 0xFF;
                } else {
                    int n9 = 0;
                    StringBuffer stringBuffer = new StringBuffer();
                    while (n9 < 2) {
                        n8 = byArray[n] & 0xFF;
                        ++n;
                        if (n8 == 10 || n8 == 13 || n8 == 9 || n8 == 32) continue;
                        stringBuffer.append((char)n8);
                        ++n9;
                    }
                    --n;
                    n8 = Integer.parseInt(stringBuffer.toString(), 16);
                }
                int n10 = n8 ^ n6 >> 8;
                n6 = (n8 + n6) * 52845 + 22719 & 0xFFFF;
                if (n <= n4 + n7) continue;
                byteArrayOutputStream.write(n10);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.startsWith("/lenIV")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            this.skipBytes = Integer.parseInt(stringTokenizer.nextToken());
        }
        bufferedReader.close();
        int n11 = byArray.length;
        int n12 = -1;
        n4 = -1;
        for (int i = 0; i < n11 && i != n11; ++i) {
            if (i + 11 < n11 && byArray[i] == 47 && byArray[i + 1] == 67 && byArray[i + 2] == 104 && byArray[i + 3] == 97 && byArray[i + 4] == 114 && byArray[i + 5] == 83 && byArray[i + 6] == 116 && byArray[i + 7] == 114 && byArray[i + 8] == 105 && byArray[i + 9] == 110 && byArray[i + 10] == 103 && byArray[i + 11] == 115) {
                n4 = i + 11;
            } else if (i + 5 < n11 && byArray[i] == 47 && byArray[i + 1] == 83 && byArray[i + 2] == 117 && byArray[i + 3] == 98 && byArray[i + 4] == 114 && byArray[i + 5] == 115) {
                n12 = i + 6;
            }
            if (n12 > -1 && n4 > -1) break;
        }
        if (n4 == -1) {
            this.isFontSubstituted = false;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No glyph data found");
            }
        } else {
            n2 = this.extractFontData(this.skipBytes, byArray, n4, string2, n11, string3);
        }
        if (n12 > -1) {
            this.extractSubroutineData(this.skipBytes, byArray, n12, n4, string2, n11, string3);
        }
        return n2;
    }

    private void extractSubroutineData(int n, byte[] byArray, int n2, int n3, String string, int n4, String string2) throws IOException {
        int n5;
        while (byArray[n2] == 32 || byArray[n2] == 10 || byArray[n2] == 13) {
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n5 = (int)byArray[n2]) != 32) {
            stringBuffer.append((char)n5);
            ++n2;
        }
        int n6 = Integer.parseInt(stringBuffer.toString());
        for (n5 = 0; n5 < n6; ++n5) {
            int n7;
            while (n2 < n4 && !((byArray[n2 - 2] == 100 && byArray[n2 - 1] == 117 && byArray[n2] == 112) | n2 == n3)) {
                ++n2;
            }
            if (n2 == n3) {
                n5 = n6;
                continue;
            }
            while (byArray[n2 + 1] == 32) {
                ++n2;
            }
            StringBuffer stringBuffer2 = new StringBuffer("subrs");
            while ((n7 = (int)byArray[++n2]) != 32) {
                stringBuffer2.append((char)n7);
            }
            stringBuffer = new StringBuffer();
            while ((n7 = (char)byArray[++n2]) != 32) {
                stringBuffer.append((char)n7);
            }
            n7 = Integer.parseInt(stringBuffer.toString());
            while (byArray[n2] == 32) {
                ++n2;
            }
            n2 = n2 + string.length() + 1;
            byte[] byArray2 = Type1.getStream(n, n2, n7, byArray);
            this.glyphs.setCharString(stringBuffer2.toString(), byArray2);
            n2 = n2 + n7 + string2.length();
        }
    }

    private int extractFontData(int n, byte[] byArray, int n2, String string, int n3, String string2) throws IOException {
        int n4 = byArray.length;
        int n5 = 0;
        while (n2 < n4 && byArray[n2] != 47) {
            ++n2;
        }
        int n6 = n2;
        while (n2 < n3) {
            if (byArray[n6] == 47) {
                n6 += 2;
                while (n6 < n4 && (byArray[n6 - 1] != 124 || byArray[n6] != 45 && byArray[n6] != 48 || byArray[n6 + 1] != 10 && byArray[n6 + 1] != 13) && (byArray[n6 - 1] != 78 || byArray[n6] != 68)) {
                    ++n6;
                }
            }
            if (n4 - n6 < 3 || byArray[n6 - 1] != 47 && byArray[n6] == 101 && byArray[n6 + 1] == 110 && byArray[n6 + 2] == 100) break;
            ++n6;
        }
        while (n2 <= n6) {
            int n7;
            char c;
            StringBuffer stringBuffer = new StringBuffer(20);
            while ((c = (char)byArray[++n2]) != ' ') {
                stringBuffer.append(c);
            }
            if (this.trackIndices) {
                this.glyphs.setIndexForCharString(n5, stringBuffer.toString());
            }
            ++n2;
            StringBuffer stringBuffer2 = new StringBuffer();
            while ((n7 = (int)byArray[n2]) != 32) {
                stringBuffer2.append((char)n7);
                ++n2;
            }
            n7 = Integer.parseInt(stringBuffer2.toString());
            while (byArray[n2] == 32) {
                ++n2;
            }
            n2 = n2 + string.length() + 1;
            byte[] byArray2 = Type1.getStream(n, n2, n7, byArray);
            this.glyphs.setCharString(stringBuffer.toString(), byArray2);
            ++n5;
            for (n2 = n2 + n7 + string2.length(); n2 <= n6 && byArray[n2] != 47; ++n2) {
            }
        }
        return n5;
    }

    private static final byte[] getStream(int n, int n2, int n3, byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = 4330;
        for (int i = 0; i < n3; ++i) {
            int n5 = byArray[n2 + i] & 0xFF;
            int n6 = n5 ^ n4 >> 8;
            n4 = (n5 + n4) * 52845 + 22719 & 0xFFFF;
            if (i < n) continue;
            byteArrayOutputStream.write(n6);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

