/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.editors;

import de.vonloesch.pdf4eclipse.Activator;
import de.vonloesch.pdf4eclipse.Messages;
import de.vonloesch.pdf4eclipse.PDFPageViewer;
import de.vonloesch.pdf4eclipse.editors.PDFNavigationLocation;
import de.vonloesch.pdf4eclipse.editors.StatusLinePageSelector;
import de.vonloesch.pdf4eclipse.model.IOutlineNode;
import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.model.IPDFFile;
import de.vonloesch.pdf4eclipse.model.IPDFPage;
import de.vonloesch.pdf4eclipse.model.PDFFactory;
import de.vonloesch.pdf4eclipse.outline.PDFFileOutline;
import de.vonloesch.synctex.SimpleSynctexParser;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PDFEditor
extends EditorPart
implements IResourceChangeListener,
INavigationLocationProvider,
StatusLinePageSelector.IPageChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String ID = "de.vonloesch.pdf4eclipse.editors.PDFEditor";
    public static final String CONTEXT_ID = "PDFViewer.editors.contextid";
    public static final int FORWARD_SEARCH_OK = 0;
    public static final int FORWARD_SEARCH_NO_SYNCTEX = -1;
    public static final int FORWARD_SEARCH_FILE_NOT_FOUND = -2;
    public static final int FORWARD_SEARCH_POS_NOT_FOUND = -3;
    public static final int FORWARD_SEARCH_UNKNOWN_ERROR = -4;
    private static final float MOUSE_ZOOMFACTOR = 0.2f;
    private static final int SCROLLING_WAIT_TIME = 200;
    static final String PDFPOSITION_ID = "PDFPosition";
    public PDFPageViewer pv;
    private File file;
    private IPDFFile f;
    private ScrolledComposite sc;
    int currentPage;
    private PDFFileOutline outline;
    private StatusLinePageSelector position;
    private Listener mouseWheelPageListener;
    private boolean isListeningForMouseWheel;
    private Cursor cursorHand;
    private Cursor cursorArrow;

    public void dispose() {
        super.dispose();
        if (this.sc != null) {
            this.sc.dispose();
        }
        if (this.pv != null) {
            this.pv.dispose();
        }
        if (this.outline != null) {
            this.outline.dispose();
        }
        if (this.cursorArrow != null) {
            this.cursorArrow.dispose();
        }
        if (this.cursorHand != null) {
            this.cursorHand.dispose();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.position != null) {
            this.position.removePageChangeListener(this);
        }
        IEclipsePreferences prefs = new InstanceScope().getNode("de.vonloesch.pdf4Eclipse");
        prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.f != null) {
            this.f.close();
        }
        this.f = null;
        this.pv = null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.currentPage = 1;
        this.setPartName(input.getName());
        this.readPdfFile();
    }

    @Override
    public void pageChange(int pageNr) {
        this.showPage(pageNr);
        this.setOrigin(this.sc.getOrigin().x, 0);
    }

    public void readPdfFile() throws PartInitException {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileStoreEditorInput) {
            this.file = new File(((FileStoreEditorInput)input).getURI());
        } else if (input instanceof IFileEditorInput) {
            this.file = new File(((IFileEditorInput)input).getFile().getLocationURI());
        } else {
            throw new PartInitException(Messages.PDFEditor_ErrorMsg1);
        }
        this.f = null;
        try {
            IEclipsePreferences prefs = new InstanceScope().getNode("de.vonloesch.pdf4Eclipse");
            int r = prefs.getInt("pdfRenderer", 3);
            this.f = PDFFactory.openPDFFile(this.file, r);
        }
        catch (FileNotFoundException fnfe) {
            throw new PartInitException(Messages.PDFEditor_ErrorMsg3, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new PartInitException(Messages.PDFEditor_ErrorMsg4, (Throwable)ioe);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            try {
                if (!(this.getEditorInput() instanceof IFileEditorInput)) {
                    return;
                }
                IFile currentfile = ((IFileEditorInput)this.getEditorInput()).getFile();
                IResourceDelta delta = event.getDelta().findMember(currentfile.getFullPath());
                if (delta != null && (delta.getKind() & 2) == 0) {
                    this.f.reload();
                    final IOutlineNode n = this.f.getOutline();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (PDFEditor.this.pv != null && !PDFEditor.this.pv.isDisposed()) {
                                PDFEditor.this.showPage(PDFEditor.this.currentPage);
                                if (PDFEditor.this.outline != null) {
                                    PDFEditor.this.outline.setInput(n);
                                }
                                PDFEditor.this.pv.redraw();
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createPartControl(Composite parent) {
        IContributionItem[] items;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Composite menuC = new Composite(composite, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        menuC.setLayoutData((Object)layoutData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layoutData.exclude = true;
        menuC.setLayout((Layout)layout);
        this.sc = new ScrolledComposite(composite, 768);
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true));
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        fillLayout.spacing = 0;
        this.sc.setLayout((Layout)fillLayout);
        this.cursorHand = new Cursor((Device)Display.getDefault(), 21);
        this.cursorArrow = new Cursor((Device)Display.getDefault(), 0);
        this.pv = new PDFPageViewer((Composite)this.sc, this);
        this.sc.setContent((Control)this.pv);
        ScrollBar vBar = this.sc.getVerticalBar();
        vBar.setIncrement(10);
        this.isListeningForMouseWheel = false;
        this.mouseWheelPageListener = new Listener(){
            long lastTime;

            public void handleEvent(Event e) {
                long time = (long)e.time & 0xFFFFFFFFL;
                if (time - this.lastTime < 200L) {
                    e.doit = false;
                    return;
                }
                Point p = PDFEditor.this.sc.getOrigin();
                int pheight = ((PDFEditor)PDFEditor.this).sc.getContent().getBounds().height;
                int height = ((PDFEditor)PDFEditor.this).sc.getClientArea().height;
                if (p.y >= pheight - height && e.count < 0) {
                    if (PDFEditor.this.currentPage < PDFEditor.this.f.getNumPages()) {
                        PDFEditor.this.showPage(PDFEditor.this.currentPage + 1);
                        PDFEditor.this.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, 0);
                        e.doit = false;
                        this.lastTime = time;
                    }
                } else if (p.y <= 0 && e.count > 0 && PDFEditor.this.currentPage > 1) {
                    PDFEditor.this.showPage(PDFEditor.this.currentPage - 1);
                    PDFEditor.this.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, pheight);
                    e.doit = false;
                    this.lastTime = time;
                }
            }
        };
        this.pv.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if ((e.stateMask & 0x40000) > 0) {
                    Point o = PDFEditor.this.getOrigin();
                    Point oldSize = PDFEditor.this.pv.getSize();
                    PDFEditor.this.pv.setZoomFactor(Math.max(PDFEditor.this.pv.getZoomFactor() + 0.2f * (float)e.count / 10.0f, 0.0f));
                    int mx = Math.round((float)PDFEditor.this.pv.getSize().x * ((float)e.x / (float)oldSize.x)) - (e.x - o.x);
                    int my = Math.round((float)PDFEditor.this.pv.getSize().y * ((float)e.y / (float)oldSize.y)) - (e.y - o.y);
                    PDFEditor.this.setOrigin(mx, my);
                    return;
                }
            }
        });
        this.pv.addMouseListener(new MouseListener(){
            Point start;
            MouseMoveListener mml = new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if ((e.stateMask & 0x100000) == 0) {
                        (this).PDFEditor.this.pv.removeMouseMoveListener(this);
                        (this).PDFEditor.this.pv.setCursor(PDFEditor.this.cursorArrow);
                        return;
                    }
                    Point o = PDFEditor.this.sc.getOrigin();
                    PDFEditor.this.sc.setOrigin(o.x - (e.x - start.x), o.y - (e.y - start.y));
                }
            };

            public void mouseUp(MouseEvent e) {
                if (e.button != 2) {
                    return;
                }
                PDFEditor.this.pv.removeMouseMoveListener(this.mml);
                PDFEditor.this.pv.setCursor(PDFEditor.this.cursorArrow);
            }

            public void mouseDown(MouseEvent e) {
                if (e.button != 2) {
                    return;
                }
                this.start = new Point(e.x, e.y);
                PDFEditor.this.pv.addMouseMoveListener(this.mml);
                PDFEditor.this.pv.setCursor(PDFEditor.this.cursorHand);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.pv.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int height = ((PDFEditor)PDFEditor.this).sc.getClientArea().height;
                int pInc = 3 * height / 4;
                int lInc = height / 20;
                int hInc = ((PDFEditor)PDFEditor.this).sc.getClientArea().width / 20;
                int pheight = ((PDFEditor)PDFEditor.this).sc.getContent().getBounds().height;
                Point p = PDFEditor.this.sc.getOrigin();
                if (e.keyCode == 0x1000006) {
                    if (p.y < pheight - height) {
                        int y = p.y + pInc;
                        if (y > pheight - height) {
                            y = pheight - height;
                        }
                        PDFEditor.this.sc.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, y);
                    } else if (PDFEditor.this.currentPage < PDFEditor.this.f.getNumPages()) {
                        PDFEditor.this.showPage(PDFEditor.this.currentPage + 1);
                        PDFEditor.this.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, 0);
                    }
                } else if (e.keyCode == 0x1000005) {
                    if (p.y > 0) {
                        int y = p.y - pInc;
                        if (y < 0) {
                            y = 0;
                        }
                        PDFEditor.this.sc.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, y);
                    } else if (PDFEditor.this.currentPage > 1) {
                        PDFEditor.this.showPage(PDFEditor.this.currentPage - 1);
                        PDFEditor.this.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, pheight);
                    }
                } else if (e.keyCode == 0x1000002) {
                    if (p.y < pheight - height) {
                        PDFEditor.this.sc.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, p.y + lInc);
                    }
                } else if (e.keyCode == 0x1000001) {
                    if (p.y > 0) {
                        int y = p.y - lInc;
                        if (y < 0) {
                            y = 0;
                        }
                        PDFEditor.this.sc.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, y);
                    }
                } else if (e.keyCode == 0x1000004) {
                    if (p.x < ((PDFEditor)PDFEditor.this).sc.getContent().getBounds().width - ((PDFEditor)PDFEditor.this).sc.getClientArea().width) {
                        PDFEditor.this.sc.setOrigin(p.x + hInc, ((PDFEditor)PDFEditor.this).sc.getOrigin().y);
                    }
                } else if (e.keyCode == 0x1000003) {
                    if (p.x > 0) {
                        int x = p.x - hInc;
                        if (x < 0) {
                            x = 0;
                        }
                        PDFEditor.this.sc.setOrigin(x, ((PDFEditor)PDFEditor.this).sc.getOrigin().y);
                    }
                } else if (e.keyCode == 0x1000007) {
                    PDFEditor.this.showPage(1);
                    PDFEditor.this.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, 0);
                } else if (e.keyCode == 0x1000008) {
                    PDFEditor.this.showPage(PDFEditor.this.f.getNumPages());
                    PDFEditor.this.setOrigin(((PDFEditor)PDFEditor.this).sc.getOrigin().x, pheight);
                }
            }
        });
        IStatusLineManager statusLineM = this.getEditorSite().getActionBars().getStatusLineManager();
        IContributionItem[] iContributionItemArray = items = statusLineM.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (PDFPOSITION_ID.equals(item.getId())) {
                this.position = (StatusLinePageSelector)item;
                this.position.setPageChangeListener(this);
            }
            ++n2;
        }
        if (this.position == null) {
            this.position = new StatusLinePageSelector(PDFPOSITION_ID, 15);
            this.position.setPageChangeListener(this);
            statusLineM.add((IContributionItem)this.position);
        }
        this.position.setPageInfo(1, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        if (this.f != null) {
            this.showPage(this.currentPage);
        }
        IEclipsePreferences prefs = new InstanceScope().getNode("de.vonloesch.pdf4Eclipse");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (prefs.getBoolean("pseudoContinuousScrolling", true)) {
            this.pv.addListener(37, this.mouseWheelPageListener);
            this.isListeningForMouseWheel = true;
        }
        this.initKeyBindingContext();
        this.sc.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                try {
                    PDFEditor.this.sc.removeControlListener((ControlListener)this);
                    PDFEditor.this.fitHorizontal();
                    PDFEditor.this.sc.addControlListener((ControlListener)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("pseudoContinuousScrolling".equals(event.getKey())) {
            boolean newValue = Boolean.parseBoolean((String)event.getNewValue());
            if (event.getNewValue() == null) {
                newValue = true;
            }
            if (this.isListeningForMouseWheel && !newValue) {
                this.pv.removeListener(37, this.mouseWheelPageListener);
                this.isListeningForMouseWheel = false;
            } else if (!this.isListeningForMouseWheel && newValue) {
                this.pv.addListener(37, this.mouseWheelPageListener);
                this.isListeningForMouseWheel = true;
            }
        }
    }

    private void initKeyBindingContext() {
        final IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        this.pv.addFocusListener(new FocusListener(){
            IContextActivation currentContext = null;

            public void focusGained(FocusEvent e) {
                if (this.currentContext == null) {
                    this.currentContext = service.activateContext(PDFEditor.CONTEXT_ID);
                }
            }

            public void focusLost(FocusEvent e) {
                if (this.currentContext != null) {
                    service.deactivateContext(this.currentContext);
                    this.currentContext = null;
                }
            }
        });
    }

    private File getSyncTeXFile() {
        String name = this.file.getAbsolutePath();
        File f = new File(String.valueOf(name = name.substring(0, name.lastIndexOf(46))) + ".synctex.gz");
        if (f.exists()) {
            return f;
        }
        f = new File(String.valueOf(name) + ".synctex");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    private SimpleSynctexParser createSimpleSynctexParser(File f) throws IOException {
        InputStream in = f.getName().toLowerCase().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(f)) : new FileInputStream(f);
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        return new SimpleSynctexParser(r);
    }

    public int forwardSearch(String file, int lineNr) {
        int page;
        double[] result;
        block10: {
            block9: {
                File syncTeXFile = this.getSyncTeXFile();
                if (syncTeXFile == null) {
                    return -1;
                }
                try {
                    SimpleSynctexParser p = this.createSimpleSynctexParser(syncTeXFile);
                    p.setForwardSearchInformation(file, lineNr);
                    p.startForward();
                    p.close();
                    result = p.getForwardSearchResult();
                    if (result != null) break block9;
                    return -2;
                }
                catch (IOException ex) {
                    return -4;
                }
            }
            page = (int)Math.round(result[0]);
            if (page <= this.f.getNumPages() && page >= 1) break block10;
            return -4;
        }
        this.showPage(page);
        this.pv.highlight(result[1], result[2], result[3], result[4]);
        Rectangle2D re = this.pv.convertPDF2ImageCoord(new Rectangle((int)Math.round(result[1]), (int)Math.round((double)this.pv.currentPage.getHeight() - result[2]), 1, 1));
        int x = this.sc.getOrigin().x;
        if (re.getX() < (double)this.sc.getOrigin().x) {
            x = (int)Math.round(re.getX() - 10.0);
        }
        this.setOrigin(x, (int)Math.round(re.getY() - (double)this.sc.getBounds().height / 4.0));
        try {
            this.getSite().getPage().openEditor(this.getEditorInput(), ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return -4;
        }
        this.setFocus();
        return 0;
    }

    public void reverseSearch(double pdfX, double pdfY) {
        block11: {
            File f = this.getSyncTeXFile();
            if (f == null) {
                this.writeStatusLineError(Messages.PDFEditor_SynctexMsg1);
                return;
            }
            try {
                IFileStore fileStore;
                SimpleSynctexParser p = this.createSimpleSynctexParser(f);
                p.setReverseSearchInformation(this.currentPage, pdfX, pdfY);
                p.startReverse();
                p.close();
                if (p.sourceFilePath == null) {
                    this.writeStatusLineError(Messages.PDFEditor_SynctexMsg2);
                    return;
                }
                File sourceFile = new File(p.sourceFilePath);
                String path = p.sourceFilePath;
                if (!sourceFile.isAbsolute()) {
                    path = f.getCanonicalPath();
                    path = String.valueOf(path.substring(0, path.lastIndexOf(File.separatorChar) + 1)) + p.sourceFilePath;
                }
                if (!(fileStore = EFS.getLocalFileSystem().fromLocalFile(new File(path))).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    IWorkbenchPage page = this.getSite().getPage();
                    try {
                        IEditorPart part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        if (part instanceof AbstractTextEditor) {
                            AbstractTextEditor t = (AbstractTextEditor)part;
                            IDocument doc = t.getDocumentProvider().getDocument((Object)t.getEditorInput());
                            t.selectAndReveal(doc.getLineOffset(p.sourceLineNr - 1), doc.getLineLength(p.sourceLineNr - 1));
                        }
                        break block11;
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    catch (BadLocationException e) {
                        this.writeStatusLineError(NLS.bind((String)Messages.PDFEditor_SynctexMsg3, (Object)(p.sourceLineNr - 1)));
                    }
                    break block11;
                }
                this.writeStatusLineError(NLS.bind((String)Messages.PDFEditor_SynctexMsg4, (Object)path));
            }
            catch (FileNotFoundException e) {
                this.writeStatusLineError(NLS.bind((String)Messages.PDFEditor_SynctexMsg5, (Object)f.getName()));
            }
            catch (IOException e1) {
                this.writeStatusLineError("Error while parsing SyncTeX file " + f.getName());
                e1.printStackTrace();
            }
        }
    }

    public void showPage(IPDFPage page) {
        this.currentPage = page.getPageNumber();
        this.pv.showPage(page);
        this.updateStatusLine();
    }

    public void showPage(int pageNr) {
        if (pageNr < 1) {
            pageNr = 1;
        }
        if (pageNr > this.f.getNumPages()) {
            pageNr = this.f.getNumPages();
        }
        IPDFPage page = this.f.getPage(pageNr);
        this.currentPage = pageNr;
        this.pv.showPage(page);
        this.updateStatusLine();
    }

    public void setFocus() {
        this.sc.setFocus();
        this.updateStatusLine();
        this.position.setPageChangeListener(this);
    }

    public void gotoAction(IPDFDestination dest) {
        if (dest.getType() == 2) {
            IPDFPage page = dest.getPage(this.f);
            if (page == null) {
                return;
            }
            IWorkbenchPage wpage = this.getSite().getPage();
            wpage.getNavigationHistory().markLocation((IEditorPart)this);
            this.showPage(page);
            Rectangle2D r = dest.getPosition();
            if (r != null) {
                Rectangle2D re = this.pv.convertPDF2ImageCoord(r);
                int x = this.sc.getOrigin().x;
                if (re.getX() < (double)this.sc.getOrigin().x) {
                    x = (int)Math.round(re.getX() - 10.0);
                }
                this.setOrigin(x, (int)Math.round(re.getY() - (double)this.sc.getBounds().height / 4.0));
            } else {
                this.setOrigin(this.sc.getOrigin().x, 0);
            }
            wpage.getNavigationHistory().markLocation((IEditorPart)this);
        } else if (dest.getType() == 1) {
            String url = dest.getURL();
            if (url.toLowerCase().indexOf("://") < 0) {
                url = "http://" + url;
            }
            try {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser("PDFBrowser").openURL(new URL(url));
            }
            catch (PartInitException e) {
                Activator.log("Problem opening browser", e);
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"No valid url", (String)e.getMessage());
            }
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outline == null) {
                IOutlineNode n;
                block6: {
                    n = this.f.getOutline();
                    if (n != null) break block6;
                    return null;
                }
                try {
                    this.outline = new PDFFileOutline(this);
                    this.outline.setInput(n);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                return this.outline;
            }
        }
        return super.getAdapter(required);
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return new PDFNavigationLocation((IEditorPart)this);
    }

    private void updateStatusLine() {
        this.position.setPageInfo(this.currentPage, this.f.getNumPages());
    }

    public void fitHorizontal() {
        int w = this.sc.getClientArea().width;
        this.pv.setZoomFactor(1.0f / this.pv.getHorizontalTrimFactor() * (float)w / this.pv.getPage().getWidth());
    }

    public void fit() {
        float ph;
        float w = 1.0f / this.pv.getHorizontalTrimFactor() * (float)this.sc.getClientArea().width;
        float h = 1.0f / this.pv.getVerticalTrimFactor() * (float)this.sc.getClientArea().height;
        float pw = this.pv.getPage().getWidth();
        if (w / pw < h / (ph = this.pv.getPage().getHeight())) {
            this.pv.setZoomFactor(w / pw);
        } else {
            this.pv.setZoomFactor(h / ph);
        }
    }

    public void writeStatusLineError(String text) {
        final IStatusLineManager statusLineM = this.getEditorSite().getActionBars().getStatusLineManager();
        statusLineM.setErrorMessage(text);
        Display.getDefault().timerExec(5000, new Runnable(){

            @Override
            public void run() {
                statusLineM.setErrorMessage("");
            }
        });
    }

    Point getOrigin() {
        if (!this.sc.isDisposed()) {
            return this.sc.getOrigin();
        }
        return null;
    }

    private void setOrigin(int x, int y) {
        this.sc.setRedraw(false);
        this.sc.setOrigin(x, y);
        this.sc.setRedraw(true);
    }

    void setOrigin(Point p) {
        this.sc.setRedraw(false);
        if (p != null) {
            this.sc.setOrigin(p);
        }
        this.sc.setRedraw(true);
    }
}

