/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.fp;

import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.TLCServerRMI;
import tlc2.tool.distributed.fp.FPSetManagerException;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.fp.MultiFPSet;
import util.ToolIO;

public class DistributedFPSet {
    private static volatile boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ToolIO.out.println("TLC Distributed FP Server " + TLCGlobals.versionOfTLC);
        if (args.length != 1) {
            DistributedFPSet.printErrorMsg("Error: Missing hostname of the TLC server to be contacted.");
            return;
        }
        String serverName = args[0];
        boolean prefixBits = false;
        try {
            TLCServerRMI tlcServer = DistributedFPSet.lookupTLCServer(serverName);
            String metadir = System.getProperty("java.io.tmpdir") + File.separator + "FPSet" + System.currentTimeMillis();
            File filedir = new File(metadir);
            if (!filedir.exists()) {
                filedir.mkdirs();
            }
            FPSetConfiguration fpSetConfiguration = new FPSetConfiguration(1.0);
            fpSetConfiguration.setFpBits(1);
            FPSet fpSet = FPSetFactory.getFPSet(fpSetConfiguration);
            String filename = "FPSet" + System.currentTimeMillis();
            fpSet.init(1, metadir, filename);
            System.err.println("FPSet instance type is: " + fpSet.getClass().getName());
            if (fpSet instanceof MultiFPSet) {
                MultiFPSet multiFPSet = (MultiFPSet)fpSet;
                FPSet[] fpSets = multiFPSet.getFPSets();
                for (int i = 0; i < fpSets.length; ++i) {
                    System.err.println("...with nested instance type: " + fpSets[i].getClass().getName());
                }
            }
            String hostname = InetAddress.getLocalHost().getHostName();
            try {
                tlcServer.registerFPSet(fpSet, hostname);
            }
            catch (FPSetManagerException e) {
                fpSet.unexportObject(false);
                ToolIO.out.println(e.getMessage());
                return;
            }
            System.out.println("Fingerprint set server at " + hostname + " is ready.");
            FPSet fPSet = fpSet;
            synchronized (fPSet) {
                while (running) {
                    ToolIO.out.println("Progress: The number of fingerprints stored at " + hostname + " is " + fpSet.size() + ".");
                    fpSet.wait(300000L);
                }
                fpSet.unexportObject(false);
                ToolIO.out.println("Exiting TLC Distributed FP Server");
            }
        }
        catch (Throwable e) {
            MP.printError(1000, e);
            ToolIO.out.println("Error: Failed to start FPSet  for server " + serverName + ".\n" + e.getMessage());
        }
        ToolIO.out.flush();
    }

    public static void shutdown() {
        running = false;
    }

    private static TLCServerRMI lookupTLCServer(String serverName) throws MalformedURLException, RemoteException, NotBoundException, InterruptedException {
        String url = "//" + serverName + ":" + TLCServer.Port + "/TLCServer";
        int i = 1;
        while (true) {
            try {
                return (TLCServerRMI)Naming.lookup(url);
            }
            catch (java.rmi.ConnectException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ConnectException) {
                    long sleep = (long)Math.sqrt(i);
                    ToolIO.out.println("Server " + serverName + " unreachable, sleeping " + sleep + "s for server to come online...");
                    Thread.sleep(sleep * 1000L);
                    i *= 2;
                    continue;
                }
                throw e;
            }
            catch (NotBoundException e) {
                long sleep = (long)Math.sqrt(i);
                ToolIO.out.println("Server " + serverName + " reachable but not ready yet, sleeping " + sleep + "s for server to come online...");
                Thread.sleep(sleep * 1000L);
                i *= 2;
                continue;
            }
            break;
        }
    }

    private static void printErrorMsg(String msg) {
        ToolIO.out.println(msg);
        ToolIO.out.println("Usage: java " + DistributedFPSet.class.getName() + " host");
    }
}

